/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimImportanceType;
import com.aligo.pim.PimTaskStatusType;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import com.aligo.pim.interfaces.PimTaskItem;
import com.aligo.pim.lotus.LotusPimCommonTaskItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimExistingApptExistingReminderItem;
import com.aligo.pim.lotus.LotusPimExistingApptNewReminderItem;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Date;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.RichTextItem;
import lotus.domino.RichTextStyle;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public class LotusPimTaskItem
extends LotusPimMessageItem
implements PimTaskItem,
LotusPimCommonTaskItem {
    public static final String START_DATE_TIME = "StartDateTime";
    public static final String DUE_DATE_TIME = "DueDateTime";
    public static final String SUBJECT = "subject";
    public static final String BODY = "Body";
    public static final String DUE_DATE = "DueDate";
    public static final String CALENDER_DATE_TIME = "CalendarDateTime";
    public static final String START_DATE = "StartDate";
    public static final String LOCATION = "Location";
    public static final String FORM = "Form";
    public static final String TASK = "Task";
    public static final String CHAIR = "Chair";
    public static final String PRINCIPAL = "Principal";
    private PimReminderItem m_oPimReminderItem;

    public LotusPimTaskItem(ViewEntry viewEntry, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntry, lotusPimSession, recycle);
    }

    public LotusPimTaskItem(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntryCollection, lotusPimSession, recycle);
    }

    public LotusPimTaskItem(Document document, LotusPimSession lotusPimSession, Recycle recycle) {
        super(document, lotusPimSession, recycle);
    }

    public void setLotusTaskItem(ViewEntry viewEntry) {
        this.setLotusMessageItem(viewEntry);
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private DateTime getStartDateTime() throws LotusPimException {
        try {
            Vector vector;
            if (this.getLotusDocument().hasItem(START_DATE_TIME) && !(vector = this.getLotusDocument().getItemValue(START_DATE_TIME)).isEmpty()) {
                DateTime dateTime = (DateTime)vector.firstElement();
                return dateTime;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    private DateTime getEndDateTime() throws LotusPimException {
        try {
            Vector vector;
            if (this.getLotusDocument().hasItem(DUE_DATE_TIME) && !(vector = this.getLotusDocument().getItemValue(DUE_DATE_TIME)).isEmpty()) {
                DateTime dateTime = (DateTime)vector.firstElement();
                return dateTime;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public Date getDueDate() throws LotusPimException {
        try {
            DateTime dateTime = this.getEndDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public PimImportanceType getImportance() throws LotusPimException {
        return PimImportanceType.NORMAL;
    }

    public Date getStartDate() throws LotusPimException {
        try {
            DateTime dateTime = this.getStartDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public String getSubject() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem(SUBJECT)) {
                return this.getLotusDocument().getItemValueString(SUBJECT);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getName() throws LotusPimException {
        try {
            return "Task Item: " + this.getSubject();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getText() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem(BODY)) {
                return this.getLotusDocument().getItemValueString(BODY);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public void setDueDate(Date date) throws LotusPimException {
        try {
            DateTime dateTime = this.getLotusSession().createDateTime(date);
            DateTime dateTime2 = this.getStartDateTime();
            if (dateTime2 == null || dateTime.timeDifference(dateTime2) < 0) {
                throw new LotusPimException(13L);
            }
            this.getLotusDocument().replaceItemValue(DUE_DATE, (Object)dateTime);
            this.getLotusDocument().replaceItemValue(DUE_DATE_TIME, (Object)dateTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setImportance(PimImportanceType pimImportanceType) throws LotusPimException {
    }

    public void setStartDate(Date date) throws LotusPimException {
        try {
            DateTime dateTime = this.getLotusSession().createDateTime(date);
            DateTime dateTime2 = this.getEndDateTime();
            if (dateTime2 != null && dateTime2.timeDifference(dateTime) < 0) {
                this.setDueDate(date);
            }
            this.getLotusDocument().replaceItemValue(CALENDER_DATE_TIME, (Object)dateTime);
            this.getLotusDocument().replaceItemValue(START_DATE, (Object)dateTime);
            this.getLotusDocument().replaceItemValue(START_DATE_TIME, (Object)dateTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSubject(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue(SUBJECT, (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setText(String string) throws LotusPimException {
        try {
            this.getLotusDocument().removeItem(BODY);
            this.getLotusDocument().save(true);
            try {
                RichTextItem richTextItem = this.getLotusDocument().createRichTextItem(BODY);
                RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                richTextStyle.setFontSize(9);
                richTextItem.appendStyle(richTextStyle);
                richTextItem.appendText(string);
            }
            catch (Exception exception) {
                this.getLotusDocument().replaceItemValue(BODY, (Object)string);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)"FW: Task Item forwarded ");
            LotusPimTaskItem lotusPimTaskItem = new LotusPimTaskItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimTaskItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void send() throws LotusPimException {
        super.send();
    }

    public PimReminderItem getReminderItem() throws LotusPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                String string = this.getLotusDocument().getItemValueString("Alarms");
                if (string != null && string.equals("1") && this.getLotusDocument().hasItem("$Alarm") && this.getLotusDocument().getItemValueInteger("$Alarm") == 1) {
                    this.m_oPimReminderItem = new LotusPimExistingApptExistingReminderItem(this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
                } else {
                    return null;
                }
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimReminderItem addReminderItem() throws LotusPimException {
        try {
            this.m_oPimReminderItem = this.getReminderItem();
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new LotusPimExistingApptNewReminderItem(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
        try {
            if (this.isThisItemNew()) {
                this.getLotusDocument().replaceItemValue(FORM, (Object)TASK);
                this.getLotusDocument().replaceItemValue(CHAIR, (Object)this.getLotusSession().getUserName());
                this.getLotusDocument().replaceItemValue(PRINCIPAL, (Object)this.getLotusSession().getUserName());
            }
            super.update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskStatusType getStatus() throws LotusPimException {
        try {
            int n;
            Document document = this.getLotusDocument();
            if (document.hasItem("DueState") && (n = document.getItemValueInteger("DueState")) == 9) {
                return PimTaskStatusType.COMPLETE;
            }
            return PimTaskStatusType.NOT_COMPLETE;
        }
        catch (Exception exception) {
            return PimTaskStatusType.NOT_COMPLETE;
        }
    }

    public void setStatus(PimTaskStatusType pimTaskStatusType) throws LotusPimException {
        try {
            if (pimTaskStatusType != null) {
                Document document = this.getLotusDocument();
                if (pimTaskStatusType.equals(PimTaskStatusType.COMPLETE)) {
                    if (this.getStatus().equals(PimTaskStatusType.NOT_COMPLETE)) {
                        document.replaceItemValue("ASSIGNSTATE", (Object)new Integer(9));
                        DateTime dateTime = this.getLotusSession().createDateTime(new Date());
                        document.replaceItemValue("CompletedDateTime", (Object)dateTime);
                        document.replaceItemValue("DueState", (Object)new Integer(9));
                        document.replaceItemValue("NoticeType", (Object)"F");
                        document.replaceItemValue("_ViewIcon", (Object)new Integer(82));
                    }
                } else if (this.getStatus().equals(PimTaskStatusType.COMPLETE)) {
                    document.removeItem("ASSIGNSTATE");
                    document.removeItem("CompletedDateTime");
                    document.removeItem("NoticeType");
                    document.replaceItemValue("_ViewIcon", (Object)new Integer(168));
                    document.replaceItemValue("DueState", (Object)new Integer(1));
                }
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

