/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimRecurrencePatternDayType;
import com.aligo.pim.PimRecurrencePatternNthType;
import com.aligo.pim.PimRecurrencePatternType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItem;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimRecurrencePatternDayTypeMapper;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimTaskRecurrencePatternItem;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Date;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;

public class LotusPimRecurrencePatternItem
extends LotusPimItem
implements PimRecurrencePatternItem,
LotusPimTaskRecurrencePatternItem {
    private LotusPimMessageItem m_oPimMessageItem;
    private Document _oParentDocument;

    public LotusPimRecurrencePatternItem(LotusPimMessageItem lotusPimMessageItem, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        super(lotusPimSession, recycle);
        this.m_oPimMessageItem = lotusPimMessageItem;
    }

    private Document getLotusDocument() throws LotusPimException {
        try {
            if (this._oParentDocument == null) {
                Document document = this.m_oPimMessageItem.getLotusDocument();
                try {
                    if (document.getParentDocumentUNID() == "") {
                        this._oParentDocument = document;
                    } else {
                        this._oParentDocument = this.m_oPimMessageItem.getLotusDatabase().getDocumentByUNID(document.getParentDocumentUNID());
                        this.getRecycle().add(this._oParentDocument);
                    }
                }
                catch (Exception exception) {
                    this._oParentDocument = document;
                }
            }
            return this._oParentDocument;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setType(PimRecurrencePatternType pimRecurrencePatternType) throws PimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setInterval(int n) throws PimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setDaysOfWeek(Vector vector) throws PimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(55L);
        }
    }

    public void setDaysOfMonth(Vector vector) throws PimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(56L);
        }
    }

    public void setNoOfOccurrences(int n) throws PimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setNoOfInstances(int n) throws PimException {
        this.setNoOfOccurrences(n);
    }

    public void setRecurrenceEndDate(Date date) throws PimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createDailyEveryNDays(Date date, int n) throws LotusPimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createDailyEveryNDays(int n, int n2) throws LotusPimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createWeeklyEveryNWeeks(Date date, int n, Vector vector) throws LotusPimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createWeeklyEveryNWeeks(int n, int n2, Vector vector) throws LotusPimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createWeeklyNoOfInstances(int n, int n2, Vector vector) throws PimException {
        this.createWeeklyEveryNWeeks(n, n2, vector);
    }

    public void createMonthlyEveryNMonths(Date date, int n, Vector vector) throws LotusPimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createMonthlyEveryNMonths(int n, int n2, Vector vector) throws LotusPimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createYearlyEveryNYears(Date date, int n) throws LotusPimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createYearlyEveryNYears(int n, int n2) throws LotusPimException {
        try {
            throw new LotusPimException(62L);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
    }

    public void delete() throws LotusPimException {
    }

    public void delete(boolean bl) throws PimException {
    }

    public String getID() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItems getFieldItems() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        try {
            return "Recurrence Pattern";
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecurrencePatternType getType() throws PimException {
        try {
            String string = this.getLotusDocument().getItemValueString("RepeatUnit");
            if (string.equals("D")) {
                return PimRecurrencePatternType.DAILY;
            }
            if (string.equals("W")) {
                return PimRecurrencePatternType.WEEKLY;
            }
            if (string.equals("MD") || string.equals("MP")) {
                return PimRecurrencePatternType.MONTHLY;
            }
            if (string.equals("YD")) {
                return PimRecurrencePatternType.YEARLY;
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getInterval() throws PimException {
        try {
            return Integer.parseInt(this.getLotusDocument().getItemValueString("RepeatInterval"));
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getDaysOfWeek() throws PimException {
        try {
            Vector<PimRecurrencePatternDayType> vector = new Vector<PimRecurrencePatternDayType>();
            if (this.getType().equals(PimRecurrencePatternType.WEEKLY)) {
                Vector vector2 = this.getLotusDocument().getItemValue("RepeatAdjust");
                int n = 0;
                while (n < vector2.size()) {
                    int n2 = Integer.parseInt((String)vector2.elementAt(n));
                    vector.add(LotusPimRecurrencePatternDayTypeMapper.getRecurrenceType(n2 + 1));
                    ++n;
                }
                return vector;
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getDaysOfMonth() throws PimException {
        try {
            if (this.getLotusDocument().getItemValueString("RepeatUnit").equals("MD")) {
                Vector vector = this.getLotusDocument().getItemValue("RepeatAdjust");
                Vector<Integer> vector2 = new Vector<Integer>();
                int n = 0;
                while (n < vector.size()) {
                    int n2 = Integer.parseInt((String)vector.elementAt(n));
                    vector2.add(new Integer(n2));
                    ++n;
                }
                return vector2;
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getNoOfOccurrences() throws PimException {
        try {
            if (this.getLotusDocument().getItemValueString("RepeatHow").equals("F")) {
                return this.getLotusDocument().getItemValueInteger("RepeatFor");
            }
            return 0;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Date getRecurrenceEndDate() throws PimException {
        try {
            Vector vector;
            if (this.getLotusDocument().getItemValueString("RepeatHow").equals("U") && (vector = this.getLotusDocument().getItemValue("RepeatUntil")).size() >= 1) {
                DateTime dateTime = (DateTime)vector.elementAt(0);
                return dateTime.toJavaDate();
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecurrencePatternNthType getNthType() throws PimException {
        return null;
    }

    public Vector getMonthsOfYear() throws PimException {
        return null;
    }
}

