/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimRecurrencePatternDayType;
import com.aligo.pim.PimRecurrencePatternNthType;
import com.aligo.pim.PimRecurrencePatternType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItem;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimRecurrencePatternDayTypeMapper;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimTaskRecurrencePatternItem;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Session;

public class LotusPimNewRecurrencePatternItem
extends LotusPimItem
implements PimRecurrencePatternItem,
LotusPimTaskRecurrencePatternItem {
    private PimRecurrencePatternType m_oPimRecurrencePatternType;
    private int m_iInterval;
    private Vector m_vDaysOfWeek;
    private Vector m_vDaysOfMonth;
    private int m_iNoOfOccurrences;
    private Date m_oStartTime;
    private Date m_oEndTime;
    private Date m_oRecurrenceEndDate;
    private LotusPimMessageItem m_oPimMessageItem;
    private Session m_oSession;
    private int NO_OF_DAYS_IN_A_WEEK = 7;
    private boolean m_bIsUpdateCalled = false;
    private Vector m_vStartDateTimeVector;
    private Vector m_vEndDateTimeVector;
    private Vector m_vRepeatAdjust;
    private String m_szRepeatFromEnd;
    private DateTime m_oRepeatCustom;
    private String m_szRepeatWeekends;
    private DateTime m_oRepeatStartDate;
    private String m_szRepeatHow;
    private DateTime m_oRepeatUntil;
    private Integer m_oRepeatFor;
    private String m_szRepeatForUnit;
    private String m_szRepeatUnit;
    private String m_szRepeatInterval;
    private DateTime m_oStartDateTime;
    private DateTime m_oEndDateTime;
    private Vector m_vRepeatDates;
    private Vector m_vRepeatOccurrenceDates;
    private DateTime m_oStartDate;
    private DateTime m_oEndDate;

    public LotusPimNewRecurrencePatternItem(LotusPimMessageItem lotusPimMessageItem, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        super(lotusPimSession, recycle);
        this.m_oPimMessageItem = lotusPimMessageItem;
        this.m_oSession = lotusPimMessageItem.getLotusSession();
        this.m_oPimRecurrencePatternType = PimRecurrencePatternType.DAILY;
        this.m_iInterval = 1;
        this.m_vDaysOfWeek = new Vector();
        this.m_vDaysOfMonth = new Vector();
        this.m_iNoOfOccurrences = 1;
    }

    public Vector getRepeatAdjust() throws LotusPimException {
        try {
            return this.m_vRepeatAdjust;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getRepeatFromEnd() throws LotusPimException {
        try {
            return this.m_szRepeatFromEnd;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getChildRepeatFromEnd() throws LotusPimException {
        try {
            return this.getRepeatFromEnd();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getRepeatCustom() throws LotusPimException {
        try {
            return this.m_oRepeatCustom;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getRepeatWeekends() throws LotusPimException {
        try {
            return this.m_szRepeatWeekends;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getRepeatStartDate() throws LotusPimException {
        try {
            return this.m_oRepeatStartDate;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getRepeatHow() throws LotusPimException {
        try {
            return this.m_szRepeatHow;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getRepeatUntil() throws LotusPimException {
        try {
            return this.m_oRepeatUntil;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Integer getRepeatFor() throws LotusPimException {
        try {
            return this.m_oRepeatFor;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getRepeatForUnit() throws LotusPimException {
        try {
            return this.m_szRepeatForUnit;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getRepeatUnit() throws LotusPimException {
        try {
            return this.m_szRepeatUnit;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getRepeatInterval() throws LotusPimException {
        try {
            return this.m_szRepeatInterval;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getStartDateTime() throws LotusPimException {
        try {
            return this.m_oStartDateTime;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getEndDateTime() throws LotusPimException {
        try {
            return this.m_oEndDateTime;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getRepeatDates() throws LotusPimException {
        try {
            return this.m_vRepeatDates;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getRepeatOccurrenceDates() throws LotusPimException {
        try {
            return this.m_vRepeatOccurrenceDates;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getStartTime() throws LotusPimException {
        try {
            return this.getLotusSession().createDateTime(this.m_oStartTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getStartDate() throws LotusPimException {
        try {
            return this.m_oStartDate;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getChildStartDate() throws LotusPimException {
        try {
            return this.getStartDate();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getChildStartTime() throws LotusPimException {
        try {
            return this.getStartTime();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getChildEndDate() throws LotusPimException {
        try {
            return this.getEndDate();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getChildEndTime() throws LotusPimException {
        try {
            return this.getEndTime();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getChildStartDateTime() throws LotusPimException {
        try {
            return this.m_vStartDateTimeVector;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getChildEndDateTime() throws LotusPimException {
        try {
            return this.m_vEndDateTimeVector;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getChildCalendarDateTime() throws LotusPimException {
        try {
            return this.m_vStartDateTimeVector;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getChildRepeatOccurrenceDates() throws LotusPimException {
        try {
            return this.m_vStartDateTimeVector;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getEndDate() throws LotusPimException {
        try {
            return this.m_oEndDate;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getEndTime() throws LotusPimException {
        try {
            return this.getLotusSession().createDateTime(this.m_oEndTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setType(PimRecurrencePatternType pimRecurrencePatternType) throws PimException {
        try {
            if (pimRecurrencePatternType != null) {
                this.m_oPimRecurrencePatternType = pimRecurrencePatternType;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setInterval(int n) throws PimException {
        try {
            if (n > 0) {
                this.m_iInterval = n;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setDaysOfWeek(Vector vector) throws PimException {
        try {
            if (vector == null) {
                throw new LotusPimException(55L);
            }
            if (vector.size() > 0) {
                Vector vector2 = new Vector();
                int n = 0;
                while (n < vector.size()) {
                    Object e = vector.elementAt(n);
                    if (!(e instanceof PimRecurrencePatternDayType)) {
                        this.m_vDaysOfWeek = new Vector();
                        throw new LotusPimException(55L);
                    }
                    int n2 = vector.lastIndexOf(e);
                    if (n == n2) {
                        vector2.add(e);
                    }
                    ++n;
                }
                this.m_vDaysOfWeek = vector2;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(55L);
        }
    }

    public void setDaysOfMonth(Vector vector) throws PimException {
        try {
            if (vector == null) {
                throw new LotusPimException(56L);
            }
            if (vector.size() > 0) {
                Vector<Integer> vector2 = new Vector<Integer>();
                int n = 0;
                while (n < vector.size()) {
                    int n2 = (Integer)vector.elementAt(n);
                    if (n2 <= 0 || n2 > 31) {
                        throw new LotusPimException(56L);
                    }
                    int n3 = vector.lastIndexOf(new Integer(n2));
                    if (n == n3) {
                        vector2.add(new Integer(n2));
                    }
                    ++n;
                }
                this.m_vDaysOfMonth = vector2;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(56L);
        }
    }

    public void setNoOfOccurrences(int n) throws PimException {
        try {
            if (n > 0) {
                this.m_iNoOfOccurrences = n;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setNoOfInstances(int n) throws PimException {
        this.setNoOfOccurrences(n);
    }

    public void setRecurrenceEndDate(Date date) throws PimException {
        try {
            if (date != null) {
                this.m_oRecurrenceEndDate = date;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createDailyEveryNDays(Date date, int n) throws LotusPimException {
        try {
            this.setType(PimRecurrencePatternType.DAILY);
            this.setNoOfOccurrences(1);
            this.setInterval(n);
            this.setRecurrenceEndDate(date);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createDailyEveryNDays(int n, int n2) throws LotusPimException {
        try {
            this.setType(PimRecurrencePatternType.DAILY);
            this.setNoOfOccurrences(n);
            this.setInterval(n2);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createWeeklyEveryNWeeks(Date date, int n, Vector vector) throws LotusPimException {
        try {
            this.setType(PimRecurrencePatternType.WEEKLY);
            this.setNoOfOccurrences(1);
            this.setInterval(n);
            this.setDaysOfWeek(vector);
            this.setRecurrenceEndDate(date);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createWeeklyEveryNWeeks(int n, int n2, Vector vector) throws LotusPimException {
        try {
            this.setType(PimRecurrencePatternType.WEEKLY);
            this.setNoOfOccurrences(n);
            this.setInterval(n2);
            this.setDaysOfWeek(vector);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createWeeklyNoOfInstances(int n, int n2, Vector vector) throws PimException {
        this.createWeeklyEveryNWeeks(n, n2, vector);
    }

    public void createMonthlyEveryNMonths(Date date, int n, Vector vector) throws LotusPimException {
        try {
            this.setType(PimRecurrencePatternType.MONTHLY);
            this.setNoOfOccurrences(1);
            this.setInterval(n);
            this.setDaysOfMonth(vector);
            this.setRecurrenceEndDate(date);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createMonthlyEveryNMonths(int n, int n2, Vector vector) throws LotusPimException {
        try {
            this.setType(PimRecurrencePatternType.MONTHLY);
            this.setNoOfOccurrences(n);
            this.setInterval(n2);
            this.setDaysOfMonth(vector);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createYearlyEveryNYears(Date date, int n) throws LotusPimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setNoOfOccurrences(1);
            this.setInterval(n);
            this.setRecurrenceEndDate(date);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void createYearlyEveryNYears(int n, int n2) throws LotusPimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setNoOfOccurrences(n);
            this.setInterval(n2);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void generateAppropriateRepeatOccurrenceDates() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.DAILY)) {
                this.getRepeatDailyOccurrenceDates();
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.WEEKLY)) {
                this.getRepeatWeeklyOccurrenceDates();
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.MONTHLY)) {
                this.getRepeatMonthlyOccurrenceDates();
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.YEARLY)) {
                this.getRepeatYearlyOccurrenceDates();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public boolean isItRecurringItem() throws LotusPimException {
        return this.m_bIsUpdateCalled;
    }

    private void getRepeatDailyOccurrenceDates() throws LotusPimException {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.m_oStartTime);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.m_oEndTime);
            Vector<DateTime> vector = new Vector<DateTime>();
            Vector<DateTime> vector2 = new Vector<DateTime>();
            if (this.m_oRecurrenceEndDate != null) {
                int n = 0;
                while (true) {
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.set(calendar.get(1), calendar.get(2), calendar.get(5) + this.m_iInterval * n, calendar.get(11), calendar.get(12), calendar.get(13));
                    Calendar calendar4 = Calendar.getInstance();
                    calendar4.set(calendar2.get(1), calendar2.get(2), calendar2.get(5) + this.m_iInterval * n, calendar2.get(11), calendar2.get(12), calendar2.get(13));
                    if (this.m_oSession.createDateTime(calendar4.getTime()).timeDifference(this.m_oSession.createDateTime(this.m_oRecurrenceEndDate)) <= 0) {
                        vector.add(this.m_oSession.createDateTime(calendar3.getTime()));
                        vector2.add(this.m_oSession.createDateTime(calendar4.getTime()));
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                int n = 0;
                while (n < this.m_iNoOfOccurrences) {
                    Calendar calendar5 = Calendar.getInstance();
                    calendar5.set(calendar.get(1), calendar.get(2), calendar.get(5) + this.m_iInterval * n, calendar.get(11), calendar.get(12), calendar.get(13));
                    Calendar calendar6 = Calendar.getInstance();
                    calendar6.set(calendar2.get(1), calendar2.get(2), calendar2.get(5) + this.m_iInterval * n, calendar2.get(11), calendar2.get(12), calendar2.get(13));
                    vector.add(this.m_oSession.createDateTime(calendar5.getTime()));
                    vector2.add(this.m_oSession.createDateTime(calendar6.getTime()));
                    ++n;
                }
            }
            this.m_vStartDateTimeVector = vector;
            this.m_vEndDateTimeVector = vector2;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void getRepeatWeeklyOccurrenceDates() throws LotusPimException {
        try {
            Object object;
            int n;
            int n2;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.m_oStartTime);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.m_oEndTime);
            Vector<Integer> vector = new Vector<Integer>();
            if (this.m_vDaysOfWeek.size() <= 0) {
                vector.add(new Integer(calendar.get(7)));
            } else {
                int n3 = 0;
                while (n3 < this.m_vDaysOfWeek.size()) {
                    vector.add(new Integer(LotusPimRecurrencePatternDayTypeMapper.getType((PimRecurrencePatternDayType)this.m_vDaysOfWeek.elementAt(n3))));
                    ++n3;
                }
            }
            Vector<DateTime> vector2 = new Vector<DateTime>();
            Vector<DateTime> vector3 = new Vector<DateTime>();
            TreeSet treeSet = new TreeSet(vector);
            Vector<DateTime> vector4 = new Vector<DateTime>();
            Vector<DateTime> vector5 = new Vector<DateTime>();
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                if (n2 == calendar.get(7)) {
                    vector2.add(0, this.m_oSession.createDateTime(calendar.getTime()));
                    vector3.add(0, this.m_oSession.createDateTime(calendar2.getTime()));
                    continue;
                }
                Calendar calendar3 = Calendar.getInstance();
                calendar3.setTime(calendar.getTime());
                n = n2 - calendar3.get(7);
                if (n < 0) {
                    n += 7;
                }
                calendar3.add(5, n);
                vector2.add(this.m_oSession.createDateTime(calendar3.getTime()));
                object = Calendar.getInstance();
                ((Calendar)object).setTime(calendar2.getTime());
                n = n2 - ((Calendar)object).get(7);
                if (n < 0) {
                    n += 7;
                }
                ((Calendar)object).add(5, n);
                vector3.add(this.m_oSession.createDateTime(((Calendar)object).getTime()));
            }
            vector4.addAll(vector2);
            vector5.addAll(vector3);
            if (this.m_oRecurrenceEndDate != null) {
                n2 = 0;
                int n4 = 1;
                while (n2 == 0) {
                    n = 0;
                    while (n < vector2.size()) {
                        object = (DateTime)vector2.elementAt(n);
                        Calendar calendar4 = Calendar.getInstance();
                        calendar4.setTime(object.toJavaDate());
                        DateTime dateTime = (DateTime)vector3.elementAt(n);
                        Calendar calendar5 = Calendar.getInstance();
                        calendar5.setTime(dateTime.toJavaDate());
                        Calendar calendar6 = Calendar.getInstance();
                        calendar6.set(calendar4.get(1), calendar4.get(2), calendar4.get(5) + this.NO_OF_DAYS_IN_A_WEEK * this.m_iInterval * n4, calendar4.get(11), calendar4.get(12), calendar4.get(13));
                        Calendar calendar7 = Calendar.getInstance();
                        calendar7.set(calendar5.get(1), calendar5.get(2), calendar5.get(5) + this.NO_OF_DAYS_IN_A_WEEK * this.m_iInterval * n4, calendar5.get(11), calendar5.get(12), calendar5.get(13));
                        if (this.m_oSession.createDateTime(calendar7.getTime()).timeDifference(this.m_oSession.createDateTime(this.m_oRecurrenceEndDate)) > 0) {
                            n2 = 1;
                            break;
                        }
                        vector4.add(this.m_oSession.createDateTime(calendar6.getTime()));
                        vector5.add(this.m_oSession.createDateTime(calendar7.getTime()));
                        ++n;
                    }
                    ++n4;
                }
            } else {
                n2 = 1;
                while (n2 < this.m_iNoOfOccurrences) {
                    int n5 = 0;
                    while (n5 < vector2.size()) {
                        DateTime dateTime = (DateTime)vector2.elementAt(n5);
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime(dateTime.toJavaDate());
                        DateTime dateTime2 = (DateTime)vector3.elementAt(n5);
                        Calendar calendar8 = Calendar.getInstance();
                        calendar8.setTime(dateTime2.toJavaDate());
                        Calendar calendar9 = Calendar.getInstance();
                        calendar9.set(((Calendar)object).get(1), ((Calendar)object).get(2), ((Calendar)object).get(5) + this.NO_OF_DAYS_IN_A_WEEK * this.m_iInterval * n2, ((Calendar)object).get(11), ((Calendar)object).get(12), ((Calendar)object).get(13));
                        Calendar calendar10 = Calendar.getInstance();
                        calendar10.set(calendar8.get(1), calendar8.get(2), calendar8.get(5) + this.NO_OF_DAYS_IN_A_WEEK * this.m_iInterval * n2, calendar8.get(11), calendar8.get(12), calendar8.get(13));
                        vector4.add(this.m_oSession.createDateTime(calendar9.getTime()));
                        vector5.add(this.m_oSession.createDateTime(calendar10.getTime()));
                        ++n5;
                    }
                    ++n2;
                }
            }
            this.m_vStartDateTimeVector = vector4;
            this.m_vEndDateTimeVector = vector5;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void getRepeatMonthlyOccurrenceDates() throws LotusPimException {
        try {
            Calendar calendar;
            Calendar calendar2;
            Calendar calendar3;
            Object object;
            int n;
            Calendar calendar4 = Calendar.getInstance();
            calendar4.setTime(this.m_oStartTime);
            Calendar calendar5 = Calendar.getInstance();
            calendar5.setTime(this.m_oEndTime);
            if (this.m_vDaysOfMonth.size() <= 0) {
                this.m_vDaysOfMonth.add(new Integer(calendar4.get(5)));
            }
            TreeSet treeSet = new TreeSet(this.m_vDaysOfMonth);
            Vector<Calendar> vector = new Vector<Calendar>();
            Vector<Calendar> vector2 = new Vector<Calendar>();
            ++this.m_iNoOfOccurrences;
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                if (n < calendar4.get(5)) continue;
                object = Calendar.getInstance();
                ((Calendar)object).set(calendar4.get(1), calendar4.get(2), n, calendar4.get(11), calendar4.get(12), calendar4.get(13));
                if (((Calendar)object).get(5) != n) continue;
                calendar3 = Calendar.getInstance();
                calendar3.set(calendar5.get(1), calendar5.get(2), n, calendar5.get(11), calendar5.get(12), calendar5.get(13));
                calendar2 = this.m_oSession.createDateTime(((Calendar)object).getTime());
                calendar = this.m_oSession.createDateTime(calendar3.getTime());
                vector.add(calendar2);
                vector2.add(calendar);
                --this.m_iNoOfOccurrences;
            }
            if (this.m_oRecurrenceEndDate != null) {
                boolean bl = false;
                n = 1;
                while (!bl) {
                    object = treeSet.iterator();
                    while (object.hasNext()) {
                        int n2 = (Integer)object.next();
                        calendar2 = Calendar.getInstance();
                        calendar2.set(calendar4.get(1), calendar4.get(2) + n * this.m_iInterval, n2, calendar4.get(11), calendar4.get(12), calendar4.get(13));
                        if (calendar2.get(5) != n2) continue;
                        calendar = Calendar.getInstance();
                        calendar.set(calendar5.get(1), calendar5.get(2) + n * this.m_iInterval, n2, calendar5.get(11), calendar5.get(12), calendar5.get(13));
                        DateTime dateTime = this.m_oSession.createDateTime(calendar2.getTime());
                        DateTime dateTime2 = this.m_oSession.createDateTime(calendar.getTime());
                        if (dateTime2.timeDifference(this.m_oSession.createDateTime(this.m_oRecurrenceEndDate)) > 0) {
                            bl = true;
                            break;
                        }
                        vector.add((Calendar)dateTime);
                        vector2.add((Calendar)dateTime2);
                    }
                    ++n;
                }
            } else {
                int n3 = 1;
                while (n3 < this.m_iNoOfOccurrences) {
                    Iterator iterator2 = treeSet.iterator();
                    while (iterator2.hasNext()) {
                        int n4 = (Integer)iterator2.next();
                        calendar3 = Calendar.getInstance();
                        calendar3.set(calendar4.get(1), calendar4.get(2) + n3 * this.m_iInterval, n4, calendar4.get(11), calendar4.get(12), calendar4.get(13));
                        if (calendar3.get(5) != n4) continue;
                        calendar2 = Calendar.getInstance();
                        calendar2.set(calendar5.get(1), calendar5.get(2) + n3 * this.m_iInterval, n4, calendar5.get(11), calendar5.get(12), calendar5.get(13));
                        calendar = this.m_oSession.createDateTime(calendar3.getTime());
                        DateTime dateTime = this.m_oSession.createDateTime(calendar2.getTime());
                        vector.add(calendar);
                        vector2.add((Calendar)dateTime);
                    }
                    ++n3;
                }
            }
            this.m_vStartDateTimeVector = vector;
            this.m_vEndDateTimeVector = vector2;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void getRepeatYearlyOccurrenceDates() throws LotusPimException {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.m_oStartTime);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.m_oEndTime);
            Vector<DateTime> vector = new Vector<DateTime>();
            Vector<DateTime> vector2 = new Vector<DateTime>();
            if (this.m_oRecurrenceEndDate != null) {
                boolean bl = false;
                int n = 0;
                while (!bl) {
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.set(calendar.get(1) + n * this.m_iInterval, calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                    Calendar calendar4 = Calendar.getInstance();
                    calendar4.set(calendar2.get(1) + n * this.m_iInterval, calendar2.get(2), calendar2.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13));
                    if (calendar3.get(5) != calendar.get(5)) {
                        calendar3.set(calendar.get(1) + n * this.m_iInterval, calendar.get(2), calendar.get(5) - 1, calendar.get(11), calendar.get(12), calendar.get(13));
                    }
                    if (calendar4.get(5) != calendar2.get(5)) {
                        calendar4.set(calendar2.get(1) + n * this.m_iInterval, calendar2.get(2), calendar2.get(5) - 1, calendar2.get(11), calendar2.get(12), calendar2.get(13));
                    }
                    DateTime dateTime = this.m_oSession.createDateTime(calendar3.getTime());
                    DateTime dateTime2 = this.m_oSession.createDateTime(calendar4.getTime());
                    if (dateTime2.timeDifference(this.m_oSession.createDateTime(this.m_oRecurrenceEndDate)) > 0) {
                        bl = true;
                        break;
                    }
                    vector.add(dateTime);
                    vector2.add(dateTime2);
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.m_iNoOfOccurrences) {
                    Calendar calendar5 = Calendar.getInstance();
                    calendar5.set(calendar.get(1) + n * this.m_iInterval, calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                    Calendar calendar6 = Calendar.getInstance();
                    calendar6.set(calendar2.get(1) + n * this.m_iInterval, calendar2.get(2), calendar2.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13));
                    if (calendar5.get(5) != calendar.get(5)) {
                        calendar5.set(calendar.get(1) + n * this.m_iInterval, calendar.get(2), calendar.get(5) - 1, calendar.get(11), calendar.get(12), calendar.get(13));
                    }
                    if (calendar6.get(5) != calendar2.get(5)) {
                        calendar6.set(calendar2.get(1) + n * this.m_iInterval, calendar2.get(2), calendar2.get(5) - 1, calendar2.get(11), calendar2.get(12), calendar2.get(13));
                    }
                    DateTime dateTime = this.m_oSession.createDateTime(calendar5.getTime());
                    DateTime dateTime3 = this.m_oSession.createDateTime(calendar6.getTime());
                    vector.add(dateTime);
                    vector2.add(dateTime3);
                    ++n;
                }
            }
            this.m_vStartDateTimeVector = vector;
            this.m_vEndDateTimeVector = vector2;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void doValidityCheck() throws LotusPimException {
        try {
            this.m_oStartTime = this.m_oPimMessageItem.getStartTime();
            if (this.m_oStartTime == null) {
                throw new LotusPimException(59L);
            }
            this.m_oEndTime = this.m_oPimMessageItem.getEndTime();
            if (this.m_oEndTime == null) {
                throw new LotusPimException(59L);
            }
            Session session = this.m_oPimMessageItem.getLotusSession();
            if (session.createDateTime(this.m_oEndTime).timeDifference(session.createDateTime(this.m_oStartTime)) < 0) {
                throw new LotusPimException(13L);
            }
            if (this.m_oRecurrenceEndDate != null && session.createDateTime(this.m_oRecurrenceEndDate).timeDifference(session.createDateTime(this.m_oEndTime)) < 0) {
                throw new LotusPimException(61L);
            }
            if (this.m_oPimRecurrencePatternType == null) {
                throw new LotusPimException(60L);
            }
            if (this.m_vDaysOfMonth == null) {
                this.m_vDaysOfMonth = new Vector();
            }
            if (this.m_vDaysOfWeek == null) {
                this.m_vDaysOfWeek = new Vector();
            }
            if (this.m_iInterval < 1) {
                this.m_iInterval = 1;
            }
            if (this.m_iNoOfOccurrences < 1) {
                this.m_iNoOfOccurrences = 1;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
        try {
            this.m_bIsUpdateCalled = false;
            this.doValidityCheck();
            this.generateAppropriateRepeatOccurrenceDates();
            this.generateAppropriateVariableValues();
            this.m_bIsUpdateCalled = true;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            this.m_bIsUpdateCalled = false;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete(boolean bl) throws PimException {
        this.delete();
    }

    private void generateAppropriateVariableValues() throws LotusPimException {
        try {
            this.m_szRepeatFromEnd = "";
            this.m_oRepeatCustom = this.getLotusSession().createDateTime(this.m_oStartTime);
            this.m_szRepeatWeekends = "D";
            this.m_oRepeatStartDate = this.getLotusSession().createDateTime(this.m_oStartTime);
            if (this.m_oRecurrenceEndDate != null) {
                this.m_szRepeatHow = "U";
                this.m_oRepeatUntil = this.getLotusSession().createDateTime(this.m_oRecurrenceEndDate);
                this.m_oRepeatFor = new Integer(this.m_iNoOfOccurrences);
            } else {
                this.m_szRepeatHow = "F";
                this.m_oRepeatUntil = this.getLotusSession().createDateTime(this.m_oStartTime);
                this.m_oRepeatFor = new Integer(this.m_iNoOfOccurrences);
            }
            if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.DAILY)) {
                this.m_szRepeatForUnit = "D";
                this.m_szRepeatUnit = "D";
                this.m_vRepeatAdjust = new Vector();
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.WEEKLY)) {
                this.m_szRepeatForUnit = "W";
                this.m_szRepeatUnit = "W";
                this.m_vRepeatAdjust = new Vector();
                int n = 0;
                while (n < this.m_vDaysOfWeek.size()) {
                    this.m_vRepeatAdjust.add(new String(LotusPimRecurrencePatternDayTypeMapper.getType((PimRecurrencePatternDayType)this.m_vDaysOfWeek.elementAt(n)) - 1 + ""));
                    ++n;
                }
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.MONTHLY)) {
                this.m_szRepeatForUnit = "M";
                this.m_szRepeatUnit = "MD";
                this.m_vRepeatAdjust = new Vector();
                int n = 0;
                while (n < this.m_vDaysOfMonth.size()) {
                    this.m_vRepeatAdjust.add(new String((Integer)this.m_vDaysOfMonth.elementAt(n) + ""));
                    ++n;
                }
            } else if (this.m_oPimRecurrencePatternType.equals(PimRecurrencePatternType.YEARLY)) {
                this.m_szRepeatForUnit = "YD";
                this.m_szRepeatUnit = "YD";
                this.m_vRepeatAdjust = new Vector();
            }
            this.m_szRepeatInterval = new String(this.m_iInterval + "");
            this.m_oStartDateTime = this.getLotusSession().createDateTime(this.m_oStartTime);
            this.m_oEndDateTime = this.getLotusSession().createDateTime(this.m_oEndTime);
            this.m_vRepeatDates = this.m_vStartDateTimeVector;
            this.m_vRepeatOccurrenceDates = this.m_vStartDateTimeVector;
            this.m_oStartDate = this.getLotusSession().createDateTime(this.m_oStartTime);
            this.m_oEndDate = this.getLotusSession().createDateTime(this.m_oEndTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getID() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Session getLotusSession() throws LotusPimException {
        try {
            return this.m_oPimMessageItem.getLotusSession();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItems getFieldItems() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        try {
            return "Recurrence Pattern Item";
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecurrencePatternType getType() throws PimException {
        try {
            return this.m_oPimRecurrencePatternType;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getInterval() throws PimException {
        try {
            return this.m_iInterval;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getDaysOfWeek() throws PimException {
        try {
            return this.m_vDaysOfWeek;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Vector getDaysOfMonth() throws PimException {
        try {
            return this.m_vDaysOfMonth;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getNoOfOccurrences() throws PimException {
        try {
            return this.m_iNoOfOccurrences;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Date getRecurrenceEndDate() throws PimException {
        try {
            return this.m_oRecurrenceEndDate;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecurrencePatternNthType getNthType() throws PimException {
        return null;
    }

    public Vector getMonthsOfYear() throws PimException {
        return null;
    }
}

