/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import com.aligo.pim.lotus.LotusPimAppointmentItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimNewApptNewReminderItem;
import com.aligo.pim.lotus.LotusPimNewRecurrencePatternItem;
import com.aligo.pim.lotus.LotusPimRecipientItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimUtility;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.RichTextItem;
import lotus.domino.RichTextStyle;
import lotus.domino.Session;
import lotus.domino.ViewEntryCollection;

public class LotusPimNewAppointmentItem
extends LotusPimMessageItem
implements PimAppointmentItem {
    private boolean m_bIsAllDayEvent;
    private PimCalendarType m_oPimCalendarType;
    private LotusPimNewRecurrencePatternItem m_oPimRecurrencePatternItem;
    private DateTime m_oStartDateTime;
    private DateTime m_oEndDateTime;
    private String m_szLocation;
    private String m_szChair;
    private String m_szSubject;
    private String m_szFrom;
    private String m_szText;
    private LotusPimNewApptNewReminderItem m_oPimReminderItem;

    public LotusPimNewAppointmentItem(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        super(viewEntryCollection, lotusPimSession, recycle);
        try {
            this.m_bIsAllDayEvent = false;
            this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
            this.m_szLocation = "";
            this.m_szChair = this.getLotusSession().getUserName();
            this.m_szSubject = "";
            this.m_szText = "";
            this.m_szFrom = this.getLotusSession().getUserName();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimCalendarType getType() throws LotusPimException {
        try {
            return this.m_oPimCalendarType;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setType(PimCalendarType pimCalendarType) throws LotusPimException {
        try {
            if (pimCalendarType != null) {
                this.m_oPimCalendarType = pimCalendarType;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getDuration() throws LotusPimException {
        try {
            if (this.isAllDayEvent()) {
                return 1440;
            }
            DateTime dateTime = this.getStartDateTime();
            DateTime dateTime2 = this.getEndDateTime();
            if (dateTime != null && dateTime2 != null) {
                int n = dateTime2.timeDifference(dateTime);
                return n / 60;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return 0;
    }

    public PimReminderItem getReminderItem() throws LotusPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new LotusPimNewApptNewReminderItem(this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimReminderItem addReminderItem() throws LotusPimException {
        try {
            return this.getReminderItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private DateTime getStartDateTime() throws LotusPimException {
        try {
            return this.m_oStartDateTime;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private DateTime getEndDateTime() throws LotusPimException {
        try {
            return this.m_oEndDateTime;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Date getEndTime() throws LotusPimException {
        try {
            DateTime dateTime = this.getEndDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public PimImportanceType getImportance() throws LotusPimException {
        return PimImportanceType.NORMAL;
    }

    public String getLocation() throws LotusPimException {
        try {
            return this.m_szLocation;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getOrganizer() throws LotusPimException {
        try {
            if (this.m_szChair != null) {
                return LotusPimUtility.getAddressEntryItem(this.getLotusSession(), this.m_szChair, this.getLotusPimSession(), this.getRecycle());
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public Date getStartTime() throws LotusPimException {
        try {
            DateTime dateTime = this.getStartDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public String getSubject() throws LotusPimException {
        try {
            return this.m_szSubject;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getText() throws LotusPimException {
        try {
            return this.m_szText;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public boolean isAllDayEvent() throws LotusPimException {
        try {
            return this.m_bIsAllDayEvent;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setBusyStatusType(PimBusyStatusType pimBusyStatusType) throws LotusPimException {
    }

    public void setAllDayEvent(boolean bl) throws LotusPimException {
        try {
            this.m_bIsAllDayEvent = bl;
            if (this.m_bIsAllDayEvent) {
                this.setAllDayEventDates();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setEndTime(Date date) throws LotusPimException {
        try {
            DateTime dateTime;
            this.m_oEndDateTime = dateTime = this.getLotusSession().createDateTime(date);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setImportance(PimImportanceType pimImportanceType) throws LotusPimException {
    }

    public void setLocation(String string) throws LotusPimException {
        try {
            this.m_szLocation = string;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setStartTime(Date date) throws LotusPimException {
        try {
            DateTime dateTime = this.getLotusSession().createDateTime(date);
            DateTime dateTime2 = this.getEndDateTime();
            if (dateTime2 != null && dateTime2.timeDifference(dateTime) < 0) {
                throw new LotusPimException(13L);
            }
            this.m_oStartDateTime = dateTime;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSubject(String string) throws LotusPimException {
        try {
            this.m_szSubject = string;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setText(String string) throws LotusPimException {
        try {
            this.m_szText = string;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)"FW: Appointment Item forwarded ");
            LotusPimAppointmentItem lotusPimAppointmentItem = new LotusPimAppointmentItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimAppointmentItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void send() throws LotusPimException {
        try {
            if (this.getLotusDocument().getItemValueInteger("_ViewIcon") == 158 && this.getLotusDocument().getItemValueString("AppointmentType").equals("3")) {
                Document document = this.getLotusDatabase().createDocument();
                this.getRecycle().add(document);
                this.getLotusDocument().copyAllItems(document, true);
                document.replaceItemValue("Form", (Object)"Notice");
                document.replaceItemValue("_ViewIcon", (Object)new Integer(133));
                document.replaceItemValue("subject", (Object)("Invitation: " + this.getSubject() + " (" + this.getStartTime() + " in " + this.getLocation() + ")"));
                document.replaceItemValue("Topic", (Object)this.getSubject());
                document.replaceItemValue("NoticeType", (Object)"I");
                document.replaceItemValue("ApptUNID", (Object)this.getID());
                document.replaceItemValue("$Orig", (Object)this.getID());
                LotusPimRecipientItems lotusPimRecipientItems = this.getLotusPimRecipientItems();
                if (lotusPimRecipientItems != null) {
                    document.replaceItemValue("SendTo", (Object)lotusPimRecipientItems.getSendToVector());
                    document.replaceItemValue("CopyTo", (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue("AltCopyTo", (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue("AltSendTo", (Object)lotusPimRecipientItems.getSendToVector());
                    document.replaceItemValue("InetCopyTo", (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue("InetSendTo", (Object)lotusPimRecipientItems.getSendToVector());
                }
                this.getLotusDocument().replaceItemValue("$StorageCc", (Object)this.getLotusDocument().getItemValue("StorageOptionalNames"));
                this.getLotusDocument().replaceItemValue("$StorageTo", (Object)this.getLotusDocument().getItemValue("StorageRequiredNames"));
                LotusPimAppointmentItem lotusPimAppointmentItem = new LotusPimAppointmentItem(document, this.getLotusPimSession(), this.getRecycle());
                lotusPimAppointmentItem.send();
                return;
            }
            super.send();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setChair(String string) throws LotusPimException {
        try {
            this.m_szChair = string;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setFrom(String string) throws LotusPimException {
        try {
            this.m_szFrom = string;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSendTo(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("SendTo", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        try {
            return "New Appointment: " + this.getSubject() + " in " + this.getLocation();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternItem == null) {
                this.m_oPimRecurrencePatternItem = new LotusPimNewRecurrencePatternItem(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private boolean checkIfDateSpansOvernight() throws LotusPimException {
        Date date = this.getStartTime();
        Date date2 = this.getEndTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(2);
        int n2 = gregorianCalendar.get(5);
        int n3 = gregorianCalendar.get(1);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        int n4 = gregorianCalendar2.get(2);
        int n5 = gregorianCalendar2.get(5);
        int n6 = gregorianCalendar2.get(1);
        return n != n4 || n2 != n5 || n3 != n6;
    }

    public void setAllDayEventDates() throws LotusPimException {
        Date date = this.getStartTime();
        Date date2 = this.getEndTime();
        if (date == null) {
            throw new LotusPimException(58L);
        }
        if (date2 == null) {
            date2 = date;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(2);
        int n2 = gregorianCalendar.get(5);
        int n3 = gregorianCalendar.get(1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n3, n, n2, 4, 0, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        int n4 = gregorianCalendar2.get(2);
        int n5 = gregorianCalendar2.get(5);
        int n6 = gregorianCalendar2.get(1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(n6, n4, n5, 20, 0, 0);
        this.setStartTime(calendar.getTime());
        this.setEndTime(calendar2.getTime());
    }

    private String getFrom() throws LotusPimException {
        try {
            if (this.m_szFrom == null) {
                this.m_szFrom = this.getLotusSession().getUserName();
            }
            return this.m_szFrom;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private String getChair() throws LotusPimException {
        try {
            if (this.m_szChair == null) {
                this.m_szChair = this.getLotusSession().getUserName();
            }
            return this.m_szChair;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void writeAppointmentParentDocument() throws LotusPimException {
        block4: {
            try {
                if (this.m_oPimRecurrencePatternItem == null) break block4;
                Session session = this.getLotusSession();
                this.writeReminderValues(this.getLotusDocument());
                this.getLotusDocument().replaceItemValue("$PublicAccess", (Object)"1");
                this.getLotusDocument().replaceItemValue("Principal", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("$AltPrincipal", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("$LangPrincipal", (Object)"");
                this.getLotusDocument().replaceItemValue("Chair", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("AltChair", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("$LangChair", (Object)"");
                Vector<String> vector = new Vector<String>();
                vector.add("D");
                vector.add("S");
                this.getLotusDocument().replaceItemValue("ExcludeFromView", vector);
                this.getLotusDocument().replaceItemValue("SequenceNum", (Object)new Integer(1));
                this.getLotusDocument().replaceItemValue("ApptUNID", (Object)this.getID());
                this.getLotusDocument().replaceItemValue("$CSVersion", (Object)"2");
                this.getLotusDocument().replaceItemValue("MailFirstPass", (Object)"1");
                this.getLotusDocument().replaceItemValue("$SMTPKeepNotesItems", (Object)"1");
                this.getLotusDocument().replaceItemValue("WebDateTimeInit", (Object)"1");
                this.getLotusDocument().replaceItemValue("OrgTable", (Object)"CO");
                this.getLotusDocument().replaceItemValue("RepeatAdjust", (Object)this.m_oPimRecurrencePatternItem.getRepeatAdjust());
                this.getLotusDocument().replaceItemValue("RepeatFromEnd", (Object)this.m_oPimRecurrencePatternItem.getRepeatFromEnd());
                this.getLotusDocument().replaceItemValue("RepeatCustom", (Object)this.m_oPimRecurrencePatternItem.getRepeatCustom());
                this.getLotusDocument().replaceItemValue("RepeatWeekends", (Object)this.m_oPimRecurrencePatternItem.getRepeatWeekends());
                this.getLotusDocument().replaceItemValue("RepeatStartDate", (Object)this.m_oPimRecurrencePatternItem.getRepeatStartDate());
                this.getLotusDocument().replaceItemValue("RepeatHow", (Object)this.m_oPimRecurrencePatternItem.getRepeatHow());
                this.getLotusDocument().replaceItemValue("RepeatUntil", (Object)this.m_oPimRecurrencePatternItem.getRepeatUntil());
                this.getLotusDocument().replaceItemValue("RepeatFor", (Object)this.m_oPimRecurrencePatternItem.getRepeatFor());
                this.getLotusDocument().replaceItemValue("RepeatForUnit", (Object)this.m_oPimRecurrencePatternItem.getRepeatForUnit());
                this.getLotusDocument().replaceItemValue("RepeatUnit", (Object)this.m_oPimRecurrencePatternItem.getRepeatUnit());
                this.getLotusDocument().replaceItemValue("RepeatInterval", (Object)this.m_oPimRecurrencePatternItem.getRepeatInterval());
                this.getLotusDocument().replaceItemValue("OrgRepeat", (Object)"1");
                this.getLotusDocument().replaceItemValue("STARTDATETIME", (Object)this.m_oPimRecurrencePatternItem.getStartDateTime());
                this.getLotusDocument().replaceItemValue("EndDateTime", (Object)this.m_oPimRecurrencePatternItem.getEndDateTime());
                this.getLotusDocument().replaceItemValue("RepeatDates", (Object)this.m_oPimRecurrencePatternItem.getRepeatDates());
                this.getLotusDocument().replaceItemValue("RepeatInstanceDates", (Object)this.m_oPimRecurrencePatternItem.getRepeatOccurrenceDates());
                this.getLotusDocument().replaceItemValue("$CSFlags", (Object)"c");
                this.getLotusDocument().replaceItemValue("$WebFlags", (Object)"J");
                this.getLotusDocument().replaceItemValue("Form", (Object)"Appointment");
                this.getLotusDocument().replaceItemValue("$ExpandGroups", (Object)"3");
                this.getLotusDocument().replaceItemValue("Logo", (Object)"stdNotesLtr0");
                this.getLotusDocument().replaceItemValue("SaveOptions", (Object)"");
                this.getLotusDocument().replaceItemValue("MailOptions", (Object)"0");
                this.getLotusDocument().replaceItemValue("Sign", (Object)"0");
                this.getLotusDocument().replaceItemValue("Encrypt", (Object)"0");
                this.getLotusDocument().replaceItemValue("From", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("location", (Object)this.getLocation());
                this.getLotusDocument().replaceItemValue("subject", (Object)this.getSubject());
                try {
                    RichTextItem richTextItem = this.getLotusDocument().createRichTextItem("Body");
                    RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                    richTextStyle.setFontSize(9);
                    richTextItem.appendStyle(richTextStyle);
                    richTextItem.appendText(this.getText());
                }
                catch (Exception exception) {
                    this.getLotusDocument().replaceItemValue("Body", (Object)this.getText());
                }
                this.getLotusDocument().replaceItemValue("StartTime", (Object)this.m_oPimRecurrencePatternItem.getStartTime());
                this.writeAllDaySpecificStuff(this.getLotusDocument());
                this.getLotusDocument().replaceItemValue("Repeats", (Object)"1");
                this.getLotusDocument().replaceItemValue("tmpOwnerHW", (Object)"1");
                this.getLotusDocument().replaceItemValue("StartDate", (Object)this.m_oPimRecurrencePatternItem.getStartDate());
                this.getLotusDocument().replaceItemValue("EndDate", (Object)this.m_oPimRecurrencePatternItem.getEndDate());
                this.getLotusDocument().replaceItemValue("EndTime", (Object)this.m_oPimRecurrencePatternItem.getEndTime());
                this.getLotusDocument().replaceItemValue("$UpdatedBy", (Object)session.getUserName());
                super.update();
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }
    }

    private void writeAppointmentChildDocument() throws LotusPimException {
        block4: {
            try {
                if (this.m_oPimRecurrencePatternItem == null) break block4;
                Session session = this.getLotusSession();
                Document document = this.getLotusDatabase().createDocument();
                this.getRecycle().add(document);
                this.writeReminderValues(document);
                document.replaceItemValue("$PublicAccess", (Object)"1");
                document.replaceItemValue("Principal", (Object)session.getUserName());
                document.replaceItemValue("$AltPrincipal", (Object)session.getUserName());
                document.replaceItemValue("$LangPrincipal", (Object)"");
                document.replaceItemValue("Chair", (Object)session.getUserName());
                document.replaceItemValue("AltChair", (Object)session.getUserName());
                document.replaceItemValue("$LangChair", (Object)"");
                Vector<String> vector = new Vector<String>();
                vector.add("D");
                vector.add("S");
                document.replaceItemValue("ExcludeFromView", vector);
                document.replaceItemValue("SequenceNum", (Object)new Integer(1));
                document.replaceItemValue("$CSVersion", (Object)"2");
                document.replaceItemValue("MailFirstPass", (Object)"1");
                document.replaceItemValue("$SMTPKeepNotesItems", (Object)"1");
                document.replaceItemValue("WebDateTimeInit", (Object)"1");
                document.replaceItemValue("OrgTable", (Object)"CO");
                document.replaceItemValue("RepeatFromEnd", (Object)this.m_oPimRecurrencePatternItem.getChildRepeatFromEnd());
                document.replaceItemValue("OrgRepeat", (Object)"1");
                document.replaceItemValue("$WebFlags", (Object)"J");
                document.replaceItemValue("Form", (Object)"Appointment");
                document.replaceItemValue("$ExpandGroups", (Object)"3");
                document.replaceItemValue("Logo", (Object)"stdNotesLtr0");
                document.replaceItemValue("SaveOptions", (Object)"");
                document.replaceItemValue("MailOptions", (Object)"0");
                document.replaceItemValue("Sign", (Object)"0");
                document.replaceItemValue("Encrypt", (Object)"0");
                document.replaceItemValue("From", (Object)session.getUserName());
                document.replaceItemValue("location", (Object)this.getLocation());
                document.replaceItemValue("subject", (Object)this.getSubject());
                try {
                    RichTextItem richTextItem = document.createRichTextItem("Body");
                    RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                    richTextStyle.setFontSize(9);
                    richTextItem.appendStyle(richTextStyle);
                    richTextItem.appendText(this.getText());
                }
                catch (Exception exception) {
                    document.replaceItemValue("Body", (Object)this.getText());
                }
                this.writeAllDaySpecificStuff(document);
                document.replaceItemValue("Repeats", (Object)"1");
                document.replaceItemValue("StartDate", (Object)this.m_oPimRecurrencePatternItem.getChildStartDate());
                document.replaceItemValue("StartTime", (Object)this.m_oPimRecurrencePatternItem.getChildStartTime());
                document.replaceItemValue("EndDate", (Object)this.m_oPimRecurrencePatternItem.getChildEndDate());
                document.replaceItemValue("EndTime", (Object)this.m_oPimRecurrencePatternItem.getChildEndTime());
                document.replaceItemValue("$RefOptions", (Object)"1");
                document.replaceItemValue("$CSFlags", (Object)"i");
                document.replaceItemValue("$BusyName", (Object)session.getUserName());
                document.replaceItemValue("$BusyPriority", (Object)"1");
                document.replaceItemValue("STARTDATETIME", (Object)this.m_oPimRecurrencePatternItem.getChildStartDateTime());
                document.replaceItemValue("EndDateTime", (Object)this.m_oPimRecurrencePatternItem.getChildEndDateTime());
                document.replaceItemValue("CalendarDateTime", (Object)this.m_oPimRecurrencePatternItem.getChildCalendarDateTime());
                document.replaceItemValue("RepeatInstanceDates", (Object)this.m_oPimRecurrencePatternItem.getChildRepeatOccurrenceDates());
                document.replaceItemValue("$UpdatedBy", (Object)session.getUserName());
                document.makeResponse(this.getLotusDocument());
                document.save(true, true);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }
    }

    private void writeReminderValues(Document document) throws LotusPimException {
        try {
            if (this.m_oPimReminderItem != null && this.m_oPimReminderItem.isReminderSet()) {
                document.replaceItemValue("$Alarm", (Object)new Integer(1));
                document.replaceItemValue("$AlarmDescription", (Object)this.getSubject());
                document.replaceItemValue("$AlarmMemoOptions", (Object)"");
                document.replaceItemValue("Alarms", (Object)"1");
                document.replaceItemValue("$AlarmUnit", (Object)this.m_oPimReminderItem.getAlarmUnit());
                document.replaceItemValue("$AlarmOffset", (Object)new Integer(-1L * this.m_oPimReminderItem.getNoOfMinutesBeforeStart() + ""));
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void writeMeetingParentDocument() throws LotusPimException {
        block4: {
            try {
                if (this.m_oPimRecurrencePatternItem == null) break block4;
                Session session = this.getLotusSession();
                this.writeMeetingSpecificValues(this.getLotusDocument());
                this.writeReminderValues(this.getLotusDocument());
                this.getLotusDocument().replaceItemValue("$PublicAccess", (Object)"1");
                this.getLotusDocument().replaceItemValue("Principal", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("$AltPrincipal", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("$LangPrincipal", (Object)"");
                this.getLotusDocument().replaceItemValue("Chair", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("AltChair", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("$LangChair", (Object)"");
                Vector<String> vector = new Vector<String>();
                vector.add("D");
                vector.add("S");
                this.getLotusDocument().replaceItemValue("ExcludeFromView", vector);
                this.getLotusDocument().replaceItemValue("SequenceNum", (Object)new Integer(1));
                this.getLotusDocument().replaceItemValue("ApptUNID", (Object)this.getID());
                this.getLotusDocument().replaceItemValue("$CSVersion", (Object)"2");
                this.getLotusDocument().replaceItemValue("MailFirstPass", (Object)"1");
                this.getLotusDocument().replaceItemValue("$SMTPKeepNotesItems", (Object)"1");
                this.getLotusDocument().replaceItemValue("WebDateTimeInit", (Object)"1");
                this.getLotusDocument().replaceItemValue("OrgTable", (Object)"CO");
                this.getLotusDocument().replaceItemValue("RepeatAdjust", (Object)this.m_oPimRecurrencePatternItem.getRepeatAdjust());
                this.getLotusDocument().replaceItemValue("RepeatFromEnd", (Object)this.m_oPimRecurrencePatternItem.getRepeatFromEnd());
                this.getLotusDocument().replaceItemValue("RepeatCustom", (Object)this.m_oPimRecurrencePatternItem.getRepeatCustom());
                this.getLotusDocument().replaceItemValue("RepeatWeekends", (Object)this.m_oPimRecurrencePatternItem.getRepeatWeekends());
                this.getLotusDocument().replaceItemValue("RepeatStartDate", (Object)this.m_oPimRecurrencePatternItem.getRepeatStartDate());
                this.getLotusDocument().replaceItemValue("RepeatHow", (Object)this.m_oPimRecurrencePatternItem.getRepeatHow());
                this.getLotusDocument().replaceItemValue("RepeatUntil", (Object)this.m_oPimRecurrencePatternItem.getRepeatUntil());
                this.getLotusDocument().replaceItemValue("RepeatFor", (Object)this.m_oPimRecurrencePatternItem.getRepeatFor());
                this.getLotusDocument().replaceItemValue("RepeatForUnit", (Object)this.m_oPimRecurrencePatternItem.getRepeatForUnit());
                this.getLotusDocument().replaceItemValue("RepeatUnit", (Object)this.m_oPimRecurrencePatternItem.getRepeatUnit());
                this.getLotusDocument().replaceItemValue("RepeatInterval", (Object)this.m_oPimRecurrencePatternItem.getRepeatInterval());
                this.getLotusDocument().replaceItemValue("OrgRepeat", (Object)"1");
                this.getLotusDocument().replaceItemValue("STARTDATETIME", (Object)this.m_oPimRecurrencePatternItem.getStartDateTime());
                this.getLotusDocument().replaceItemValue("EndDateTime", (Object)this.m_oPimRecurrencePatternItem.getEndDateTime());
                this.getLotusDocument().replaceItemValue("_ViewIcon", (Object)new Integer(158));
                this.getLotusDocument().replaceItemValue("RepeatDates", (Object)this.m_oPimRecurrencePatternItem.getRepeatDates());
                this.getLotusDocument().replaceItemValue("RepeatInstanceDates", (Object)this.m_oPimRecurrencePatternItem.getRepeatOccurrenceDates());
                this.getLotusDocument().replaceItemValue("$CSFlags", (Object)"c");
                this.getLotusDocument().replaceItemValue("$WebFlags", (Object)"J");
                this.getLotusDocument().replaceItemValue("Form", (Object)"Appointment");
                this.getLotusDocument().replaceItemValue("$ExpandGroups", (Object)"3");
                this.getLotusDocument().replaceItemValue("Logo", (Object)"stdNotesLtr0");
                this.getLotusDocument().replaceItemValue("SaveOptions", (Object)"");
                this.getLotusDocument().replaceItemValue("MailOptions", (Object)"0");
                this.getLotusDocument().replaceItemValue("Sign", (Object)"0");
                this.getLotusDocument().replaceItemValue("Encrypt", (Object)"0");
                this.getLotusDocument().replaceItemValue("From", (Object)session.getUserName());
                this.getLotusDocument().replaceItemValue("location", (Object)this.getLocation());
                this.getLotusDocument().replaceItemValue("subject", (Object)this.getSubject());
                try {
                    RichTextItem richTextItem = this.getLotusDocument().createRichTextItem("Body");
                    RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                    richTextStyle.setFontSize(9);
                    richTextItem.appendStyle(richTextStyle);
                    richTextItem.appendText(this.getText());
                }
                catch (Exception exception) {
                    this.getLotusDocument().replaceItemValue("Body", (Object)this.getText());
                }
                this.getLotusDocument().replaceItemValue("StartTime", (Object)this.m_oPimRecurrencePatternItem.getStartTime());
                this.getLotusDocument().replaceItemValue("AppointmentType", (Object)"3");
                this.getLotusDocument().replaceItemValue("Repeats", (Object)"1");
                this.getLotusDocument().replaceItemValue("tmpOwnerHW", (Object)"1");
                this.getLotusDocument().replaceItemValue("StartDate", (Object)this.m_oPimRecurrencePatternItem.getStartDate());
                this.getLotusDocument().replaceItemValue("EndDate", (Object)this.m_oPimRecurrencePatternItem.getEndDate());
                this.getLotusDocument().replaceItemValue("EndTime", (Object)this.m_oPimRecurrencePatternItem.getEndTime());
                this.getLotusDocument().replaceItemValue("$UpdatedBy", (Object)session.getUserName());
                super.update();
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }
    }

    private void writeMeetingChildDocument() throws LotusPimException {
        block4: {
            try {
                if (this.m_oPimRecurrencePatternItem == null) break block4;
                Session session = this.getLotusSession();
                Document document = this.getLotusDatabase().createDocument();
                this.getRecycle().add(document);
                this.writeMeetingSpecificValues(document);
                this.writeReminderValues(document);
                document.replaceItemValue("$PublicAccess", (Object)"1");
                document.replaceItemValue("Principal", (Object)session.getUserName());
                document.replaceItemValue("$AltPrincipal", (Object)session.getUserName());
                document.replaceItemValue("$LangPrincipal", (Object)"");
                document.replaceItemValue("Chair", (Object)session.getUserName());
                document.replaceItemValue("AltChair", (Object)session.getUserName());
                document.replaceItemValue("$LangChair", (Object)"");
                Vector<String> vector = new Vector<String>();
                vector.add("D");
                vector.add("S");
                document.replaceItemValue("ExcludeFromView", vector);
                document.replaceItemValue("SequenceNum", (Object)new Integer(1));
                document.replaceItemValue("$CSVersion", (Object)"2");
                document.replaceItemValue("MailFirstPass", (Object)"1");
                document.replaceItemValue("$SMTPKeepNotesItems", (Object)"1");
                document.replaceItemValue("WebDateTimeInit", (Object)"1");
                document.replaceItemValue("OrgTable", (Object)"CO");
                document.replaceItemValue("RepeatFromEnd", (Object)this.m_oPimRecurrencePatternItem.getChildRepeatFromEnd());
                document.replaceItemValue("OrgRepeat", (Object)"1");
                document.replaceItemValue("$WebFlags", (Object)"J");
                document.replaceItemValue("Form", (Object)"Appointment");
                document.replaceItemValue("$ExpandGroups", (Object)"3");
                document.replaceItemValue("Logo", (Object)"stdNotesLtr0");
                document.replaceItemValue("SaveOptions", (Object)"");
                document.replaceItemValue("MailOptions", (Object)"0");
                document.replaceItemValue("Sign", (Object)"0");
                document.replaceItemValue("Encrypt", (Object)"0");
                document.replaceItemValue("From", (Object)session.getUserName());
                document.replaceItemValue("location", (Object)this.getLocation());
                document.replaceItemValue("subject", (Object)this.getSubject());
                try {
                    RichTextItem richTextItem = document.createRichTextItem("Body");
                    RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                    richTextStyle.setFontSize(9);
                    richTextItem.appendStyle(richTextStyle);
                    richTextItem.appendText(this.getText());
                }
                catch (Exception exception) {
                    document.replaceItemValue("Body", (Object)this.getText());
                }
                document.replaceItemValue("AppointmentType", (Object)"3");
                document.replaceItemValue("Repeats", (Object)"1");
                document.replaceItemValue("StartDate", (Object)this.m_oPimRecurrencePatternItem.getChildStartDate());
                document.replaceItemValue("StartTime", (Object)this.m_oPimRecurrencePatternItem.getChildStartTime());
                document.replaceItemValue("EndDate", (Object)this.m_oPimRecurrencePatternItem.getChildEndDate());
                document.replaceItemValue("EndTime", (Object)this.m_oPimRecurrencePatternItem.getChildEndTime());
                document.replaceItemValue("_ViewIcon", (Object)new Integer(158));
                document.replaceItemValue("$RefOptions", (Object)"1");
                document.replaceItemValue("$CSFlags", (Object)"i");
                document.replaceItemValue("$BusyName", (Object)session.getUserName());
                document.replaceItemValue("$BusyPriority", (Object)"1");
                document.replaceItemValue("STARTDATETIME", (Object)this.m_oPimRecurrencePatternItem.getChildStartDateTime());
                document.replaceItemValue("EndDateTime", (Object)this.m_oPimRecurrencePatternItem.getChildEndDateTime());
                document.replaceItemValue("CalendarDateTime", (Object)this.m_oPimRecurrencePatternItem.getChildCalendarDateTime());
                document.replaceItemValue("RepeatInstanceDates", (Object)this.m_oPimRecurrencePatternItem.getChildRepeatOccurrenceDates());
                document.replaceItemValue("$UpdatedBy", (Object)session.getUserName());
                document.makeResponse(this.getLotusDocument());
                document.save(true, true);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }
    }

    private void updateAsRecurringItem() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternItem != null) {
                if (!this.m_oPimRecurrencePatternItem.isItRecurringItem()) {
                    this.m_oPimRecurrencePatternItem.update();
                }
                if (this.m_oPimCalendarType == null) {
                    this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
                }
                if (this.m_oPimCalendarType.equals(PimCalendarType.APPOINTMENT)) {
                    if (this.checkIfDateSpansOvernight()) {
                        throw new LotusPimException(54L);
                    }
                    this.writeAppointmentParentDocument();
                    this.writeAppointmentChildDocument();
                } else if (this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                    if (this.checkIfDateSpansOvernight()) {
                        throw new LotusPimException(54L);
                    }
                    this.writeMeetingParentDocument();
                    this.writeMeetingChildDocument();
                }
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void updateAsNormalItem() throws LotusPimException {
        try {
            if (this.m_oPimCalendarType == null) {
                this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
            }
            Cloneable cloneable = this.getStartTime();
            Date date = this.getEndTime();
            if (cloneable == null) {
                cloneable = new Date();
                this.setStartTime((Date)cloneable);
            }
            if (date == null) {
                date = cloneable;
                this.setEndTime(date);
            }
            if (this.getEndDateTime().timeDifference(this.getStartDateTime()) < 0) {
                throw new LotusPimException(13L);
            }
            this.writeReminderValues(this.getLotusDocument());
            this.getLotusDocument().replaceItemValue("Chair", (Object)this.getChair());
            this.getLotusDocument().replaceItemValue("From", (Object)this.getFrom());
            this.getLotusDocument().replaceItemValue("location", (Object)this.getLocation());
            this.getLotusDocument().replaceItemValue("subject", (Object)this.getSubject());
            try {
                cloneable = this.getLotusDocument().createRichTextItem("Body");
                date = this.getLotusSession().createRichTextStyle();
                date.setFontSize(9);
                cloneable.appendStyle((RichTextStyle)date);
                cloneable.appendText(this.getText());
            }
            catch (Exception exception) {
                this.getLotusDocument().replaceItemValue("Body", (Object)this.getText());
            }
            this.getLotusDocument().replaceItemValue("endDate", (Object)this.getEndDateTime());
            this.getLotusDocument().replaceItemValue("endTime", (Object)this.getEndDateTime());
            this.getLotusDocument().replaceItemValue("EndDateTime", (Object)this.getEndDateTime());
            this.getLotusDocument().replaceItemValue("CalendarDateTime", (Object)this.getStartDateTime());
            this.getLotusDocument().replaceItemValue("StartDate", (Object)this.getStartDateTime());
            this.getLotusDocument().replaceItemValue("StartTime", (Object)this.getStartDateTime());
            this.getLotusDocument().replaceItemValue("StartDateTime", (Object)this.getStartDateTime());
            this.getLotusDocument().replaceItemValue("$BusyName", (Object)this.getLotusSession().getUserName());
            this.getLotusDocument().replaceItemValue("$BusyPriority", (Object)"1");
            this.getLotusDocument().replaceItemValue("$CSVersion", (Object)"2");
            this.getLotusDocument().replaceItemValue("$ExpandGroups", (Object)"3");
            this.getLotusDocument().replaceItemValue("$NoPurge", (Object)this.getStartDateTime());
            this.getLotusDocument().replaceItemValue("$PublicAccess ", (Object)"1");
            this.getLotusDocument().replaceItemValue("$SMTPKeepNotesItems", (Object)"1");
            this.getLotusDocument().replaceItemValue("$UpdatedBy", (Object)this.getLotusSession().getUserName());
            this.getLotusDocument().replaceItemValue("$WebFlags", (Object)"J");
            this.getLotusDocument().replaceItemValue("ApptUNID", (Object)this.getID());
            this.getLotusDocument().replaceItemValue("Encrypt", (Object)"0");
            cloneable = new Vector();
            ((Vector)cloneable).add("D");
            ((Vector)cloneable).add("S");
            this.getLotusDocument().replaceItemValue("ExcludeFromView", (Object)cloneable);
            this.getLotusDocument().replaceItemValue("Encrypt", (Object)"0");
            this.getLotusDocument().replaceItemValue("Form", (Object)"Appointment");
            this.getLotusDocument().replaceItemValue("Logo", (Object)"stdNotesLtr0");
            this.getLotusDocument().replaceItemValue("MailFirstPass", (Object)"1");
            this.getLotusDocument().replaceItemValue("Principal", (Object)this.getLotusSession().getUserName());
            this.getLotusDocument().replaceItemValue("SequenceNum", (Object)"1");
            this.getLotusDocument().replaceItemValue("Sign", (Object)"0");
            this.getLotusDocument().replaceItemValue("tmpOwnerHW", (Object)"1");
            this.getLotusDocument().replaceItemValue("WebDateTimeInit", (Object)"1");
            if (this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                if (this.checkIfDateSpansOvernight()) {
                    throw new LotusPimException(54L);
                }
                if (this.m_bIsAllDayEvent) {
                    this.setAllDayEventDates();
                }
                this.writeMeetingSpecificValues(this.getLotusDocument());
            } else {
                if (this.checkIfDateSpansOvernight()) {
                    throw new LotusPimException(54L);
                }
                this.writeAllDaySpecificStuff(this.getLotusDocument());
            }
            super.update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void writeMeetingSpecificValues(Document document) throws LotusPimException {
        try {
            LotusPimRecipientItems lotusPimRecipientItems = this.getLotusPimRecipientItems();
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            if (lotusPimRecipientItems != null) {
                vector = lotusPimRecipientItems.getSendToVector();
                vector2 = lotusPimRecipientItems.getCopyToVector();
                vector3 = lotusPimRecipientItems.getBlindCopyToVector();
                document.replaceItemValue("SendTo", (Object)vector);
                document.replaceItemValue("CopyTo", (Object)vector2);
                document.replaceItemValue("BlindCopyTo", (Object)vector3);
            }
            document.replaceItemValue("OptionalAttendees", vector2);
            document.replaceItemValue("AltFYINames", (Object)vector3);
            document.replaceItemValue("AltOptionalNames", (Object)vector2);
            document.replaceItemValue("AltRequiredNames", (Object)vector);
            document.replaceItemValue("AppointmentType", (Object)"3");
            document.replaceItemValue("FYIAttendees", (Object)vector3);
            document.replaceItemValue("INetFYINames", (Object)vector3);
            document.replaceItemValue("INetOptionalNames", (Object)vector2);
            document.replaceItemValue("INetRequiredNames", (Object)vector);
            Vector vector4 = new Vector();
            vector4.addAll(vector);
            vector4.addAll(vector2);
            vector4.addAll(vector3);
            document.replaceItemValue("Recipients", vector4);
            document.replaceItemValue("RequiredAttendees", (Object)vector);
            document.replaceItemValue("_ViewIcon", (Object)new Integer(158));
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            int n = 0;
            while (n < vector.size()) {
                vector5.add("1");
                ++n;
            }
            int n2 = 0;
            while (n2 < vector2.size()) {
                vector6.add("1");
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector3.size()) {
                vector7.add("1");
                ++n3;
            }
            document.replaceItemValue("StorageFYINames", vector7);
            document.replaceItemValue("StorageOptionalNames", vector6);
            document.replaceItemValue("StorageRequiredNames", vector5);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternItem != null && this.m_oPimRecurrencePatternItem.isItRecurringItem()) {
                this.updateAsRecurringItem();
            } else {
                this.updateAsNormalItem();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void writeAllDaySpecificStuff(Document document) throws LotusPimException {
        try {
            if (this.m_bIsAllDayEvent) {
                document.replaceItemValue("AppointmentType", (Object)"2");
                document.replaceItemValue("OrgTable", (Object)"PO");
                document.replaceItemValue("_ViewIcon", (Object)new Integer(9));
                this.setAllDayEventDates();
            } else {
                document.replaceItemValue("AppointmentType", (Object)"0");
                document.replaceItemValue("MailOptions", (Object)"0");
                document.replaceItemValue("OrgTable", (Object)"CO");
                document.replaceItemValue("_ViewIcon", (Object)new Integer(160));
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

