/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimFolderItemsType;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimFolders;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.lotus.LotusPimCalendar;
import com.aligo.pim.lotus.LotusPimDraft;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimInbox;
import com.aligo.pim.lotus.LotusPimItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Vector;
import lotus.domino.View;

public class LotusPimFolders
extends LotusPimItems
implements PimFolders {
    String _oPath;
    Vector _oViews;
    LotusPimCalendar m_oPimCalendar;

    public LotusPimFolders(Vector vector, String string, LotusPimCalendar lotusPimCalendar, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this._oViews = vector;
        this._oPath = string;
        this.m_oPimCalendar = lotusPimCalendar;
        this.sort();
        this.refineFodlers();
    }

    public int getCount() throws LotusPimException {
        return this._oViews.size();
    }

    public void delete() throws LotusPimException {
    }

    public PimFolder addFolder() throws LotusPimException {
        return this.addFolder("Unknown");
    }

    public PimFolder addFolder(String string) throws LotusPimException {
        return this.addFolder(string, PimFolderItemsType.MAIL_ITEMS);
    }

    public PimFolder addFolder(String string, PimFolderItemsType pimFolderItemsType) throws LotusPimException {
        try {
            this.getLotusPimSession().getLotusMailDatabase().enableFolder(this._oPath + string);
            View view = this.getLotusPimSession().getLotusMailDatabase().getView(this._oPath + string);
            return new LotusPimInbox(view, this.m_oPimCalendar, this.getLotusPimSession(), this.getRecycle());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFolder getFolder(int n) throws LotusPimException {
        View view = (View)this._oViews.elementAt(n);
        return this.getRespectiveFolder(view);
    }

    public PimFolder getFolder(String string) throws LotusPimException {
        View view = this.getLotusPimSession().getView(string, this._oPath);
        if (view == null) {
            return null;
        }
        return this.getRespectiveFolder(view);
    }

    public PimFolder getFirstFolder() throws LotusPimException {
        int n = this.getFirstIndex();
        if (n >= this.getCount()) {
            return null;
        }
        View view = (View)this._oViews.elementAt(n);
        return this.getRespectiveFolder(view);
    }

    public PimFolder getNextFolder() throws LotusPimException {
        int n = this.getNextIndex();
        if (n >= this.getCount()) {
            return null;
        }
        View view = (View)this._oViews.elementAt(n);
        return this.getRespectiveFolder(view);
    }

    public PimFolder getLastFolder() throws LotusPimException {
        int n = this.getLastIndex();
        if (n >= this.getCount()) {
            return null;
        }
        View view = (View)this._oViews.elementAt(n);
        return this.getRespectiveFolder(view);
    }

    public PimFolder getPreviousFolder() throws LotusPimException {
        int n = this.getPreviousIndex();
        if (n >= this.getCount()) {
            return null;
        }
        View view = (View)this._oViews.elementAt(n);
        return this.getRespectiveFolder(view);
    }

    public PimItem getItem(int n) throws LotusPimException {
        return this.getFolder(n);
    }

    public PimItem getItem(String string) throws LotusPimException {
        return this.getFolder(string);
    }

    public PimItem addItem() throws LotusPimException {
        return this.addFolder();
    }

    public PimItem getFirstItem() throws LotusPimException {
        return this.getFirstFolder();
    }

    public PimItem getNextItem() throws LotusPimException {
        return this.getNextFolder();
    }

    public PimItem getLastItem() throws LotusPimException {
        return this.getLastFolder();
    }

    public PimItem getPreviousItem() throws LotusPimException {
        return this.getPreviousFolder();
    }

    public void refineFodlers() {
        try {
            String string = "";
            int n = 0;
            while (n < this._oViews.size()) {
                View view = (View)this._oViews.elementAt(n);
                if (string != "" && view.getName().startsWith(string + "\\")) {
                    this._oViews.removeElementAt(n);
                    --n;
                } else {
                    string = view.getName();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sort() {
        try {
            int n = 0;
            while (n < this._oViews.size() - 1) {
                int n2 = n;
                while (n2 < this._oViews.size() - 1) {
                    if (((View)this._oViews.get(n2)).getName().compareTo(((View)this._oViews.get(n2 + 1)).getName()) > 0) {
                        Object e = this._oViews.get(n2);
                        Object e2 = this._oViews.get(n2 + 1);
                        this._oViews.set(n2, e2);
                        this._oViews.set(n2 + 1, e);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PimFolder getRespectiveFolder(View view) throws LotusPimException {
        try {
            String string = view.getName();
            if (string.equals("($Inbox)")) {
                return new LotusPimInbox(view, this.m_oPimCalendar, this.getLotusPimSession(), this.getRecycle());
            }
            if (string.equals("($Drafts)")) {
                return new LotusPimDraft(view, this.m_oPimCalendar, this.getLotusPimSession(), this.getRecycle());
            }
            if (string.equals("($Sent)")) {
                return new LotusPimInbox(view, this.m_oPimCalendar, this.getLotusPimSession(), this.getRecycle());
            }
            if (string.equals("($Trash)")) {
                return new LotusPimInbox(view, this.m_oPimCalendar, this.getLotusPimSession(), this.getRecycle());
            }
            return new LotusPimInbox(view, this.m_oPimCalendar, this.getLotusPimSession(), this.getRecycle());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

