/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimFolderItemsType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimFolders;
import com.aligo.pim.interfaces.PimItems;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import com.aligo.pim.util.StringUtility;
import lotus.domino.NotesException;
import lotus.domino.View;
import lotus.domino.ViewEntryCollection;

public class LotusPimFolder
implements PimFolder {
    private View _oView;
    private LotusPimSession m_oPimSession;
    private Recycle m_oRecycle;

    public LotusPimFolder(View view, LotusPimSession lotusPimSession, Recycle recycle) {
        this.m_oRecycle = recycle;
        this._oView = view;
        this.m_oPimSession = lotusPimSession;
    }

    public Recycle getRecycle() {
        return this.m_oRecycle;
    }

    public LotusPimSession getLotusPimSession() {
        return this.m_oPimSession;
    }

    public void setLotusFolder(View view) {
        this._oView = view;
    }

    public View getLotusFolder() {
        try {
            this._oView.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._oView;
    }

    public View getLotusView() {
        return this.getLotusFolder();
    }

    public void recycle() throws LotusPimException {
        try {
            this._oView.recycle();
            this._oView = null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public ViewEntryCollection getLotusMessageItems() throws LotusPimException {
        return this.getLotusViewEntryCollection();
    }

    public ViewEntryCollection getLotusViewEntryCollection() throws LotusPimException {
        try {
            ViewEntryCollection viewEntryCollection = this.getLotusFolder().getAllEntries();
            this.getRecycle().add(viewEntryCollection);
            return viewEntryCollection;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getID() throws LotusPimException {
        try {
            return this.getLotusFolder().getUniversalID();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        try {
            String string = this.getRealName();
            if (string.indexOf("\\") != -1) {
                string = string.substring(string.lastIndexOf("\\") + 1, string.length());
            }
            string = StringUtility.replace((String)string, (String)"$", (String)"");
            string = StringUtility.replace((String)string, (String)"(", (String)"");
            string = StringUtility.replace((String)string, (String)")", (String)"");
            return string;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getRealName() throws LotusPimException {
        try {
            return this.getLotusFolder().getName();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimItems getItems() throws PimException {
        return null;
    }

    public PimFolders getFolders() throws LotusPimException {
        return this.getLotusPimSession().getFolders(this.getRealName());
    }

    public PimFolderItemsType getFolderItemsType() throws LotusPimException {
        if (this.getRealName().equals("($Inbox)")) {
            return PimFolderItemsType.INBOX_ITEMS;
        }
        if (this.getRealName().equals("($Drafts)")) {
            return PimFolderItemsType.DRAFT_ITEMS;
        }
        if (this.getRealName().equals("($Sent)")) {
            return PimFolderItemsType.SENT_ITEMS;
        }
        if (this.getRealName().equals("($Trash)")) {
            return PimFolderItemsType.DELETED_ITEMS;
        }
        return PimFolderItemsType.MAIL_ITEMS;
    }

    public void delete() throws LotusPimException {
        try {
            if (this._oView != null) {
                this._oView.remove();
                this.getLotusPimSession().refreshDatabase();
            }
        }
        catch (NotesException notesException) {
            throw new LotusPimException((Exception)((Object)notesException));
        }
    }

    public void delete(boolean bl) throws PimException {
        this.delete();
    }

    public void update() throws LotusPimException {
    }

    public PimFieldItems getFieldItems() throws LotusPimException {
        return null;
    }
}

