/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimFieldType;
import com.aligo.pim.interfaces.PimFieldItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimFieldItem;
import com.aligo.pim.lotus.LotusPimFieldTypeMapper;
import com.aligo.pim.lotus.LotusPimItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Vector;
import lotus.domino.Document;
import lotus.domino.Item;

public class LotusPimFieldItems
extends LotusPimItems
implements PimFieldItems {
    private Vector _vItems;
    private Document _oDocument;

    public LotusPimFieldItems(Vector vector, Document document, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this._vItems = vector;
        this._oDocument = document;
    }

    public void setLotusFields(Vector vector, Document document) {
        this._vItems = vector;
        this._oDocument = document;
    }

    private Document getLotusDocument() {
        return this._oDocument;
    }

    private Vector getLotusItems() {
        return this._vItems;
    }

    public PimFieldItem addFieldItem() throws LotusPimException {
        try {
            return new LotusPimFieldItem(null, this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public boolean doesFieldExist(PimFieldType pimFieldType) throws LotusPimException {
        try {
            String string = LotusPimFieldTypeMapper.getType(pimFieldType);
            if (string != null) {
                return this.getLotusDocument().hasItem(string) && this.getLotusDocument().getItemValue(string).size() > 0;
            }
            return false;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void addFieldItem(PimFieldType pimFieldType, Object object) throws LotusPimException {
        try {
            String string = LotusPimFieldTypeMapper.getType(pimFieldType);
            if (string != null) {
                this.getLotusDocument().replaceItemValue(string, object);
                this.getLotusDocument().save(true, true);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getCount() throws LotusPimException {
        try {
            if (this.getLotusItems() == null) {
                return 0;
            }
            return this.getLotusItems().size();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            if (this.getLotusItems() == null) {
                return;
            }
            int n = 0;
            while (n < this.getLotusItems().size()) {
                Item item = (Item)this.getLotusItems().elementAt(n);
                String string = item.getName();
                this.getLotusDocument().removeItem(string);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItem getFieldItem(int n) throws LotusPimException {
        try {
            if (this.getCount() <= 0 || n >= this.getCount() || n < 0) {
                return null;
            }
            Item item = (Item)this.getLotusItems().elementAt(n);
            if (item == null) {
                return null;
            }
            LotusPimFieldItem lotusPimFieldItem = new LotusPimFieldItem(item, this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
            return lotusPimFieldItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItem getFieldItem(String string) throws LotusPimException {
        return null;
    }

    public PimFieldItem getFieldItem(PimFieldType pimFieldType) throws LotusPimException {
        try {
            Vector vector;
            String string = LotusPimFieldTypeMapper.getType(pimFieldType);
            if (string == null) {
                return null;
            }
            if (this.getLotusDocument().hasItem(string) && (vector = this.getLotusDocument().getItemValue(string)).size() > 0) {
                Object e = vector.elementAt(0);
                return new LotusPimFieldItem(string, e, this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItem getFirstFieldItem() throws LotusPimException {
        try {
            return this.getFieldItem(this.getFirstIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItem getLastFieldItem() throws LotusPimException {
        try {
            return this.getFieldItem(this.getLastIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItem getNextFieldItem() throws LotusPimException {
        try {
            return this.getFieldItem(this.getNextIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItem getPreviousFieldItem() throws LotusPimException {
        try {
            return this.getFieldItem(this.getPreviousIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimItem addItem() throws LotusPimException {
        return this.addFieldItem();
    }

    public PimItem getItem(int n) throws LotusPimException {
        return this.getFieldItem(n);
    }

    public PimItem getItem(String string) throws LotusPimException {
        return this.getFieldItem(string);
    }

    public PimItem getFirstItem() throws LotusPimException {
        return this.getFirstFieldItem();
    }

    public PimItem getLastItem() throws LotusPimException {
        return this.getLastFieldItem();
    }

    public PimItem getNextItem() throws LotusPimException {
        return this.getNextFieldItem();
    }

    public PimItem getPreviousItem() throws LotusPimException {
        return this.getPreviousFieldItem();
    }
}

