/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimReminderItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItem;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimTaskReminderItem;
import com.aligo.pim.lotus.recycle.Recycle;
import lotus.domino.Document;

public class LotusPimExistingApptNewReminderItem
extends LotusPimItem
implements PimReminderItem,
LotusPimTaskReminderItem {
    Document _oDocument;
    String m_szSubject;
    long lNoOfMinutesBeforeStart = -1L;

    public LotusPimExistingApptNewReminderItem(LotusPimMessageItem lotusPimMessageItem, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        super(lotusPimSession, recycle);
        try {
            this._oDocument = lotusPimMessageItem.getLotusDocument();
            this.m_szSubject = lotusPimMessageItem.getSubject();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setNoOfMinutesBeforeStart(long l) throws LotusPimException {
        try {
            this.lNoOfMinutesBeforeStart = l;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public long getNoOfMinutesBeforeStart() throws LotusPimException {
        try {
            return this.lNoOfMinutesBeforeStart;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private Document getLotusDocument() throws LotusPimException {
        try {
            return this._oDocument;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private String getSubject() throws LotusPimException {
        try {
            return this.m_szSubject;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private String getAlarmUnit() {
        if (this.lNoOfMinutesBeforeStart >= 1440L) {
            return "D";
        }
        if (this.lNoOfMinutesBeforeStart >= 60L) {
            return "H";
        }
        return "M";
    }

    public void update() throws LotusPimException {
        try {
            if (this.lNoOfMinutesBeforeStart >= 0L) {
                Document document = this.getLotusDocument();
                document.replaceItemValue("$Alarm", (Object)new Integer(1));
                document.replaceItemValue("$AlarmDescription", (Object)this.getSubject());
                document.replaceItemValue("$AlarmMemoOptions", (Object)"");
                document.replaceItemValue("Alarms", (Object)"1");
                document.replaceItemValue("$AlarmUnit", (Object)this.getAlarmUnit());
                document.replaceItemValue("$AlarmOffset", (Object)new Integer(-1L * this.lNoOfMinutesBeforeStart + ""));
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            this.lNoOfMinutesBeforeStart = -1L;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete(boolean bl) throws PimException {
        try {
            this.lNoOfMinutesBeforeStart = -1L;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getID() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItems getFieldItems() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        try {
            return "New Reminder Item";
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

