/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Date;
import java.util.Vector;
import lotus.domino.DateRange;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public class LotusPimAddressEntryItem
extends LotusPimMessageItem
implements PimAddressEntryItem {
    public static final String BUSINESS_CITY = "officecity";
    public static final String BUSINESS_COUNTRY = "officecountry";
    public static final String BUSINESS_FAX_NUMBER = "OfficeFAXPhoneNumber";
    public static final String BUSINESS_STATE = "OfficeState";
    public static final String BUSINESS_STREET_ADDRESS = "OfficeStreetAddress";
    public static final String BUSINESS_TELEPHONE_NUMBER = "OfficePhoneNumber";
    public static final String BUSINESS_ZIP = "OfficeZIP";
    public static final String COMPANY_NAME = "CompanyName";
    public static final String EMAIL_ADDRESS = "InternetAddress";
    public static final String FIRST_NAME = "FirstName";
    public static final String HOME_CITY = "City";
    public static final String HOME_COUNTRY = "country";
    public static final String HOME_STATE = "State";
    public static final String HOME_STREET = "StreetAddress";
    public static final String HOME_TELEPHONE_NUMBER = "PhoneNumber";
    public static final String HOME_ZIP = "Zip";
    public static final String LAST_NAME = "LastName";
    public static final String MOBILE_TELEPHONE_NUMBER = "CellPhoneNumber";
    public static final String TITLE = "JobTitle";
    public static final String FORM = "Form";
    public static final String PERSON = "Person";
    public static final String GROUP = "Group";
    public static final String CHAIR = "Chair";
    public static final String PRINCIPAL = "Principal";
    public static final String FULLNAME = "FullName";
    public static final String ALT_FULLNAME = "AltFullName";
    public static final String MIDDLE_NAME = "MiddleInitial";
    public static final String MAILFILE = "MailFile";

    public PimAddressEntryItems addMembers() throws LotusPimException {
        return null;
    }

    public LotusPimAddressEntryItem(ViewEntry viewEntry, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntry, lotusPimSession, recycle);
    }

    public LotusPimAddressEntryItem(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntryCollection, lotusPimSession, recycle);
    }

    public void setLotusAddressEntryItem(ViewEntry viewEntry) {
        this.setLotusMessageItem(viewEntry);
    }

    public LotusPimAddressEntryItem(Document document, LotusPimSession lotusPimSession, Recycle recycle) {
        super(document, lotusPimSession, recycle);
    }

    public PimAddressEntryItems getMembers() throws LotusPimException {
        return null;
    }

    public String getBusinessCity() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(BUSINESS_CITY)) {
                return document.getItemValueString(BUSINESS_CITY);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getBusinessCountry() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(BUSINESS_COUNTRY)) {
                return document.getItemValueString(BUSINESS_COUNTRY);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getBusinessFaxNumber() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(BUSINESS_FAX_NUMBER)) {
                return document.getItemValueString(BUSINESS_FAX_NUMBER);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getBusinessState() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(BUSINESS_STATE)) {
                return document.getItemValueString(BUSINESS_STATE);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getBusinessStreet() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(BUSINESS_STREET_ADDRESS)) {
                return document.getItemValueString(BUSINESS_STREET_ADDRESS);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getBusinessTelephoneNumber() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(BUSINESS_TELEPHONE_NUMBER)) {
                return document.getItemValueString(BUSINESS_TELEPHONE_NUMBER);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getBusinessZip() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(BUSINESS_ZIP)) {
                return document.getItemValueString(BUSINESS_ZIP);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getCompanyName() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(COMPANY_NAME)) {
                return document.getItemValueString(COMPANY_NAME);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getEmailAddress() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(EMAIL_ADDRESS)) {
                return document.getItemValueString(EMAIL_ADDRESS);
            }
            if (document.hasItem(FULLNAME)) {
                return document.getItemValueString(FULLNAME);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getFirstName() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(FIRST_NAME)) {
                return document.getItemValueString(FIRST_NAME);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getAlternateFullName() throws PimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(ALT_FULLNAME)) {
                String string = document.getItemValueString(ALT_FULLNAME);
                if (string.indexOf("=") == -1) {
                    return string;
                }
                return string.substring(string.indexOf("=") + 1, string.indexOf("/"));
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getHomeCity() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(HOME_CITY)) {
                return document.getItemValueString(HOME_CITY);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getHomeCountry() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(HOME_COUNTRY)) {
                return document.getItemValueString(HOME_COUNTRY);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getHomeState() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(HOME_STATE)) {
                return document.getItemValueString(HOME_STATE);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getHomeStreet() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(HOME_STREET)) {
                return document.getItemValueString(HOME_STREET);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getHomeTelephoneNumber() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(HOME_TELEPHONE_NUMBER)) {
                return document.getItemValueString(HOME_TELEPHONE_NUMBER);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getHomeZip() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(HOME_ZIP)) {
                return document.getItemValueString(HOME_ZIP);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getLastName() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(LAST_NAME)) {
                return document.getItemValueString(LAST_NAME);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getName() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(FULLNAME)) {
                Vector vector = document.getItemValue(FULLNAME);
                if (vector.size() > 1) {
                    return (String)vector.elementAt(1);
                }
                if (vector.size() > 0) {
                    return (String)vector.elementAt(0);
                }
                return this.getFirstName() + " " + this.getLastName();
            }
            return this.getFirstName() + " " + this.getMiddleName() + " " + this.getLastName();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getMiddleName() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(MIDDLE_NAME)) {
                return document.getItemValueString(MIDDLE_NAME);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getMobileTelephoneNumber() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(MOBILE_TELEPHONE_NUMBER)) {
                return document.getItemValueString(MOBILE_TELEPHONE_NUMBER);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getTitle() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(TITLE)) {
                return document.getItemValueString(TITLE);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getMailFileName() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(MAILFILE)) {
                String string = "";
                string = document.getItemValueString(MAILFILE);
                return string;
            }
            return "";
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimBusyStatusType getBusyStatusType(Date date, Date date2, int n) throws LotusPimException {
        try {
            DateTime dateTime = this.getLotusSession().createDateTime(date);
            DateTime dateTime2 = this.getLotusSession().createDateTime(date2);
            if (dateTime2.timeDifference(dateTime) < 0) {
                throw new LotusPimException(13L);
            }
            if (dateTime2.timeDifference(dateTime) / 60 < n) {
                n = dateTime2.timeDifference(dateTime) / 60;
            }
            DateRange dateRange = this.getLotusSession().createDateRange(dateTime, dateTime2);
            Vector<String> vector = new Vector<String>();
            vector.addElement(this.getName());
            Vector vector2 = this.getLotusSession().freeTimeSearch(dateRange, n, vector, true);
            if (vector2 == null) {
                return PimBusyStatusType.BUSY;
            }
            if (vector2.size() > 0) {
                return PimBusyStatusType.FREE;
            }
            return PimBusyStatusType.BUSY;
        }
        catch (NotesException notesException) {
            return PimBusyStatusType.UNKNOWN;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setBusinessCity(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setBusinessCountry(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setBusinessFaxNumber(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setBusinessState(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setBusinessStreet(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setBusinessTelephoneNumber(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setBusinessZip(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setCompanyName(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setEmailAddress(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setFirstName(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setAlternateFullName(String string) throws PimException {
    }

    public void setHomeCity(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setHomeCountry(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setHomeState(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setHomeStreet(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setHomeTelephoneNumber(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setHomeZip(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setLastName(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setMobileTelephoneNumber(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public void setTitle(String string) throws LotusPimException {
        throw new LotusPimException(10L);
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)"FW: Address Entry Item forwarded ");
            LotusPimAddressEntryItem lotusPimAddressEntryItem = new LotusPimAddressEntryItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimAddressEntryItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void send() throws LotusPimException {
        super.send();
    }

    public void update() throws LotusPimException {
    }

    public void superDelete() throws LotusPimException {
        super.delete();
    }

    public void superUpdate() throws LotusPimException {
        super.update();
    }

    public void delete() throws LotusPimException {
    }
}

