/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.sun.portal.common.clip.CLIPException;
import com.sun.portal.common.clip.CLIPParser;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.portlet.cli.PDDeploy;
import com.sun.portal.portlet.cli.PDUNDeploy;
import com.sun.portal.portlet.cli.PortletDeployerException;
import com.sun.portal.portlet.cli.PortletDeployerLocalizer;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

class PortletDeployerCommand {
    protected static final String DEPLOY = "deploy";
    protected static final String UNDEPLOY = "undeploy";
    protected static final int SUBCMD_DEPLOY = 1;
    protected static final int SUBCMD_UNDEPLOY = 2;
    protected static final String UID = "runasdn";
    protected static final String PASSWORD = "password";
    protected static final String ADMIN_PASSWORD = "wc_password";
    protected static final String WC_INSTANCE = "instance";
    protected static final String DN = "dn";
    protected static final String GLOBAL = "global";
    protected static final String VERBOSE = "verbose";
    protected static final String VERSION = "version";
    protected static final String LOCALE = "locale";
    protected static final String ROLES_FILE = "rolesfile";
    protected static final String USERINFO_FILE = "userinfofile";
    public static final String OPT_DEFAULT = "*";
    public static final String LOCALE_DEFAULT = Locale.getDefault().toString();
    protected int subcmd = -1;
    protected String uid = null;
    protected String password = null;
    protected String dn = null;
    protected boolean global = false;
    protected boolean verbose = false;
    protected boolean version = false;
    protected String rolesfile = null;
    protected String userinfofile = null;
    protected String warfileLocation = null;
    protected File warFile = null;
    protected String warName = null;
    protected static final String DESKTOP_PROPERTIES = "desktop.propertiesFile";

    PortletDeployerCommand(CLIPParser clipp, String[] args) throws PortletDeployerException {
        this.parse(clipp, args);
    }

    private void parse(CLIPParser clipp, String[] argv) throws PortletDeployerException {
        if (this.needsVersion(argv)) {
            System.err.println(this.getVersionInfo());
            System.exit(1);
        }
        if (clipp.needsHelp(argv)) {
            System.err.println(clipp.getHelp(argv));
            System.exit(1);
        }
        Map options = null;
        try {
            options = clipp.getOptions(argv);
        }
        catch (CLIPException ce) {
            throw new PortletDeployerException("errorCLIPParseError", ce);
        }
        try {
            clipp.verifyArguments(argv);
        }
        catch (CLIPException ce) {
            throw new PortletDeployerException("errorCLIPParseError", ce);
        }
        this.verbose = ((String[])options.get(VERBOSE))[0].equals("true");
        String sc = null;
        try {
            sc = clipp.getSubCommand(argv);
        }
        catch (CLIPException ce) {
            Object[] tokens = new Object[]{sc};
            throw new PortletDeployerException("errorInvalidSubCmd", ce, tokens);
        }
        if (sc.equals(DEPLOY)) {
            this.subcmd = 1;
        } else if (sc.equals(UNDEPLOY)) {
            this.subcmd = 2;
        }
        this.uid = ((String[])options.get(UID))[0];
        this.password = ((String[])options.get(PASSWORD))[0];
        this.dn = ((String[])options.get(DN))[0];
        this.global = ((String[])options.get(GLOBAL))[0].equals("true");
        if (this.dn.equals(OPT_DEFAULT)) {
            if (!this.global) {
                throw new PortletDeployerException("errorNoDNGlobal");
            }
        } else if (this.global) {
            throw new PortletDeployerException("errorBothDNGlobal");
        }
        String[] files = null;
        try {
            files = clipp.getOperands(argv);
        }
        catch (CLIPException ce) {
            Object[] tokens = new Object[]{ce.toString()};
            throw new PortletDeployerException("errorOperand", tokens);
        }
        if (this.subcmd == 1) {
            this.rolesfile = ((String[])options.get(ROLES_FILE))[0];
            this.userinfofile = ((String[])options.get(USERINFO_FILE))[0];
            if (this.rolesfile.equals(OPT_DEFAULT)) {
                this.rolesfile = null;
            }
            if (this.userinfofile.equals(OPT_DEFAULT)) {
                this.userinfofile = null;
            }
            if (files != null && files.length > 0) {
                this.warfileLocation = files[0];
            }
            if (this.warfileLocation != null) {
                this.warFile = new File(this.warfileLocation);
            }
            if (this.warFile == null || this.warFile.length() == 0L) {
                throw new PortletDeployerException("errorEmptyFile");
            }
        }
        if (this.subcmd == 2) {
            if (files != null && files.length > 0) {
                this.warName = files[0];
            }
            if (this.warName == null || this.warName.length() == 0) {
                throw new PortletDeployerException("errorPortletAppName");
            }
        }
    }

    protected void runCommand() throws PortletDeployerException {
        DSAMEAdminDPContext dadc = this.doAuth();
        switch (this.subcmd) {
            case 1: {
                PDDeploy pdd = new PDDeploy();
                String res = pdd.process(dadc, this.dn, this.global, this.warFile, this.rolesfile, this.userinfofile, this.verbose);
                if (res != null) {
                    byte[] bytes = null;
                    try {
                        bytes = res.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException ue) {
                        bytes = res.getBytes();
                    }
                    System.out.write(bytes, 0, bytes.length);
                    break;
                }
                throw new PortletDeployerException("errorNotFound");
            }
            case 2: {
                PDUNDeploy pdud = new PDUNDeploy();
                String res = pdud.process(dadc, this.dn, this.global, this.warName, this.verbose);
                if (res != null) {
                    byte[] bytes = null;
                    try {
                        bytes = res.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException ue) {
                        bytes = res.getBytes();
                    }
                    System.out.write(bytes, 0, bytes.length);
                    break;
                }
                throw new PortletDeployerException("errorNotFound");
            }
            default: {
                Object[] tokens = new Object[]{new Integer(this.subcmd)};
                throw new PortletDeployerException("errorInvalidSubCmd", tokens);
            }
        }
    }

    protected static CLIPParser getCLIPParser() throws CLIPException {
        CLIPParser.SubCommand[] sc;
        CLIPParser.SubCommand[] subcmds = null;
        CLIPParser.Option[] optsDeploy = new CLIPParser.Option[]{new CLIPParser.Option(UID, "u", 1, null, PortletDeployerLocalizer.getLocalizedString("optUID")), new CLIPParser.Option(PASSWORD, "w", 1, null, PortletDeployerLocalizer.getLocalizedString("optPassword")), new CLIPParser.Option(ADMIN_PASSWORD, "p", 1, null, PortletDeployerLocalizer.getLocalizedString("optAdminPassword")), new CLIPParser.Option(WC_INSTANCE, "i", 1, OPT_DEFAULT, PortletDeployerLocalizer.getLocalizedString("optInstance")), new CLIPParser.Option(DN, "d", 1, OPT_DEFAULT, PortletDeployerLocalizer.getLocalizedString("optDN")), new CLIPParser.Option(GLOBAL, "g", 0, "false", PortletDeployerLocalizer.getLocalizedString("optGlobal")), new CLIPParser.Option(ROLES_FILE, "r", 1, OPT_DEFAULT, PortletDeployerLocalizer.getLocalizedString("optRolesFile")), new CLIPParser.Option(USERINFO_FILE, "f", 1, OPT_DEFAULT, PortletDeployerLocalizer.getLocalizedString("optUIFile")), new CLIPParser.Option(VERBOSE, "v", 0, "false", PortletDeployerLocalizer.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", PortletDeployerLocalizer.getLocalizedString("optVersion")), new CLIPParser.Option(LOCALE, "l", 1, LOCALE_DEFAULT, PortletDeployerLocalizer.getLocalizedString("optLocale"))};
        CLIPParser.SubCommand scDeploy = new CLIPParser.SubCommand(DEPLOY, optsDeploy, 0, 1, PortletDeployerLocalizer.getLocalizedString("helpDeploy"), PortletDeployerLocalizer.getLocalizedString("helpFile"));
        CLIPParser.Option[] optsUnDeploy = new CLIPParser.Option[]{new CLIPParser.Option(UID, "u", 1, null, PortletDeployerLocalizer.getLocalizedString("optUID")), new CLIPParser.Option(PASSWORD, "w", 1, null, PortletDeployerLocalizer.getLocalizedString("optPassword")), new CLIPParser.Option(ADMIN_PASSWORD, "p", 1, null, PortletDeployerLocalizer.getLocalizedString("optAdminPassword")), new CLIPParser.Option(WC_INSTANCE, "i", 1, OPT_DEFAULT, PortletDeployerLocalizer.getLocalizedString("optInstance")), new CLIPParser.Option(DN, "d", 1, OPT_DEFAULT, PortletDeployerLocalizer.getLocalizedString("optDN")), new CLIPParser.Option(GLOBAL, "g", 0, "false", PortletDeployerLocalizer.getLocalizedString("optGlobal")), new CLIPParser.Option(VERBOSE, "v", 0, "false", PortletDeployerLocalizer.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", PortletDeployerLocalizer.getLocalizedString("optVersion")), new CLIPParser.Option(LOCALE, "l", 1, LOCALE_DEFAULT, PortletDeployerLocalizer.getLocalizedString("optLocale"))};
        CLIPParser.SubCommand scUnDeploy = new CLIPParser.SubCommand(UNDEPLOY, optsUnDeploy, 0, 1, PortletDeployerLocalizer.getLocalizedString("helpUnDeploy"), PortletDeployerLocalizer.getLocalizedString("helpFile"));
        subcmds = sc = new CLIPParser.SubCommand[]{scDeploy, scUnDeploy};
        return new CLIPParser(subcmds, PortletDeployerLocalizer.getLocalizedString("helpCmd"));
    }

    private DSAMEAdminDPContext doAuth() throws PortletDeployerException {
        DSAMEAdminDPContext dadc = null;
        String propertiesFile = System.getProperty(DESKTOP_PROPERTIES);
        if (propertiesFile == null) {
            throw new PortletDeployerException("errorProperties");
        }
        try {
            dadc = new DSAMEAdminDPContext();
            dadc.init(this.uid, this.password, propertiesFile, "pdeploy.debug");
        }
        catch (ContextError ce) {
            throw new PortletDeployerException("errorAuthFailed", ce);
        }
        return dadc;
    }

    private String getVersionInfo() {
        ResourceBundle prodRB = ResourceBundle.getBundle("PSversion");
        StringBuffer vinfo = new StringBuffer();
        vinfo.append("pdeploy").append(" (").append(prodRB.getString("productname")).append(" ").append(prodRB.getString("productversion")).append(") ").append("1.0");
        vinfo.append("\n").append(prodRB.getString("copyright"));
        return vinfo.toString();
    }

    public boolean needsVersion(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-V") || args[i].equals("--version")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

