/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.configservlet.client.SrapClient;
import com.sun.portal.util.SystemProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UserProfileGatewayCache
implements Runnable {
    private HashMap cache = new HashMap();
    private static UserProfileGatewayCache instance = null;
    private static final String GET_REQUEST = "GET_USERS";
    private static final String SET_USER_ATTRIBUTES = "SET_USER_ATTRIBUTES";
    private int numCacheEntries = 0;
    private static int MAX_CACHE_SIZE;
    private static long CACHE_SLEEP_TIME;
    private static long CLEANUP_TIME;
    private int numOfCleanCacheSkips = 0;

    private UserProfileGatewayCache() {
    }

    public static Map getResponse(String string) throws SendRequestException, GetResponseException {
        UserProfileGatewayCacheEntry userProfileGatewayCacheEntry = (UserProfileGatewayCacheEntry)instance.getEntry(string);
        if (userProfileGatewayCacheEntry == null && (userProfileGatewayCacheEntry = instance.addEntry(string)) == null) {
            return new HashMap();
        }
        return userProfileGatewayCacheEntry.getValue();
    }

    private synchronized Object getEntry(String string) {
        return this.cache.get(string);
    }

    private synchronized void addNewEntry(Object object, Object object2) {
        if (this.numCacheEntries >= MAX_CACHE_SIZE) {
            this.cleanCache(System.currentTimeMillis(), true);
        }
        this.cache.put(object, object2);
        ++this.numCacheEntries;
    }

    private UserProfileGatewayCacheEntry addEntry(String string) throws SendRequestException, GetResponseException {
        UserProfileGatewayCacheEntry userProfileGatewayCacheEntry = null;
        Request request = new Request(string, null, GET_REQUEST);
        Response response = SrapClient.execute(request);
        if (response != null) {
            Map map = (Map)response.getReturnedObject();
            if (map == null) {
                return null;
            }
            userProfileGatewayCacheEntry = new UserProfileGatewayCacheEntry(map);
            this.addNewEntry(string, userProfileGatewayCacheEntry);
        }
        return userProfileGatewayCacheEntry;
    }

    public static void setAttribute(String string, String string2, Set set) throws SendRequestException, GetResponseException {
        Request request = new Request(string, null, SET_USER_ATTRIBUTES, string2, new Object[]{set});
        Response response = SrapClient.execute(request);
        UserProfileGatewayCacheEntry userProfileGatewayCacheEntry = (UserProfileGatewayCacheEntry)instance.getEntry(string);
        if (userProfileGatewayCacheEntry != null) {
            Map map = userProfileGatewayCacheEntry.getValue();
            map.put(string2, set);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(CACHE_SLEEP_TIME);
                    long l = System.currentTimeMillis();
                    if (this.numOfCleanCacheSkips >= 10) {
                        this.cleanCache(l, true);
                        continue;
                    }
                    ++this.numOfCleanCacheSkips;
                    this.cleanCache(l, false);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private synchronized void cleanCache(long l, boolean bl) {
        if (bl || this.numCacheEntries >= MAX_CACHE_SIZE) {
            this.numOfCleanCacheSkips = 0;
            Set set = this.cache.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                UserProfileGatewayCacheEntry userProfileGatewayCacheEntry = (UserProfileGatewayCacheEntry)this.cache.get(k);
                if (l - userProfileGatewayCacheEntry.getTime() <= CLEANUP_TIME) continue;
                iterator.remove();
                --this.numCacheEntries;
            }
        }
    }

    static {
        try {
            MAX_CACHE_SIZE = Integer.parseInt(SystemProperties.get((String)"gateway.userProfile.cacheSize", (String)"1024"));
        }
        catch (Exception exception) {
            MAX_CACHE_SIZE = 1024;
        }
        try {
            CACHE_SLEEP_TIME = Integer.parseInt(SystemProperties.get((String)"gateway.userProfile.cacheSleepTime", (String)"60000"));
        }
        catch (Exception exception) {
            CACHE_SLEEP_TIME = 60000L;
        }
        try {
            CLEANUP_TIME = Integer.parseInt(SystemProperties.get((String)"gateway.userProfile.cacheCleanupTime", (String)"300000"));
        }
        catch (Exception exception) {
            CLEANUP_TIME = 300000L;
        }
        instance = new UserProfileGatewayCache();
        Thread thread = new Thread(instance);
        thread.start();
    }

    private class UserProfileGatewayCacheEntry {
        private Map value = null;
        private long timestamp;

        public UserProfileGatewayCacheEntry(Map map) {
            this.value = map;
            this.timestamp = System.currentTimeMillis();
        }

        public Map getValue() {
            return this.value;
        }

        public long getTime() {
            return this.timestamp;
        }
    }
}

