/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMUtil {
    public static void printDOM(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                System.out.println("<?xml version=\"1.0\" ?>");
                DOMUtil.printDOM(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                System.out.print("<");
                System.out.print(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attr = attrs.item(i);
                    System.out.print(" " + attr.getNodeName().trim() + "=\"" + attr.getNodeValue().trim() + "\"");
                    ++i;
                }
                System.out.println(">");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i2 = 0;
                while (i2 < len) {
                    DOMUtil.printDOM(children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                System.out.print("&");
                System.out.print(node.getNodeName().trim());
                System.out.print(";");
                break;
            }
            case 4: {
                System.out.print("");
                break;
            }
            case 3: {
                System.out.print(node.getNodeValue().trim());
                break;
            }
            case 7: {
                System.out.print("");
            }
        }
        if (type == 1) {
            System.out.println();
            System.out.print("'");
        }
    }

    public static Document parse(String fileName) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(fileName));
            return document;
        }
        catch (SAXParseException spe) {
            System.out.println("\n** Parsing error , line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.out.println(" " + spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public static void writeXmlToFile(String filename, Document document) {
        try {
            DOMSource source = new DOMSource(document);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            System.out.println("TransformerConfigurationException: " + e);
        }
        catch (TransformerException e) {
            System.out.println("TransformerException: " + e);
        }
    }

    public static int countByTagName(String tag, Document document) {
        NodeList list = document.getElementsByTagName(tag);
        return list.getLength();
    }
}

