/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom;

import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.collections.TypedHashCache;
import com.sun.portal.rewriter.util.xml.Document;
import java.io.FileReader;
import java.io.Reader;
import java.util.Set;
import org.xml.sax.SAXException;

public final class RuleSetManager {
    private static RuleSetManager defaultManager;
    private final TypedHashCache ruleSetCache = new TypedHashCache(class$com$sun$portal$rewriter$rom$RuleSet == null ? (class$com$sun$portal$rewriter$rom$RuleSet = RuleSetManager.class$("com.sun.portal.rewriter.rom.RuleSet")) : class$com$sun$portal$rewriter$rom$RuleSet);
    private DataService dataService;
    static /* synthetic */ Class class$com$sun$portal$rewriter$rom$RuleSet;

    public RuleSetManager(DataService aDataService) {
        this.dataService = aDataService;
        this.dataService.getChangeNotifier().addObserver(this.ruleSetCache);
        if (defaultManager == null) {
            defaultManager = this;
        }
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public RuleSet fetchRuleSet(String aRuleSetID) throws InvalidXMLException, DataServiceException {
        if (aRuleSetID.equals("none")) {
            return null;
        }
        RuleSet result = (RuleSet)this.ruleSetCache.get(aRuleSetID);
        if (result != null) {
            return result;
        }
        String lXMLString = this.retrieve(aRuleSetID);
        if (Debug.isMessageEnabled()) {
            Debug.recordRuleSetMessage("\n\n\nRetrieved XML For RuleSet ID: " + aRuleSetID + " is\n\n" + lXMLString);
        }
        RuleSet lRuleSet = RuleSetManager.create(lXMLString);
        this.ruleSetCache.put(lRuleSet.getID(), lRuleSet);
        return lRuleSet;
    }

    public Set getRuleSetNames() throws DataServiceException {
        return this.dataService.retrieveKeys();
    }

    public String matchesWithID(String aXMLString) throws DataServiceException, InvalidXMLException {
        RuleSet r = RuleSetManager.create(aXMLString);
        return this.dataService.matchesWithID(r.getID());
    }

    private boolean isRuleSetExists(String aXMLString) throws DataServiceException, InvalidXMLException {
        return this.matchesWithID(aXMLString) != null;
    }

    public String retrieve(String aRuleSetID) throws DataServiceException {
        return this.dataService.retrieveXML(aRuleSetID);
    }

    public String store(String aXMLString) throws InvalidXMLException, DataServiceException {
        RuleSet r = RuleSetManager.create(aXMLString);
        String keyIDFromXML = r.getID();
        if (this.isRuleSetExists(aXMLString)) {
            this.delete(keyIDFromXML);
        }
        return this.dataService.storeXML(keyIDFromXML, aXMLString);
    }

    public String delete(String aRuleSetID) throws DataServiceException {
        return this.dataService.deleteKey(aRuleSetID);
    }

    public static RuleSet create(String aXMLString) throws InvalidXMLException {
        try {
            return new RuleSet(Document.create(aXMLString).getRootNode());
        }
        catch (InvalidXMLException iXMLe) {
            throw iXMLe;
        }
        catch (SAXException se) {
            throw new InvalidXMLException(se.getMessage(), aXMLString, se, 1001);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidXMLException(e.getMessage(), aXMLString, e, 1000);
        }
    }

    public static RuleSet create(Reader aXMLStringReader) throws InvalidXMLException {
        return RuleSetManager.create(Resource.read(aXMLStringReader));
    }

    public static boolean validate(String aXMLString) {
        try {
            RuleSetManager.create(aXMLString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final RuleSetManager getDefault() {
        return defaultManager;
    }

    public static void main(String[] args) throws Exception {
        RuleSet lRuleSet = RuleSetManager.create(new FileReader(args[0]));
        Debug.println(lRuleSet.toXML());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

