/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.xml;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RewriterPool;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.TranslatorHelper;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.RewriterBroker;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.rom.RuleSetHelper;
import com.sun.portal.rewriter.rom.RuleSetManager;
import com.sun.portal.rewriter.rom.common.Attribute;
import com.sun.portal.rewriter.rom.common.AttributeRule;
import com.sun.portal.rewriter.rom.common.TagText;
import com.sun.portal.rewriter.rom.common.TagTextRule;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.xml.Document;
import java.io.FileReader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLRewriter
extends AbstractRewriter {
    public static final String PROPERTY_IS_REWRITE_XSL = "IS_REWRITE_XSL";
    private static final String[][] xmlEntities = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&apos;"}};
    private static final String[][] decAndHexEntities = new String[][]{{"&#160;", "\u00a0"}, {"&#x200E;", "\u200e"}, {"&#x200F;", "\u200f"}};
    private static final String[][] revDecAndHexEntities = new String[][]{{"\u00a0", "&#160;"}, {"\u200e", "&#x200E;"}, {"\u200f", "&#x200F;"}};

    public XMLRewriter(RewriterBroker aRewriterBroker) {
        super(aRewriterBroker, "text/xml");
    }

    public final void plugableRewriter(PageContent aPageContent, Translator aTranslator) {
        this.parseXML(aPageContent, aTranslator);
    }

    private void parseXML(PageContent aPageContent, Translator aTranslator) {
        try {
            String aContent = aPageContent.getOriginalContent();
            Node bRootNode = Document.create(aContent, false, true, false).getRootNode().getW3CNode();
            String lHeadder = aContent.substring(0, aContent.indexOf("<" + bRootNode.getNodeName()));
            if (lHeadder.indexOf("href=") != -1) {
                String tmpHeadder = lHeadder.substring(0, lHeadder.indexOf("href") + 4);
                String rHeadder = lHeadder.substring(lHeadder.indexOf("href") + 4, lHeadder.length());
                rHeadder = rHeadder.substring(rHeadder.indexOf("=") + 1, rHeadder.length());
                rHeadder = rHeadder.substring(rHeadder.indexOf("\"") + 1, rHeadder.length());
                String hrefVal = rHeadder.substring(0, rHeadder.indexOf("\""));
                rHeadder = rHeadder.substring(rHeadder.indexOf("\"") + 1, rHeadder.length());
                hrefVal = aTranslator.translate(hrefVal);
                lHeadder = tmpHeadder + "=\"" + hrefVal + "\"" + rHeadder;
            }
            if (!ConfigManager.getBoolean(PROPERTY_IS_REWRITE_XSL, true) && bRootNode.getNodeName().equalsIgnoreCase("xsl:stylesheet")) {
                return;
            }
            this.printDOM(bRootNode, aPageContent.getResultBuffer().append(lHeadder), aTranslator, new Attribute(""), new TagText(""), false);
        }
        catch (Exception ex) {
            Debug.recordOriginalPageWarning("Unable to translate XML:", ex);
        }
    }

    public StringBuffer printDOM(Node aNode, StringBuffer aResultBuffer, Translator aTranslator, Attribute aAttribute, TagText aTagText, boolean aUseSingleQuotes) {
        short type = aNode.getNodeType();
        switch (type) {
            case 1: {
                ListMap bMAP = ListMap.EMPTY_LISTMAP;
                String bTagName = aNode.getNodeName();
                aResultBuffer.append('<');
                aResultBuffer.append(bTagName);
                NamedNodeMap attrs = aNode.getAttributes();
                if (attrs != null && attrs.getLength() != 0) {
                    bMAP = new ListMap();
                    int i = 0;
                    while (i < attrs.getLength()) {
                        Node attr = attrs.item(i);
                        String bAttName = attr.getNodeName().trim();
                        String bAttValue = attr.getNodeValue();
                        bMAP.put(bAttName, bAttValue);
                        if (!aUseSingleQuotes && bAttValue.indexOf("\"") != -1) {
                            aUseSingleQuotes = true;
                        }
                        this.rewriteAttribute(aResultBuffer, aAttribute.recycleMatchee(attr.getNodeName(), aNode.getNodeName(), "URL", aTranslator.getPageSpec().getPageURI().getFullFileURI()), XMLRewriter.processNodeValue(bAttValue), aTranslator, aUseSingleQuotes);
                        ++i;
                    }
                }
                int tagEndIndex = aResultBuffer.length();
                String endString = "/>";
                NodeList children = aNode.getChildNodes();
                int bChildCount = children.getLength();
                if (bChildCount > 0) {
                    endString = ">";
                    boolean bUseSingleQuotes = false;
                    int i = 0;
                    while (i < bChildCount) {
                        Node bChildNode = children.item(i);
                        short bChildNodeType = bChildNode.getNodeType();
                        switch (bChildNodeType) {
                            case 3: {
                                String bPCData = bChildNode.getNodeValue();
                                String bTrimmedPCData = bPCData.trim();
                                if (bTrimmedPCData.length() != 0) {
                                    if (i == 0 && bTrimmedPCData.indexOf("\"") != -1) {
                                        bUseSingleQuotes = true;
                                    }
                                    this.rewriteTagText(aResultBuffer, aTagText.recycleMatchee(aNode.getNodeName(), bMAP, aTranslator.getPageSpec().getPageURI().getFullFileURI()), StringHelper.searchAndReplace(bPCData, "\u00a0", "&#160;"), aTranslator);
                                    break;
                                }
                                aResultBuffer.append(bPCData);
                                break;
                            }
                            default: {
                                this.printDOM(bChildNode, aResultBuffer, aTranslator, aAttribute, aTagText, bUseSingleQuotes);
                            }
                        }
                        ++i;
                    }
                } else if (bTagName.equalsIgnoreCase("span") || bTagName.equalsIgnoreCase("div")) {
                    endString = ">";
                }
                aResultBuffer.insert(tagEndIndex, endString);
                if (endString.length() != 1) break;
                aResultBuffer.append("</").append(aNode.getNodeName()).append(">");
                break;
            }
            default: {
                this.handleDefault(aNode, aResultBuffer);
            }
        }
        return aResultBuffer;
    }

    private static final String processNodeValue(String aData) {
        aData = StringHelper.searchAndReplace(aData, decAndHexEntities);
        aData = StringHelper.searchAndReplace(aData, xmlEntities);
        aData = StringHelper.searchAndReplace(aData, revDecAndHexEntities);
        return aData;
    }

    private void handleDefault(Node aNode, StringBuffer aResultBuffer) {
        switch (aNode.getNodeType()) {
            case 5: {
                aResultBuffer.append("&").append(aNode.getNodeName()).append(";");
                break;
            }
            case 8: {
                aResultBuffer.append("<!--").append(aNode.getNodeValue()).append("-->");
                break;
            }
            case 4: {
                aResultBuffer.append("<![CDATA[").append(aNode.getNodeValue()).append("]]>");
                break;
            }
            default: {
                if (!Debug.isWarningEnabled()) break;
                Debug.recordOriginalPageWarning("Ignoring :" + aNode.getNodeName() + " Node Type : " + aNode.getNodeType());
            }
        }
    }

    private void rewriteAttribute(StringBuffer tagbuff, Attribute aAttribute, String aValue, Translator aTranslator, boolean useSingleQuites) {
        AttributeRule lMatch = (AttributeRule)RuleSetHelper.findXMLAttributeMatch(this.getRuleSet(), aAttribute);
        tagbuff.append(" ").append(aAttribute.getName()).append("=");
        XMLRewriter.appendQuotes(tagbuff, useSingleQuites);
        if (lMatch != null) {
            Pattern[] lList = lMatch.getParsedPatterns();
            aValue = lList.length == 0 ? aTranslator.translate(aValue) : TranslatorHelper.translateSubStrings(lList, aValue, aTranslator);
        }
        tagbuff.append(aValue);
        XMLRewriter.appendQuotes(tagbuff, useSingleQuites);
    }

    private static void appendQuotes(StringBuffer tagbuff, boolean useSingleQuites) {
        if (useSingleQuites) {
            tagbuff.append("'");
        } else {
            tagbuff.append("\"");
        }
    }

    private void rewriteTagText(StringBuffer aTagBuff, TagText aTagText, String aPCData, Translator aTranslator) {
        TagTextRule lTextMatch = (TagTextRule)RuleSetHelper.findXMLTagTextMatch(this.getRuleSet(), aTagText);
        if (lTextMatch != null) {
            aPCData = aTranslator.translate(aPCData);
        }
        aPCData = StringHelper.searchAndReplace(aPCData, decAndHexEntities);
        aPCData = StringHelper.searchAndReplace(aPCData, xmlEntities);
        aPCData = StringHelper.searchAndReplace(aPCData, revDecAndHexEntities);
        aTagBuff.append(aPCData);
    }

    public static void main(String[] args) {
        try {
            String rules = Resource.read(new FileReader(args[0]));
            String content = Resource.read(new FileReader(args[1]));
            Translator defaultTranslator = SampleRuleObjects.defaultTranslator;
            RuleSet lRuleSet = RuleSetManager.create(rules);
            Rewriter xmlRewriter = RewriterPool.create(lRuleSet, "text/xml");
            Debug.println(xmlRewriter.rewrite(content, defaultTranslator));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

