/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.js.parser;

import com.sun.portal.rewriter.AbsoluteTranslator;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.js.parser.JavaScriptException;
import com.sun.portal.rewriter.engines.js.parser.TokenStream;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.rom.RuleSetHelper;
import com.sun.portal.rewriter.rom.js.Function;
import com.sun.portal.rewriter.rom.js.FunctionRule;
import com.sun.portal.rewriter.rom.js.Variable;
import com.sun.portal.rewriter.rom.js.VariableRule;
import com.sun.portal.rewriter.test.util.CreateRuleSet;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public final class JSParser {
    public static final String PROPERTY_IS_REWRITE_VARS_IN_DHTML = "IS_REWRITE_VARS_IN_DHTML";
    private static final boolean REWRITE_VARS_IN_DHTML = ConfigManager.getBoolean("IS_REWRITE_VARS_IN_DHTML", true);
    private final Function functionMatche;
    private final Variable variableMatche;
    private final List tokenList = new ArrayList();
    private final Reader contentStream;
    private int lastExprEndLine;
    private boolean ok;
    private final RuleSet ruleSet;
    private final String sourceURI;
    private static final boolean implementsCatchCond = false;

    public JSParser(String aContent, RuleSet aRuleSet, Translator aTranslator) {
        this.ruleSet = aRuleSet;
        this.contentStream = new StringReader(aContent);
        this.sourceURI = aTranslator.getPageSpec().getInputString();
        String source = aTranslator.getPageSpec().getPageURI().getFullFileURI();
        this.functionMatche = new Function("xxyyzz", null, null, source);
        this.variableMatche = new Variable("xxyyzz", null, source);
    }

    private void mustMatchToken(TokenStream ts, int toMatch, String messageId) throws IOException, JavaScriptException {
        int tt = ts.getToken();
        if (tt != toMatch) {
            this.reportError(ts, messageId);
            ts.ungetToken(tt);
        }
    }

    private void reportError(TokenStream ts, String messageId) throws JavaScriptException {
        String message = messageId;
        if (this.ok) {
            this.ok = false;
            if ((ts.flags & 1) == 0) {
                message = JSParser.getMessage(messageId, null);
            }
        }
        throw new JavaScriptException(message, this.sourceURI, ts.getLineBuffer());
    }

    public int[][] parse() throws IOException {
        TokenStream ts = new TokenStream(this.contentStream, this.sourceURI);
        try {
            this.ok = true;
            while (this.ok) {
                ts.flags |= 0x200;
                int tt = ts.getToken();
                ts.flags &= 0xFFFFFDFF;
                if (tt > 0) {
                    if (tt == 109) {
                        try {
                            this.function(ts);
                            this.wellTerminated(ts, 109);
                        }
                        catch (JavaScriptException e) {
                            this.ok = false;
                            JSParser.recordWarning(e);
                        }
                        continue;
                    }
                    ts.ungetToken(tt);
                    this.statement(ts);
                    continue;
                }
                break;
            }
        }
        catch (JavaScriptException je) {
            JSParser.recordWarning(je);
        }
        return (int[][])this.tokenList.toArray((T[])Constants.EMPTY_INT_INT_ARRAY);
    }

    private void parseFunctionBody(TokenStream ts) throws IOException, JavaScriptException {
        int oldflags = ts.flags;
        ts.flags &= 0xFFFFFFCF;
        ts.flags |= 8;
        try {
            this.statements(ts);
            Object var4_3 = null;
            ts.flags = oldflags;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ts.flags = oldflags;
            throw throwable;
        }
    }

    private void function(TokenStream ts) throws IOException, JavaScriptException {
        if (ts.matchesToken(44)) {
            while (ts.matchesToken(107) && ts.matchesToken(44)) {
            }
        }
        this.mustMatchToken(ts, 93, "msg.no.paren.parms");
        if (!ts.matchesToken(94)) {
            do {
                this.mustMatchToken(ts, 44, "msg.no.parm");
            } while (ts.matchesToken(95));
            this.mustMatchToken(ts, 94, "msg.no.paren.after.parms");
        }
        this.mustMatchToken(ts, 91, "msg.no.brace.body");
        this.parseFunctionBody(ts);
        this.mustMatchToken(ts, 92, "msg.no.brace.after.body");
    }

    private void statements(TokenStream ts) throws IOException, JavaScriptException {
        int tt;
        while ((tt = ts.peekToken()) > 0 && tt != 92) {
            this.statement(ts);
        }
    }

    private void condition(TokenStream ts) throws IOException, JavaScriptException {
        this.mustMatchToken(ts, 93, "msg.no.paren.cond");
        this.expr(ts, false);
        this.mustMatchToken(ts, 94, "msg.no.paren.after.cond");
    }

    private boolean wellTerminated(TokenStream ts, int lastExprType) throws IOException, JavaScriptException {
        int tt = ts.peekTokenSameLine();
        if (tt == -1) {
            this.reportError(ts, "msg.scanner.caught.error");
            return false;
        }
        if (tt != 0 && tt != 1 && tt != 88 && tt != 92) {
            if (tt == 109 || lastExprType == 109) {
                return true;
            }
            this.reportError(ts, "msg.no.semi.stmt");
        }
        return true;
    }

    private String matchLabel(TokenStream ts) throws IOException, JavaScriptException {
        String label = null;
        int tt = ts.peekTokenSameLine();
        if (tt == 44) {
            ts.getToken();
            label = ts.getString();
        }
        return label;
    }

    private void statement(TokenStream ts) throws IOException, JavaScriptException {
        try {
            this.statementHelper(ts);
        }
        catch (JavaScriptException e) {
            int t;
            JSParser.recordWarning(e);
            while ((t = ts.getToken()) != 88 && t != 1 && t != 0 && t != -1) {
            }
        }
    }

    private void statementHelper(TokenStream ts) throws IOException, JavaScriptException {
        int lastExprType = 0;
        int tt = ts.getToken();
        switch (tt) {
            case 112: {
                this.condition(ts);
                this.statement(ts);
                if (!ts.matchesToken(113)) break;
                this.statement(ts);
                break;
            }
            case 114: {
                this.mustMatchToken(ts, 93, "msg.no.paren.switch");
                this.expr(ts, false);
                this.mustMatchToken(ts, 94, "msg.no.paren.after.switch");
                this.mustMatchToken(ts, 91, "msg.no.brace.switch");
                while ((tt = ts.getToken()) != 92 && tt != 0) {
                    switch (tt) {
                        case 115: {
                            this.expr(ts, false);
                            break;
                        }
                        case 116: {
                            break;
                        }
                        default: {
                            this.reportError(ts, "msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(ts, 98, "msg.no.colon.case");
                    while ((tt = ts.peekToken()) != 92 && tt != 115 && tt != 116 && tt != 0) {
                        this.statement(ts);
                    }
                }
                break;
            }
            case 117: {
                this.condition(ts);
                this.statement(ts);
                break;
            }
            case 118: {
                this.statement(ts);
                this.mustMatchToken(ts, 117, "msg.no.while.do");
                this.condition(ts);
                break;
            }
            case 119: {
                this.mustMatchToken(ts, 93, "msg.no.paren.for");
                tt = ts.peekToken();
                if (tt != 88) {
                    if (tt == 122) {
                        ts.getToken();
                        this.variables(ts, true);
                    } else {
                        this.expr(ts, true);
                    }
                }
                if ((tt = ts.peekToken()) == 102 && ts.getOp() == 63) {
                    ts.matchesToken(102);
                    this.expr(ts, false);
                } else {
                    this.mustMatchToken(ts, 88, "msg.no.semi.for");
                    if (ts.peekToken() != 88) {
                        this.expr(ts, false);
                    }
                    this.mustMatchToken(ts, 88, "msg.no.semi.for.cond");
                    if (ts.peekToken() != 94) {
                        this.expr(ts, false);
                    }
                }
                this.mustMatchToken(ts, 94, "msg.no.paren.for.ctrl");
                this.statement(ts);
                break;
            }
            case 75: {
                this.statement(ts);
                int peek = ts.peekToken();
                if (peek == 124) {
                    while (ts.matchesToken(124)) {
                        this.mustMatchToken(ts, 93, "msg.no.paren.catch");
                        this.mustMatchToken(ts, 44, "msg.bad.catchcond");
                        this.mustMatchToken(ts, 94, "msg.bad.catchcond");
                        this.mustMatchToken(ts, 91, "msg.no.brace.catchblock");
                        this.statements(ts);
                        ts.matchesToken(92);
                    }
                } else if (peek != 125) {
                    this.mustMatchToken(ts, 125, "msg.try.no.catchfinally");
                }
                if (!ts.matchesToken(125)) break;
                this.statement(ts);
                break;
            }
            case 62: {
                int lineno = ts.getLineno();
                this.expr(ts, false);
                if (lineno != ts.getLineno()) break;
                this.wellTerminated(ts, -1);
                break;
            }
            case 120: {
                this.matchLabel(ts);
                break;
            }
            case 121: {
                this.matchLabel(ts);
                break;
            }
            case 123: {
                this.mustMatchToken(ts, 93, "msg.no.paren.with");
                this.expr(ts, false);
                this.mustMatchToken(ts, 94, "msg.no.paren.after.with");
                this.statement(ts);
                break;
            }
            case 122: {
                this.variables(ts, false);
                break;
            }
            case 5: {
                ts.flags |= 0x200;
                tt = ts.peekTokenSameLine();
                ts.flags &= 0xFFFFFDFF;
                if (tt != 0 && tt != 1 && tt != 88 && tt != 92) {
                    this.expr(ts, false);
                    ts.flags |= 0x10;
                    break;
                }
                ts.flags |= 0x20;
                break;
            }
            case 91: {
                this.statements(ts);
                this.mustMatchToken(ts, 92, "msg.no.brace.block");
                break;
            }
            case -1: {
                this.reportError(ts, "msg.scanner.caught.error");
            }
            case 1: 
            case 88: {
                break;
            }
            default: {
                lastExprType = tt;
                int tokenno = ts.getTokenno();
                ts.ungetToken(tt);
                this.expr(ts, false);
                if (ts.peekToken() == 98) {
                    if (lastExprType != 44 || ts.getTokenno() != tokenno) {
                        this.reportError(ts, "msg.bad.label");
                    }
                    ts.getToken();
                    return;
                }
                int tmpToken = ts.getToken();
                ts.ungetToken(tmpToken);
                if (lastExprType != 109 || ts.getLineno() != this.lastExprEndLine) break;
                this.wellTerminated(ts, lastExprType);
                break;
            }
        }
        ts.matchesToken(88);
    }

    private void variables(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        do {
            this.mustMatchToken(ts, 44, "msg.bad.var");
            this.handleVariableMatch(ts.getString(), ts, inForInit, false);
        } while (ts.matchesToken(95));
    }

    private void expr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        this.assignExpr(ts, inForInit, 0);
        while (ts.matchesToken(95)) {
            this.assignExpr(ts, inForInit, 0);
        }
    }

    private void assignExpr(TokenStream ts, boolean inForInit, int opCode) throws IOException, JavaScriptException {
        StringBuffer vname = new StringBuffer();
        this.condExpr(ts, inForInit, vname, opCode);
        this.handleVariableMatch(vname.toString(), ts, inForInit, false);
    }

    private void condExpr(TokenStream ts, boolean inForInit, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.orExpr(ts, inForInit, vname, opCode);
        if (ts.matchesToken(97)) {
            this.assignExpr(ts, false, opCode);
            this.mustMatchToken(ts, 98, "msg.no.colon.cond");
            this.assignExpr(ts, inForInit, opCode);
        }
    }

    private void orExpr(TokenStream ts, boolean inForInit, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.andExpr(ts, inForInit, vname, opCode);
        if (ts.matchesToken(99)) {
            this.orExpr(ts, inForInit, null, 0);
        }
    }

    private void andExpr(TokenStream ts, boolean inForInit, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.bitOrExpr(ts, inForInit, vname, opCode);
        if (ts.matchesToken(100)) {
            this.andExpr(ts, inForInit, null, 0);
        }
    }

    private void bitOrExpr(TokenStream ts, boolean inForInit, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.bitXorExpr(ts, inForInit, vname, opCode);
        while (ts.matchesToken(11)) {
            this.bitXorExpr(ts, inForInit, null, 0);
        }
    }

    private void bitXorExpr(TokenStream ts, boolean inForInit, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.bitAndExpr(ts, inForInit, vname, opCode);
        while (ts.matchesToken(12)) {
            this.bitAndExpr(ts, inForInit, null, 0);
        }
    }

    private void bitAndExpr(TokenStream ts, boolean inForInit, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.eqExpr(ts, inForInit, vname, opCode);
        while (ts.matchesToken(13)) {
            this.eqExpr(ts, inForInit, null, 0);
        }
    }

    private void eqExpr(TokenStream ts, boolean inForInit, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.relExpr(ts, inForInit, vname, opCode);
        while (ts.matchesToken(101)) {
            this.relExpr(ts, inForInit, null, 0);
        }
    }

    private void relExpr(TokenStream ts, boolean inForInit, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.shiftExpr(ts, vname, opCode);
        while (ts.matchesToken(102)) {
            int op = ts.getOp();
            if (inForInit && op == 63) {
                ts.ungetToken(102);
                break;
            }
            this.shiftExpr(ts, null, 0);
        }
    }

    private void shiftExpr(TokenStream ts, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        this.addExpr(ts, vname, opCode);
        while (ts.matchesToken(103)) {
            this.addExpr(ts, null, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addExpr(TokenStream ts, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        int tt;
        this.mulExpr(ts, vname, opCode);
        while ((tt = ts.getToken()) == 23 || tt == 24) {
            void var4_4;
            if (var4_4 == 24 || opCode == 1) {
                this.mulExpr(ts, null, 0);
                continue;
            }
            this.mulExpr(ts, null, opCode);
        }
        ts.ungetToken(tt);
    }

    private void mulExpr(TokenStream ts, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        int tt;
        this.unaryExpr(ts, vname, opCode);
        while ((tt = ts.peekToken()) == 25 || tt == 26 || tt == 27) {
            ts.getToken();
            this.unaryExpr(ts, null, 0);
        }
    }

    private void unaryExpr(TokenStream ts, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        ts.flags |= 0x200;
        int tt = ts.getToken();
        ts.flags &= 0xFFFFFDFF;
        switch (tt) {
            case 104: {
                this.unaryExpr(ts, vname, 0);
                return;
            }
            case 23: 
            case 24: {
                this.unaryExpr(ts, null, 0);
                return;
            }
            case 105: 
            case 106: {
                this.memberExpr(ts, true, vname, 0);
                return;
            }
            case 31: {
                this.unaryExpr(ts, null, 0);
                return;
            }
            case -1: {
                this.reportError(ts, "msg.scanner.caught.error");
                break;
            }
            default: {
                ts.ungetToken(tt);
                this.memberExpr(ts, true, vname, opCode);
                tt = ts.peekToken();
                if (!ts.matchesToken(105)) {
                    ts.matchesToken(106);
                }
                return;
            }
        }
    }

    private void argumentList(TokenStream ts, String fname) throws IOException, JavaScriptException {
        ts.flags |= 0x200;
        boolean matched = ts.matchesToken(94);
        ts.flags &= 0xFFFFFDFF;
        if (!matched) {
            FunctionRule f = this.findFunctionMatch(fname, 10);
            if (f == null) {
                do {
                    this.assignExpr(ts, false, 0);
                } while (ts.matchesToken(95));
            } else {
                String[] bParamSpec = f.getParamSpec(10);
                int opCode = f.getFunction().getTypeCode();
                int argCount = 0;
                do {
                    if (bParamSpec[argCount].equalsIgnoreCase("y")) {
                        if (opCode == 5 && ts.getPushbackToken() == 46) {
                            this.addRestValueWrapTokens(ts, 6);
                        } else if (opCode == 2) {
                            this.addValueWrapTokens(ts);
                        } else {
                            this.assignExpr(ts, false, opCode);
                        }
                    } else {
                        this.assignExpr(ts, false, 0);
                    }
                    ++argCount;
                } while (ts.matchesToken(95));
            }
            this.mustMatchToken(ts, 94, "msg.no.paren.arg");
        }
    }

    private void memberExpr(TokenStream ts, boolean allowCallSyntax, StringBuffer vname, int opCode) throws IOException, JavaScriptException {
        int nextToken;
        StringBuffer lFunName = new StringBuffer();
        boolean lFuncNameSupported = true;
        ts.flags |= 0x200;
        int tt = ts.peekToken();
        ts.flags &= 0xFFFFFDFF;
        if (tt == 30) {
            ts.getToken();
            StringBuffer obj_name = new StringBuffer();
            this.memberExpr(ts, false, obj_name, 0);
            if (ts.matchesToken(93)) {
                this.argumentList(ts, obj_name.toString());
            }
        } else {
            this.primaryExpr(ts, lFunName, opCode);
        }
        int lineno2 = ts.getLineno();
        int offset2 = ts.getOffset() + 1;
        int lineno1 = lineno2;
        int offset1 = offset2 - lFunName.length();
        this.lastExprEndLine = ts.getLineno();
        boolean isVariable = true;
        while ((tt = ts.getToken()) > 0) {
            if (tt == 107) {
                isVariable = true;
                this.mustMatchToken(ts, 44, "msg.no.name.after.dot");
                lFunName.append(".").append(ts.getString());
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            if (tt == 89) {
                lFuncNameSupported = false;
                this.expr(ts, false);
                this.mustMatchToken(ts, 90, "msg.no.bracket.index");
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            if (allowCallSyntax && tt == 93) {
                isVariable = false;
                String ss = lFuncNameSupported ? lFunName.toString() : null;
                this.argumentList(ts, ss);
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            ts.ungetToken(tt);
            break;
        }
        if (tt == -1) {
            this.reportError(ts, "msg.scanner.caught.error");
            return;
        }
        if ((allowCallSyntax || isVariable) && vname != null) {
            vname.append(lFunName.toString());
        }
        if ((nextToken = ts.peekToken()) != 96 && isVariable && lFunName.toString().trim().length() > 0) {
            VariableRule bMatch = RuleSetHelper.findJSSystemVariableMatch(this.ruleSet, this.variableMatche.recycleMatchee(lFunName.toString(), 7));
            if (bMatch != null) {
                this.addVariableWrapTokens(ts, lineno1, offset1, 7);
            } else if (REWRITE_VARS_IN_DHTML && opCode == 4 && (bMatch = RuleSetHelper.findJSNonSystemVariableMatch(this.ruleSet, this.variableMatche.recycleMatchee(lFunName.toString(), 2))) != null) {
                this.addVariableWrapTokens(ts, lineno1, offset1, 2);
            }
        }
    }

    private void primaryExpr(TokenStream ts, StringBuffer fname, int opCode) throws IOException, JavaScriptException {
        ts.flags |= 0x200;
        int tt = ts.getToken();
        ts.flags &= 0xFFFFFDFF;
        switch (tt) {
            case 109: {
                this.function(ts);
                return;
            }
            case 89: {
                ts.flags |= 0x200;
                boolean matched = ts.matchesToken(90);
                ts.flags &= 0xFFFFFDFF;
                if (!matched) {
                    do {
                        ts.flags |= 0x200;
                        tt = ts.peekToken();
                        ts.flags &= 0xFFFFFDFF;
                        if (tt == 90) break;
                        if (tt == 95) continue;
                        this.assignExpr(ts, false, 0);
                    } while (ts.matchesToken(95));
                    this.mustMatchToken(ts, 90, "msg.no.bracket.arg");
                }
                return;
            }
            case 91: {
                if (!ts.matchesToken(92)) {
                    block18: do {
                        tt = ts.getToken();
                        switch (tt) {
                            case 44: 
                            case 45: 
                            case 46: {
                                break;
                            }
                            case 92: {
                                ts.ungetToken(tt);
                                break block18;
                            }
                            default: {
                                this.reportError(ts, "msg.bad.prop");
                                break block18;
                            }
                        }
                        this.mustMatchToken(ts, 98, "msg.no.colon.prop");
                        this.handleVariableMatch(ts.getString(), ts, false, true);
                    } while (ts.matchesToken(95));
                    this.mustMatchToken(ts, 92, "msg.no.brace.prop");
                }
                return;
            }
            case 93: {
                this.expr(ts, false);
                this.mustMatchToken(ts, 94, "msg.no.paren");
                return;
            }
            case 44: {
                String name = ts.getString();
                fname.append(name);
                return;
            }
            case 45: {
                return;
            }
            case 46: {
                if (opCode != 0) {
                    this.addRestValueWrapTokens(ts, opCode);
                }
                return;
            }
            case 56: {
                return;
            }
            case 108: {
                String primaryStr = ts.getString();
                if (primaryStr.equals("this") || primaryStr.equals("super")) {
                    fname.append(primaryStr);
                }
                return;
            }
            case 126: {
                this.reportError(ts, "msg.reserved.id");
                break;
            }
            case -1: {
                this.reportError(ts, "msg.scanner.caught.error");
                break;
            }
            default: {
                if (tt == 102) {
                    return;
                }
                this.reportError(ts, "msg.syntax");
            }
        }
    }

    private void handleVariableMatch(String aVariableName, TokenStream ts, boolean inForInit, boolean isObjectProperty) throws IOException, JavaScriptException {
        if (isObjectProperty || ts.matchesToken(96)) {
            int opCode = 0;
            VariableRule v = this.findVariableMatch(aVariableName);
            if (v != null) {
                opCode = v.getVariable().getTypeCode();
                if ((opCode == 1 || opCode == 2) && ts.getOp() != 127) {
                    this.assignExpr(ts, inForInit, 0);
                    return;
                }
                if (opCode == 5 && ts.getPushbackToken() == 46) {
                    this.addRestValueWrapTokens(ts, 6);
                    return;
                }
                if (opCode == 2) {
                    this.addValueWrapTokens(ts);
                    return;
                }
            }
            this.assignExpr(ts, inForInit, opCode);
        }
    }

    private VariableRule findVariableMatch(String aVariableName) {
        if (aVariableName == null || aVariableName.length() == 0) {
            return null;
        }
        return RuleSetHelper.findJSNonSystemVariableMatch(this.ruleSet, this.variableMatche.recycleMatchee(aVariableName, 0));
    }

    private FunctionRule findFunctionMatch(String aFunctionName, int aParamCount) {
        if (aFunctionName == null || aFunctionName.length() == 0) {
            return null;
        }
        return RuleSetHelper.findJSFunctionMatch(this.ruleSet, this.functionMatche.recycleMatchee(aFunctionName, aParamCount));
    }

    private void addVariableWrapTokens(TokenStream aTokenStream, int aStartLine, int aStartOffset, int aType) {
        int[] spec = new int[]{aType, aStartLine, aStartOffset - 1};
        this.tokenList.add(spec);
        spec = new int[]{aType == 7 ? 8 : 3, aTokenStream.getLineno(), aTokenStream.getOffset()};
        this.tokenList.add(spec);
    }

    private void addValueWrapTokens(TokenStream ts) throws IOException, JavaScriptException {
        int[] spec = new int[]{2, ts.getLineno(), ts.getOffset()};
        this.tokenList.add(spec);
        this.assignExpr(ts, false, 0);
        spec = new int[]{3, ts.getLineno(), ts.getOffset()};
        this.tokenList.add(spec);
    }

    private void addRestValueWrapTokens(TokenStream ts, int opCode) throws IOException, JavaScriptException {
        int[] spec = new int[5];
        System.arraycopy(ts.getStringSpec(), 0, spec, 1, 4);
        spec[0] = opCode;
        if (opCode == 6) {
            spec[0] = 5;
            this.assignExpr(ts, false, 0);
            spec[3] = ts.getLineno();
            spec[4] = ts.getOffset();
        }
        this.tokenList.add(spec);
    }

    public static void recordWarning(JavaScriptException e) {
        if (Debug.isWarningEnabled()) {
            Debug.recordOriginalPageWarning("Unable to Translate JS:", e);
        }
    }

    static String getMessage(String aMessageID, Object[] aArgs) {
        return "JavaScript compile error: id = " + aMessageID + ", args = " + aArgs;
    }

    public static void main(String[] args) throws Exception {
        String[][] basicTestData = new String[][]{{"this.sessURL = prot + \"http://myhost.domain.com:81\" + \"/scripts/cgi\";"}};
        String lRules = "<Variable name=\"this.sessURL\" type=\"EXPRESSION\"/>";
        int i = 0;
        while (i < basicTestData.length) {
            RuleSet lRuleSet = CreateRuleSet.withJSVariableRules(lRules);
            JSParser p = new JSParser(basicTestData[i][0], lRuleSet, new AbsoluteTranslator(new PageSpec("http://raja.sun.com/ab.html?eee")));
            String result = p.parse().toString();
            Debug.println("SourceURI: " + basicTestData[i][0]);
            Debug.println("Input: " + basicTestData[i][1]);
            Debug.println("Result: " + result);
            ++i;
        }
    }
}

