/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.addressbook.ABSession;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import java.util.Hashtable;
import java.util.Properties;

public class NotesABSSOAdapter
extends SSOAdapter {
    protected ABStore abStore = null;
    protected ABSession abSession = null;
    private static String CLIENT_DEFAULT_PORT = "80";
    private static String CLIENT_DEFAULT_PROTOCOL = "http";
    private static String serviceClass = "com.sun.ssoadapter.ab.notes.NotesABStore";

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        super.init(adapterName, token, adapterProperties);
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
    }

    public void validate() throws ValidationException {
        String hostString;
        String portString = this.adapterProperties.getProperty("port");
        if (portString != null) {
            try {
                int portInt = Integer.parseInt(portString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidPort");
                throw ve;
            }
        }
        if ((hostString = this.adapterProperties.getProperty("host")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingHost");
            throw ve;
        }
        String uidString = this.adapterProperties.getProperty("uid");
        if (uidString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingUid");
            throw ve;
        }
        String passwordString = this.adapterProperties.getProperty("password");
        if (passwordString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingPassword");
            throw ve;
        }
        String clientPortString = this.adapterProperties.getProperty("clientPort");
        if (clientPortString != null) {
            try {
                int portInt = Integer.parseInt(clientPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidClientPort");
                throw ve;
            }
        }
    }

    public Object getConnection() {
        ABStore obj = null;
        try {
            obj = this.getABStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store");
        }
        return obj;
    }

    public ABStore getABStore() throws Exception {
        if (this.isAvailable()) {
            return this.abStore;
        }
        this.abSession = this.getABSession();
        this.abStore = this.abSession.getABStore(serviceClass);
        this.abStore.connect();
        return this.abStore;
    }

    public ABSession getABSession() throws Exception {
        if (this.abSession != null) {
            return this.abSession;
        }
        Properties props = new Properties();
        String host = this.adapterProperties.getProperty("host");
        String uid = this.adapterProperties.getProperty("uid");
        String port = this.adapterProperties.getProperty("port", null);
        String password = this.adapterProperties.getProperty("password");
        String abType = this.adapterProperties.getProperty("abtype");
        if (host != null) {
            ((Hashtable)props).put("ab.host", host);
        }
        if (uid != null) {
            ((Hashtable)props).put("ab.userName", uid);
            ((Hashtable)props).put("ab.userMailBox", uid);
        }
        if (password != null) {
            ((Hashtable)props).put("ab.userPassword", password);
        }
        if (abType != null) {
            ((Hashtable)props).put("ab.type", abType);
        }
        if (port != null) {
            ((Hashtable)props).put("ab.port", port);
        }
        this.abSession = ABSession.getInstance((Properties)props);
        return this.abSession;
    }

    public boolean isAvailable() {
        try {
            return this.abStore != null && this.abStore.isConnected();
        }
        catch (ABStoreException abse) {
            SSOAdapterDebug.logMessage("NotesABSSOAdapter.isAvailable(): Failed isConnected() check.");
            return false;
        }
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.abStore.disconnect();
            this.abStore = null;
            this.abSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (this.abStore != null) {
                this.abStore.disconnect();
            }
            this.abStore = null;
            this.abSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

