/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.Store;

public class JavaMailSSOAdapter
extends SSOAdapter {
    protected Store mailStore = null;
    protected Session mailSession = null;
    public String psimap = "psimap";

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        super.init(adapterName, token, adapterProperties);
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
    }

    public void validate() throws ValidationException {
        String enableProxyAuth;
        String hostString;
        String portString = this.adapterProperties.getProperty("port");
        if (portString != null) {
            try {
                int portInt = Integer.parseInt(portString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidPort");
                throw ve;
            }
        }
        if ((hostString = this.adapterProperties.getProperty("host")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingHost");
            throw ve;
        }
        String clientPortString = this.adapterProperties.getProperty("clientPort");
        if (clientPortString != null) {
            try {
                int portInt = Integer.parseInt(clientPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidClientPort");
                throw ve;
            }
        }
        if ((enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false")).equals("false")) {
            String uidString = this.adapterProperties.getProperty("uid");
            if (uidString == null) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("missingUid");
                throw ve;
            }
            String passwordString = this.adapterProperties.getProperty("password");
            if (passwordString == null) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("missingPassword");
                throw ve;
            }
        }
    }

    public Object getConnection() {
        Store obj = null;
        try {
            obj = this.getStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store");
        }
        return obj;
    }

    public boolean isAvailable() {
        return this.mailStore != null && this.mailStore.isConnected();
    }

    public Store getStore() throws Exception {
        if (this.isAvailable()) {
            return this.mailStore;
        }
        Session mailSession = this.getSession();
        String protocolString = this.adapterProperties.getProperty("protocol");
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        String uid = null;
        String password = null;
        String portString = this.adapterProperties.getProperty("port", protocolString.equals("pop3") ? "110" : "143");
        if (enableProxyAuth.equals("true")) {
            SSOToken tok = this.getSSOToken();
            protocolString = this.psimap;
            if (tok != null) {
                uid = this.adapterProperties.getProperty("proxyAdminUid");
                password = this.adapterProperties.getProperty("proxyAdminPassword");
            }
        } else {
            uid = this.adapterProperties.getProperty("uid");
            password = this.adapterProperties.getProperty("password");
            String domain = this.adapterProperties.getProperty("domain");
            if (domain != null) {
                uid = uid + "@" + domain;
            }
        }
        SSOAdapterDebug.logMessage(this.identifier + " retrieving store with protocol " + protocolString);
        this.mailStore = mailSession.getStore(protocolString);
        this.mailStore.connect(this.adapterProperties.getProperty("host"), Integer.parseInt(portString), uid, password);
        return this.mailStore;
    }

    public Session getSession() throws Exception {
        if (this.mailSession != null) {
            return this.mailSession;
        }
        Properties props = new Properties();
        String host = this.adapterProperties.getProperty("host");
        String smtpPort = this.adapterProperties.getProperty("smtpPort");
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        ((Hashtable)props).put("mail.debug", "false");
        ((Hashtable)props).put("mail.store.pkgs", "com.sun.mail");
        ((Hashtable)props).put("mail.transport.protocol", "smtp");
        ((Hashtable)props).put("mail.imap.fetchsize", "16384");
        ((Hashtable)props).put("mail.smtp.host", this.adapterProperties.getProperty("smtpServer", host));
        if (smtpPort != null) {
            ((Hashtable)props).put("mail.smtp.port", smtpPort);
        }
        if (enableProxyAuth.equals("true")) {
            SSOToken tok = this.getSSOToken();
            AMStoreConnection amsc = null;
            AMUser auser = null;
            String usrAttr = null;
            String puid = null;
            ((Hashtable)props).put("mail." + this.psimap + ".fetchsize", "16384");
            if (tok != null) {
                usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                try {
                    amsc = new AMStoreConnection(tok);
                    auser = amsc.getUser(tok.getPrincipal().getName());
                    puid = auser.getStringAttribute(usrAttr);
                }
                catch (SSOException ssoe) {
                    SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ssoe);
                }
                catch (AMException ame) {
                    SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ame);
                }
                if (puid != null && puid.length() > 0) {
                    String domain = this.adapterProperties.getProperty("domain");
                    if (domain != null) {
                        puid = puid + "@" + domain;
                    }
                    ((Hashtable)props).put("mail." + this.psimap + ".proxyauth.user", puid);
                }
                SSOAdapterDebug.logMessage(this.identifier + "connecting with proxy uid=" + puid);
            }
        }
        this.mailSession = Session.getInstance((Properties)props, null);
        return this.mailSession;
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.mailStore.close();
            this.mailStore = null;
            this.mailSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (this.mailStore != null) {
                this.mailStore.close();
            }
            this.mailStore = null;
            this.mailSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

