/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterConstants;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.config.Configuration;
import com.sun.ssoadapter.config.ConfigurationEvent;
import com.sun.ssoadapter.config.ConfigurationException;
import com.sun.ssoadapter.config.ConfigurationFactory;
import com.sun.ssoadapter.config.ConfigurationListener;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class SSOAdapterFactory
implements SSOAdapterConstants,
ConfigurationListener {
    public static final String SERVICE_NAME = "SunSSOAdapterService";
    protected static final String ATTR_TEMPLATES_NAME = "sunConfigurationTemplates";
    protected static final String ATTR_CONFIGURATIONS_NAME = "sunSSOAdapterConfigurations";
    protected static SSOAdapterFactory ssoAdapterInstance = new SSOAdapterFactory();
    private ConfigurationFactory configurationFactory = null;
    private Hashtable adapterHashtable = new Hashtable(100);
    private final String thisClass = this.getClass().getName();
    private static final String authlessSUID = "ssoadapter.authless.suid";

    private SSOAdapterFactory() {
        this.configurationFactory = ConfigurationFactory.getInstance(SERVICE_NAME, ATTR_CONFIGURATIONS_NAME, ATTR_TEMPLATES_NAME);
    }

    public static SSOAdapterFactory getInstance() {
        return ssoAdapterInstance;
    }

    public SSOAdapter getSSOAdapter(String configName, HttpServletRequest request) throws SSOAdapterException {
        return this.getSSOAdapter(configName, request, null, null, null);
    }

    public SSOAdapter getSSOAdapter(String configName, HttpServletRequest request, Locale locale) throws SSOAdapterException {
        return this.getSSOAdapter(configName, request, locale, null, null);
    }

    public SSOAdapter getSSOAdapter(String configName, HttpServletRequest request, Locale locale, String authlessUid) throws SSOAdapterException {
        return this.getSSOAdapter(configName, request, locale, authlessUid, null);
    }

    public SSOAdapter getSSOAdapter(String configName, HttpServletRequest request, Locale locale, String authlessUid, String instanceName) throws SSOAdapterException {
        if (request == null) {
            String msg = this.getClass().getName() + ".getSSOAdapter():  " + "requires request be set.";
            SSOAdapterDebug.logWarning(msg);
            throw new SSOAdapterException(msg);
        }
        if (configName == null || configName.length() == 0) {
            Enumeration nameEnum = this.configurationFactory.getConfigurationNames(request);
            if (nameEnum == null || !nameEnum.hasMoreElements()) {
                String msg = this.thisClass + "getSSOAdapter(): " + "could not determine configName.";
                SSOAdapterDebug.logWarning(msg);
                throw new SSOAdapterException(msg);
            }
            configName = (String)nameEnum.nextElement();
        }
        SSOAdapter ssoAdapter = null;
        SSOTokenManager tokenManager = null;
        SSOToken token = null;
        SSOTokenID tokenID = null;
        String tokenString = null;
        try {
            tokenManager = SSOTokenManager.getInstance();
            token = tokenManager.createSSOToken(request);
            tokenID = token.getTokenID();
            tokenString = tokenID.toString();
        }
        catch (SSOException ssoe) {
            if (authlessUid != null) {
                tokenString = authlessUid;
                request.setAttribute(authlessSUID, (Object)tokenString);
            }
            String msg = this.thisClass + ".getSSOAdapter() failed.  Reason: " + " Session Invalid for configuration " + configName;
            SSOAdapterDebug.logWarning(msg);
            throw new SSOAdapterException(msg);
        }
        try {
            String hashKey = tokenString + configName;
            if (instanceName != null) {
                hashKey = hashKey + instanceName;
            }
            if ((ssoAdapter = (SSOAdapter)this.adapterHashtable.get(hashKey)) != null && ssoAdapter.getProperties() != null) {
                return ssoAdapter;
            }
            Configuration config = this.configurationFactory.readConfiguration(configName, true, request);
            if (config == null) {
                String msg = this.thisClass + ".getSSOAdapter():  " + "could not find configuration \"" + configName + "\"";
                SSOAdapterDebug.logWarning(msg);
                throw new SSOAdapterException(msg);
            }
            ssoAdapter = this.createSSOAdapter(config, token, locale);
            this.adapterHashtable.put(hashKey, ssoAdapter);
            if (token != null) {
                token.addSSOTokenListener((SSOTokenListener)ssoAdapter);
            }
            HashtableReaper reaper = new HashtableReaper(hashKey, this.adapterHashtable);
            if (token != null) {
                token.addSSOTokenListener((SSOTokenListener)reaper);
            }
        }
        catch (SSOAdapterException ssoe) {
            if (ssoe.isInvalid()) {
                throw ssoe;
            }
            String msg = this.getClass().getName() + ".getSSOAdapter() failed.  Reason:  " + ssoe.toString();
            SSOAdapterDebug.logWarning(msg);
            throw new SSOAdapterException(msg);
        }
        catch (Exception e) {
            String msg = this.getClass().getName() + ".getSSOAdapter() failed.  Reason:  " + e.toString();
            SSOAdapterDebug.logWarning(msg);
            throw new SSOAdapterException(msg);
        }
        return ssoAdapter;
    }

    public SSOAdapter getSSOAdapter(SSOAdapter immutableAdapter, Properties newProperties, HttpServletRequest request) throws SSOAdapterException {
        return this.getSSOAdapter(immutableAdapter, newProperties, request, null, null);
    }

    public SSOAdapter getSSOAdapter(SSOAdapter immutableAdapter, Properties newProperties, HttpServletRequest request, Locale locale) throws SSOAdapterException {
        return this.getSSOAdapter(immutableAdapter, newProperties, request, locale, null);
    }

    public SSOAdapter getSSOAdapter(SSOAdapter immutableAdapter, Properties newProperties, HttpServletRequest request, Locale locale, String instanceName) throws SSOAdapterException {
        String msg;
        SSOAdapter returnAdapter = null;
        Configuration config = null;
        Configuration configOrig = null;
        String configName = null;
        String channelName = null;
        SSOToken token = null;
        String hashKey = "";
        if (immutableAdapter == null) {
            return returnAdapter;
        }
        configName = immutableAdapter.getName();
        channelName = newProperties.getProperty("channelName");
        try {
            String tokenString;
            configOrig = this.configurationFactory.readConfiguration(configName, true, request);
            if (configOrig == null) {
                String msg2 = this.thisClass + ".getSSOAdapter():  " + "could not find configuration \"" + configName + "\"";
                SSOAdapterDebug.logWarning(msg2);
                throw new SSOAdapterException(msg2);
            }
            config = new Configuration(configOrig.getConfigurationURL());
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            token = tokenManager.createSSOToken(request);
            SSOTokenID tokenID = token.getTokenID();
            hashKey = tokenString = tokenID.toString();
        }
        catch (ConfigurationException ce) {
            String msg3 = this.thisClass + ".getSSOAdapter() failed.  Reason: " + ce.toString();
            SSOAdapterDebug.logError(msg3);
            throw new SSOAdapterException(msg3);
        }
        catch (SSOException ssoe) {
            msg = this.thisClass + ".getSSOAdapter() failed to get SSO: " + ssoe.toString();
            SSOAdapterDebug.logWarning(msg);
        }
        if (config != null) {
            String uniqueName;
            Enumeration<?> propsEnum = newProperties.propertyNames();
            while (propsEnum.hasMoreElements()) {
                String key = (String)propsEnum.nextElement();
                config.setProperty(key, newProperties.getProperty(key));
            }
            if (channelName != null && !configName.endsWith("_" + channelName) && !configName.equals(uniqueName = configName + "_" + channelName)) {
                configName = uniqueName;
                config.setConfigurationName(configName);
            }
            try {
                returnAdapter = this.createSSOAdapter(config, token, locale);
                this.configurationFactory.writeConfiguration(config, request);
                hashKey = hashKey + configName;
                if (instanceName != null) {
                    hashKey = hashKey + instanceName;
                }
                if (this.adapterHashtable.containsKey(hashKey)) {
                    this.adapterHashtable.remove(hashKey);
                }
            }
            catch (ConfigurationException ce) {
                msg = this.thisClass + ".getSSOAdapter() failed.  Reason: " + ce.toString();
                SSOAdapterDebug.logError(msg);
                throw new SSOAdapterException(msg);
            }
            catch (SSOAdapterException ssoe) {
                if (ssoe.isInvalid()) {
                    throw ssoe;
                }
                String msg4 = this.thisClass + ".getSSOAdapter() failed.  Reason: " + ssoe.toString();
                SSOAdapterDebug.logError(msg4);
                throw new SSOAdapterException(msg4);
            }
        }
        return returnAdapter;
    }

    private SSOAdapter createSSOAdapter(Configuration config, SSOToken token, Locale locale) throws SSOAdapterException {
        SSOAdapter ssoAdapter = null;
        String configName = config.getConfigurationName();
        String className = config.getProperty("ssoClassName");
        if (className == null) {
            String msg = this.getClass().getName() + ".getSSOAdapter():  " + "did not find ssoClassName property in configuration \"" + configName + "\"";
            SSOAdapterDebug.logWarning(msg);
            throw new SSOAdapterException(msg);
        }
        try {
            Class<?> ssoAdapterClass = Class.forName(className);
            Class[] argConst = new Class[]{};
            Constructor<?> ssoAdapterConst = ssoAdapterClass.getConstructor(argConst);
            Object[] argConstObj = new Object[]{};
            ssoAdapter = (SSOAdapter)ssoAdapterConst.newInstance(argConstObj);
            ssoAdapter.locale = locale;
            ssoAdapter.init(configName, token, config.getProperties());
        }
        catch (SSOAdapterException ssoe) {
            throw ssoe;
        }
        catch (Exception e) {
            throw new SSOAdapterException("Could not create SSOAdapter");
        }
        return ssoAdapter;
    }

    public boolean configurationChanged(ConfigurationEvent evt) {
        return true;
    }

    private class HashtableReaper
    implements SSOTokenListener {
        private String key;
        private Hashtable hashTable;

        HashtableReaper(String key, Hashtable hashTable) {
            this.key = key;
            this.hashTable = hashTable;
        }

        public void ssoTokenChanged(SSOTokenEvent evt) {
            try {
                int evtType = evt.getType();
                if (evtType != 3 && evtType != 1 && evtType != 2) {
                    return;
                }
                this.hashTable.remove(this.key);
            }
            catch (Exception e) {
                SSOAdapterDebug.logError(this.getClass().getName() + ".ssoTokenChanged():  failed:  " + e);
            }
        }
    }
}

