/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class LocaleHelper {
    private static final Map localeHelperList = new HashMap();
    private final String RESOURCE_BASE;
    private ResourceBundle resourceBundle;

    public LocaleHelper(String aBase) {
        this(aBase, Locale.getDefault());
    }

    public LocaleHelper(String aBase, Locale aLocale) {
        this.RESOURCE_BASE = aBase;
        this.setLocale(aLocale);
    }

    public void setLocale(Locale locale) {
        this.resourceBundle = ResourceBundle.getBundle(this.RESOURCE_BASE, locale);
    }

    public String getResourceBase() {
        return this.RESOURCE_BASE;
    }

    public String getLocalizedString(String key) {
        return this.resourceBundle.getString(key);
    }

    public String getLocalizedString(String key, Object[] objs) {
        if (objs != null && objs.length > 0) {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(this.resourceBundle.getLocale());
            mf.applyPattern(this.resourceBundle.getString(key));
            return mf.format(objs);
        }
        return this.resourceBundle.getString(key);
    }

    public void debug(String key) {
        this.debug(key, null);
    }

    public void debug(String key, Object[] tokens) {
        String msg = this.getLocalizedString(key, tokens);
        Object[] toks = new Object[]{msg};
        System.out.println(this.getLocalizedString("msgDebug", toks));
    }

    public void warning(String key) {
        this.warning(key, null);
    }

    public void warning(String key, Object[] tokens) {
        String msg = this.getLocalizedString(key, tokens);
        Object[] toks = new Object[]{msg};
        System.out.println(this.getLocalizedString("msgWarning", toks));
    }

    public static Locale getLocale(String stringformat) {
        if (stringformat == null) {
            return Locale.getDefault();
        }
        StringTokenizer tk = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    public static void store(String aLocaleBase, Locale aLocale) {
        localeHelperList.put(aLocaleBase, new LocaleHelper(aLocaleBase, aLocale));
    }

    public static LocaleHelper getLocaleHelper(String aLocaleBase) {
        return (LocaleHelper)localeHelperList.get(aLocaleBase);
    }
}

