/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.ids;

import com.sun.portal.rewriter.rom.DataRuleCollection;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.rom.RuleCollection;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.rom.html.HTMLRules;
import com.sun.portal.rewriter.rom.js.JSRules;
import com.sun.portal.rewriter.rom.xml.XMLRules;
import com.sun.portal.rewriter.services.ids.DataSource;
import com.sun.portal.rewriter.services.ids.IDSRuleCollectionBuilder;
import com.sun.portal.rewriter.services.ids.test.MockIDSDataSource;
import com.sun.portal.rewriter.util.Debug;

public final class IDSRuleSetBuilder {
    public static RuleSet createRuleSet(DataSource aDataSource) throws InvalidXMLException {
        RuleCollection[] ruleCollections = new RuleCollection[]{IDSRuleSetBuilder.createHTMLRules(aDataSource), IDSRuleSetBuilder.createJSRules(aDataSource), IDSRuleSetBuilder.createXMLRules(aDataSource)};
        return new RuleSet("ids_ruleset", ruleCollections);
    }

    private static HTMLRules createHTMLRules(DataSource aDataSource) throws InvalidXMLException {
        RuleCollection[] htmlRuleCollections = new DataRuleCollection[]{IDSRuleCollectionBuilder.getHTMLAppletRuleCollection(aDataSource), IDSRuleCollectionBuilder.getHTMLFormRuleCollection(aDataSource), IDSRuleCollectionBuilder.getHTMLAttributeRuleCollection(aDataSource)};
        return new HTMLRules(htmlRuleCollections);
    }

    private static JSRules createJSRules(DataSource aDataSource) throws InvalidXMLException {
        RuleCollection[] jsRuleCollections = new DataRuleCollection[]{IDSRuleCollectionBuilder.getJSVariableRuleCollection(aDataSource), IDSRuleCollectionBuilder.getJSFunctionRuleCollection(aDataSource)};
        return new JSRules(jsRuleCollections);
    }

    private static XMLRules createXMLRules(DataSource aDataSource) throws InvalidXMLException {
        RuleCollection[] xmlRuleCollections = new DataRuleCollection[]{IDSRuleCollectionBuilder.getXMLAttributeRuleCollection(aDataSource), IDSRuleCollectionBuilder.getXMLTagTextRuleCollection(aDataSource)};
        return new XMLRules(xmlRuleCollections);
    }

    public static void main(String[] args) throws InvalidXMLException {
        Debug.println(IDSRuleSetBuilder.createRuleSet(new MockIDSDataSource()).toXML());
    }
}

