/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.css;

import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.RewriterBroker;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;

public final class CSSRewriter
extends AbstractRewriter {
    public CSSRewriter(RewriterBroker aRewriterBroker) {
        super(aRewriterBroker, "text/css");
    }

    public void plugableRewriter(PageContent aPageContent, Translator aTranslator) {
        CSSRewriter.handleCSSURLs(aPageContent, aTranslator);
        CSSRewriter.handleCSSImports(aPageContent, aTranslator);
    }

    private static final void handleCSSImports(PageContent aPageContent, Translator aTranslator) {
        int importURLBeginIndex;
        String lTranslatedURLContent = aPageContent.getResult();
        String lLowerTranslatedURLContent = lTranslatedURLContent.toLowerCase();
        StringBuffer lResultBuffer = null;
        int cursorIndex = 0;
        do {
            int importURLEndIndex;
            char c;
            if ((importURLBeginIndex = lLowerTranslatedURLContent.indexOf("@import ", cursorIndex)) == -1) continue;
            if (lResultBuffer == null) {
                lResultBuffer = new StringBuffer();
            }
            importURLBeginIndex += "@import ".length();
            while (Character.isWhitespace(c = lTranslatedURLContent.charAt(importURLBeginIndex))) {
                ++importURLBeginIndex;
            }
            lResultBuffer.append(lTranslatedURLContent.substring(cursorIndex, importURLBeginIndex + 1));
            if ((c == Constants.DOUBLE_QUOTES_CHAR || c == Constants.SINGLE_QUOTES_CHAR) && (importURLEndIndex = lLowerTranslatedURLContent.indexOf(c, importURLBeginIndex + 1)) != -1) {
                lResultBuffer.append(CSSRewriter.translateCSSURI(lTranslatedURLContent.substring(importURLBeginIndex + 1, importURLEndIndex), aTranslator)).append(c);
                cursorIndex = importURLEndIndex + 1;
                continue;
            }
            cursorIndex = importURLBeginIndex + 1;
        } while (importURLBeginIndex != -1);
        if (lResultBuffer != null) {
            lResultBuffer.append(lTranslatedURLContent.substring(cursorIndex));
            StringBuffer bResult = aPageContent.getResultBuffer();
            bResult.setLength(0);
            bResult.append((Object)lResultBuffer);
        }
    }

    private static final void handleCSSURLs(PageContent aPageContent, Translator aTranslator) {
        int urlBeginIndex;
        StringBuffer lResultBuffer = aPageContent.getResultBuffer();
        String lowerContent = aPageContent.toLowerCase();
        int cursorIndex = 0;
        do {
            if ((urlBeginIndex = lowerContent.indexOf("url(", cursorIndex)) == -1) continue;
            lResultBuffer.append(aPageContent.substring(cursorIndex, urlBeginIndex += "url(".length()));
            int urlEndIndex = lowerContent.indexOf(")", urlBeginIndex);
            if (urlEndIndex != -1) {
                lResultBuffer.append(CSSRewriter.translateCSSURI(aPageContent.substring(urlBeginIndex, urlEndIndex), aTranslator)).append(")");
                cursorIndex = urlEndIndex + ")".length();
                continue;
            }
            if (Debug.isWarningEnabled()) {
                Debug.recordOriginalPageWarning("Unable to traslate CSS:\n" + aTranslator.getPageSpec());
            }
            cursorIndex = 0;
        } while (urlBeginIndex != -1);
        if (cursorIndex > 0) {
            lResultBuffer.append(aPageContent.substring(cursorIndex));
        }
    }

    private static final String translateCSSURI(String aUrl, Translator aTranslator) {
        if (!aUrl.trim().startsWith("#")) {
            aUrl = aTranslator.translate(aUrl);
        }
        return aUrl;
    }
}

