/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.encode;

import com.sun.portal.desktop.encode.TypeDecoder;
import com.sun.portal.desktop.encode.TypeEncoder;
import com.sun.portal.desktop.util.Integers;
import java.net.URLDecoder;

class CookieEncoderDecoder
implements TypeEncoder,
TypeDecoder {
    public static final char[] cookieEscapeChars = new char[]{';', ',', ' ', '[', ']', '{', '}', '=', '\"', '/', '\\', '?', '@', ':', '\n', '\r'};

    CookieEncoderDecoder() {
    }

    private static boolean isCookieEscChar(char ch) {
        boolean result = false;
        int i = 0;
        while (i < cookieEscapeChars.length) {
            if (ch == cookieEscapeChars[i]) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public String encode(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (CookieEncoderDecoder.isCookieEscChar(ch)) {
                char j = ch;
                buf.append("%").append(Integers.getHex(j));
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public String decode(String value) {
        return URLDecoder.decode(value);
    }
}

