/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPProperty;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import com.sun.portal.desktop.encode.Encoder;
import com.sun.portal.desktop.util.OrderedMap;
import com.sun.portal.desktop.util.OrderedSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDPCollection
extends XMLDPProperty
implements DPCollection,
DPTypes,
XMLDPTags {
    protected Map propertiesTable = XMLDPObject.createElementTable(this.getElement());

    XMLDPCollection(DPContext dpc, DPRoot r, Document d, String name, Map val) {
        this(dpc, r, XMLDPCollection.createElement(dpc, r, d, name, val));
    }

    XMLDPCollection(DPContext dpc, DPRoot r, Document d, String name, List val) {
        this(dpc, r, XMLDPCollection.createElement(dpc, r, d, name, val));
    }

    XMLDPCollection(DPContext dpc, DPRoot r, Document d, String name) {
        this(dpc, r, XMLDPObject.createElement(dpc, d, name));
    }

    XMLDPCollection(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
    }

    public void checkType() {
        if (!(this.getElement().getTagName().equals("Properties") || this.getElement().getTagName().equals("ConditionalProperties") || this.getElement().getTagName().equals("Locale") || this.getElement().getTagName().equals("Collection"))) {
            throw new DPError("XMLDPCollection.checkType(): wrong type tagName=" + this.getElement().getTagName());
        }
    }

    public Object setValue(Object o) {
        Object old = this.getValue();
        if (o instanceof Map) {
            this.setCollectionValue((Map)o);
        } else if (o instanceof List) {
            this.setCollectionValue((List)o);
        } else {
            throw new DPError("XMLDPCollection.setValue(): object was not a List or Map");
        }
        return old;
    }

    public short getType() {
        return 14;
    }

    public String getTag() {
        return "Collection";
    }

    public DPProperty getFromThis(String key) {
        Element e = this.getElementFromThis(key);
        DPProperty dpProperty = null;
        if (e != null && (dpProperty = (DPProperty)this.getObject(e)) == null) {
            dpProperty = XMLDPFactory.getInstance().getProperty(this.getContext(), this.getRoot(), e);
            this.putObject(dpProperty);
        }
        return dpProperty;
    }

    Element getElementFromThis(String key) {
        Element e = (Element)this.propertiesTable.get(key);
        return e;
    }

    DPProperty getFromMergers(String key) {
        long start = System.currentTimeMillis();
        DPProperty dpProperty = null;
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPCollection dpc = (DPCollection)i.next();
            DPProperty dpp = ((XMLDPCollection)dpc).getFromThis(key);
            if (dpp == null) continue;
            dpProperty = dpp;
            break;
        }
        return dpProperty;
    }

    public DPProperty get(String key) {
        boolean replace = false;
        DPProperty dpProperty = this.getFromThis(key);
        if (dpProperty == null || !dpProperty.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPCollection dpc = (DPCollection)i.next();
                DPProperty dpp = ((XMLDPCollection)dpc).getFromThis(key);
                if (dpp == null) continue;
                if (dpProperty != null) {
                    if (dpp.getType() != dpProperty.getType()) {
                        throw new DPError("XMLDPCollection.get(): conflicting types found for key=" + key);
                    }
                } else {
                    DPProperty ddpp = ((XMLDPProperty)dpp).createDummy(this.getRoot());
                    dpProperty = this.add(ddpp, false, false, true);
                    if (!dpp.isLocked() && dpProperty.isDummy() && this.isReplace()) {
                        replace = true;
                    }
                }
                if (!dpProperty.isMergeLocked() && dpp.isLocked() && dpp.isRemove()) {
                    dpProperty = null;
                    break;
                }
                dpProperty.addMerger(dpp);
            }
        }
        if (dpProperty != null && !dpProperty.isMergeLocked() && dpProperty.isRemove()) {
            dpProperty = null;
        }
        if (replace) {
            dpProperty = null;
        }
        return dpProperty;
    }

    public void addAll(Set props) {
        if (props == null) {
            return;
        }
        Iterator i = props.iterator();
        while (i.hasNext()) {
            XMLDPProperty dpp = (XMLDPProperty)i.next();
            this.add(dpp);
        }
    }

    public DPProperty add(DPProperty dpp) {
        return this.add(dpp, true, true, false);
    }

    DPProperty add(DPProperty dpp, boolean copy, boolean deep, boolean dummy) {
        this.removeObject(dpp);
        XMLDPProperty xmldpp = null;
        xmldpp = copy ? (XMLDPProperty)dpp.copy(this.getRoot(), deep) : (XMLDPProperty)dpp;
        Element e = xmldpp.getElement();
        this.getElement().appendChild(e);
        this.propertiesTable.put(xmldpp.getName(), e);
        this.putObject(xmldpp);
        xmldpp.setDummy(dummy);
        return xmldpp;
    }

    public void removeAll() {
        Set names = this.getNamesFromThis();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.remove(name, false);
        }
        this.propertiesTable.clear();
    }

    public DPProperty remove(String key) {
        return this.remove(key, true);
    }

    protected DPProperty remove(String key, boolean updateTable) {
        DPProperty dppFromMerger;
        DPProperty removedDPP = null;
        DPProperty dppFromThis = this.getFromThis(key);
        if (dppFromThis != null) {
            this.removeElement(dppFromThis);
            if (updateTable) {
                this.propertiesTable.remove(key);
            }
            this.removeObject(dppFromThis);
            removedDPP = dppFromThis;
            this.setDummy(false);
        }
        if ((dppFromMerger = this.getFromMergers(key)) != null) {
            DPProperty dpp = this.add(dppFromMerger, true, false, false);
            dpp.setMergeType((short)2);
            if (removedDPP == null) {
                removedDPP = dpp;
            }
        }
        return removedDPP;
    }

    void removeElement(DPProperty dpp) {
        XMLDPProperty xmlDPP = (XMLDPProperty)dpp;
        Element childElement = xmlDPP.getElement();
        Element parentElement = this.getElement();
        parentElement.removeChild(childElement);
    }

    void removeChildElements() {
        List childElements = XMLDPObject.getChildElements(this.getElement(), null);
        Iterator i = childElements.iterator();
        while (i.hasNext()) {
            Element childElement = (Element)i.next();
            this.getElement().removeChild(childElement);
            this.removeObject(childElement);
        }
        this.propertiesTable.clear();
    }

    private void removeElement(String key) {
        Element childElement = this.getElementFromThis(key);
        if (childElement == null) {
            return;
        }
        this.getElement().removeChild(childElement);
        this.removeObject(childElement);
        this.propertiesTable.remove(key);
    }

    public void setCollectionValue(Map m) {
        Set mergerNames = this.getNamesFromMergers();
        Set names = this.getNames();
        Iterator i = mergerNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (m.containsKey(name)) continue;
            DPProperty mergerDPP = this.getFromMergers(name);
            this.removeElement(name);
            if (names.contains(name)) {
                names.remove(name);
            }
            DPProperty dpp = this.add(mergerDPP, true, false, false);
            dpp.setMergeType((short)2);
        }
        Iterator i2 = m.keySet().iterator();
        while (i2.hasNext()) {
            DPProperty dpp;
            String name = (String)i2.next();
            Object o = m.get(name);
            DPProperty dpProp = this.get(name);
            if (names.contains(name)) {
                this.removeElement(name);
                names.remove(name);
            }
            if (dpProp != null) {
                dpp = this.add(dpProp, true, false, false);
                dpp.setValue(o);
                continue;
            }
            dpp = this.createProperty(name, o);
            this.add(dpp);
        }
        if (names.size() > 0) {
            Iterator i3 = names.iterator();
            while (i3.hasNext()) {
                this.removeElement((String)i3.next());
            }
        }
        this.setDummy(false);
    }

    DPProperty createProperty(String name, Object o) {
        DPProperty dpp = XMLDPFactory.getInstance().createProperty(this.getContext(), this.getRoot(), this.getDocument(), name, o);
        return dpp;
    }

    public void setCollectionValue(List l) {
        OrderedMap m = new OrderedMap();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            m.put(s, s);
        }
        this.setCollectionValue(m);
    }

    public Map getCollectionValue() {
        return (Map)this.getValue();
    }

    public Object getValue() {
        return this.getValue(this.getNames());
    }

    Object getValue(Set names) {
        OrderedMap objs = new OrderedMap();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            DPProperty dpProperty = this.get(name);
            if (dpProperty == null) {
                throw new DPError("XMLDPCollection.getValue(): couldn't get value for name=" + name);
            }
            Object v = dpProperty.getValue();
            objs.put(name, v);
        }
        return objs;
    }

    public Set getNamesFromThis() {
        return this.propertiesTable.keySet();
    }

    Set mergeNamesFromThis(Set names, Set locked) {
        Set namesFromThis = this.getNamesFromThis();
        Iterator i = namesFromThis.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            DPProperty dpp = this.getFromThis(name);
            if (dpp == null) {
                throw new DPError("XMLDPCollection.mergeNamesFromThis(): mismatch, could not get object from this for name from this, name=" + name + ", namesFromThis=" + namesFromThis);
            }
            if (dpp.isDummy() || locked.contains(name)) continue;
            if (dpp.isLocked()) {
                locked.add(name);
            }
            if (dpp.getMergeType() == 2) {
                names.remove(name);
                continue;
            }
            names.add(name);
        }
        return names;
    }

    Set getNamesFromMergers() {
        Set names = new OrderedSet();
        OrderedSet locked = new OrderedSet();
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            XMLDPCollection dpc = (XMLDPCollection)i.next();
            if (dpc.isRemove()) {
                names = this.clearElements(names, locked);
            } else if (!dpc.isDummy() && !dpc.isMergeLocked() && dpc.isReplace()) {
                names = this.clearElements(names, locked);
                names = dpc.mergeNamesFromThis(names, locked);
            } else {
                names = dpc.mergeNamesFromThis(names, locked);
            }
            if (!dpc.isLocked()) continue;
            return names;
        }
        return names;
    }

    public Set getValues() {
        Set names = this.getNames();
        OrderedSet values = new OrderedSet();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            DPProperty dpp = this.get(key);
            values.add(dpp.getValue());
        }
        return values;
    }

    public Set getNames() {
        Set names = new OrderedSet();
        OrderedSet locked = new OrderedSet();
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPCollection dpc = (DPCollection)i.next();
            if (dpc.isRemove()) {
                names = this.clearElements(names, locked);
            } else if (!dpc.isDummy() && !dpc.isMergeLocked() && dpc.isReplace()) {
                names = this.clearElements(names, locked);
                names = ((XMLDPCollection)dpc).mergeNamesFromThis(names, locked);
            } else {
                names = ((XMLDPCollection)dpc).mergeNamesFromThis(names, locked);
            }
            if (!dpc.isLocked()) continue;
            return names;
        }
        if (!this.isDummy()) {
            if (this.isReplace()) {
                names = this.clearElements(names, locked);
            }
            names = this.mergeNamesFromThis(names, locked);
        }
        return names;
    }

    protected Element getMergedElement() {
        Map map = this.getCollectionValue();
        Element e = XMLDPCollection.createElement(this.getContext(), this.getRoot(), this.getDocument(), this.getTag(), this.getName(), map);
        return e;
    }

    public static Element createElement(DPContext dpc, DPRoot r, Document d, String n, Map m) {
        Element e = XMLDPCollection.createElement(dpc, r, d, "Collection", n, m);
        return e;
    }

    public static Element createElement(DPContext dpc, DPRoot r, Document d, String n, List l) {
        Element e = XMLDPCollection.createElement(dpc, r, d, "Collection", n, l);
        return e;
    }

    protected static Element createElement(DPContext dpc, DPRoot r, Document d, String tagName, String n, List l) {
        OrderedMap m = new OrderedMap();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            m.put(o.toString(), o);
        }
        return XMLDPCollection.createElement(dpc, r, d, tagName, n, m);
    }

    private static Element createElement(DPContext dpc, DPRoot r, Document d, String tagName, String n, Map m) {
        Element e = XMLDPObject.createElement(dpc, d, tagName, n);
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object o = m.get(name);
            DPProperty dpp = XMLDPFactory.getInstance().createProperty(dpc, r, d, name, o);
            XMLDPProperty xmlDPP = (XMLDPProperty)dpp;
            Element newElement = xmlDPP.getElement();
            e.appendChild(newElement);
        }
        XMLDPCollection.setDefaultsElement(e);
        return e;
    }

    public int getDefaultMergeType() {
        return XMLDPCollection.staticGetDefaultMergeType();
    }

    static int staticGetDefaultMergeType() {
        return 0;
    }

    public void setMergeDefaults() {
        XMLDPCollection.setMergeDefaultsElement(this.getElement());
    }

    public void setDefaults() {
        XMLDPCollection.setDefaultsElement(this.getElement());
    }

    static void setMergeDefaultsElement(Element e) {
        XMLDPObject.setMergeTypeElement(e, XMLDPCollection.staticGetDefaultMergeType());
        e.setAttribute("lock", "false");
    }

    static void setDefaultsElement(Element e) {
        XMLDPCollection.setMergeDefaultsElement(e);
        e.setAttribute("propagate", "true");
        e.setAttribute("advanced", "false");
    }

    Set clearElements(Set names, Set locked) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (locked.contains(name)) continue;
            i.remove();
        }
        return names;
    }

    public void appendChildProperty(StringBuffer b, int indent) {
        Iterator i = this.getNamesFromThis().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            DPProperty prop = this.getFromThis(name);
            prop.toXML(b, indent + 1);
        }
    }

    public void toXML(StringBuffer b, int indent) {
        if (this.isDummy()) {
            return;
        }
        this.indentBuffer(b, indent);
        this.appendStartTag(b);
        b.append(" name=\"").append(Encoder.XML_ENCODER.encode(this.getName())).append("\"");
        this.appendMergeAttr(b);
        this.appendLockAttr(b);
        this.appendAdvancedAttr(b);
        this.appendPropagateAttr(b);
        b.append(">\n");
        this.appendChildProperty(b, indent);
        this.indentBuffer(b, indent);
        this.appendEndTag(b);
    }
}

