/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPNode;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDPChannel
extends XMLDPNode
implements DPChannel,
DPTypes,
XMLDPTags {
    static long ccount = 0L;

    XMLDPChannel(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
        if (this.isPerfMessageEnabled()) {
            this.perfMessage("XMLDPChannel.XMLDPChannel(): ccount=" + ++ccount);
        }
    }

    XMLDPChannel(DPContext dpc, DPRoot r, Document d, String name, String providerName) {
        this(dpc, r, XMLDPChannel.createElement(dpc, d, name, providerName, XMLDPProperties.createElement(dpc, d)));
    }

    public void checkType() {
        if (!this.getElement().getTagName().equals(this.getTag()) && !this.getElement().getTagName().equals("Container")) {
            throw new DPError("XMLDPChannel.checkType(): invalid type tagName=" + this.getElement().getTagName());
        }
    }

    public String getTag() {
        return "Channel";
    }

    public short getType() {
        return 6;
    }

    public String getName() {
        StringBuffer name = new StringBuffer(super.getName());
        DPNode parentNode = this.getParentNode();
        if (parentNode != null && parentNode.getType() != 13) {
            name.insert(0, '/');
            name.insert(0, parentNode.getName());
        }
        return name.toString();
    }

    public String getChannelName() {
        return super.getName();
    }

    public String getProviderName() {
        String pn;
        String providerName = null;
        boolean locked = false;
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPChannel dpc = (DPChannel)i.next();
            String pn2 = dpc.getProviderName();
            if (pn2 != null && pn2.length() > 0) {
                providerName = pn2;
            }
            if (!dpc.isLocked()) continue;
            locked = true;
            if (!dpc.isRemove()) break;
            providerName = null;
            break;
        }
        if (!locked && !this.isDummy() && (pn = this.getProviderNameFromThis()) != null && pn.length() > 0) {
            providerName = pn;
        }
        return providerName;
    }

    protected String getProviderNameFromThis() {
        return this.getElement().getAttribute("provider");
    }

    public void setProviderName(String providerName) {
        this.getElement().setAttribute("provider", providerName);
        this.setDirty(true);
    }

    public DPProvider getProvider() {
        String name = this.getProviderName();
        return this.getProvider(name);
    }

    public DPProvider getProvider(String name) {
        DPRoot root = this.getRoot();
        return root.getProvider(name);
    }

    public DPChannel getChannel(String name) {
        if (this.getType() != 5) {
            return null;
        }
        return super.getChannel(name);
    }

    public DPChannel copy(DPRoot dpr, boolean deep) {
        return this.copy(dpr, deep, null);
    }

    public DPChannel copy(DPRoot dpr, boolean deep, String newName) {
        XMLDPRoot xmldpr = (XMLDPRoot)dpr;
        Document ownerDocument = xmldpr.getElement().getOwnerDocument();
        Element copyElement = (Element)ownerDocument.importNode(this.getElement(), deep);
        if (!deep) {
            copyElement.appendChild(ownerDocument.importNode(XMLDPObject.getChildElement(this.getElement(), "Properties", null), false));
        }
        if (newName != null) {
            XMLDPObject.setName(copyElement, newName);
        }
        return XMLDPFactory.getInstance().getChannel(this.getContext(), dpr, copyElement);
    }

    DPChannel createDummy(DPRoot dpr) {
        DPChannel dpc = this.copy(dpr, false);
        dpc.setDummy(true);
        dpc.setDefaults();
        return dpc;
    }

    protected Element getMergedElement() {
        XMLDPProperties xp = (XMLDPProperties)this.getProperties();
        Element e = XMLDPChannel.createElement(this.getContext(), this.getDocument(), super.getName(), this.getProviderName(), xp.getMergedElement());
        return e;
    }

    static Element createElement(DPContext dpc, Document d, String name, String providerName, Element propertiesElement) {
        Element e = XMLDPObject.createElement(dpc, d, "Channel", name);
        e.setAttribute("provider", providerName);
        e.appendChild(propertiesElement);
        XMLDPPropertyHolder.setDefaultsElement(e);
        return e;
    }

    protected void appendProviderAttr(StringBuffer b) {
        String toSet = null;
        String fromMergers = null;
        boolean locked = false;
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPChannel dpc = (DPChannel)i.next();
            fromMergers = dpc.getProviderName();
            if (!dpc.isLocked()) continue;
            locked = true;
            if (!dpc.isRemove()) break;
            fromMergers = null;
            break;
        }
        if (locked) {
            toSet = fromMergers;
        } else {
            String fromThis = this.getProviderNameFromThis();
            if (fromMergers == null) {
                toSet = fromThis;
            } else if (fromThis != null && fromThis.length() > 0 && !fromThis.equals(fromMergers)) {
                toSet = fromThis;
            }
        }
        if (toSet != null && toSet.length() > 0) {
            b.append(" provider=\"");
            b.append(toSet);
            b.append("\"");
        }
    }

    public void toXML(StringBuffer b, int indent) {
        if (this.isDummy()) {
            return;
        }
        this.indentBuffer(b, indent);
        this.appendStartTag(b);
        b.append(" name=\"").append(this.getChannelName()).append("\"");
        this.appendProviderAttr(b);
        this.appendMergeAttr(b);
        this.appendLockAttr(b);
        this.appendAdvancedAttr(b);
        b.append(">\n");
        this.getPropertiesFromThis().toXML(b, indent + 1);
        this.indentBuffer(b, indent);
        this.appendEndTag(b);
    }
}

