/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFile;
import com.sun.portal.desktop.deployment.ParFileBuilder;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParXferPPF;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class ParManifest
extends Manifest {
    public static final int CLASSFILE = 1;
    public static final int DPFILE = 2;
    public static final int PBFILE = 3;
    public static final int STATFILE = 4;
    private String m_CRoot;
    private String m_PBFRoot;
    private String m_DPRoot;
    private String m_SRoot;
    private static final int VERSION = 1;
    private static final String INCLUDE_DELIM = ",";
    private static final String INCLUDE_OPEN = "(";
    private static final String INCLUDE_CLOSE = ")";
    private static final String KEY_PFX = "PS-";
    private static final String MAKEY_VERSION = "PS-Version";
    private static final String MAKEY_PBFILEROOT = "PS-PBFileRoot";
    private static final String MAKEY_DPROOT = "PS-DPRoot";
    private static final String MAKEY_CLASSROOT = "PS-ClassRoot";
    private static final String MAKEY_STATROOT = "PS-StaticRoot";
    private static final String MAKEY_DEFAULTENTRY = "PS-DefaultEntry";
    private static final String EAKEY_NAME = "PS-EntryName";
    private static final String EAKEY_INCLUDE = "PS-Include";
    private static final String EAKEY_AUTOEXTRACT = "PS-AutoExtract";

    public ParManifest(String classroot, String dproot, String pbfileroot, String sroot) {
        this.m_CRoot = classroot;
        this.m_DPRoot = dproot;
        this.m_PBFRoot = pbfileroot;
        this.m_SRoot = sroot;
        Attributes ma = this.getMainAttributes();
        ma.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        ma.putValue(MAKEY_VERSION, Integer.toString(1));
        if (classroot != null) {
            ma.putValue(MAKEY_CLASSROOT, classroot);
        }
        if (dproot != null) {
            ma.putValue(MAKEY_DPROOT, dproot);
        }
        if (pbfileroot != null) {
            ma.putValue(MAKEY_PBFILEROOT, pbfileroot);
        }
        if (pbfileroot != null) {
            ma.putValue(MAKEY_STATROOT, sroot);
        }
    }

    public ParManifest() {
        this(null, "dp", "pbfiles", "static");
    }

    private ParManifest(Manifest man) {
        super(man);
        Attributes ma = this.getMainAttributes();
        this.m_CRoot = ma.getValue(MAKEY_CLASSROOT);
        this.m_DPRoot = ma.getValue(MAKEY_DPROOT);
        this.m_PBFRoot = ma.getValue(MAKEY_PBFILEROOT);
        this.m_SRoot = ma.getValue(MAKEY_STATROOT);
    }

    public static ParManifest makeManifest(Manifest man) throws ParFileException {
        Attributes ma = man.getMainAttributes();
        String ver = ma.getValue(MAKEY_VERSION);
        if (ver == null) {
            throw new ParFileException("errorManifestNoVersion");
        }
        try {
            if (Integer.parseInt(ver) != 1) {
                throw new ParFileException("errorManifestBadVersion");
            }
        }
        catch (Exception ex) {
            throw new ParFileException("errorManifestBadVersion");
        }
        return new ParManifest(man);
    }

    public ZipEntry getClassZip(String pkg, String classname) {
        return new ZipEntry(this.getClassPath(pkg, classname));
    }

    public ZipEntry getClassZip(String fullclassname) {
        return new ZipEntry(this.getClassPath(fullclassname));
    }

    public ZipEntry getDPZip(String name) throws ParFileException {
        return new ZipEntry(this.getDPPath(name, false));
    }

    public ZipEntry getPBFileZip(String prop, String path) {
        return new ZipEntry(this.getPBFPath(prop, path));
    }

    public ZipEntry getStatZip(String path) {
        return new ZipEntry(this.getStaticPath(path));
    }

    public void addDPEntry(String name) throws ParFileException {
        this.getDPPath(name, true);
    }

    public void addDPEntryIncludeClass(String name, String pkg, String classname, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getClassPath(pkg, classname), types);
    }

    public void addDPEntryIncludeClass(String name, String fullclassname, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getClassPath(fullclassname), types);
    }

    public void addDPEntryIncludePBFile(String name, String prop, String path, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getPBFPath(prop, path), types);
    }

    public void addDPEntryIncludeStat(String name, String path, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getStaticPath(path), types);
    }

    public void addDPEntryAutoExtract(String name, ExtractOp op) throws ParFileException {
        Attributes a = this.getAttributes(this.getDPPath(name, false));
        op = new ExtractOp(op);
        op.setEntryName(name);
        a.putValue(EAKEY_AUTOEXTRACT, op.toArg());
    }

    public Vector getDPEntryList() throws ParFileException {
        Vector<String> v = new Vector<String>();
        Iterator<String> it = this.getEntries().keySet().iterator();
        while (it.hasNext()) {
            v.add(this.getNameFromDPPath(it.next()));
        }
        return v;
    }

    public Vector getDPEntryIncludeList(String name, int types) throws ParFileException {
        Vector v = new Vector();
        this.getDPEntryIncludeList(name, types, v, null);
        return v;
    }

    public void getDPEntryIncludeList(String name, int types, Vector v, Vector vt) throws ParFileException {
        String list;
        v.clear();
        if (vt != null) {
            vt.clear();
        }
        if ((list = this.getAttributes(this.getDPPath(name, false)).getValue(EAKEY_INCLUDE)) == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(list, INCLUDE_DELIM);
        while (tok.hasMoreTokens()) {
            StringTokenizer subtok = new StringTokenizer(tok.nextToken(), ")(");
            if (!subtok.hasMoreTokens()) continue;
            String fn = subtok.nextToken();
            if (!subtok.hasMoreTokens()) {
                v.add(fn);
                if (vt == null) continue;
                vt.add(new Integer(3));
                continue;
            }
            try {
                int ftyp = Integer.parseInt(subtok.nextToken());
                if ((ftyp & types) == 0) continue;
                v.add(fn);
                if (vt == null) continue;
                vt.add(new Integer(ftyp));
            }
            catch (Exception ex) {
                throw new ParFileException("errorManifestInclusion");
            }
        }
    }

    public ExtractOp getDPEntryAutoExtract(String name) throws ParFileException {
        String opstr = this.getAttributes(this.getDPPath(name, false)).getValue(EAKEY_AUTOEXTRACT);
        if (opstr == null) {
            return null;
        }
        return ExtractOp.makeOpFromArgument(opstr);
    }

    public int getPathRootType(String path) throws ParFileException {
        return this.getPathRootType(path, null);
    }

    public String getPropertyFromPBFPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 3) {
            throw new ParFileException("errorManifestPathType");
        }
        StringTokenizer tok = new StringTokenizer(rest.toString(), "/");
        if (!tok.hasMoreTokens()) {
            throw new ParFileException("errorManifestPathSyntax");
        }
        return tok.nextToken();
    }

    public String getPathFromPBFPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 3) {
            throw new ParFileException("errorManifestPathType");
        }
        StringTokenizer tok = new StringTokenizer(rest.toString(), "/");
        if (!tok.hasMoreTokens()) {
            throw new ParFileException("errorManifestPathSyntax");
        }
        tok.nextToken();
        StringBuffer buf = new StringBuffer();
        String pfx = "";
        while (tok.hasMoreTokens()) {
            buf.append(pfx);
            buf.append(tok.nextToken());
            pfx = "/";
        }
        return buf.toString();
    }

    public String getFullFromClassPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 1) {
            throw new ParFileException("errorManifestPathType");
        }
        StringBuffer cb = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(rest.toString(), "/");
        String pfx = "";
        while (tok.hasMoreTokens()) {
            cb.append(pfx);
            String part = tok.nextToken();
            int dotidx = part.indexOf(".");
            if (dotidx > 0) {
                part = part.substring(0, dotidx);
            }
            cb.append(part);
            pfx = ".";
        }
        return cb.toString();
    }

    public String getPathFromStaticPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 4) {
            throw new ParFileException("errorManifestPathType");
        }
        return rest.toString();
    }

    public void transferFileEntries(ParFileBuilder pfb, ParFile oldpf) throws ParFileException {
        Iterator<String> it = this.getEntries().keySet().iterator();
        while (it.hasNext()) {
            String ekey = it.next();
            String ename = this.getNameFromDPPath(ekey);
            ExtractOp op = this.getDPEntryAutoExtract(ename);
            Vector vif = new Vector();
            Vector vift = new Vector();
            this.getDPEntryIncludeList(ename, 3, vif, vift);
            Vector<ParXferPPF> vppf = new Vector<ParXferPPF>();
            int i = 0;
            while (i < vif.size()) {
                String fn = (String)vif.elementAt(i);
                Integer fntyp = (Integer)vift.elementAt(i);
                vppf.add(new ParXferPPF(oldpf, fn, fntyp));
                ++i;
            }
            pfb.addDPEntry(this.getDPDoc(ekey, oldpf), vppf, op);
        }
    }

    public void describe(PrintStream out, ParFile pf) throws ParFileException {
        out.println(Par.getLocalizedString("parDescClassRoot") + ": " + (this.m_CRoot == null ? "/" : "/" + this.m_CRoot));
        out.println(Par.getLocalizedString("parDescPBRoot") + ": " + (this.m_PBFRoot == null ? "/" : "/" + this.m_PBFRoot));
        out.println(Par.getLocalizedString("parDescDPRoot") + ": " + (this.m_DPRoot == null ? "/" : "/" + this.m_DPRoot));
        out.println(Par.getLocalizedString("parDescStaticRoot") + ": " + (this.m_SRoot == null ? "/" : "/" + this.m_SRoot));
        Iterator<String> it = this.getEntries().keySet().iterator();
        while (it.hasNext()) {
            String ekey = it.next();
            String ename = this.getNameFromDPPath(ekey);
            out.println("");
            out.println(Par.getLocalizedString("parDescEntry") + ": " + ename);
            ExtractOp op = this.getDPEntryAutoExtract(ename);
            if (op != null) {
                out.println(Par.getLocalizedString("parDescAutoExtract") + ": " + op.toArg());
            }
            Par.describeDPDoc(this.getDPDoc(ekey, pf), out);
            Vector v = new Vector();
            Vector vt = new Vector();
            this.getDPEntryIncludeList(ename, 3, v, vt);
            int i = 0;
            while (i < v.size()) {
                String fn = (String)v.elementAt(i);
                int ty = (Integer)vt.elementAt(i);
                StringBuffer bf = new StringBuffer();
                bf.append(Par.getLocalizedString("parDescIncludes") + ": ");
                this.describeFile(bf, fn);
                bf.append(" (");
                ExtractOp.describeTypes(bf, ty);
                bf.append(INCLUDE_CLOSE);
                out.println(bf.toString());
                ++i;
            }
        }
    }

    private Document getDPDoc(String path, ParFile pf) throws ParFileException {
        try {
            InputStream is = pf.getInputStream(pf.getEntry(path));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(is);
        }
        catch (Exception ex) {
            throw new ParFileException("errorDescribingDPDocument", ex);
        }
    }

    private void describeFile(StringBuffer bf, String fn) throws ParFileException {
        switch (this.getPathRootType(fn)) {
            case 1: {
                Object[] tokc = new Object[]{fn};
                bf.append(Par.getLocalizedString("parDescClassFile", tokc));
                break;
            }
            case 3: {
                Object[] tokpb = new Object[]{this.getPropertyFromPBFPath(fn), this.getPathFromPBFPath(fn)};
                bf.append(Par.getLocalizedString("parDescPBFile", tokpb));
                break;
            }
            case 4: {
                Object[] toks = new Object[]{fn};
                bf.append(Par.getLocalizedString("parDescStaticFile", toks));
                break;
            }
            default: {
                throw new ParFileException("errorManifestPathType");
            }
        }
    }

    private String getNameFromDPPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 2) {
            throw new ParFileException("errorManifestPathType");
        }
        String rstr = rest.toString();
        int idx = rstr.lastIndexOf(46);
        if (idx <= 0) {
            throw new ParFileException("Empty DP path");
        }
        return rstr.substring(0, idx);
    }

    private String getDPPath(String name, boolean create) throws ParFileException {
        if (name == null) {
            if (create) {
                throw new ParFileException("errorNullDPEntry");
            }
            Attributes ma = this.getMainAttributes();
            name = ma.getValue(MAKEY_DEFAULTENTRY);
            if (name == null) {
                throw new ParFileException("errorNullDPEntry");
            }
        }
        StringBuffer buf = new StringBuffer();
        if (this.m_DPRoot != null) {
            buf.append(this.m_DPRoot);
            buf.append("/");
        }
        buf.append(name);
        buf.append(".xml");
        String key = buf.toString();
        if (this.getAttributes(key) == null) {
            if (!create) {
                throw new ParFileException("errorBadDPEntry");
            }
            Attributes ea = new Attributes();
            ea.putValue(EAKEY_NAME, name);
            this.getEntries().put(key, ea);
            Attributes ma = this.getMainAttributes();
            if (ma.getValue(MAKEY_DEFAULTENTRY) == null) {
                ma.putValue(MAKEY_DEFAULTENTRY, name);
            }
            return key;
        }
        if (create) {
            throw new ParFileException("errorBadDPEntry");
        }
        return key;
    }

    private String getClassPath(String fullclassname) {
        String cfile = Par.classToFile(fullclassname);
        if (this.m_CRoot == null) {
            return cfile;
        }
        return this.m_CRoot + "/" + cfile;
    }

    private String getClassPath(String pkg, String classname) {
        String cfile = Par.classToFile(pkg, classname);
        if (this.m_CRoot == null) {
            return cfile;
        }
        return this.m_CRoot + "/" + cfile;
    }

    private String getPBFPath(String prop, String path) {
        StringBuffer buf = new StringBuffer();
        if (this.m_PBFRoot != null) {
            buf.append(this.m_PBFRoot);
            buf.append("/");
        }
        buf.append(prop);
        buf.append("/");
        buf.append(path);
        return buf.toString();
    }

    private String getStaticPath(String path) {
        StringBuffer buf = new StringBuffer();
        if (this.m_SRoot != null) {
            buf.append(this.m_SRoot);
            buf.append("/");
        }
        buf.append(path);
        return buf.toString();
    }

    private void addDPEntryInclude(String name, String path, int types) throws ParFileException {
        Attributes a = this.getAttributes(this.getDPPath(name, false));
        String list = a.getValue(EAKEY_INCLUDE);
        StringBuffer buf = new StringBuffer();
        String pfx = "";
        if (list != null) {
            StringTokenizer toks = new StringTokenizer(list, INCLUDE_DELIM);
            while (toks.hasMoreTokens()) {
                String p = toks.nextToken();
                if (p.startsWith(path)) continue;
                buf.append(pfx);
                pfx = INCLUDE_DELIM;
                buf.append(p);
            }
        }
        buf.append(pfx);
        buf.append(path);
        buf.append(INCLUDE_OPEN);
        buf.append(types);
        buf.append(INCLUDE_CLOSE);
        a.putValue(EAKEY_INCLUDE, buf.toString());
    }

    private int getPathRootType(String path, StringBuffer rem) throws ParFileException {
        StringTokenizer tok = new StringTokenizer(path, "/");
        if (!tok.hasMoreTokens()) {
            throw new ParFileException("errorManifestPathSyntax");
        }
        String root = tok.nextToken();
        if (rem != null) {
            rem.setLength(0);
            String pfx = "";
            while (tok.hasMoreTokens()) {
                rem.append(pfx);
                rem.append(tok.nextToken());
                pfx = "/";
            }
        }
        if (this.m_CRoot != null && this.m_CRoot.equals(root)) {
            return 1;
        }
        if (this.m_DPRoot != null && this.m_DPRoot.equals(root)) {
            return 2;
        }
        if (this.m_PBFRoot != null && this.m_PBFRoot.equals(root)) {
            return 3;
        }
        if (this.m_SRoot != null && this.m_SRoot.equals(root)) {
            return 4;
        }
        if (rem != null) {
            rem.setLength(0);
            rem.append(path);
        }
        if (this.m_CRoot == null) {
            return 1;
        }
        if (this.m_DPRoot == null) {
            return 2;
        }
        if (this.m_PBFRoot == null) {
            return 3;
        }
        if (this.m_SRoot == null) {
            return 3;
        }
        throw new ParFileException("errorManifestPathSyntax");
    }
}

