/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.DPBasedContext;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParExtractionContext;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPReference;
import com.sun.portal.desktop.dp.DPReferenceList;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DPBasedExCtx
extends DPBasedContext
implements ParExtractionContext {
    private boolean m_Overwrite = false;
    private boolean m_Verbose = false;
    private PrintStream m_Out = null;
    private ExtractOp m_Op = null;
    private DPRootSpecifier m_DPRSpec;
    private String m_PathXFrom = null;
    private String m_PathXTo = null;
    private String m_PropFileXFrom = null;
    private String m_PropFileXTo = null;

    public DPBasedExCtx(DPRootSpecifier droot, boolean overwrite, boolean verbose, PrintStream out, String ss) {
        this.m_DPRSpec = droot;
        this.m_Overwrite = overwrite;
        this.m_Verbose = verbose;
        this.m_Out = out;
        this.setStaticSub(ss);
    }

    public void putParEntryXMLFile(InputStream in, int types) throws ParFileException {
        Object[] tok;
        String pvname;
        if (!this.deployDynamic()) {
            return;
        }
        Document doc = Par.streamToDom(in);
        DPRoot dr = this.m_DPRSpec.getRoot();
        String objname = pvname = Par.getProviderNameFromChannel(doc);
        this.m_PathXFrom = null;
        this.m_PathXTo = null;
        this.m_PropFileXFrom = null;
        this.m_PropFileXTo = null;
        if ((types & 1) != 0) {
            pvname = this.m_Op.getProviderName();
            if (pvname == null) {
                pvname = Par.getProviderName(doc);
            } else {
                this.m_PropFileXFrom = Par.getProviderName(doc);
                this.m_PropFileXTo = pvname;
            }
            objname = pvname;
            String cls = Par.getProviderClass(doc);
            int providerVersion = Par.getProviderVersion(doc);
            try {
                if (dr.getProvider(pvname) != null) {
                    if (!this.m_Overwrite) {
                        Object[] tok2 = new Object[]{pvname};
                        throw new ParFileException("errorProviderExists", tok2);
                    }
                    dr.removeProvider(pvname);
                }
                tok = new Object[]{"provider", pvname + ", " + cls};
                this.message(Par.getLocalizedString("msgImportAdd", tok));
                DPProvider pr = this.m_DPRSpec.createProvider(pvname, cls, providerVersion);
                pr = dr.addProvider(pr);
                this.setProperties(pr, Par.getProviderProperties(doc));
            }
            catch (Exception ex) {
                throw new ParFileException("errorImporting", ex);
            }
        }
        if ((types & 2) != 0) {
            try {
                Object[] tok3;
                DPNode container = dr;
                String containerName = this.m_Op.getChannelContainer();
                if (containerName != null && (container = dr.getChannel(containerName)) == null) {
                    tok = new Object[]{containerName};
                    throw new ParFileException("errorNoContainer", tok);
                }
                String channelName = this.m_Op.getChannelName();
                if (channelName == null) {
                    channelName = Par.getChannelName(doc);
                } else {
                    this.m_PathXFrom = Par.getChannelName(doc);
                    this.m_PathXTo = channelName;
                }
                String string = objname = containerName != null ? containerName + '/' + channelName : channelName;
                if (dr.getChannel(objname) != null) {
                    if (!this.m_Overwrite) {
                        tok3 = new Object[]{objname};
                        throw new ParFileException("errorChannelExists", tok3);
                    }
                    dr.removeChannel(objname);
                }
                tok3 = new Object[]{"channel", objname + ", " + pvname};
                this.message(Par.getLocalizedString("msgImportAdd", tok3));
                DPChannel chan = this.m_DPRSpec.createChannel(channelName, pvname);
                chan = container.addChannel(chan);
                this.setProperties(chan, Par.getChannelProperties(doc));
                String aname = this.m_Op.getAvailContainer();
                if (aname != null) {
                    DPChannel avchan = dr.getChannel(aname);
                    this.addReference(((DPContainerChannel)avchan).getAvailable(), objname);
                    if (this.m_Op.getMakeSelected()) {
                        this.addReference(((DPContainerChannel)avchan).getSelected(), objname);
                    }
                }
            }
            catch (Exception ex) {
                throw new ParFileException("errorImporting", ex);
            }
        }
        this.m_DPRSpec.flush();
        this.setPropertyHolder(dr, objname, types);
    }

    public void putClassFile(String fullname, InputStream in) throws ParFileException {
        if (!this.deployDynamic()) {
            return;
        }
        String cdir = (String)this.getClassPath().elementAt(0);
        this.streamOut(cdir + "/" + Par.classToFile(fullname), in);
    }

    public void initializeForOperation(ExtractOp op) throws ParFileException {
        Object[] tok = new Object[]{op.toArg()};
        this.message(Par.getLocalizedString("msgImportInitOp", tok));
        this.m_DPRSpec.setDN(op.getDPNode());
        this.m_Op = op;
    }

    public void putPropLocFile(String rootproperty, String path, InputStream in) throws ParFileException {
        if (this.deployDynamic()) {
            this.streamOut(this.getPBFProperty(rootproperty, false) + "/" + this.translatePath(path), in);
        }
    }

    public void putStaticFile(String path, InputStream in) throws ParFileException {
        if (this.deployStatic()) {
            int idx = 0;
            while (idx < this.getStaticDirectoryCount()) {
                String outpath = this.getStaticDirectory() + "/" + this.translatePath(path);
                this.streamOut(outpath, in);
                try {
                    in = new FileInputStream(outpath);
                }
                catch (Exception ex) {
                    throw new ParFileException("errorImporting", ex);
                }
                ++idx;
            }
        }
    }

    public void terminateOperation(boolean success) throws ParFileException {
        if (success) {
            if (this.deployStatic()) {
                // empty if block
            }
            this.message(Par.getLocalizedString("msgImportOpComplete"));
        } else {
            this.message(Par.getLocalizedString("msgImportOpFailed"));
        }
        this.m_Op = null;
    }

    private String translatePath(String path) {
        if (this.m_PathXFrom == null && this.m_PropFileXFrom == null) {
            return path;
        }
        StringBuffer buf = new StringBuffer();
        StringTokenizer toks = new StringTokenizer(path, "/");
        String pfx = "";
        while (toks.hasMoreTokens()) {
            String comp = toks.nextToken();
            if (this.m_PathXFrom != null && comp.equals(this.m_PathXFrom)) {
                comp = this.m_PathXTo;
            }
            if (this.m_PropFileXFrom != null && comp.endsWith(".properties") && comp.startsWith(this.m_PropFileXFrom)) {
                comp = this.m_PropFileXTo + comp.substring(this.m_PropFileXFrom.length());
            }
            buf.append(pfx);
            buf.append(comp);
            pfx = "/";
        }
        return buf.toString();
    }

    private void setProperties(DPPropertyHolder nd, Element props) throws ParFileException {
        XMLDPObject xnd = (XMLDPObject)((Object)nd);
        Element elt = xnd.getElement();
        Par.replaceProps(elt, props);
    }

    private void addReference(DPReferenceList rl, String nm) throws ParFileException {
        try {
            DPReference ref = this.m_DPRSpec.createReference(nm);
            rl.add(ref);
        }
        catch (Exception ex) {
            throw new ParFileException("errorImporting", ex);
        }
    }

    private void message(String mess) {
        if (this.m_Verbose) {
            this.m_Out.println(mess);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void streamOut(String filename, InputStream in) throws ParFileException {
        try {
            int len;
            byte[] buf = new byte[4000];
            File f = new File(filename);
            f.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(f);
            while ((len = in.read(buf)) > 0) {
                void var6_7;
                os.write(buf, 0, (int)var6_7);
            }
            os.close();
        }
        catch (Exception ex) {
            throw new ParFileException("errorImporting", ex);
        }
    }

    public void putJarFile(String path, InputStream in) throws ParFileException {
    }
}

