/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.common.pool.PartitionObject;
import com.sun.common.util.LockWithMemory;
import com.sun.portal.desktop.DesktopThreadLocalManager;
import com.sun.portal.desktop.PerfData;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.Monitor;
import com.sun.portal.desktop.context.ProviderCallerPool;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.context.ContainerProviderContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReusableProviderCaller
extends Thread
implements PartitionObject {
    private ContainerProviderContext providerContext = null;
    private Provider provider = null;
    private StringBuffer content = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private HttpServletRequest origRequest = null;
    private HttpServletResponse origResponse = null;
    private String parent = null;
    private Monitor monitor = null;
    private boolean initialized = false;
    private boolean running = true;
    private LockWithMemory begin = new LockWithMemory();
    private LockWithMemory end = new LockWithMemory();
    private boolean executing = false;
    private ProviderCallerPool pool = null;
    private DesktopAppContext desktopAppContext = null;
    private DesktopContext desktopContext = null;
    private ServletConfig servletConfig = null;
    private PerfData perfData = null;
    private int partition = 0;

    public ReusableProviderCaller() {
        this.setDaemon(true);
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public int getPartition() {
        return this.partition;
    }

    void init(DesktopAppContext dac, DesktopContext dc, ContainerProviderContext cpc, Provider p, String parent, Monitor m, HttpServletRequest req, HttpServletResponse res, HttpServletRequest origReq, HttpServletResponse origRes, ServletConfig servletConfig, PerfData perfData, ProviderCallerPool callerPool) {
        this.providerContext = cpc;
        this.provider = p;
        this.parent = parent;
        this.monitor = m;
        this.request = req;
        this.response = res;
        this.origRequest = origReq;
        this.origResponse = origRes;
        this.desktopAppContext = dac;
        this.desktopContext = dc;
        this.servletConfig = servletConfig;
        this.perfData = perfData;
        this.pool = callerPool;
        this.initialized = true;
    }

    void clear() {
        this.initialized = false;
        this.content = null;
        this.providerContext = null;
        this.provider = null;
        this.parent = null;
        this.monitor = null;
        this.request = null;
        this.response = null;
        this.origRequest = null;
        this.origResponse = null;
        this.desktopAppContext = null;
        this.desktopContext = null;
        this.servletConfig = null;
        this.perfData = null;
    }

    public void execute() {
        this.begin.signal();
        this.executing = true;
    }

    void finish() {
        this.running = false;
        this.begin.signal();
    }

    public Provider getProvider() {
        return this.provider;
    }

    public StringBuffer getContent() {
        return this.content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                Object var7_8;
                block19: {
                    block18: {
                        if (!this.running) {
                            return;
                        }
                        try {
                            try {
                                try {
                                    this.begin.waitFor();
                                }
                                catch (InterruptedException ie) {
                                    var7_8 = null;
                                    DesktopThreadLocalManager.release();
                                    continue;
                                }
                                if (!this.running) {
                                    var7_8 = null;
                                    break block18;
                                }
                                String name = null;
                                DesktopThreadLocalManager.init(this.desktopAppContext, this.request, this.response, this.origRequest, this.origResponse, this.servletConfig, this.perfData);
                                DesktopThreadLocalManager.init(this.desktopContext, this.providerContext);
                                DesktopThreadLocalManager.init(this.parent);
                                try {
                                    if (!this.initialized) {
                                        throw new ContextError("ProviderCaller.run(): attmpted un-initialized loop!");
                                    }
                                    ProviderContextThreadLocalizer.set(this.providerContext);
                                    name = this.provider.getName();
                                    long start = System.currentTimeMillis();
                                    this.content = this.provider.getContent(this.request, this.response);
                                    if (this.provider.getRefreshTime() > 0L) {
                                        this.providerContext.putCachedContent(name, this.content);
                                    }
                                    long now = System.currentTimeMillis();
                                    if (this.desktopAppContext.isPerfMessageEnabled()) {
                                        this.desktopAppContext.perfMessage("ProviderCaller.run(): to get content for channel=" + name + ", elapsed=" + (now - start));
                                    }
                                    if (this.desktopAppContext.isPasContextActivated()) {
                                        this.desktopAppContext.logProcessTime("channel", "get_content_from_provider", name, now - start);
                                    }
                                    if (this.content == null) {
                                        throw new ContextError("couldn't fetch content");
                                    }
                                    this.monitor.put(name, this.content);
                                }
                                catch (Throwable e) {
                                    this.desktopAppContext.debugError("ProviderCaller.run(): exception thrown from " + name, e);
                                    this.monitor.put(name, this.content);
                                }
                                this.end.signal();
                                this.executing = false;
                                this.pool.releaseCaller(this);
                                break block19;
                            }
                            catch (Throwable t1) {
                                throw new ContextError("ProviderCaller.run()", t1);
                            }
                        }
                        catch (Throwable throwable) {
                            var7_8 = null;
                            DesktopThreadLocalManager.release();
                            throw throwable;
                        }
                    }
                    DesktopThreadLocalManager.release();
                    return;
                }
                var7_8 = null;
                DesktopThreadLocalManager.release();
            }
        }
        catch (Throwable t2) {
            throw new ContextError("ProviderCaller.run()", t2);
        }
    }
}

