/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ClientContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

class DSAMEClientContext
implements ClientContext {
    protected AMClientDetector cd = null;
    private static final String CLIENT_OBJECT = "clientObject.";
    private static Map AUTHLESS_STATES = null;
    private static DesktopAppContext dac = null;

    public void init() {
        this.cd = new AMClientDetector();
    }

    private Client getClient(String clientType) {
        String clientObjectKey = CLIENT_OBJECT + clientType;
        Client client = (Client)ROC.getObject(clientObjectKey);
        if (client == null) {
            try {
                client = Client.getInstance((String)clientType);
            }
            catch (ClientException c) {
                throw new ContextError("DSAMEDPContext.init(): can not get client instance", c);
            }
            ROC.setObject(clientObjectKey, client);
        }
        return client;
    }

    public String getContentType(String clientType) {
        return this.getClientTypeProperty(clientType, "contentType");
    }

    public String getClientPath(String clientType) {
        return this.getClientTypeProperty(clientType, "filePath");
    }

    public String getClientType(HttpServletRequest req) {
        return this.cd.getClientType(req);
    }

    public String getDefaultClientType() {
        Client cli = Client.getDefaultInstance();
        return cli.getClientType();
    }

    public String getClientTypeProperty(String clientType, String key) {
        Client client = this.getClient(clientType);
        return client.getProperty(key);
    }

    public Set getClientTypeProperties(String clientType, String key) {
        Client client = this.getClient(clientType);
        Set properties = client.getProperties(key);
        return properties;
    }

    public String getCharset(String clientType, Locale locale) {
        Client client = this.getClient(clientType);
        return client.getCharset(locale);
    }

    public boolean getCookieSupport(String clientType) {
        Client client = this.getClient(clientType);
        String cookieSupport = client.getProperty("cookieSupport");
        return cookieSupport != null && cookieSupport.equalsIgnoreCase("true");
    }

    private short getDefaultAuthlessState(String clientType) {
        boolean genericHTML = false;
        String property = this.getClientTypeProperty(clientType, "genericHTML");
        if (property != null) {
            genericHTML = property.equals("true");
        } else if (clientType.equals("genericHTML")) {
            genericHTML = true;
        }
        if (genericHTML) {
            return 2;
        }
        return 3;
    }

    public short getAuthlessState(String clientType) {
        Client client = this.getClient(clientType);
        String authlessState = client.getProperty("authlessState");
        if (authlessState == null || authlessState.length() == 0) {
            return this.getDefaultAuthlessState(clientType);
        }
        Short as = (Short)AUTHLESS_STATES.get(authlessState);
        if (as == null) {
            return this.getDefaultAuthlessState(clientType);
        }
        return as;
    }

    public String getEncoderClassName(String clientType) {
        Client client = this.getClient(clientType);
        String cn = client.getProperty("encoderClassName");
        if (cn != null && cn.length() != 0) {
            return cn;
        }
        return "com.sun.portal.desktop.encode.HTMLEncoder";
    }

    static {
        AUTHLESS_STATES = new HashMap();
        AUTHLESS_STATES.put("none", new Short(3));
        AUTHLESS_STATES.put("server", new Short(1));
        AUTHLESS_STATES.put("client", new Short(2));
        dac = DesktopAppContextThreadLocalizer.get();
    }
}

