/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.pool;

import com.sun.common.pool.PartitionObject;
import com.sun.common.pool.ThreadPool;
import com.sun.common.util.LockWithMemory;

public class ReusableThread
implements Runnable,
PartitionObject {
    private ThreadPool _ownerPool;
    private Thread _thread;
    private boolean _running = true;
    private LockWithMemory _begin = new LockWithMemory();
    private LockWithMemory _end = new LockWithMemory();
    private Runnable _runnable = null;
    private boolean _executing = false;
    private int _partition;
    private boolean _reuse = true;

    ReusableThread(ThreadPool ownerPool) {
        this._ownerPool = ownerPool;
        this._thread = new Thread(this);
        this._thread.setDaemon(true);
        this._thread.start();
    }

    void setReuseThread(boolean b) {
        this._reuse = b;
    }

    public void setPartition(int partition) {
        this._partition = partition;
    }

    public int getPartition() {
        return this._partition;
    }

    void setRunnable(Runnable runnable) {
        this._runnable = runnable;
        this._executing = false;
    }

    public void start() {
        this._begin.signal();
        this._executing = true;
    }

    public void join() {
        this.join(0L, 0);
    }

    public void join(long timeout) {
        this.join(timeout, 0);
    }

    public void join(long timeout, int nanos) {
        if (this._runnable != null) {
            try {
                this._end.waitFor(timeout, nanos);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public boolean isAlive() {
        return this._executing;
    }

    void finish() {
        this._running = false;
        this._begin.signal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (!this._running) {
                    return;
                }
                try {
                    this._begin.waitFor();
                    try {
                        if (this._runnable != null) {
                            this._runnable.run();
                        }
                    }
                    catch (Throwable ex1) {
                        // empty catch block
                    }
                    this._running = this._reuse;
                    this._end.signal();
                    this._executing = false;
                    this._ownerPool.releaseThread(this);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

