/*
 * Decompiled with CFR 0.152.
 */
package migration_is60.modules.srap.netfile;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import migration_is60.modules.srap.netfile.NetfileOrgData;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFRecord;

public class NetfileMigrate {
    private String inputFile;
    private String outputFile;
    static final String SERVICE_NAME_DELIM = "ou=sunPortalNetFileService,ou=services,";
    static final int SERVICE_NAME_DELIM_LEN = "ou=sunPortalNetFileService,ou=services,".length();

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage : <input ldiff file> , <output xml file>");
            System.exit(0);
        }
        NetfileMigrate netfileMigrate = new NetfileMigrate(stringArray[0], stringArray[1]);
        netfileMigrate.migrate();
        System.exit(0);
    }

    public NetfileMigrate(String string, String string2) {
        this.inputFile = string;
        this.outputFile = string2;
    }

    void migrate() {
        int n = 0;
        try {
            LDIF lDIF = new LDIF(this.inputFile);
            FileWriter fileWriter = new FileWriter(this.outputFile);
            LDIFRecord lDIFRecord = lDIF.nextRecord();
            NetfileMigrate.printHeader(fileWriter);
            while (lDIFRecord != null) {
                System.out.println("\n # Entry id:" + n);
                ++n;
                NetfileOrgData netfileOrgData = this.ConvertRecord(lDIFRecord);
                try {
                    this.OutputRecord(fileWriter, netfileOrgData);
                }
                catch (Exception exception) {
                    System.out.println("Error writing to output file:" + this.outputFile);
                    exception.printStackTrace();
                }
                lDIFRecord = lDIF.nextRecord();
            }
            fileWriter.write("\n</Requests>");
            fileWriter.close();
            System.out.println("Processed " + n + " entries");
            System.out.println("Output available in file " + this.outputFile);
        }
        catch (IOException iOException) {
            System.out.println("Error:" + iOException.toString());
            iOException.printStackTrace();
        }
    }

    NetfileOrgData ConvertRecord(LDIFRecord lDIFRecord) {
        String string = NetfileMigrate.getOrgName(lDIFRecord.getDN());
        LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)lDIFRecord.getContent();
        LDAPAttribute[] lDAPAttributeArray = lDIFAttributeContent.getAttributes();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet(lDAPAttributeArray);
        NetfileOrgData netfileOrgData = new NetfileOrgData(string);
        int n = 0;
        while (n < lDAPAttributeArray.length) {
            String string2 = lDAPAttributeArray[n].getName();
            String[] stringArray = lDAPAttributeSet.getAttribute(lDAPAttributeArray[n].getName()).getStringValueArray();
            netfileOrgData.handleAttribute(string2, stringArray);
            ++n;
        }
        return netfileOrgData;
    }

    static String getOrgName(String string) {
        int n = string.indexOf(SERVICE_NAME_DELIM);
        if (n == -1) {
            System.out.println("Inavlid org name : " + string);
            throw new RuntimeException("Inavlid org name : " + string);
        }
        return string.substring(n + SERVICE_NAME_DELIM_LEN);
    }

    static void printHeader(FileWriter fileWriter) throws IOException {
        Locale locale = Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("AMConfig");
        String string = new String();
        String string2 = "";
        if (resourceBundle.getObject("com.iplanet.am.rootsuffix") != null) {
            string2 = (String)resourceBundle.getObject("com.iplanet.am.rootsuffix");
        }
        if (resourceBundle.getObject("com.iplanet.am.installdir") != null) {
            string = (String)resourceBundle.getObject("com.iplanet.am.installdir");
            string = string.substring(0, string.indexOf("SUNWam"));
        }
        fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        fileWriter.write("\n<!--  PROPRIETARY/CONFIDENTIAL/ Use of this product is subject");
        fileWriter.write("\n to license terms. Copyright 2001 Sun Microsystems Inc.");
        fileWriter.write("Some preexisting portions Copyright 2001 Netscape");
        fileWriter.write("Communications Corp. All rights reserved. -->");
        fileWriter.write("\n<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN \" ");
        fileWriter.write("\"file:" + string + "SUNWam/dtd/amAdmin.dtd\">");
        fileWriter.write("\n<Requests>");
    }

    void OutputRecord(FileWriter fileWriter, NetfileOrgData netfileOrgData) throws IOException {
        if (netfileOrgData.isNull()) {
            return;
        }
        if (netfileOrgData.tempDir != null) {
            fileWriter.write("\n<OrganizationRequests DN=\"" + netfileOrgData.org + "\">");
            fileWriter.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"Dynamic\">");
            fileWriter.write("\n       <AttributeValuePair>");
            fileWriter.write("\n           <Attribute name=\"sunPortalNetFileTempDir\"/>");
            fileWriter.write("\n        <Value>" + netfileOrgData.tempDir);
            fileWriter.write("</Value>");
            fileWriter.write("\n       </AttributeValuePair>");
            fileWriter.write("\n    </ModifyServiceTemplate>");
            fileWriter.write("\n</OrganizationRequests>");
        }
        if (netfileOrgData.osCharSet != null) {
            fileWriter.write("\n<OrganizationRequests DN=\"" + netfileOrgData.org + "\">");
            fileWriter.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"Dynamic\">");
            fileWriter.write("\n       <AttributeValuePair>");
            fileWriter.write("\n           <Attribute name=\"sunPortalNetFileOSCharSet\"/>");
            fileWriter.write("\n        <Value>" + netfileOrgData.osCharSet);
            fileWriter.write("</Value>");
            fileWriter.write("\n       </AttributeValuePair>");
            fileWriter.write("\n    </ModifyServiceTemplate>");
            fileWriter.write("\n</OrganizationRequests>");
        }
        if (netfileOrgData.mimetypesConfigFileLocation != null) {
            fileWriter.write("\n<OrganizationRequests DN=\"" + netfileOrgData.org + "\">");
            fileWriter.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"Dynamic\">");
            fileWriter.write("\n       <AttributeValuePair>");
            fileWriter.write("\n           <Attribute name=\"sunPortalNetFileMimetypesConfigFileLocation\"/>");
            fileWriter.write("\n        <Value>" + netfileOrgData.mimetypesConfigFileLocation);
            fileWriter.write("</Value>");
            fileWriter.write("\n       </AttributeValuePair>");
            fileWriter.write("\n    </ModifyServiceTemplate>");
            fileWriter.write("\n</OrganizationRequests>");
        }
    }
}

