/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.log.LogException;
import com.iplanet.log.LogManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.ApplicationLogin;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.LogCreateThread;
import com.sun.portal.util.RemoteWriteLogThread;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.SystemProperties;
import java.util.Hashtable;

public class GWLogManager {
    private static String logName = "srapGateway";
    public static LogManager lm = null;
    public static boolean loggingEnabled = false;
    public static SSOToken appSession = null;
    private static int logId = 0;
    public static Hashtable logIdMap = new Hashtable();
    static String actualLogName = null;
    static boolean logError = false;
    private static String platformLogName = null;
    private static RemoteWriteLogThread remoteLogThread = null;
    private static LogCreateThread createThread = null;
    static boolean logCreateInvoked;

    public static synchronized void createNewAppSession() {
        GWLogManager.createNewAppSession(false);
    }

    public static synchronized void createNewAppSession(boolean bl) {
        block6: {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("createNewAppSession ... ");
            }
            try {
                String string = ApplicationLogin.login("srapGateway");
                appSession = GWLogManager.createSession(string);
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("createNewAppSession : app session created : " + appSession);
                }
                if (!logCreateInvoked && loggingEnabled && !bl) {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("createNewAppSession : recreating log ... ");
                    }
                    GWLogManager.recreateLog();
                }
            }
            catch (Exception exception) {
                if (!GWDebug.debug.errorEnabled()) break block6;
                GWDebug.debug.error("Error while creating Application Session ", exception);
            }
        }
    }

    public static String getUserId(String string) {
        block5: {
            if (string == null) {
                return "";
            }
            try {
                SSOToken sSOToken = SSOUtil.getSSOTokenThrowExceptionToClient(string);
                String string2 = sSOToken.getPrincipal().getName();
                return string2.substring(string2.indexOf("=") + 1, string2.indexOf(","));
            }
            catch (SSOException sSOException) {
                if (sSOException.toString().indexOf("Session state is invalid") != -1 && GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("GWLogManager: Unable to get user ID, did you not login!!");
                }
            }
            catch (Exception exception) {
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("GWLogManager: Unable to get user ID -> " + exception);
            }
        }
        return "";
    }

    public static synchronized int getLogId() {
        return ++logId;
    }

    public static void createDefault() {
        GWLogManager.createDefault(logName);
    }

    private static SSOToken createSession(String string) {
        SSOToken sSOToken = null;
        try {
            sSOToken = SSOUtil.getSSOTokenNoDecode(string);
        }
        catch (SSOException sSOException) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to create application session", sSOException);
            }
            sSOToken = null;
        }
        catch (Exception exception) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to create application session", exception);
            }
            sSOToken = null;
        }
        return sSOToken;
    }

    public static void initialise() {
        loggingEnabled = GatewayProfile.getBoolean("LoggingEnabled", false);
    }

    public static void createDefault(String string) {
        block6: {
            if (appSession == null) {
                GWLogManager.createNewAppSession(true);
            }
            if (loggingEnabled) {
                lm = new LogManager(appSession);
                if (string != null && string.length() > 0) {
                    logName = string;
                }
                if (platformLogName != null) {
                    logName = platformLogName;
                }
                try {
                    lm.create(logName);
                    actualLogName = logName;
                }
                catch (LogException logException) {
                    actualLogName = null;
                    if (!GWDebug.debug.errorEnabled()) break block6;
                    GWDebug.debug.error("GWLogManager: Unable to create log");
                    GWDebug.debug.error("GWLogManager: " + logException.toString());
                }
            }
        }
    }

    public static void write(String string, String string2) {
        if (lm == null) {
            return;
        }
        if (logError) {
            return;
        }
        if (!loggingEnabled) {
            return;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Validating session ... " + appSession);
        }
        if (!GWLogManager.isAppSessionValid(appSession)) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Invalid Application session ... " + appSession);
                GWDebug.debug.error("Attempting to recreate logs ... ");
            }
            GWLogManager.recreateLog();
            return;
        }
        try {
            remoteLogThread.addEntryForLogging("ACCESS", string2);
        }
        catch (Exception exception) {
            logError = true;
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("GWLogManager: Unable to create log record", exception);
                String string3 = exception.toString();
                GWDebug.debug.error("GWLogManager: " + string3);
            }
            GWLogManager.recreateLog();
        }
    }

    private static synchronized void recreateLog() {
        if (logCreateInvoked) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("logCreateInvoked : true");
            }
            return;
        }
        logError = true;
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Recreate log !!");
        }
        if (!GWLogManager.isAppSessionValid(appSession)) {
            appSession = null;
            GWLogManager.createNewAppSession(true);
        }
        logCreateInvoked = true;
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Notifying ... ");
        }
        createThread.createLogsInThread(actualLogName);
    }

    static boolean isAppSessionValid(SSOToken sSOToken) {
        boolean bl;
        block5: {
            bl = false;
            if (sSOToken == null) {
                return false;
            }
            try {
                SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                SSOToken sSOToken2 = sSOToken;
                bl = sSOTokenManager.isValidToken(sSOToken2);
            }
            catch (SSOException sSOException) {
                bl = false;
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Invalid Application session ", sSOException);
                }
            }
            catch (Exception exception) {
                bl = false;
                if (!GWDebug.debug.messageEnabled()) break block5;
                GWDebug.debug.message("Invalid Application session ", exception);
            }
        }
        return bl;
    }

    public static LogManager getLogManager() {
        return lm;
    }

    public static String getLogName() {
        return logName;
    }

    static {
        platformLogName = SystemProperties.get("gateway.logname");
        if (platformLogName != null && (platformLogName = platformLogName.trim().replace('-', '_')).length() == 0) {
            platformLogName = null;
        }
        GWLogManager.createNewAppSession(true);
        createThread = new LogCreateThread();
        Thread thread = new Thread(createThread);
        thread.start();
        remoteLogThread = new RemoteWriteLogThread();
        new Thread(remoteLogThread).start();
        logCreateInvoked = false;
    }
}

