/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.sso.SSOToken;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.util.GWLocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class HeaderResponse
implements Response {
    protected final String crlf = "\r\n";
    protected SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private String statusCode;
    private String statusText;
    private byte[] responseContent;
    private Map _headerLines;
    private static final String CONTENT_ENCODING = "html";
    private static final String CONTENT_TYPE = "text";
    private static final String SERVER = "sun.net";
    private static final String HTTP_VERSION = "HTTP/1.0";
    private static final String SUBST_STRING = "$$";
    private static final String space = " ";
    private static String defaultLocale = "en_US";
    private static String defaultCharset = "ISO-8859-1";
    private static final String HTMLCHARSET_ATTRIBUTE = "HTML-CharSets";
    private String language = null;
    private String userLocale;
    private String userCharset;
    protected String keepAliveToken = null;
    protected String _cookie = null;

    public HeaderResponse(String string, String string2, String string3, String string4, SSOToken sSOToken) {
        this.getLocaleCharset(sSOToken);
        StringBuffer stringBuffer = new StringBuffer(GWLocale.getString(string, this.userLocale));
        this._headerLines = new HashMap();
        if (string2.length() > 0) {
            stringBuffer.append(space);
            stringBuffer.append(string2);
        }
        this.responseContent = stringBuffer.toString().getBytes();
        this.statusCode = string3;
        this.statusText = string4;
        this._headerLines.put("ndate", "Date: " + this.df.format(new Date()));
        this._headerLines.put("pragma", "Pragma: no-cache");
        this._headerLines.put("server", "Server: sun.net");
        this._headerLines.put("allow", "Allow: GET");
        this._headerLines.put("content-length", "Content-Length: " + this.responseContent.length);
        this._headerLines.put("content-type", "Content-Type: text/html;charset=" + this.userCharset);
    }

    public HeaderResponse(String string, String string2, String string3, SSOToken sSOToken) {
        this(string, string2, string3, sSOToken, null);
    }

    public HeaderResponse(String string, String string2, String string3, SSOToken sSOToken, String string4) {
        this.language = string4;
        this.getLocaleCharset(sSOToken);
        this._headerLines = new HashMap();
        this.responseContent = string.getBytes();
        this.statusCode = string2;
        this.statusText = string3;
        this._headerLines.put("ndate", "Date: " + this.df.format(new Date()));
        this._headerLines.put("pragma", "Pragma: no-cache");
        this._headerLines.put("server", "Server: sun.net");
        this._headerLines.put("allow", "Allow: GET");
        this._headerLines.put("content-length", "Content-Length: " + this.responseContent.length);
        this._headerLines.put("content-type", "Content-Type: text/html;charset=" + this.userCharset);
    }

    public HeaderResponse(String string, String string2, String string3) {
        this.getLocaleCharset(null);
        this._headerLines = new HashMap();
        this.responseContent = string.getBytes();
        this.statusCode = string2;
        this.statusText = string3;
        this._headerLines.put("ndate", "Date: " + this.df.format(new Date()));
        this._headerLines.put("pragma", "Pragma: no-cache");
        this._headerLines.put("server", "Server: sun.net");
        this._headerLines.put("allow", "Allow: GET");
        this._headerLines.put("content-length", "Content-Length: " + this.responseContent.length);
        this._headerLines.put("content-type", "Content-Type: text/html;charset=" + this.userCharset);
    }

    public void substituteContent(String string) {
        String string2 = new String(this.responseContent);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.indexOf(SUBST_STRING);
        if (n != -1) {
            stringBuffer.append(string2.substring(0, n));
            stringBuffer.append(string);
            stringBuffer.append(string2.substring(n + 2));
            this.responseContent = stringBuffer.toString().getBytes();
        }
        this._headerLines.put("content-length", "Content-Length: " + this.getContentLength());
    }

    public String getHTTPVersion() {
        return HTTP_VERSION;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getContentType() {
        return "text/html";
    }

    public String getContentEncoding() {
        return CONTENT_ENCODING;
    }

    public String getResponseHeader(String string) {
        return (String)this._headerLines.get(string.toLowerCase());
    }

    public void setResponseHeader(String string, String string2) {
        if (string != null) {
            this._headerLines.remove(string.toLowerCase());
            this._headerLines.put(string.toLowerCase(), string2);
            if (string.toLowerCase().startsWith("set-cookie")) {
                this._cookie = string2;
            }
        }
    }

    public void setContentLength(int n) {
        this._headerLines.remove("content-length");
        this._headerLines.put("content-length", "Content-Length: " + n + "\r\n");
    }

    public void setConnectionClose() {
        this._headerLines.remove("Connection");
        this.keepAliveToken = "Connection: close\r\n";
        this._headerLines.put("Connection", "Connection: close");
    }

    public void setConnectionAlive(String string) {
        String string2 = this.getResponseHeader("Connection");
        if (string2 != null) {
            this._headerLines.remove("Connection");
        }
        if ((string2 = this.getResponseHeader("Keep-Alive")) != null) {
            this._headerLines.remove("Keep-Alive");
        }
        this.keepAliveToken = "Keep-Alive: " + string;
        this._headerLines.put("Keep-Alive", this.keepAliveToken);
        this._headerLines.put("Connection", "Connection: Keep-Alive");
        this.keepAliveToken = "Connection: Keep-Alive\r\n" + this.keepAliveToken + "\r\n";
    }

    public void setLocation(String string) {
    }

    public int getContentLength() {
        String string = (String)this._headerLines.get("content-length");
        if (null == string) {
            return this.responseContent.length;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return this.responseContent.length;
        }
        if (string.endsWith("\r\n")) {
            return Integer.parseInt(string.substring(n + 1, string.length() - 2).trim());
        }
        return Integer.parseInt(string.substring(n + 1, string.length()).trim());
    }

    public byte[] getHeaderBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getHTTPVersion());
            stringBuffer.append(space);
            stringBuffer.append(this.getStatusCode());
            stringBuffer.append(space);
            stringBuffer.append(this.getStatusText());
            stringBuffer.append("\r\n");
            stringBuffer.append("Date: ");
            stringBuffer.append(this.df.format(new Date()));
            stringBuffer.append("\r\n");
            stringBuffer.append("Pragma: no-cache");
            stringBuffer.append("\r\n");
            stringBuffer.append("Server: ");
            stringBuffer.append(SERVER);
            stringBuffer.append("\r\n");
            stringBuffer.append("Allow: GET");
            stringBuffer.append("\r\n");
            stringBuffer.append("Content-Length: ");
            stringBuffer.append(this.getContentLength());
            stringBuffer.append("\r\n");
            stringBuffer.append("Content-Type: ");
            stringBuffer.append(this.getContentType());
            stringBuffer.append(";charset=");
            stringBuffer.append(this.userCharset);
            stringBuffer.append("\r\n");
            dataOutputStream.writeBytes(stringBuffer.toString());
            if (this.keepAliveToken != null) {
                dataOutputStream.writeBytes(this.keepAliveToken);
            }
            if (this._cookie != null) {
                dataOutputStream.writeBytes(this._cookie + "\r\n");
            }
            dataOutputStream.writeBytes("\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BufferedInputStream getContentStream() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(this.responseContent);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public String toString() {
        return new String(this.getHeaderBytes());
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    private void getLocaleCharset(SSOToken sSOToken) {
        if (sSOToken == null) {
            if (this.language != null) {
                this.userLocale = this.language = this.language.substring(this.language.indexOf(58) + 1).trim();
                this.userCharset = this.getHTMLCharset(this.userLocale);
                if (this.userCharset == null) {
                    this.userLocale = defaultLocale;
                    this.userCharset = defaultCharset;
                }
            } else {
                this.userLocale = defaultLocale;
                this.userCharset = defaultCharset;
            }
            return;
        }
        try {
            String string = sSOToken.getTokenID().toString();
            UserProfile userProfile = new UserProfile(URLEncoder.encode(string));
            this.userLocale = userProfile.getString("preferredlocale", "en_US");
            this.userCharset = this.getHTMLCharset(this.userLocale);
            if (this.userCharset == null) {
                this.userLocale = defaultLocale;
                this.userCharset = defaultCharset;
            }
        }
        catch (Exception exception) {
            this.userLocale = defaultLocale;
            this.userCharset = defaultCharset;
        }
    }

    private String getHTMLCharset(String string) {
        String string2 = GWLocale.getString(HTMLCHARSET_ATTRIBUTE, string);
        if (string2 == null || string2.equals(HTMLCHARSET_ATTRIBUTE)) {
            string2 = null;
        }
        return string2;
    }

    public void setSocket(CachedSocket cachedSocket) {
    }

    public void closeSocket() {
    }

    public void setClientCaching() {
    }
}

