/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public class VerifyCertificate
implements Command {
    private JSSContext cntx;
    private String msg;

    public boolean execute(JSSContext jSSContext) {
        this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + CertAdminLocale.getPFString("m57", "Could not verify,") + " " + CertAdminLocale.getPFString("m56", "Insufficient command parameters");
        return false;
    }

    public String getMessage() {
        return this.msg;
    }

    public boolean execute(JSSContext jSSContext, String string) {
        this.cntx = jSSContext;
        if (!JSSUtil.certExist(jSSContext, string)) {
            this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + string + " " + CertAdminLocale.getPFString("m31", "Specified certificate does not exist!");
            return false;
        }
        X509Certificate x509Certificate = null;
        try {
            org.mozilla.jss.crypto.X509Certificate x509Certificate2 = JSSUtil.getCertByNickname(jSSContext, string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate2.getEncoded());
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            x509Certificate.checkValidity();
            this.msg = x509Certificate.getIssuerDN().toString().equalsIgnoreCase(x509Certificate.getSubjectDN().toString()) ? CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + string + " " + CertAdminLocale.getPFString("m60", "is a self signed certificate!") : CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + string + " " + CertAdminLocale.getPFString("m62", "is valid!");
        }
        catch (CertificateExpiredException certificateExpiredException) {
            this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + string + " " + CertAdminLocale.getPFString("m59", "has already expired!") + " " + certificateExpiredException.getMessage();
            return false;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + string + " " + CertAdminLocale.getPFString("m61", "is invalid!") + " " + certificateNotYetValidException.getMessage();
            return false;
        }
        catch (Exception exception) {
            this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + CertAdminLocale.getPFString("m57", "Could not verify,") + string + " " + exception.getMessage();
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

