/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.mozilla.jss.crypto.X509Certificate;

public class PrintCertificate
implements Command {
    public boolean execute(JSSContext jSSContext) {
        String string = CertAdminUtil.question(CertAdminLocale.getPFString("q18", "Enter the name you like for this certificate ["));
        if (string.trim().equals("")) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m30", "Certificate name entered is not valid!"));
            return false;
        }
        if (!JSSUtil.certExist(jSSContext, string)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m31", "Specified certificate does not exist!"));
            return false;
        }
        try {
            X509Certificate x509Certificate = JSSUtil.getCertByNickname(jSSContext, string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getEncoded());
            Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            CertAdminUtil.println(certificate.toString());
            return true;
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m39", "Could not print the certificate!") + " " + string + " ");
            exception.printStackTrace();
            return false;
        }
    }
}

