/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.io.File;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class InstallCertificate
implements Command {
    public boolean execute(JSSContext jSSContext) {
        CertAdminHelpText.getCertHelpText();
        String string = CertAdminUtil.question(CertAdminLocale.getPFString("q15", "What is the name (including path) of file that contains the certificate ?"));
        File file = new File(string);
        if (!file.exists()) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m23", "Certificate file") + " " + string + " " + CertAdminLocale.getPFString("m231", "doesn't exist!"));
            return false;
        }
        String string2 = "server-cert";
        String string3 = CertAdminUtil.question(CertAdminLocale.getPFString("q9", "Enter the name you like for this certificate [") + string2 + CertAdminLocale.getPFString("q1", "]"));
        if (string3.trim().equals("")) {
            string3 = string2;
        }
        while (JSSUtil.certExist(jSSContext, string3)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m26", "Certificate") + " " + string3 + " " + CertAdminLocale.getPFString("m261", " already exist. Choose another nickname!"));
            string3 = CertAdminUtil.question(CertAdminLocale.getPFString("q9", "Enter the name you like for this certificate [") + string2 + CertAdminLocale.getPFString("q1", "]"));
            if (!string3.trim().equals("")) continue;
            string3 = string2;
        }
        String string4 = CertAdminUtil.question(CertAdminLocale.getPFString("q16", "Enter the token name you used when creating CSR for this certificate []"));
        try {
            CertAdminPasswordCallback certAdminPasswordCallback;
            String string5 = jSSContext.getPasswordContext().generatePassphrase(jSSContext);
            CryptoToken cryptoToken = null;
            if (string4.trim().equals("")) {
                cryptoToken = jSSContext.getCryptoManager().getInternalKeyStorageToken();
                certAdminPasswordCallback = new CertAdminPasswordCallback(string5);
                if (!cryptoToken.passwordIsInitialized()) {
                    cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)certAdminPasswordCallback);
                }
            } else {
                cryptoToken = jSSContext.getCryptoManager().getTokenByName(string4);
                certAdminPasswordCallback = new ConsolePasswordCallback();
                if (!cryptoToken.passwordIsInitialized()) {
                    cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)certAdminPasswordCallback);
                }
            }
            cryptoToken.login((PasswordCallback)certAdminPasswordCallback);
            X509Certificate x509Certificate = JSSUtil.addCertificate(jSSContext, file, string3, false);
            String string6 = jSSContext.getCertdir() + CertAdminConstants.SEPERATOR + ".nickname";
            if (CertAdminUtil.fileExist(string6) && !CertAdminUtil.delete(string6)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m46", "Could not delete the .nickname file!"));
            }
            if (!CertAdminUtil.writeLine(string3, string6)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m47", "Could not update .nickname file. Please update it manually!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                CertAdminUtil.println(CertAdminLocale.getPFString("m48", ".nickname file location : "));
            }
            CertAdminUtil.println(CertAdminConstants.newline);
            CertAdminUtil.println(CertAdminLocale.getPFString("m27", "Certificate successfully installed"));
            CertAdminUtil.println(CertAdminLocale.getPFString("m28", "To use the new Certificate, you must (re)start the server"));
            return true;
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m29", "Could not install certificate!"));
            exception.printStackTrace();
            return false;
        }
    }
}

