/*
 * Decompiled with CFR 0.152.
 */
package ob.tree;

import java.io.Serializable;
import ob.tree.TreeNodeX;

public class TreeNode
implements Serializable {
    protected TreeNode m_pParent = null;
    protected TreeNode m_pNextSibling = null;
    protected TreeNode m_pPrevSibling = null;
    protected TreeNode m_pFirstChild = null;
    public static final int TREENODE_FIRST = 0;
    public static final int TREENODE_LAST = 1;
    public static final int TREENODE_SORT = 2;

    public void deleteChildren() {
    }

    public TreeNode getParent() {
        return this.m_pParent;
    }

    public boolean isParent(TreeNode parent) {
        return this.m_pParent == parent;
    }

    public TreeNode getNextSibling() {
        return this.m_pNextSibling;
    }

    public TreeNode getPrevSibling() {
        return this.m_pPrevSibling;
    }

    public TreeNode getFirstChild() {
        return this.m_pFirstChild;
    }

    public TreeNode getLastChild() {
        TreeNode pNode = this.getFirstChild();
        if (pNode == null) {
            return null;
        }
        return pNode.getLastSibling();
    }

    public TreeNode getFirstSibling() {
        TreeNode pNode = this;
        while (pNode.getPrevSibling() != null) {
            pNode = pNode.getPrevSibling();
        }
        return pNode;
    }

    public TreeNode getLastSibling() {
        TreeNode pNode = this;
        while (pNode.getNextSibling() != null) {
            pNode = pNode.getNextSibling();
        }
        return pNode;
    }

    public TreeNode getBottomLeftChild() {
        TreeNode pNode = this.m_pFirstChild;
        if (pNode != null) {
            while (pNode.getFirstChild() != null) {
                pNode = pNode.getFirstChild();
            }
        }
        return pNode;
    }

    public TreeNode getBottomRightChild() {
        TreeNode pNode = this.getLastChild();
        if (pNode != null) {
            return pNode.getBottomRightChild();
        }
        return this;
    }

    public TreeNode getRoot() {
        TreeNode pNode = this;
        while (pNode.m_pParent != null) {
            pNode = pNode.m_pParent;
        }
        return pNode;
    }

    public TreeNode getNextInDisplayOrder() {
        if (this.getFirstChild() != null) {
            return this.getFirstChild();
        }
        if (this.getNextSibling() != null) {
            return this.getNextSibling();
        }
        TreeNode pNodeAncestor = this;
        while (pNodeAncestor.getParent() != null) {
            if ((pNodeAncestor = pNodeAncestor.getParent()).getNextSibling() == null) continue;
            return pNodeAncestor.getNextSibling();
        }
        return null;
    }

    public TreeNode getPrevInDisplayOrder() {
        if (this.getPrevSibling() != null) {
            TreeNode pBRC = this.getPrevSibling().getBottomRightChild();
            if (pBRC != null) {
                return pBRC;
            }
            return this.getPrevSibling();
        }
        return this.getParent();
    }

    public TreeNode search(int idSearch) {
        TreeNode pNode = this.getBottomLeftChild();
        while (pNode != null) {
            boolean bFound = this.onNextSearchNode(idSearch, pNode);
            if (bFound) {
                return pNode;
            }
            if (pNode.getNextSibling() != null) {
                pNode = pNode.getNextSibling();
                continue;
            }
            if (pNode.getParent() == null || pNode.getParent() == this) break;
            pNode = pNode.getParent();
        }
        return null;
    }

    public boolean onNextSearchNode(int idSearch, TreeNode pNode) {
        return false;
    }

    public void setParent(TreeNode n) {
        this.m_pParent = n;
    }

    public void setNextSibling(TreeNode n) {
        this.m_pNextSibling = n;
    }

    public void setPrevSibling(TreeNode n) {
        this.m_pPrevSibling = n;
    }

    public void setFirstChild(TreeNode n) {
        this.m_pFirstChild = n;
    }

    public boolean addChild(TreeNode pNewTreeNode) {
        return this.addChild(pNewTreeNode, null);
    }

    public boolean addChild(TreeNode pNewTreeNode, int pInsAfter) {
        if (pInsAfter == 2) {
            System.out.println("WARNING:  haven't implemented TREENODE_SORT");
            pInsAfter = 1;
        }
        pNewTreeNode.m_pParent = this;
        if (this.m_pFirstChild == null) {
            this.m_pFirstChild = pNewTreeNode;
            pNewTreeNode.m_pNextSibling = null;
            pNewTreeNode.m_pPrevSibling = null;
        } else if (pInsAfter == 1) {
            TreeNodeX pChild = (TreeNodeX)this.m_pFirstChild;
            while (pChild.m_pNextSibling != null) {
                pChild = (TreeNodeX)pChild.m_pNextSibling;
            }
            pChild.m_pNextSibling = pNewTreeNode;
            pNewTreeNode.m_pPrevSibling = pChild;
            pNewTreeNode.m_pNextSibling = null;
        } else if (pInsAfter == 0) {
            pNewTreeNode.m_pPrevSibling = null;
            pNewTreeNode.m_pNextSibling = this.m_pFirstChild;
            this.m_pFirstChild.m_pPrevSibling = pNewTreeNode;
            this.m_pFirstChild = pNewTreeNode;
        }
        return true;
    }

    public boolean addChild(TreeNode pNewTreeNode, TreeNode pInsAfter) {
        if (pInsAfter == null) {
            return this.addChild(pNewTreeNode, 1);
        }
        pNewTreeNode.m_pParent = this;
        if (this.m_pFirstChild == null) {
            this.m_pFirstChild = pNewTreeNode;
            pNewTreeNode.m_pNextSibling = null;
            pNewTreeNode.m_pPrevSibling = null;
        } else {
            boolean bFound = false;
            TreeNodeX pChild = (TreeNodeX)this.m_pFirstChild;
            while (pChild != null) {
                if (pChild == pInsAfter) {
                    bFound = true;
                    break;
                }
                pChild = (TreeNodeX)pChild.m_pNextSibling;
            }
            if (!bFound) {
                return false;
            }
            pNewTreeNode.m_pNextSibling = pInsAfter.m_pNextSibling;
            pNewTreeNode.m_pPrevSibling = pInsAfter;
            if (pInsAfter.m_pNextSibling != null) {
                pInsAfter.m_pNextSibling.m_pPrevSibling = pNewTreeNode;
            }
            pInsAfter.m_pNextSibling = pNewTreeNode;
        }
        return true;
    }

    public void detachFromTree() {
        if (this.m_pNextSibling != null) {
            this.m_pNextSibling.m_pPrevSibling = this.m_pPrevSibling;
        }
        if (this.m_pPrevSibling != null) {
            this.m_pPrevSibling.m_pNextSibling = this.m_pNextSibling;
        }
        if (this.m_pParent.m_pFirstChild == this) {
            this.m_pParent.m_pFirstChild = this.m_pNextSibling;
        }
        this.m_pParent = null;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteAllChildren() {
        TreeNode pChild;
        while ((pChild = this.getFirstChild()) != null) {
            void var1_1;
            var1_1.detachFromTree();
        }
    }

    public boolean hasChildren() {
        return this.m_pFirstChild != null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isDescendant(TreeNode pNode) {
        if (pNode != null) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if ((pNode = pNode.getParent()) != this) continue;
            return true;
lbl5:
            // 2 sources

            ** while (pNode.getParent() != null)
        }
lbl6:
        // 1 sources

        return false;
    }

    public boolean isAncestor(TreeNode possibleAncestor) {
        TreeNode pNode = this;
        pNode = this.getParent();
        while (pNode != null) {
            if (pNode == possibleAncestor) {
                return true;
            }
            pNode = pNode.getParent();
        }
        return false;
    }

    public boolean isSibling(TreeNode pNodeTest) {
        TreeNode pNode = this.getFirstSibling();
        while (pNode != null) {
            if (pNodeTest == pNode) {
                return true;
            }
            pNode = pNode.getNextSibling();
        }
        return false;
    }

    public int getDistanceFromRoot() {
        TreeNode pNode = this.getParent();
        int w = 0;
        while (pNode != null) {
            pNode = pNode.getParent();
            ++w;
        }
        return w;
    }

    public boolean isExpanded() {
        return false;
    }

    public void expand(boolean bExpand) {
    }

    public void expand() {
        this.expand(true);
    }

    public void collapse() {
        this.expand(false);
    }

    public int getNumDescendents() {
        int iCount = 0;
        TreeNode pNode = this.getFirstChild();
        while (pNode != null) {
            ++iCount;
            pNode = pNode.getNextInDisplayOrder();
        }
        return iCount;
    }
}

