/*
 * Decompiled with CFR 0.152.
 */
package ob.tree;

import java.awt.Rectangle;
import ob.tree.Node;

public class TreeItem
extends Node {
    public static final int EXPAND = 1;
    public static final int UNEXPAND = 2;
    boolean Visible = true;
    int Image = -1;
    int SelImage = -1;
    int Status = 1;
    int nChild = 0;
    int Indent = 0;
    Rectangle BaseBound;
    Object Data = null;

    public TreeItem(String label) {
        super(label, -1, -1);
    }

    public void addItem(TreeItem child) {
        super.addChild(child);
    }

    public String getLabel() {
        return super.getText();
    }

    public void setLabel(String s) {
        super.setText(s);
    }

    public Object getData() {
        return this.Data;
    }

    public void setData(Object data) {
        this.Data = data;
    }

    public int getStatus() {
        return this.Status;
    }

    public void setStatus(int s) {
        this.Status = s;
        if (s == 1) {
            super.expand(true);
        }
    }

    public int getIndex() {
        int nCount = 1;
        TreeItem sib = (TreeItem)this.getFirstSibling();
        while (sib != this) {
            sib = (TreeItem)sib.getNextSibling();
            ++nCount;
        }
        return nCount;
    }

    public TreeItem getNextItem() {
        return (TreeItem)this.getNextSibling();
    }

    public TreeItem getPrevItem() {
        return (TreeItem)this.getPrevSibling();
    }

    public boolean hasChild() {
        return super.hasChildren();
    }

    public int getCount() {
        int nCount = 0;
        TreeItem ti = (TreeItem)this.getFirstChild();
        while (ti != null) {
            try {
                ti = (TreeItem)ti.getNextSibling();
                ++nCount;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return nCount;
    }

    public Rectangle bounds() {
        return this.BaseBound;
    }

    public TreeItem getChild(int index) {
        int nCount = 0;
        TreeItem ti = null;
        ti = (TreeItem)this.getFirstChild();
        while (ti != null && index < nCount) {
            if (ti != null) {
                ti = (TreeItem)ti.getNextSibling();
            }
            ++nCount;
        }
        return ti;
    }

    public boolean isParentOf(TreeItem item) {
        if (item == null) {
            return false;
        }
        return super.isParent(item);
    }

    public boolean isChildOf(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i].isParentOf(this)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void remove(TreeItem item) {
        item.detachFromTree();
    }

    public void removeAll() {
        System.out.println("in removeAll....");
        if (this.getSubItems().isEmpty()) {
            System.out.println("Vector is empty");
        } else {
            System.out.println("Vector has elements ");
            System.out.println("Vector size is " + this.getSubItems().size());
            this.getSubItems().removeAllElements();
        }
    }

    public TreeItem findObject(Object o) {
        if (this.Data == o) {
            return this;
        }
        int i = 0;
        int count = this.getCount();
        TreeItem ti = null;
        while (ti == null && i < count) {
            try {
                ti = this.getItemChild(i).findObject(o);
                ++i;
            }
            catch (NullPointerException n) {
                // empty catch block
            }
        }
        return ti;
    }

    public void printTree() {
        int i = 0;
        while (i < this.getCount()) {
            this.getChild(i).printTree();
            ++i;
        }
    }

    public TreeItem getItemChild(int index) {
        int nChild = this.getSubItems().size();
        if (index >= 0 && index < nChild) {
            return (TreeItem)this.getSubItems().elementAt(index);
        }
        return null;
    }

    public synchronized void deleteChild(TreeItem item) {
        boolean i = false;
        TreeItem firstChild = (TreeItem)item.getFirstChild();
        while (firstChild != null) {
            item.remove(firstChild);
            firstChild = (TreeItem)item.getFirstChild();
        }
    }
}

