/*
 * Decompiled with CFR 0.152.
 */
package ob.tree;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Vector;
import ob.listbox.Column;
import ob.listbox.ListBox;
import ob.listbox.ListItem;
import ob.text.ExpandableText;
import ob.text.Text;
import ob.tree.Node;
import ob.tree.TreeItem;
import ob.tree.TreeNode;
import ob.tree.TreeNodeX;

public class TreeBase
extends ListBox
implements Serializable {
    public static final int ILLEGAL = 3000;
    public static final int OPENFOLDER = 3002;
    public static final int SELECTION_CHANGE = 3003;
    public static final int ITEM_COLLAPSED = 3004;
    public static final int ITEM_EXPANDED = 3005;
    public static final int DOUBLE_CLICK = 3006;
    public static final String commandDragDrop = "Drag_Drop";
    public static final String commandOpenFolder = "Open_Folder";
    public static final String commandSelectionChanged = "Selection_Changed";
    public static final String commandIllegalAction = "Illegal_Action";
    public static final String commandItemCollapsed = "Item_Collapsed";
    public static final String commandItemExpanded = "Item_Expanded";
    public static final int TVGN_NEXT = 0;
    public static final int TVGN_PREVIOUS = 1;
    public static final int TVGN_CHILD = 2;
    public static final int TVGN_PARENT = 3;
    public static final int TVGN_ROOT = 4;
    public static final int TVGN_CARET = 5;
    public static final int TVGN_FIRSTVISIBLE = 6;
    public static final int TVGN_NEXTVISIBLE = 7;
    public static final int TVGN_PREVIOUSVISIBLE = 8;
    public static final int TVGN_DROPHILITE = 9;
    public static final int TVGN_FIRSTSELECTED = 10;
    public static final int TVGN_NEXTSELECTED = 11;
    public static final int TVGN_PREVIOUSSELECTED = 12;
    public static final int TVE_COLLAPSE = 0;
    public static final int TVE_EXPAND = 1;
    public static final int TVE_TOGGLE = 2;
    Node m_itemEventTarget;
    protected Vector m_arrRoots = null;
    protected int m_nIndent = 18;
    private int m_nButtonSize = 8;
    protected boolean m_bHideDisabledItems = false;
    protected boolean m_bHierarchyLines = true;
    protected Color m_colHierarchyLines = SystemColor.windowBorder;
    protected int m_nStyleHierarchyLines = 0;
    protected boolean m_bLinesAtRoot = true;
    protected boolean m_bButton = true;
    protected int m_nWordGap = 4;
    String txtBgHighColor = "";
    String txtTxtColor = "";
    String txtHiTxtColor = "";
    Node m_itemDropTarget;
    Node m_nodeCurrentEdit = new Node();

    public TreeBase() {
        this.m_nRowSpace = 3;
    }

    public TreeBase(boolean bMultipleSelections) {
        super(bMultipleSelections);
        this.m_nRowSpace = 3;
    }

    public TreeBase(String rootText, int imgReg, int imgExp, ActionListener action) {
        this(false);
        this.initRootNode(rootText, imgReg, imgExp);
        this.actionListener = action;
    }

    public boolean isRoot(Node node) {
        return this.m_arrRoots.contains(node);
    }

    public boolean isRoot(int x) {
        int i = 0;
        while (i < this.m_arrRoots.size()) {
            if (this.nodeIndex((Node)this.m_arrRoots.elementAt(i)) == x) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Node getRoot(int rootIndex) {
        if (this.m_arrRoots.size() > rootIndex) {
            return (Node)this.m_arrRoots.elementAt(rootIndex);
        }
        return null;
    }

    public Node insertItem(Node item, Node parent, Node insertAfter, int imageID, int imageExpID) {
        item.setImage(imageID);
        item.setExpandedImage(imageExpID);
        return this.insertItem(item, parent, insertAfter);
    }

    public Node insertItem(Node item, Node parent, Node insertAfter, int imageID, int imageExpID, Font nodeFont) {
        item.setFont(nodeFont);
        return this.insertItem(item, parent, insertAfter, imageID, imageExpID);
    }

    public Node insertItem(Node item, Node parent, Node insertAfter) {
        if (this.m_arrRoots == null) {
            this.initRootNode();
        }
        Node pNodeParent = parent;
        if (parent == null) {
            pNodeParent = (Node)this.m_arrRoots.elementAt(0);
        }
        Node pNodeInsertAfter = insertAfter;
        Node pNodeNew = new Node();
        pNodeNew = item;
        if (!pNodeParent.addChild((TreeNode)pNodeNew, pNodeInsertAfter)) {
            return null;
        }
        pNodeNew.collapse();
        if (this.shouldBeInListBox(pNodeNew)) {
            this.addNodeToListBox(pNodeNew);
        }
        return pNodeNew;
    }

    public Node insertItem(String strItem, Node parent, Node insertAfter, int image, int imageExp) {
        Node pNodeNew = new Node();
        pNodeNew.setText(strItem);
        return this.insertItem(pNodeNew, parent, insertAfter, image, imageExp);
    }

    public Node insertItem(String strItem, Node parent, Node insertAfter, int image, int imageExp, Font nodeFont) {
        Node pNodeNew = new Node();
        pNodeNew.setText(strItem);
        return this.insertItem(pNodeNew, parent, insertAfter, image, imageExp, nodeFont);
    }

    public Node insertItem(String strItem, Node parent, Node insertAfter) {
        Node pNodeNew = new Node();
        pNodeNew.setText(strItem);
        return this.insertItem(pNodeNew, parent, insertAfter);
    }

    public void setHierarchyLineColor(Color c) {
        this.m_colHierarchyLines = c;
    }

    public void setHierarchyLineStyle(int nStyle) {
        this.m_nStyleHierarchyLines = nStyle;
    }

    public void setIndent(int indent) {
        this.m_nIndent = indent;
        this.reMeasureAllItems();
        this.update();
    }

    public int getIndent() {
        return this.m_nIndent;
    }

    protected int measureText() {
        Rectangle rectText = new Rectangle();
        rectText.y = 0;
        rectText.height = 0;
        Font font = ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getFont();
        if (font == null) {
            font = ListBox.defaultfont;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.m_lvi_pszText = ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getText();
        if (this.m_bAutoWrap && this.m_lvi_pszText != null) {
            int nIndent = ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x + this.m_nWidthGap + (this.getInsideRect().width + this.m_nVScrollbarWidth - this.getBounds().width);
            Vector wrapLines = Text.wrapText(this.m_lvi_pszText, ((Column)this.m_arrColumns.elementAt(this.m_lvi_iSubItem)).getWidth() - this.m_nWidthGap * 2 - nIndent, true, fontMetrics);
            rectText.height = wrapLines.size() * fontMetrics.getHeight();
        } else {
            rectText.height = fontMetrics.getHeight();
        }
        return rectText.height;
    }

    public int measureSubItem(Graphics g) {
        try {
            if (this.m_lvi_iSubItem == 0) {
                int leftText;
                int nIndent = this.getIndent() * (((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getDistanceFromRoot() - 1);
                nIndent += this.getIndent();
                if (this.m_arrImages != null && this.m_arrImages.size() != 0) {
                    int nImgWidth;
                    int imageID = ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getImage();
                    Image img = this.getImageList(imageID);
                    int nImgHeight = img.getHeight(this);
                    int ImgSize = nImgWidth = img.getWidth(this);
                    ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).setImageBounds(new Rectangle(nIndent + this.m_nWidthGap, 0, nImgWidth, nImgHeight));
                    Rectangle rcTemp = ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getImageBounds();
                    leftText = rcTemp.width + nIndent + this.m_nWidthGap + 18;
                }
                leftText = nIndent + this.m_nWordGap + 18;
                Font font = ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getFont();
                if (font == null) {
                    font = ListBox.defaultfont;
                }
                FontMetrics fm = this.getFontMetrics(font);
                if (this.m_bAutoWrap) {
                    ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).setTextBounds(leftText, 0, Math.min(((Column)this.m_arrColumns.elementAt(0)).getWidth(), fm.stringWidth(((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getText()) + leftText + this.m_nWidthGap), 0);
                } else {
                    ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).setTextBounds(leftText, 0, fm.stringWidth(((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getText()) + leftText + this.m_nWidthGap, 0);
                }
                int textHeight = this.measureText();
                ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).setTextHeight(textHeight);
                this.m_recPCRect = new Rectangle(((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getTextBounds());
                this.m_recPCRect.height = Math.max(this.m_recPCRect.height, ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().height);
                return this.m_recPCRect.height;
            }
            return super.measureSubItem(g);
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public void drawSubItem(Graphics g) {
        Rectangle bounds = this.getBounds();
        if (this.m_lvi_iSubItem == 0) {
            int textHeight = this.measureText();
            boolean bSelected = this.isSelected(this.m_lvi_iItem);
            Node nodeTemp = (Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData();
            String strText = nodeTemp.getText();
            int iImage = !nodeTemp.isExpanded() ? ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getImage() : ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getExpandedImage();
            g.setColor(this.getBackground());
            Rectangle rectFill = this.m_recPCRect;
            Rectangle rectText = ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getTextBounds();
            rectText.y = this.m_recPCRect.y + 2;
            if (this.m_arrColumns.size() > 1) {
                rectText.width = Math.min(rectText.width, this.m_recPCRect.x + ((Column)this.m_arrColumns.elementAt(0)).getWidth() - this.m_nWidthGap);
            }
            Rectangle rcIndent = this.m_recPCRect;
            rcIndent.width = 0;
            if (this.m_arrImages != null && this.m_arrImages.size() > 0) {
                if (this.getImageIndex(iImage) >= this.m_arrImages.size()) {
                    System.out.println("Warning:  Image " + iImage + " does not exist!");
                    iImage = 0;
                }
                ListItem pItem = (ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem);
                Point pt = new Point(this.m_recPCRect.x + pItem.getImageBounds().x, this.m_recPCRect.y + pItem.getImageBounds().y);
                ++pt.y;
                Image img = this.getImageList(iImage);
                if (img != null) {
                    g.drawImage(img, pt.x, pt.y - bounds.y, this);
                }
                rcIndent.width = pt.x;
            }
            rectFill.x = rectText.x + rectText.width;
            rectFill.width = this.m_recPCRect.width;
            g.fillRect(rectFill.x, rectFill.y - bounds.y, rectFill.width, rectFill.height);
            this.m_recPCRect.x = rectText.x;
            if (this.m_bHierarchyLines) {
                this.drawHierarchyLines(g);
            }
            if (this.m_bButton) {
                this.drawButton(g);
            }
            rectFill.x = rectText.x - this.m_nWidthGap / 2;
            rectFill.width = rectText.width + this.m_nWidthGap / 2;
            rectFill.y = this.m_recPCRect.y;
            rectFill.height = textHeight * 1;
            g.setFont(((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getFont());
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.getBackground());
            if (strText != null) {
                if (this.m_bAutoWrap) {
                    int cySubItem;
                    ListItem pItem;
                    String selectText = ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getText();
                    Font font = ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getFont();
                    if (font == null) {
                        font = ListBox.defaultfont;
                    }
                    g.setFont(font);
                    fm = this.getFontMetrics(font);
                    int nIndent = ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x + this.m_nWidthGap;
                    Vector nodeText = Text.wrapText(strText, ((Column)this.m_arrColumns.elementAt(this.m_lvi_iSubItem)).getWidth() - this.m_nWidthGap * 2 - nIndent, true, fm);
                    int selectWidth = fm.stringWidth(selectText);
                    if (nodeText.size() > 1) {
                        selectWidth = ((Column)this.m_arrColumns.elementAt(this.m_lvi_iSubItem)).getWidth() - this.m_nWidthGap * 2 - nIndent;
                    }
                    if (selectWidth > ((Column)this.m_arrColumns.elementAt(0)).getWidth() - (rectText.x - 2 + this.m_nWidthGap)) {
                        selectWidth = rectText.width;
                    }
                    g.setColor(SystemColor.textText);
                    if (!this.isSelected(this.m_lvi_iItem)) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(TreeBase.getTreeColor(this.txtBgHighColor, Color.black));
                        pItem = (ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem);
                        cySubItem = Math.max(textHeight, pItem.getImageBounds().height);
                        if (((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().height <= textHeight) {
                            g.fillRect(rectText.x - 1 + this.m_nWidthGap - this.m_ptViewportOrg.x, rectText.y - bounds.y - 1, selectWidth + 3, textHeight + textHeight / 4 - 2);
                            if (this.m_bHasFocus) {
                                this.drawDottedRect(g, rectText.x - 2 + this.m_nWidthGap - this.m_ptViewportOrg.x, rectText.y - bounds.y - 2, selectWidth + 4, textHeight + textHeight / 4 - 1);
                            }
                        } else {
                            g.fillRect(rectText.x + this.m_nWidthGap - this.m_ptViewportOrg.x + 1, rectText.y + (cySubItem / 2 - textHeight / 2) - bounds.y - 2, selectWidth + 3, textHeight + textHeight / 4 - 2);
                            if (this.m_bHasFocus) {
                                this.drawDottedRect(g, rectText.x + this.m_nWidthGap - this.m_ptViewportOrg.x, rectText.y + (cySubItem / 2 - textHeight / 2) - 1 - bounds.y - 2, selectWidth + 4, textHeight + textHeight / 4 - 1);
                            }
                        }
                        g.setXORMode(this.getBackground());
                        g.setPaintMode();
                        g.setColor(TreeBase.getTreeColor(this.txtBgHighColor, Color.black));
                    }
                    pItem = (ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem);
                    cySubItem = Math.max(textHeight, pItem.getImageBounds().height);
                    int xPos = 0;
                    int yPos = 0;
                    int rowHeight = fm.getHeight();
                    if (((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().height <= textHeight) {
                        xPos = rectText.x + this.m_nWidthGap - this.m_ptViewportOrg.x;
                        yPos = rectText.y - 2 - bounds.y + rowHeight - rowHeight / 4;
                    } else {
                        xPos = rectText.x + this.m_nWidthGap - this.m_ptViewportOrg.x;
                        yPos = rectText.y + textHeight + (cySubItem / 2 - textHeight / 2) - 1 - bounds.y - 2;
                    }
                    int i = 0;
                    while (i < nodeText.size()) {
                        g.drawString((String)nodeText.elementAt(i), xPos, yPos);
                        yPos += rowHeight;
                        yPos += rowHeight / 4;
                        ++i;
                    }
                } else {
                    int cySubItem;
                    ListItem pItem;
                    Font font = ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getFont();
                    if (font == null) {
                        font = ListBox.defaultfont;
                    }
                    g.setFont(font);
                    fm = this.getFontMetrics(font);
                    if (!this.isSelected(this.m_lvi_iItem)) {
                        g.setColor(TreeBase.getTreeColor(this.txtTxtColor, Color.black));
                    } else {
                        g.setColor(TreeBase.getTreeColor(this.txtBgHighColor, Color.black));
                        pItem = (ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem);
                        cySubItem = Math.max(textHeight, pItem.getImageBounds().height);
                        int selectWidth = fm.stringWidth(strText) + this.m_recPCRect.x + this.m_nWidthGap + this.getIndent() < ((Column)this.m_arrColumns.elementAt(0)).getWidth() ? fm.stringWidth(strText) : Math.min(this.m_recPCRect.width + 2 - this.m_recPCRect.x - this.getIndent(), fm.stringWidth(strText));
                        if (((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().height <= textHeight && this.m_arrColumns.size() == 1) {
                            g.fillRect(rectText.x - 2 + this.m_nWidthGap - this.m_ptViewportOrg.x + 1, rectText.y - bounds.y - 1, selectWidth + 3, textHeight + textHeight / 4 - 2);
                            if (this.m_bHasFocus) {
                                this.drawDottedRect(g, rectText.x - 2 + this.m_nWidthGap - this.m_ptViewportOrg.x, rectText.y - bounds.y - 2, selectWidth + 4, textHeight + textHeight / 4 - 1);
                            }
                        } else {
                            g.fillRect(rectText.x + this.m_nWidthGap - this.m_ptViewportOrg.x - 1, rectText.y + (cySubItem / 2 - textHeight / 2) - bounds.y - 2, selectWidth + 3, textHeight + textHeight / 4 - 2);
                            if (this.m_bHasFocus) {
                                this.drawDottedRect(g, rectText.x + this.m_nWidthGap - this.m_ptViewportOrg.x - 2, rectText.y + (cySubItem / 2 - textHeight / 2) - 1 - bounds.y - 2, selectWidth + 4, textHeight + textHeight / 4 - 1);
                            }
                        }
                        g.setXORMode(this.getBackground());
                        g.setPaintMode();
                        g.setColor(TreeBase.getTreeColor(this.txtHiTxtColor, Color.white));
                    }
                    g.setFont(((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getFont());
                    if (g.getFont() == null) {
                        g.setFont(ListBox.defaultfont);
                    }
                    pItem = (ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem);
                    cySubItem = Math.max(textHeight, pItem.getImageBounds().height);
                    int xPos = 0;
                    int yPos = 0;
                    int rowHeight = fm.getHeight();
                    if (((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().height <= textHeight) {
                        xPos = rectText.x + this.m_nWidthGap - this.m_ptViewportOrg.x;
                        yPos = rectText.y - 2 - bounds.y + rowHeight - rowHeight / 4;
                    } else {
                        xPos = rectText.x + this.m_nWidthGap - this.m_ptViewportOrg.x;
                        yPos = rectText.y + textHeight + (cySubItem / 2 - textHeight / 2) - 1 - bounds.y - 2;
                    }
                    if (this.m_arrColumns.size() > 1) {
                        int nTotalWidth = fm.stringWidth(strText) + ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x;
                        String str = "";
                        int nImgWidth = 0;
                        if (nTotalWidth > this.m_recPCRect.width - 2 * this.m_nWidthGap - (bounds.width - this.getInsideRect().width)) {
                            int nDotWidth = fm.stringWidth(".");
                            if (nImgWidth + this.m_nWidthGap + nDotWidth > this.m_recPCRect.width - (bounds.width - this.getInsideRect().width) || ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x > this.m_recPCRect.width - (bounds.width - this.getInsideRect().width)) {
                                nTotalWidth = nImgWidth;
                                str = " ";
                            } else if (nImgWidth + this.m_nWidthGap + 2 * nDotWidth > this.m_recPCRect.width - (bounds.width - this.getInsideRect().width)) {
                                nTotalWidth = nImgWidth + this.m_nWidthGap + nDotWidth;
                                str = ".";
                            } else if (nImgWidth + this.m_nWidthGap + 3 * nDotWidth > this.m_recPCRect.width - (bounds.width - this.getInsideRect().width)) {
                                nTotalWidth = nImgWidth + this.m_nWidthGap + 2 * nDotWidth;
                                str = "..";
                            } else {
                                int j = 0;
                                j = 1;
                                while (j < strText.length()) {
                                    nTotalWidth = nImgWidth + 2 * this.m_nWidthGap + fm.stringWidth(strText.substring(0, j - 1)) + 3 * nDotWidth + ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x;
                                    if (nTotalWidth > this.m_recPCRect.width) break;
                                    ++j;
                                }
                                if (j - 2 < 0) {
                                    j = 2;
                                }
                                str = strText.substring(0, j - 2) + "...";
                                nTotalWidth = ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x + nImgWidth + this.m_nWidthGap + fm.stringWidth(str);
                            }
                        }
                        if (fm.stringWidth(strText) + ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x > this.m_recPCRect.width - 2 * this.m_nWidthGap - this.m_recPCRect.x + bounds.x) {
                            strText = str;
                        }
                    }
                    int xPos2 = this.m_recPCRect.x + this.m_nWidthGap - this.m_ptViewportOrg.x + 2;
                    int yPos2 = this.m_recPCRect.y + ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().height - bounds.y - ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().height / 4;
                    int sLen = this.m_nWidthGap + fm.stringWidth(this.m_lvi_pszText);
                    Column tempCol = (Column)this.m_arrColumns.elementAt(this.m_lvi_iSubItem);
                    g.drawString(strText, xPos2, yPos2);
                }
            }
        } else {
            super.drawSubItem(g);
        }
    }

    public void drawTargetHighLight(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setColor(SystemColor.textHighlight);
        int index = this.getTarget(this.m_nXMouse, this.m_nYMouse);
        if (index != this.m_nOldTargetIndex) {
            if (this.m_nOldTargetIndex != -1 && !this.isSelected(this.m_nOldTargetIndex)) {
                this.m_lvi_iItem = this.m_nOldTargetIndex;
                ListItem tempItem = (ListItem)this.m_arrItems.elementAt(this.m_nOldTargetIndex);
                int selectWidth = ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().width < ((Column)this.m_arrColumns.elementAt(0)).getWidth() ? ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().width - ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x : Math.min(((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().width - ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x, ((Column)this.m_arrColumns.elementAt(0)).getWidth() - ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().x);
                g.fillRect(tempItem.getTextBounds().x + this.m_nWidthGap - 2, tempItem.getTextBounds().y - 2 - bounds.y, selectWidth, tempItem.getTextBounds().height + tempItem.getTextBounds().height / 4);
            }
            this.m_nOldTargetIndex = index;
            if (index != -1 && !this.isSelected(index)) {
                this.m_lvi_iItem = index;
                ListItem pItem = (ListItem)this.m_arrItems.elementAt(index);
                g.fillRect(pItem.getTextBounds().x + this.m_nWidthGap - 2, pItem.getTextBounds().y - 2 - bounds.y, pItem.getTextBounds().width - pItem.getTextBounds().x, pItem.getTextBounds().height + pItem.getTextBounds().height / 4);
            }
        }
    }

    protected void drawButton(Graphics g) {
        Rectangle rectButton = this.calcButtonRect();
        Node pNode = (Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData();
        if (!pNode.hasChildren()) {
            return;
        }
        int w = rectButton.width / 3;
        Point pt = new Point(rectButton.width / 2 + rectButton.x, rectButton.height / 2 + rectButton.y);
        g.setColor(this.getBackground());
        g.fillRect(rectButton.x, rectButton.y, rectButton.width, rectButton.height);
        g.setColor(this.m_colHierarchyLines);
        g.drawRect(rectButton.x, rectButton.y, rectButton.width, rectButton.height);
        g.drawLine(pt.x - w + 1, pt.y, pt.x + w, pt.y);
        if (!((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).isExpanded()) {
            g.drawLine(pt.x, pt.y - w + 1, pt.x, pt.y + w);
        }
    }

    protected Rectangle calcButtonRect() {
        Rectangle bounds = this.getBounds();
        Node pNode = this.getNodeAt(this.m_lvi_iItem);
        if (this.isRoot(pNode) || !pNode.hasChildren()) {
            return new Rectangle(0, 0, 0, 0);
        }
        ListItem pItem = super.getItemAt(this.m_lvi_iItem);
        int iDist = pNode.getDistanceFromRoot();
        int textHeight = this.measureText();
        int yMid = this.m_recPCRect.y;
        int xMid = this.m_recPCRect.x - this.m_nButtonSize + this.getIndent() * (iDist - 1) - (this.m_bLinesAtRoot ? 0 : this.getIndent());
        xMid += bounds.x;
        xMid += this.m_nWidthGap;
        yMid += pItem.getTextBounds().y + pItem.getImageBounds().height / 2 - 2;
        int w = this.m_nButtonSize;
        if (this.m_bLinesAtRoot) {
            xMid += this.getIndent();
        }
        Rectangle pRectButton = new Rectangle();
        pRectButton.x = xMid - w / 2 - bounds.x - this.m_recPCRect.x - this.m_ptViewportOrg.x;
        pRectButton.y = yMid - w / 2 - bounds.y - this.m_recPCRect.y;
        pRectButton.width = w;
        pRectButton.height = w;
        return pRectButton;
    }

    public void drawHierarchyLines(Graphics g) {
        int w;
        Rectangle bounds = this.getBounds();
        g.setColor(this.m_colHierarchyLines);
        Point pt = new Point();
        boolean bSelected = this.isSelected(this.m_lvi_iItem);
        int iOrigDist = ((Node)((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getItemData()).getDistanceFromRoot() - 1;
        boolean bLinesAtRoot = this.m_bLinesAtRoot;
        pt.y = this.m_recPCRect.y;
        ListItem tempItem = (ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem);
        if (this.m_arrImages != null && this.m_arrImages.size() > 0) {
            pt.x = -this.m_ptViewportOrg.x + this.m_nButtonSize + this.getIndent() * iOrigDist - (bLinesAtRoot ? 0 : this.getIndent());
            pt.y += tempItem.getImageBounds().y + tempItem.getImageBounds().height / 2;
            w = tempItem.getImageBounds().x - pt.x - 1 - this.m_nWidthGap - this.m_ptViewportOrg.x;
            pt.y -= bounds.y;
            pt.x += this.m_nWidthGap;
        } else {
            pt.x = -this.m_ptViewportOrg.x + this.m_nButtonSize + this.getIndent() * iOrigDist - (bLinesAtRoot ? 0 : this.getIndent());
            pt.y += tempItem.getTextBounds().y + tempItem.getTextBounds().height / 2;
            w = tempItem.getTextBounds().x - pt.x - 1;
            pt.y -= tempItem.getTextBounds().y;
            pt.y -= bounds.y;
        }
        pt.x += bounds.x;
        if ((pt.y - this.m_ptViewportOrg.y) % 2 != 0) {
            ++pt.y;
        }
        ++pt.x;
        if (!this.isRoot(this.m_lvi_iItem)) {
            this.drawHorzHierarchyLine(g, bSelected, pt.x, pt.x + w, pt.y + 3);
        }
        if (this.m_lvi_iItem > 0) {
            int temp = tempItem.getTextBounds().y;
            if (!this.isRoot(this.m_lvi_iItem)) {
                this.drawVertHierarchyLine(g, bSelected, pt.x, pt.y + 4, temp - bounds.y - 2);
            }
        }
        if (((Node)tempItem.getItemData()).hasChildren() && ((Node)tempItem.getItemData()).isExpanded()) {
            int cyOff = this.m_arrImages != null && this.m_arrImages.size() > 0 ? tempItem.getImageBounds().height / 2 : tempItem.getTextBounds().height / 2;
            this.drawVertHierarchyLine(g, bSelected, pt.x + this.getIndent(), pt.y + cyOff + 2 + 2, this.m_recPCRect.height + this.m_recPCRect.height / 4 + pt.y);
        }
        if (this.isRoot(this.m_lvi_iItem)) {
            return;
        }
        Node pParent = (Node)tempItem.getItemData();
        int i = iOrigDist + 1;
        while (i >= (bLinesAtRoot ? 0 : 1)) {
            if (pParent.getNextSibling() != null) {
                if (this.m_arrImages == null || this.m_arrImages.size() < 0) {
                    this.drawVertHierarchyLine(g, bSelected, pt.x, pt.y, tempItem.getTextBounds().height + tempItem.getTextBounds().y - bounds.y + tempItem.getTextBounds().height / 4);
                } else {
                    this.drawVertHierarchyLine(g, bSelected, pt.x, pt.y, this.m_recPCRect.height + this.m_recPCRect.y - bounds.y + this.m_recPCRect.height / 4);
                }
            }
            pParent = (Node)pParent.getParent();
            pt.x -= this.getIndent();
            pt.y = this.m_recPCRect.y - 2 - bounds.y;
            --i;
        }
    }

    public void drawVertHierarchyLine(Graphics g, boolean bSelected, int x, int y1, int y2) {
        if (y2 < y1) {
            int swap = y1;
            y1 = y2;
            y2 = swap;
        }
        x -= this.getBounds().x;
        if ((y1 + this.m_ptViewportOrg.y) % 2 != 0 && this.m_nStyleHierarchyLines == 0) {
            --y1;
        }
        if (this.m_nStyleHierarchyLines == 0) {
            this.drawDottedLine(g, x, y1, x, y2);
        } else {
            g.drawLine(x, y1, x, y2);
        }
    }

    public void drawHorzHierarchyLine(Graphics g, boolean bSelected, int x1, int x2, int y) {
        Rectangle bounds = this.getBounds();
        if ((x2 -= bounds.x) < (x1 -= bounds.x)) {
            int swap = x1;
            x1 = x2;
            x2 = swap;
        }
        if ((x1 + this.m_ptViewportOrg.x) % 2 != 0) {
            ++x1;
        }
        if (this.m_nStyleHierarchyLines == 0) {
            this.drawDottedLine(g, x1, y, x2, y);
        } else {
            g.drawLine(x1, y, x2, y);
        }
    }

    public Node getNextItem(Node item, int nRelation) {
        switch (nRelation) {
            case 0: {
                return this.getNextSiblingItem(item);
            }
            case 1: {
                return this.getPrevSiblingItem(item);
            }
            case 2: {
                return this.getChildItem(item);
            }
            case 3: {
                return this.getParentItem(item);
            }
            case 4: {
                return this.getRootItem(item);
            }
            case 6: {
                return this.getFirstVisibleItem();
            }
            case 7: {
                return this.getNextVisibleItem(item);
            }
            case 8: {
                return this.getPrevVisibleItem(item);
            }
            case 10: {
                return this.getFirstSelectedItem();
            }
            case 11: {
                return this.getNextSelectedItem(item);
            }
            case 12: {
                return this.getPrevSelectedItem(item);
            }
        }
        return null;
    }

    public Node getChildItem(Node hItem) {
        TreeNodeX pNode = new TreeNodeX();
        pNode = hItem == null ? (Node)this.m_arrRoots.elementAt(0) : hItem;
        return (Node)pNode.getFirstChild();
    }

    public Node getNextSiblingItem(Node hItem) {
        Node pNode = hItem == null ? (Node)this.m_arrRoots.elementAt(0) : hItem;
        return (Node)pNode.getNextSibling();
    }

    public Node getPrevSiblingItem(Node hItem) {
        Node pNode = hItem == null ? (Node)this.m_arrRoots.elementAt(0) : hItem;
        return (Node)pNode.getPrevSibling();
    }

    public Node getParentItem(Node hItem) {
        TreeNodeX pNode = hItem == null ? (Node)this.m_arrRoots.elementAt(0) : hItem;
        if (!this.isRoot((Node)pNode)) {
            while (pNode != null && !this.isRoot((Node)pNode.getParent())) {
                pNode = (TreeNodeX)pNode.getParent();
            }
            return (Node)pNode.getFirstChild();
        }
        return (Node)((Node)this.m_arrRoots.elementAt(0)).getFirstChild();
    }

    public Node getFirstVisibleItem() {
        Node pNode = null;
        int nNext = this.m_nTopRow;
        if (nNext != -1) {
            pNode = this.getNodeAt(nNext);
        }
        return pNode;
    }

    public Node getNextVisibleItem(Node hItem) {
        int nItem = this.nodeIndex(hItem);
        if (nItem >= 0) {
            if (++nItem < this.getItemCount()) {
                return this.getNodeAt(nItem);
            }
        } else {
            Node pNode = hItem;
            if (pNode != null) {
                pNode = (Node)pNode.getNextInDisplayOrder();
                while (pNode != null) {
                    if (pNode.isVisible()) {
                        return pNode;
                    }
                    pNode = (Node)pNode.getNextInDisplayOrder();
                }
            }
        }
        return null;
    }

    public Node getLastVisibleItem(Node hItem) {
        int iLast = this.getItemCount();
        if (iLast < 0) {
            return null;
        }
        return this.getNodeAt(iLast - 1);
    }

    public Node getPrevVisibleItem(Node hItem) {
        if (!this.isRoot(hItem)) {
            int nItem = this.nodeIndex(hItem);
            if (nItem >= 0) {
                if (--nItem != -1) {
                    return this.getNodeAt(nItem);
                }
            } else {
                Node pNode = hItem;
                while ((pNode = (Node)pNode.getPrevInDisplayOrder()) != null) {
                    if (this.nodeIndex(pNode) == -1) continue;
                    return pNode;
                }
            }
        }
        return null;
    }

    public Node getFirstSelectedItem() {
        Node pNode = null;
        if (this.getSelectedItems().length == 0) {
            return pNode;
        }
        int nIndex = this.getSelectedIndexes()[0];
        pNode = this.getNodeAt(nIndex);
        return pNode;
    }

    public Node getNextSelectedItem(Node hItem) {
        int nItem = this.nodeIndex(hItem);
        if (nItem >= 0) {
            int i = 0;
            while (i < this.getSelectedIndexes().length) {
                if (nItem == this.getSelectedIndexes()[i]) {
                    if (i == this.getSelectedIndexes().length - 1) {
                        nItem = -1;
                        break;
                    }
                    nItem = i + 1;
                    break;
                }
                ++i;
            }
            if (nItem != -1) {
                return this.getNodeAt(nItem);
            }
        } else {
            Node pNode = hItem;
            while ((pNode = (Node)pNode.getPrevInDisplayOrder()) != null) {
                if (!pNode.isVisible()) continue;
                return this.getNextSelectedItem(pNode);
            }
        }
        return null;
    }

    public Node getPrevSelectedItem(Node hItem) {
        int nItem = this.nodeIndex(hItem);
        if (nItem >= 0) {
            int i = 0;
            while (i < this.getSelectedIndexes().length) {
                if (nItem == this.getSelectedIndexes()[i]) {
                    nItem = i - 1;
                    break;
                }
                ++i;
            }
            if (nItem != -1) {
                return this.getNodeAt(nItem);
            }
        } else {
            Node pNode = hItem;
            if (pNode != null) {
                pNode = (Node)pNode.getNextInDisplayOrder();
                while (pNode != null) {
                    if (pNode.isVisible()) {
                        return this.getPrevSelectedItem(pNode);
                    }
                    pNode = (Node)pNode.getNextInDisplayOrder();
                }
            }
        }
        return null;
    }

    public Node getSelectedNode() {
        if (this.selected.length > 0 && this.selected[this.selected.length - 1] < this.m_arrItems.size()) {
            return (Node)((ListItem)this.m_arrItems.elementAt(this.selected[this.selected.length - 1])).getItemData();
        }
        return null;
    }

    public Node getRootItem(Node hti) {
        if (this.m_arrRoots == null) {
            return null;
        }
        Node pNode = hti == null ? (Node)this.m_arrRoots.elementAt(0) : hti;
        if (!this.isRoot(pNode)) {
            while (pNode != null && !this.isRoot((Node)pNode.getParent())) {
                pNode = (Node)pNode.getParent();
            }
            return (Node)pNode.getFirstChild();
        }
        return (Node)((Node)this.m_arrRoots.elementAt(0)).getFirstChild();
    }

    public Node getRootItem() {
        return this.getRootItem(null);
    }

    public Node getNextItemInDisplayOrder(Node hti) {
        Node pNode = hti;
        return (Node)pNode.getNextInDisplayOrder();
    }

    public Node getNode(ListItem pItem) {
        if (pItem == null) {
            return null;
        }
        return (Node)pItem.getItemData();
    }

    public Node getNodeAt(int nIndex) {
        ListItem pItem = super.getItemAt(nIndex);
        Node pNode = pItem != null ? (Node)pItem.getItemData() : null;
        return pNode;
    }

    public boolean isExpanded(Node hItem) {
        return hItem.isExpanded();
    }

    public boolean expand(Node htiExpand, int nCode, boolean bRedraw) {
        Node htiSelected = this.getSelectedNode();
        Node pNodeExpand = htiExpand;
        int action = nCode == 2 ? (pNodeExpand.isExpanded() ? 0 : 1) : nCode;
        int nIndex = this.nodeIndex(pNodeExpand);
        switch (action) {
            case 0: {
                if (!pNodeExpand.isExpanded()) {
                    return true;
                }
                pNodeExpand.collapse();
                Vector preCollapseList = new Vector();
                int i = 0;
                while (i < this.selected.length) {
                    preCollapseList.addElement(this.m_arrItems.elementAt(this.selected[i]));
                    ++i;
                }
                this.deselectAll(false);
                this.removeChildrenFromListCtrl(pNodeExpand, nIndex, false);
                this.selected = new int[0];
                int j = 0;
                while (j < preCollapseList.size()) {
                    this.select(this.getIndex((ListItem)preCollapseList.elementAt(j)), false);
                    ++j;
                }
                this.reMeasureAllItems();
                if (bRedraw) {
                    this.update();
                }
                this.processActionEvent(new ActionEvent(this, 3004, commandItemCollapsed));
                break;
            }
            case 1: {
                if (pNodeExpand.isExpanded()) {
                    return true;
                }
                Vector preExpandList = new Vector();
                int i = 0;
                while (i < this.selected.length) {
                    preExpandList.addElement(this.m_arrItems.elementAt(this.selected[i]));
                    ++i;
                }
                this.deselectAll(false);
                pNodeExpand.expand();
                if (pNodeExpand.hasChildren()) {
                    this.addChildrenToListCtrl(pNodeExpand, nIndex);
                    this.processActionEvent(new ActionEvent(this, 3005, commandItemExpanded));
                } else {
                    this.processActionEvent(new ActionEvent(this, 3002, commandOpenFolder));
                }
                this.selected = new int[0];
                int j = 0;
                while (j < preExpandList.size()) {
                    this.select(this.getIndex((ListItem)preExpandList.elementAt(j)), false);
                    ++j;
                }
                this.reMeasureAllItems();
                if (!bRedraw) break;
                this.update();
                break;
            }
        }
        return true;
    }

    public boolean expand(Node hItem, int nCode) {
        return this.expand(hItem, nCode, true);
    }

    protected boolean addNodeToListBox(Node pNodeAdd) {
        int nIndex;
        if (this.isRoot((Node)pNodeAdd.getParent()) && pNodeAdd.getPrevSibling() == null) {
            nIndex = 1 + this.nodeIndex((Node)pNodeAdd.getParent());
        } else {
            Node pNodeAbove = this.getPrevVisibleItem(pNodeAdd);
            if (pNodeAbove == null) {
                return false;
            }
            nIndex = this.nodeIndex(pNodeAbove);
            ++nIndex;
        }
        ListItem pItem = super.createNewItem();
        pItem.setItemData(pNodeAdd);
        pItem.setHeight(-1);
        super.insertItem(nIndex, pItem);
        if (pNodeAdd.hasChildren() && pNodeAdd.isExpanded()) {
            Node childNode = (Node)pNodeAdd.getFirstChild();
            while (childNode != null) {
                this.addNodeToListBox(childNode);
                childNode = (Node)childNode.getNextSibling();
            }
        }
        return true;
    }

    protected boolean delNodeFromListBox(Node pNodeDel) {
        return this.delNodeFromListBox(pNodeDel, true);
    }

    protected boolean delNodeFromListBox(Node pNodeDel, boolean bUpdate) {
        if (this.isRoot((Node)pNodeDel.getParent()) && pNodeDel.isVisible()) {
            return false;
        }
        int nIndex = this.nodeIndex(pNodeDel);
        super.deleteItem(nIndex, bUpdate);
        return true;
    }

    public void initRootNode(String label, int image, int imageExpanded) {
        if (this.m_arrRoots == null) {
            this.m_arrRoots = new Vector();
            this.m_arrRoots.addElement(new Node(label, image, imageExpanded));
            ((Node)this.m_arrRoots.elementAt(0)).expand();
        }
        ListItem root = new ListItem();
        root.setItemData((Node)this.m_arrRoots.elementAt(0));
        this.addItem(root);
    }

    protected void initRootNode() {
        if (this.m_arrRoots == null) {
            this.m_arrRoots.addElement(new Node());
            ((Node)this.m_arrRoots.elementAt(0)).expand();
        }
        ListItem root = new ListItem();
        root.setItemData(this.m_arrItems.elementAt(0));
        this.addItem(root);
    }

    public int createRootNode(String label, int image, int imageExpanded) {
        if (this.m_arrRoots == null) {
            this.initRootNode(label, image, imageExpanded);
            return 0;
        }
        this.m_arrRoots.addElement(new Node(label, image, imageExpanded));
        ((Node)this.m_arrRoots.elementAt(this.m_arrRoots.size() - 1)).expand();
        ListItem root = new ListItem();
        root.setItemData((Node)this.m_arrRoots.elementAt(this.m_arrRoots.size() - 1));
        this.addItem(root);
        return this.m_arrRoots.size() - 1;
    }

    public int addRootItem(Node node) {
        if (this.m_arrRoots == null) {
            this.m_arrRoots = new Vector();
        }
        this.m_arrRoots.addElement(node);
        ((Node)this.m_arrRoots.elementAt(this.m_arrRoots.size() - 1)).expand();
        ListItem root = new ListItem();
        root.setItemData((Node)this.m_arrRoots.elementAt(this.m_arrRoots.size() - 1));
        this.addItem(root);
        this.addChildrenToListCtrl((Node)this.m_arrRoots.elementAt(this.m_arrRoots.size() - 1), this.nodeIndex((Node)this.m_arrRoots.elementAt(this.m_arrRoots.size() - 1)));
        return this.m_arrRoots.size() - 1;
    }

    public int createRootNode() {
        return this.createRootNode("", -1, -1);
    }

    protected boolean deleteUnChildedItem(Node hti, boolean bDelFromListBox) {
        Node pNodeDelete = hti;
        if (pNodeDelete.getFirstChild() != null) {
            return false;
        }
        pNodeDelete.detachFromTree();
        if (bDelFromListBox && this.nodeInListBox(pNodeDelete)) {
            this.delNodeFromListBox(pNodeDelete);
        }
        return true;
    }

    protected boolean deletedUnChildedItem(Node hti) {
        return this.deleteUnChildedItem(hti, true);
    }

    protected boolean nodeInListBox(Node pNode) {
        return this.nodeIndex(pNode) != -1;
    }

    protected Node expandSelectedItem(int nCode) {
        Node hti = this.getSelectedNode();
        if (!this.expand(hti, nCode)) {
            return null;
        }
        return hti;
    }

    protected int addChildrenToListCtrl(Node pParent, int nIndex) {
        ListItem pItem = new ListItem();
        if (nIndex == -1) {
            return nIndex;
        }
        Node pNode = (Node)pParent.getFirstChild();
        while (pNode != null) {
            pItem = this.createNewItem();
            pItem.setItemData(pNode);
            super.insertItem(++nIndex, pItem);
            if (pNode.isExpanded() && pNode.hasChildren()) {
                nIndex = this.addChildrenToListCtrl(pNode, nIndex++);
            }
            pNode = (Node)pNode.getNextSibling();
        }
        return nIndex;
    }

    protected void removeChildrenFromListCtrl(Node pParent, int nParent) {
        this.removeChildrenFromListCtrl(pParent, nParent, true);
    }

    protected void removeChildrenFromListCtrl(Node pParent, int nParent, boolean bUpdate) {
        Node pNode;
        if (nParent == -1) {
            return;
        }
        int cCount = 0;
        int nIndex = nParent + 1;
        while (nIndex < this.getItemCount()) {
            pNode = this.getNodeAt(nIndex);
            if (!pParent.isDescendant(pNode)) break;
            ++nIndex;
            ++cCount;
        }
        int nLast = nParent + 1 + cCount - 1;
        int i = this.selected.length - 1;
        while (i >= 0) {
            int nTempIndex;
            int val = this.selected[i];
            if (val > nParent && val < nLast && this.isSelected(nTempIndex = this.nodeIndex(pNode = this.getNodeAt(val)))) {
                this.deselect(nTempIndex);
            }
            --i;
        }
        if (cCount > 0) {
            if (bUpdate) {
                super.deleteItem(nParent + 1, cCount);
            } else {
                super.deleteItem(nParent + 1, cCount, false);
            }
        }
    }

    protected int nodeIndex(Node pNode, int nStartFrom) {
        int i = nStartFrom;
        while (i < this.getItemCount()) {
            if (pNode == this.getNodeAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int nodeIndex(Node pNode) {
        return this.nodeIndex(pNode, 0);
    }

    protected boolean shouldBeInListBox(Node pNode) {
        return ((Node)pNode.getParent()).isExpanded() && this.nodeIndex((Node)pNode.getParent()) != -1;
    }

    public void moveItems(Object[] items, int targetIndex) {
        if (targetIndex == -1) {
            return;
        }
        int j = items.length - 1;
        while (j > -1) {
            if (items[j] == this.m_arrItems.elementAt(targetIndex)) {
                return;
            }
            if (((Node)((ListItem)this.m_arrItems.elementAt(targetIndex)).getItemData()).isAncestor((Node)((ListItem)items[j]).getItemData())) {
                return;
            }
            if (((Node)((ListItem)items[j]).getItemData()).isParent((Node)((ListItem)this.m_arrItems.elementAt(targetIndex)).getItemData())) {
                return;
            }
            if (this.isRoot((Node)((ListItem)items[j]).getItemData())) {
                return;
            }
            --j;
        }
        this.deselectAll(false);
        int nSelect = targetIndex;
        int i = items.length - 1;
        while (i > -1) {
            Node tempNode;
            if (this.getIndex((ListItem)items[i]) < targetIndex) {
                --targetIndex;
            }
            if ((tempNode = (Node)((ListItem)items[i]).getItemData()).hasChildren()) {
                this.removeChildrenFromListCtrl(tempNode, this.nodeIndex(tempNode), false);
            }
            this.delNodeFromListBox(tempNode, false);
            tempNode.detachFromTree();
            ((Node)((ListItem)this.m_arrItems.elementAt(targetIndex)).getItemData()).addChild(tempNode);
            if (this.shouldBeInListBox(tempNode)) {
                this.addNodeToListBox(tempNode);
            }
            --i;
        }
    }

    public void editItem() {
        Rectangle bounds = this.getBounds();
        this.m_bEditModeEnabled = false;
        this.m_bDragModeEnabled = false;
        if (this.selected.length > 1) {
            int temp = this.selected[this.selected.length - 1];
            this.selected = new int[0];
            this.select(temp);
        }
        this.m_nodeCurrentEdit = this.getSelectedNode();
        ListItem item = (ListItem)this.m_arrItems.elementAt(this.selected[this.selected.length - 1]);
        this.m_textEditNode = new ExpandableText(this.m_nodeCurrentEdit.getText());
        this.m_textEditNode.setBorderStyle(3);
        this.m_textEditNode.setTextHIndent(1);
        this.m_textEditNode.setTextVIndent(2);
        this.m_textEditNode.selectAll();
        this.m_textEditNode.setBorderColor(Color.black);
        Font font = this.m_nodeCurrentEdit.getFont();
        if (font == null) {
            font = ListBox.defaultfont;
        }
        this.m_textEditNode.setFont(font);
        this.m_textEditNode.selectAll();
        this.m_textEditNode.addActionListener(this);
        this.m_nodeCurrentEdit.setText("");
        this.add(this.m_textEditNode);
        this.m_textEditNode.requestFocus();
        this.m_textEditNode.setBounds(item.getTextBounds().x - 2 + this.m_nWidthGap - this.m_ptViewportOrg.x, item.getTextBounds().y - bounds.y - 2, item.getTextBounds().width + 2, item.getTextBounds().height + item.getTextBounds().height / 4);
        this.m_textEditNode.update();
    }

    protected void changeItemText() {
        this.m_nodeCurrentEdit.setText(this.m_textEditNode.getText());
        this.remove(this.m_textEditNode);
        this.m_textEditNode = null;
        this.measureItem(this.nodeIndex(this.m_nodeCurrentEdit), this.getGraphics());
        this.updateScrollbar();
    }

    protected int getSelected(int x1, int y1) {
        int hitItem;
        if (this.m_textEditNode != null && this.m_textEditNode.isShowing()) {
            this.changeItemText();
        }
        if ((hitItem = super.getSelected(x1, y1)) > -1) {
            ListItem tempItem = this.getItemAt(hitItem);
            Node tempNode = (Node)tempItem.getItemData();
            Font font = tempNode.getFont();
            if (font == null) {
                font = ListBox.defaultfont;
            }
            FontMetrics fm = this.getGraphics().getFontMetrics(font);
            int textWidth = 0;
            textWidth = fm.stringWidth(tempNode.getText()) < tempItem.getTextBounds().width ? fm.stringWidth(tempNode.getText()) : tempItem.getTextBounds().width;
            Rectangle hitRect = new Rectangle(tempItem.getTextBounds().x - 2 + this.m_nWidthGap, y1 - 2, textWidth, 4);
            if (this.m_arrImages != null && this.m_arrImages.size() > 0) {
                hitRect.width += tempItem.getImageBounds().width;
                hitRect.width += this.getIndent() / 2;
                hitRect.x = tempItem.getImageBounds().x - this.m_ptViewportOrg.x;
            }
            if (hitRect.contains(x1, y1)) {
                if (this.isSelected(hitItem)) {
                    hitRect.x = tempItem.getTextBounds().x - 2 + this.m_nWidthGap - this.m_ptViewportOrg.x;
                    if (hitRect.contains(x1, y1)) {
                        if (this.selected.length > 1 && this.m_bEditModeEnabled && !this.m_bDragModeEnabled) {
                            this.selected = new int[0];
                            this.select(hitItem, false);
                        }
                        if (this.m_bEditModeAllowed) {
                            this.m_bEditModeEnabled = true;
                        }
                    }
                    return hitItem;
                }
                return hitItem;
            }
            this.m_lvi_iItem = hitItem;
            this.m_recPCRect = new Rectangle(tempItem.getTextBounds().x - 2 + this.m_nWidthGap, y1 - 2, textWidth, 4);
            Rectangle buttonRect = this.calcButtonRect();
            if (buttonRect.contains(x1, y1)) {
                this.expand(tempNode, 2, true);
                this.m_bEditModeEnabled = false;
                this.m_bDragModeEnabled = false;
                return -1;
            }
        }
        return -1;
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
            return;
        }
        Node tempEventTarget = this.getSelectedNode();
        Container parent = this.getParent();
        if (parent != null) {
            if (e.getActionCommand().equals(commandDragDrop)) {
                int eventID = 3001;
            } else if (e.getActionCommand().equals(commandOpenFolder)) {
                int eventID = 3002;
            } else if (e.getActionCommand().equals(commandSelectionChanged)) {
                int eventID = 3003;
            } else if (e.getActionCommand().equals(commandItemCollapsed)) {
                int eventID = 3004;
                tempEventTarget = this.m_itemEventTarget;
            } else if (e.getActionCommand().equals(commandItemExpanded)) {
                int eventID = 3005;
                tempEventTarget = this.m_itemEventTarget;
            } else if (e.getActionCommand().equals(this.commandDoubleClicked)) {
                int eventID = 3006;
            } else {
                int eventID = 3000;
            }
            parent.dispatchEvent(e);
        }
    }

    protected int getTarget(int x, int y) {
        return super.getSelected(x, y);
    }

    protected void processKeyEvent(KeyEvent e) {
        int key = e.getKeyCode();
        if (e.getID() == 401) {
            switch (key) {
                case 37: {
                    if (this.getSelectedNode() != null && this.getSelectedNode().isExpanded()) {
                        this.expand(this.getSelectedNode(), 0, true);
                        this.prev = this.nodeIndex(this.getSelectedNode());
                        break;
                    }
                    return;
                }
                case 39: {
                    if (this.getSelectedNode() != null) {
                        if (!this.getSelectedNode().isExpanded()) {
                            this.expand(this.getSelectedNode(), 1, true);
                            this.prev = this.nodeIndex(this.getSelectedNode());
                        }
                        this.reMeasureAllItems();
                        this.update();
                    }
                    return;
                }
            }
        }
        if (key != 39 && key != 37) {
            super.processKeyEvent(e);
        }
    }

    protected void doubleClickEvent(int itemHit) {
        if (itemHit == -1) {
            return;
        }
        this.expand(this.getNodeAt(itemHit), 2, true);
    }

    public synchronized void delNode(Node pChild, boolean pUpdate) {
        TreeItem ti = (TreeItem)pChild;
        if (ti == null) {
            return;
        }
        if (ti.getIndex() > -1) {
            this.delNodeFromListBox(pChild, pUpdate);
            ti.detachFromTree();
        } else {
            this.deleteItem(ti);
        }
    }

    public void delParentNode(Node parentNode, boolean bUpdate) {
        TreeItem ti = (TreeItem)parentNode;
        this.delNodeFromListBox(parentNode, bUpdate);
        ti.detachFromTree();
    }

    public void deleteItem(TreeItem item) {
        if (item == null || this.isRoot(item)) {
            return;
        }
        TreeItem temp = (TreeItem)item.getParent();
        item.deleteAllChildren();
        this.removeChildrenFromListCtrl(item, item.getIndex());
        this.delNodeFromListBox(item, false);
        item.detachFromTree();
    }

    public void setTextColor(String txtHiC, String txtHiTxtC, String txtTxtC) {
        this.txtBgHighColor = txtHiC;
        this.txtHiTxtColor = txtHiTxtC;
        this.txtTxtColor = txtTxtC;
    }

    static Color getTreeColor(String userColor, Color defColor) {
        try {
            return Color.decode(userColor);
        }
        catch (Exception e) {
            return defColor;
        }
    }
}

