/*
 * Decompiled with CFR 0.152.
 */
package ob.text;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.StringTokenizer;
import java.util.Vector;
import ob.text.OBLabel;
import ob.text.Paragraph;

public class Text
extends OBLabel
implements Runnable,
ClipboardOwner {
    protected Point cursorPoint;
    protected ActionListener actionListener;
    protected TextListener textListener;
    protected TextEvent textEvent = new TextEvent(this, 900);
    protected TextEvent textEventEnter = new TextEvent(this, 900);
    protected ActionEvent actionEventEnter = new ActionEvent(this, 1001, endEditing);
    Point selectionStart;
    Point selectionEnd;
    Thread m_tCursor;
    Color m_cCursorColor;
    Point cursor;
    boolean m_bAllowHScroll = true;
    boolean m_bEditable = true;
    boolean m_bModified = false;
    transient Clipboard clipboard = new Clipboard("BlendTextComponentClipboard");
    int m_nCursorWidth = 2;
    boolean AllowEnter = false;
    public String textModified = "textModified";
    public String cursorMovedOutOfBound = "cursorMovedOutOfBound";
    public static String endEditing = "End_Editing";

    public Text() {
        this("");
    }

    public Text(String s) {
        super(s);
        this.setBorderStyle(1);
        this.m_inTextInsets.top = 3;
        this.m_inTextInsets.left = 3;
        this.cursorPoint = new Point(0, 0);
        this.cursor = new Point(0, 0);
        this.m_cCursorColor = Color.black;
        this.selectionStart = new Point(0, 0);
        this.selectionEnd = new Point(0, 0);
        this.setAutoWrap(false);
        this.setInsets(this.m_inTextInsets);
        this.setAllowHScroll(true);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(4L);
        this.enableEvents(8L);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void addTextListener(TextListener l) {
        this.textListener = AWTEventMulticaster.add(this.textListener, l);
    }

    protected void copy() {
        if (!this.isSelected()) {
            return;
        }
        String str = this.getSelectedText();
        this.setClipboardText(str);
    }

    protected void cut(boolean copy) {
        if (!this.isSelected()) {
            return;
        }
        if (copy) {
            String clipText = this.getSelectedText();
            this.setClipboardText(clipText);
        }
        Point start = this.selectionStart;
        Point end = this.selectionEnd;
        if (end.y < start.y || start.y == end.y && start.x > end.x) {
            Point temp = start;
            start = end;
            end = temp;
        }
        String str = new String();
        int i = start.y;
        while (i <= end.y) {
            String s;
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            if (i == start.y) {
                s = p.getText();
                str = str + s.substring(0, start.x);
            }
            if (i == end.y) {
                s = p.getText();
                str = str + s.substring(end.x);
            }
            ++i;
        }
        ((Paragraph)this.m_vParagraphs.elementAt(start.y)).setText(str);
        int i2 = start.y + 1;
        while (i2 <= end.y) {
            this.m_vParagraphs.removeElement((Paragraph)this.m_vParagraphs.elementAt(start.y + 1));
            ++i2;
        }
        this.unselectAll();
        this.start();
        this.cursorPoint.y = start.y;
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(start.y);
        p.moveSpecial(true, p.getCursorPoint().x, 0);
        p.setCursorPos(start.x);
        this.y_offset = this.prevYOffset;
        this.repaint();
    }

    protected Paragraph findParagraph(int y, boolean b) {
        int marker = 0;
        y += this.y_offset;
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            if (y < (marker += p.getYSpan())) {
                return p;
            }
            ++i;
        }
        return b ? (Paragraph)this.m_vParagraphs.lastElement() : null;
    }

    protected int findYCoord(Paragraph p) {
        int y = this.m_inTextInsets.top;
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph pg = (Paragraph)this.m_vParagraphs.elementAt(i);
            if (pg == p) break;
            y += pg.getYSpan();
            ++i;
        }
        return y;
    }

    public boolean getAllowHScroll() {
        return this.m_bAllowHScroll && this.getHAlign() == 1 && !this.isAutoWrap();
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public int getCursorPos() {
        return ((Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).getCursorPos();
    }

    public int getCursorWidth() {
        return this.m_nCursorWidth;
    }

    public boolean getModified() {
        return this.m_bModified;
    }

    public String getSelectedText() {
        String str = new String();
        if (!this.isSelected()) {
            return str;
        }
        Point start = this.selectionStart;
        Point end = this.selectionEnd;
        if (end.y < start.y || start.y == end.y && start.x > end.x) {
            Point temp = start;
            start = end;
            end = temp;
        }
        int i = start.y;
        while (i <= end.y) {
            String s;
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            if (i == start.y && start.y == end.y) {
                s = p.getText();
                str = str + s.substring(start.x, end.x);
            } else {
                if (i == start.y) {
                    s = p.getText();
                    str = str + s.substring(start.x);
                }
                if (i == end.y) {
                    s = p.getText();
                    str = str + s.substring(0, end.x);
                }
                if (i != start.y && i != end.y && i > start.y && i < end.y) {
                    str = str + p.getText();
                }
            }
            str = str + "\n";
            ++i;
        }
        str = str.substring(0, str.length() - 1);
        return str;
    }

    public int getSelectionEnd() {
        return Math.max(this.selectionStart.x, this.selectionEnd.x);
    }

    public int getSelectionStart() {
        return Math.min(this.selectionStart.x, this.selectionEnd.x);
    }

    protected void gotFocus() {
        if (this.m_bEditable) {
            this.start();
            int i = 0;
            while (i < this.m_vParagraphs.size()) {
                ((Paragraph)this.m_vParagraphs.elementAt(i)).setMarkVisible(true);
                ++i;
            }
            this.repaint();
        }
    }

    protected boolean insertChar(char c) {
        Paragraph p;
        if (c == '\uffff') {
            return false;
        }
        if (this.m_vParagraphs == null || this.cursorPoint.y < 0 || this.cursorPoint.y > this.m_vParagraphs.size() - 1) {
            return false;
        }
        if (this.isSelected()) {
            this.cut(false);
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            this.start();
        }
        if ((p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).insertChar(c, !this.m_bAllowHScroll && !this.isAutoWrap())) {
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            this.update();
            return true;
        }
        return false;
    }

    public boolean isAllowEnter() {
        return false;
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public boolean isFocusTraversable() {
        return this.m_bEditable;
    }

    public boolean isModified() {
        return this.m_bModified;
    }

    private boolean isNotBreakChar(char c) {
        boolean res = true;
        switch (c) {
            case ' ': 
            case '!': 
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case '?': {
                res = false;
            }
        }
        return res;
    }

    public boolean isSelected() {
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            if (((Paragraph)this.m_vParagraphs.elementAt(i)).getSelectionState() != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void lostFocus() {
        if (this.m_bEditable) {
            this.stop();
            int i = 0;
            while (i < this.m_vParagraphs.size()) {
                ((Paragraph)this.m_vParagraphs.elementAt(i)).setMarkVisible(false);
                ++i;
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(this.actionEventEnter);
            }
            this.repaint();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected void onBackspaceKey() {
        if (this.isSelected()) {
            this.cut(false);
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            this.start();
        } else {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            if (this.getAllowHScroll() && p.getCursorPos() == 0) {
                if (p.getXOffset() > 0) {
                    p.setXOffset(0);
                    this.repaint();
                }
                return;
            }
            if (p.getCursorPos() == 0) {
                return;
            }
            p.onBackspaceKey();
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
        }
        this.repaint();
    }

    protected void onDeleteKey() {
        if (this.isSelected()) {
            this.cut(false);
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            this.start();
        } else {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            if (p.isCursorAtEnd()) {
                return;
            }
            p.onDeleteKey();
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
        }
        this.repaint();
    }

    protected void onDoubleClicked() {
        this.selectWord();
    }

    protected void onDownKey(int mod) {
    }

    protected void onEndKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        int pos = p.getCursorPos();
        this.stop();
        String s = p.getText();
        p.setCursorPos(s.length());
        if (p.getFontMetrics().stringWidth(s) > this.getSize().width) {
            int n = p.getFontMetrics().stringWidth(s) - this.getSize().width + 15;
            p.setXOffset(n);
        }
        if (mod == 1) {
            if (p.getSelectionState() == 0) {
                p.setSelectionState(1);
                p.setSelectionStart(pos);
                this.selectionStart.x = pos;
            }
            this.selectionEnd.x = p.getText().length();
            p.setSelectionEnd(p.getText().length());
        } else {
            if (p.getSelectionState() != 0) {
                p.setSelectionState(0);
            }
            this.start();
        }
        this.repaint();
    }

    protected void onEnterKey() {
        if (this.textListener != null) {
            this.textListener.textValueChanged(this.textEventEnter);
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(this.actionEventEnter);
        }
    }

    protected void onHomeKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        int pos = p.getCursorPos();
        this.stop();
        p.setCursorPos(0);
        p.setXOffset(0);
        if (mod == 1) {
            if (p.getSelectionState() == 0) {
                p.setSelectionState(1);
                p.setSelectionStart(pos);
                this.selectionStart.x = pos;
            }
            this.selectionEnd.x = 0;
            p.setSelectionEnd(0);
        } else {
            if (p.getSelectionState() != 0) {
                p.setSelectionState(0);
            }
            this.start();
        }
        this.repaint();
    }

    protected void onLeftKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        int pos = p.getCursorPos();
        if (pos == 0) {
            if (p.getXOffset() > 0) {
                this.setXOffset(0);
                this.repaint();
            }
            return;
        }
        p.setCursorPos(--pos);
        if (mod == 1) {
            if (p.getSelectionState() == 0) {
                p.setSelectionState(1);
                p.setSelectionStart(pos + 1);
                this.selectionStart.x = pos + 1;
            }
            this.selectionEnd.x = pos;
            p.setSelectionEnd(pos);
        } else if (this.isSelected()) {
            p.setSelectionState(0);
            p.setCursorPos(Math.min(this.selectionStart.x, this.selectionEnd.x));
        }
        if (this.m_bAllowHScroll && this.getHAlign() == 1 && !this.isAutoWrap() && p.getCursorPoint().x < this.m_inTextInsets.left + 2) {
            int offset = p.getXOffset() - this.getSize().width / 2;
            if (offset < 0) {
                offset = 0;
            }
            p.setXOffset(offset);
        }
        this.repaint();
    }

    public void setXOffset(int n) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        p.setXOffset(n);
    }

    protected void onMovement() {
        this.repaint();
    }

    protected void onRightKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        int pos = p.getCursorPos();
        if (pos == p.getText().length()) {
            return;
        }
        this.stop();
        p.setCursorPos(++pos);
        if (this.m_bAllowHScroll) {
            p.onScrollAction();
        }
        if (mod == 1) {
            if (p.getSelectionState() == 0) {
                p.setSelectionState(1);
                p.setSelectionStart(pos - 1);
                this.selectionStart.x = pos - 1;
                if (this.m_bAllowHScroll) {
                    p.setPrevXOffset(p.getXOffset());
                }
            }
            this.selectionEnd.x = pos;
            p.setSelectionEnd(pos);
        } else {
            if (p.getSelectionState() != 0) {
                p.setSelectionState(0);
                p.setCursorPos(Math.max(this.selectionStart.x, this.selectionEnd.x));
            }
            this.start();
        }
        this.repaint();
    }

    protected void onTripleClicked() {
        this.selectAll();
    }

    protected void onUpKey(int mod) {
    }

    protected void paintCursor(boolean b) {
        if (this.m_vParagraphs == null || this.cursorPoint.y < 0 || this.cursorPoint.y > this.m_vParagraphs.size() - 1) {
            return;
        }
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        Point pt = p.getCursorPoint();
        if (this.y_offset == 0 && this.m_nVAlign != 1) {
            int h1 = this.getSize().height;
            int h2 = 0;
            int i = 0;
            while (i < this.m_vParagraphs.size()) {
                h2 += ((Paragraph)this.m_vParagraphs.elementAt(i)).getYSpan();
                ++i;
            }
            if (this.m_nVAlign == 3) {
                pt.y += h1 / 2 - h2 / 2;
            } else if (this.m_nVAlign == 2) {
                pt.y += h1 - h2 - this.m_inTextInsets.bottom;
            }
        }
        if (this.m_nVAlign == 1) {
            pt.y += this.m_inTextInsets.top;
        }
        pt.y -= this.y_offset;
        Dimension d = this.getSize();
        int i = 0;
        while (i < this.cursorPoint.y) {
            Paragraph pg = (Paragraph)this.m_vParagraphs.elementAt(i);
            if (pg.isVisible()) {
                pt.y += pg.getYSpan();
            }
            ++i;
        }
        pt.x += 2;
        pt.y += 2;
        g.setXORMode(this.getBackground());
        Font f = p.getFont();
        if (f == null) {
            f = this.getFont();
        }
        FontMetrics fm = this.getFontMetrics(f);
        g.setColor(this.m_cCursorColor);
        int h = fm.getHeight() - 3;
        g.fillRect(pt.x, pt.y, this.m_nCursorWidth, h);
        g.setPaintMode();
    }

    protected void paste() {
        Transferable content = this.clipboard.getContents(this);
        if (this.isSelected()) {
            this.cut(false);
            this.unselectAll();
            this.start();
        }
        if (content != null) {
            try {
                String data = (String)content.getTransferData(DataFlavor.stringFlavor);
                StringTokenizer st = new StringTokenizer(data, "\n", false);
                data = st.nextToken();
                Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
                int pos = p.getCursorPos();
                String text = p.getText();
                String partb4 = text.substring(0, pos);
                String after = text.substring(pos);
                p.setText(partb4 + data);
                p.setCursorPos(pos + data.length());
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    p = new Paragraph(this, s);
                    p.setFont(this.getFont());
                    p.setFontMetrics(this.getFontMetrics(this.getFont()));
                    p.setWidth(this.getSize().width - this.m_nWidthOffset);
                    p.setForeground(this.getForeground());
                    p.setBackground(this.getBackground());
                    p.setInsets(this.m_inTextInsets);
                    this.m_vParagraphs.insertElementAt(p, this.cursorPoint.y + 1);
                    ++this.cursorPoint.y;
                }
                p.setText(p.getText() + after);
                p.setCursorPos(p.getText().length() - after.length());
                this.repaint();
            }
            catch (Exception e) {
                System.out.println("Couldn't get contents in format: " + DataFlavor.stringFlavor.getHumanPresentableName());
            }
        }
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            this.gotFocus();
        } else if (e.getID() == 1005) {
            this.lostFocus();
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        int key;
        super.processKeyEvent(e);
        if (!this.m_bEditable) {
            return;
        }
        if (e.getID() == 401 && (key = e.getKeyCode()) != 27) {
            if (key == 9) {
                this.transferFocus();
            } else if (key == 37) {
                this.onLeftKey(e.getModifiers());
            } else if (key == 39) {
                this.onRightKey(e.getModifiers());
            } else if (key == 38) {
                this.onUpKey(e.getModifiers());
            } else if (key == 40) {
                this.onDownKey(e.getModifiers());
            } else if (key == 36) {
                this.onHomeKey(e.getModifiers());
            } else if (key == 35) {
                this.onEndKey(e.getModifiers());
            } else if (key == 8) {
                this.onBackspaceKey();
            } else if (key == 127) {
                this.onDeleteKey();
            } else if (key == 10) {
                this.onEnterKey();
            } else if (key != 33 && key != 34) {
                if (e.getModifiers() == 2 && key == 67) {
                    this.copy();
                } else if (e.getModifiers() == 2 && key == 88) {
                    this.cut(true);
                } else if (e.getModifiers() == 2 && key == 86) {
                    this.paste();
                } else {
                    this.insertChar(e.getKeyChar());
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (!this.m_bEditable) {
            return;
        }
        Point p = e.getPoint();
        if (e.getID() == 501) {
            this.requestFocus();
            this.setCursorPosition(p.x, p.y);
            this.unselectAll();
            this.repaint();
            try {
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e.getClickCount() == 2) {
                this.onDoubleClicked();
            } else if (e.getClickCount() == 3) {
                this.onTripleClicked();
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (!this.m_bEditable) {
            return;
        }
        Point pt = e.getPoint();
        if (e.getID() == 506) {
            this.stop();
            Paragraph pg = this.findParagraph(pt.y, true);
            pt.x -= this.m_inTextInsets.left;
            this.selectionEnd.y = this.m_vParagraphs.indexOf(pg);
            pt.y += this.y_offset;
            int i = 0;
            while (i < this.selectionEnd.y) {
                pt.y -= ((Paragraph)this.m_vParagraphs.elementAt(i)).getYSpan();
                ++i;
            }
            if (this.y_offset == 0 && this.m_nVAlign != 1) {
                int h1 = this.getSize().height;
                int h2 = 0;
                int i2 = 0;
                while (i2 < this.m_vParagraphs.size()) {
                    h2 += ((Paragraph)this.m_vParagraphs.elementAt(i2)).getYSpan();
                    ++i2;
                }
                if (this.m_nVAlign == 3) {
                    pt.y -= (h1 - h2) / 2;
                } else if (this.m_nVAlign == 2) {
                    pt.y -= h1 - h2;
                }
            }
            this.selectionEnd.x = pg.getCursorPosFromPoint(pt);
            pg.setCursorPos(this.selectionEnd.x);
            this.cursorPoint.y = this.selectionEnd.y;
            this.cursorPoint.x = this.selectionEnd.x;
            if (this.m_bAllowHScroll) {
                pg.onScrollAction();
            }
            Point start = new Point(this.selectionStart);
            Point end = new Point(this.selectionEnd);
            if (end.y < start.y || end.y == start.y && end.x < start.x) {
                Point temp = new Point(start);
                start = end;
                end = temp;
            }
            int i3 = 0;
            while (i3 < this.m_vParagraphs.size()) {
                Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i3);
                if (i3 < start.y || i3 > end.y) {
                    p.setSelectionState(0);
                } else if (start.y == end.y) {
                    p.setSelectionState(1);
                    p.setSelectionStart(start.x);
                    p.setSelectionEnd(end.x);
                } else {
                    int j = start.y;
                    while (j <= end.y) {
                        Paragraph pp = (Paragraph)this.m_vParagraphs.elementAt(j);
                        if (j == start.y) {
                            pp.setSelectionState(1);
                            pp.setSelectionStart(start.x);
                            pp.setSelectionEnd(pp.getText().length());
                        } else if (j == end.y) {
                            pp.setSelectionState(1);
                            pp.setSelectionStart(0);
                            pp.setSelectionEnd(end.x);
                        } else {
                            pp.setSelectionState(2);
                        }
                        ++j;
                    }
                    i3 = end.y;
                }
                ++i3;
            }
            this.repaint();
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void removeTextListener(TextListener l) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, l);
    }

    public void run() {
        boolean blink = true;
        while (true) {
            this.paintCursor(blink);
            blink = !blink;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void select(int from, int to) {
        if (this.m_vParagraphs == null || this.m_vParagraphs.size() == 0) {
            return;
        }
        this.stop();
        this.selectionStart = new Point(from, 0);
        this.selectionEnd = new Point(to, 0);
        Paragraph p = (Paragraph)this.m_vParagraphs.firstElement();
        p.setSelectionStart(from);
        p.setSelectionEnd(to);
        p.setCursorPos(to);
        if (from == to) {
            p.setSelectionState(0);
            this.start();
        } else {
            p.setSelectionState(1);
        }
        this.repaint();
    }

    public void selectAll() {
        this.stop();
        this.selectionStart = new Point(0, 0);
        this.selectionEnd = new Point(((Paragraph)this.m_vParagraphs.lastElement()).getText().length(), this.m_vParagraphs.size() - 1);
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.setSelectionState(2);
            p.setMarkVisible(true);
            ++i;
        }
        this.repaint();
    }

    public void selectWord() {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        String s = p.getText();
        if (s.length() == 0) {
            return;
        }
        this.stop();
        int start = this.cursorPoint.x;
        int end = this.cursorPoint.x;
        if (end == 0) {
            end = 1;
        }
        while (start > 0 && this.isNotBreakChar(s.charAt(start - 1))) {
            --start;
        }
        while (end < s.length() && this.isNotBreakChar(s.charAt(end))) {
            ++end;
        }
        this.selectionStart = new Point(start, this.cursorPoint.y);
        this.selectionEnd = new Point(end, this.cursorPoint.y);
        p.setSelectionState(1);
        p.setSelectionStart(start);
        p.setSelectionEnd(end);
        this.repaint();
    }

    public void setAllowEnter(boolean b) {
    }

    public void setAllowHScroll(boolean b) {
        this.m_bAllowHScroll = b && this.getHAlign() == 1 && !this.isAutoWrap();
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.setAllowScroll(this.m_bAllowHScroll);
            ++i;
        }
    }

    public void setClipboard(Clipboard bd) {
        this.clipboard = bd;
    }

    protected void setClipboardText(String text) {
        if (text != null) {
            StringSelection contents = new StringSelection(text);
            this.clipboard.setContents(contents, this);
        }
    }

    public void setCursorPos(int x) {
        ((Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).setCursorPos(x);
        this.cursorPoint.x = x;
    }

    protected void setCursorPosition(int x, int y) {
        int i;
        y -= this.m_inTextInsets.top;
        if (this.y_offset == 0 && this.m_nVAlign != 1) {
            int h1 = this.getSize().height;
            int h2 = 0;
            i = 0;
            while (i < this.m_vParagraphs.size()) {
                h2 += ((Paragraph)this.m_vParagraphs.elementAt(i)).getYSpan();
                ++i;
            }
            if (this.m_nVAlign == 3) {
                y -= (h1 - h2) / 2;
            } else if (this.m_nVAlign == 2) {
                y -= h1 - h2;
            }
        }
        Point p = new Point(x, y);
        Paragraph pg = this.findParagraph(p.y, true);
        this.cursorPoint.y = this.m_vParagraphs.indexOf(pg);
        p.y -= this.m_inTextInsets.top;
        p.y += this.y_offset;
        i = 0;
        while (i < this.cursorPoint.y) {
            p.y -= ((Paragraph)this.m_vParagraphs.elementAt(i)).getYSpan();
            ++i;
        }
        this.cursorPoint.x = pg.getCursorPosFromPoint(p);
        pg.setCursorPos(this.cursorPoint.x);
        this.selectionStart.x = this.cursorPoint.x;
        this.selectionStart.y = this.cursorPoint.y;
        this.selectionEnd.x = this.cursorPoint.x;
        this.selectionEnd.y = this.cursorPoint.y;
    }

    public void setCursorWidth(int w) {
        if (w < 0) {
            return;
        }
        this.m_nCursorWidth = w;
    }

    public void setEditable(boolean b) {
        this.m_bEditable = b;
    }

    public void setHAlign(int align) {
        if (align != 1) {
            this.setAllowHScroll(false);
        }
        super.setHAlign(align);
    }

    public void setModified(boolean b) {
        this.m_bModified = b;
    }

    public void setText(String t, boolean repaint) {
        if (t == null) {
            t = "";
        }
        if (this.m_vParagraphs.size() > 0) {
            this.m_vParagraphs.removeAllElements();
        }
        Paragraph p = new Paragraph(this, t);
        p.setFont(this.getFont());
        p.setFontMetrics(this.getFontMetrics(this.getFont()));
        p.setBackground(this.getBackground());
        p.setForeground(this.getForeground());
        p.setWidth(this.getSize().width - this.m_nWidthOffset);
        p.setInsets(this.m_inTextInsets);
        p.setHAlign(this.getHAlign());
        p.setAutoWrap(this.isAutoWrap());
        p.setAllowScroll(this.getAllowHScroll());
        this.m_vParagraphs.addElement(p);
        if (repaint) {
            this.repaint();
        }
    }

    public void start() {
        if (this == null) {
            return;
        }
        if (this.m_tCursor == null) {
            this.m_tCursor = new Thread(this);
            this.m_tCursor.start();
        }
    }

    public void stop() {
        if (this.m_tCursor != null) {
            this.m_tCursor.stop();
            this.m_tCursor = null;
        }
    }

    protected void unselectAll() {
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            ((Paragraph)this.m_vParagraphs.elementAt(i)).setSelectionState(0);
            ++i;
        }
    }

    public void update() {
        this.repaint();
    }

    public static Vector wrapText(String string, int width, boolean bAutoWrap, FontMetrics fm) {
        Vector<String> v = new Vector<String>();
        int first = 0;
        int nStringLength = 0;
        if (bAutoWrap) {
            int i = 0;
            while (i < string.length()) {
                if (string.charAt(i) == '\n' || (nStringLength += fm.charWidth(string.charAt(i))) > width) {
                    int nWord = i;
                    while (nWord > first && string.charAt(nWord) != '\n' && string.charAt(nWord) != ' ') {
                        --nWord;
                    }
                    if (nWord == first) {
                        nWord = i;
                    }
                    if (nWord != first) {
                        v.addElement(string.substring(first, nWord));
                    }
                    first = string.charAt(nWord) == '\n' || string.charAt(nWord) == ' ' ? nWord + 1 : nWord;
                    nStringLength = first < i ? fm.stringWidth(string.substring(first, i + 1)) : fm.charWidth(string.charAt(i));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < string.length()) {
                if (string.charAt(i) == '\n') {
                    v.addElement(string.substring(first, i));
                    first = i + 1;
                }
                ++i;
            }
        }
        if (first < string.length()) {
            v.addElement(string.substring(first));
        } else {
            v.addElement(new String());
        }
        return v;
    }
}

