/*
 * Decompiled with CFR 0.152.
 */
package ob.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.io.Serializable;
import java.util.Vector;
import ob.text.IScrollable;

public class Paragraph
implements Serializable {
    public static final int LEFT = 1;
    public static final int CENTER = 3;
    public static final int RIGHT = 2;
    protected static final int NONE = 0;
    protected static final int PARTIAL = 1;
    protected static final int COMPLETE = 2;
    private int x_offset = 0;
    private int prevXOffset = 0;
    private boolean m_bAllowScroll = false;
    private boolean m_bAutoWrap = false;
    StringBuffer buffer;
    Vector lines;
    FontMetrics fontMetrics;
    Font m_fFont = null;
    Color m_cHighlight = SystemColor.textHighlight;
    Color m_cTextHighlight = SystemColor.textHighlightText;
    Color m_cBackground = Color.white;
    Color m_cForeground = Color.black;
    Insets m_inInsets;
    boolean m_bVisible = true;
    boolean m_bMarkVisible = true;
    int cursorPos = 0;
    int currentLine = 0;
    int m_nYSpan;
    int m_nFirstLine = 0;
    int m_nHAlign = 1;
    int leftOffset = 10;
    int m_nWidth = 0;
    int selectionStart;
    int selectionEnd;
    int selected = 0;
    IScrollable target;

    public Paragraph() {
        this("");
    }

    public Paragraph(String s) {
        this.lines = new Vector();
        this.buffer = new StringBuffer(s);
        this.lines.addElement(this.buffer.toString());
        this.m_inInsets = new Insets(3, 3, 3, 3);
    }

    public Paragraph(IScrollable target) {
        this(target, "");
    }

    public Paragraph(IScrollable target, String s) {
        this(s);
        this.target = target;
    }

    public void addNotify() {
        this.onTextModified();
    }

    public Color getBackground() {
        return this.m_cBackground;
    }

    protected Point getCursorPoint() {
        Point p = new Point(0, 0);
        int base = 0;
        int i = 0;
        while (i < this.lines.size()) {
            String s = (String)this.lines.elementAt(i);
            int upper = s.length();
            if (upper > 0 && i < this.lines.size() - 1 && s.charAt(upper - 1) == ' ') {
                --upper;
            }
            if (this.cursorPos >= base && this.cursorPos <= (upper += base)) {
                String str = s.substring(0, this.cursorPos - base);
                p.x = this.fontMetrics.stringWidth(str) + this.m_inInsets.left;
                if (this.x_offset <= 0 && this.m_nHAlign != 1) {
                    if (this.m_nHAlign == 3) {
                        p.x = this.m_nWidth / 2 - this.fontMetrics.stringWidth(s) / 2 + this.fontMetrics.stringWidth(str) - 4;
                    } else if (this.m_nHAlign == 2) {
                        p.x = this.fontMetrics.stringWidth(str) > this.m_nWidth ? this.m_inInsets.left + this.fontMetrics.stringWidth(str) + 2 : this.m_nWidth - 2 - this.m_inInsets.right - this.fontMetrics.stringWidth(s) + this.fontMetrics.stringWidth(str);
                    }
                }
                p.x -= this.x_offset;
                break;
            }
            base += s.length();
            p.y += this.fontMetrics.getHeight();
            ++i;
        }
        return p;
    }

    protected int getCursorPos() {
        return this.cursorPos;
    }

    public int getCursorPosFromPoint(Point p) {
        if (p.y > this.getYSpan()) {
            return this.buffer.length();
        }
        int line = -1;
        int base = 0;
        int i = 0;
        while (i < this.lines.size()) {
            if ((i + 1) * this.fontMetrics.getHeight() > p.y) {
                line = i;
                break;
            }
            base += ((String)this.lines.elementAt(i)).length();
            ++i;
        }
        if (line == -1) {
            line = this.lines.size() - 1;
        }
        String s = (String)this.lines.elementAt(line);
        return base + this.getPositionAt(s, p.x);
    }

    protected int getFirstLine() {
        return this.m_nFirstLine;
    }

    public Font getFont() {
        return this.m_fFont;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public Color getForeground() {
        return this.m_cForeground;
    }

    protected Color getHighlight() {
        return this.m_cHighlight;
    }

    protected Color getHighlightedText() {
        return this.m_cTextHighlight;
    }

    public Insets getInsets() {
        return this.m_inInsets;
    }

    protected Vector getLines() {
        return this.lines;
    }

    protected boolean getMarkVisible() {
        return this.m_bMarkVisible;
    }

    protected int getPositionAt(String s, int len) {
        if (this.x_offset <= 0 && this.m_nHAlign != 1) {
            int w1 = this.m_nWidth;
            int w2 = this.fontMetrics.stringWidth(s);
            if (this.m_nHAlign == 3) {
                len -= (w1 - w2) / 2;
            } else if (this.m_nHAlign == 2) {
                len -= w1 - w2;
            }
        }
        if ((len += this.x_offset) == 0) {
            return len;
        }
        if (this.fontMetrics.stringWidth(s) <= len) {
            int result = s.length();
            if (this.lines.indexOf(s) < this.lines.size() - 1 && s.charAt(result - 1) == ' ') {
                --result;
            }
            return result;
        }
        int i = 0;
        while (i < s.length() - 1) {
            if (this.fontMetrics.stringWidth(s.substring(0, i + 1)) > len) break;
            ++i;
        }
        return i;
    }

    protected int getPrevXOffset() {
        return this.prevXOffset;
    }

    protected int getSelectionEnd() {
        return this.selectionEnd;
    }

    protected int getSelectionStart() {
        return this.selectionStart;
    }

    protected int getSelectionState() {
        return this.selected;
    }

    public IScrollable getTarget() {
        return this.target;
    }

    protected String getText() {
        return this.buffer.toString();
    }

    public int getWidth() {
        return this.m_nWidth;
    }

    protected int getXCoord() {
        return this.cursorPos;
    }

    protected int getXOffset() {
        return this.x_offset;
    }

    protected int getYSpan() {
        return this.fontMetrics.getHeight() * this.lines.size();
    }

    protected boolean insertChar(char c, boolean watchWidth) {
        if (watchWidth) {
            StringBuffer b2 = new StringBuffer(this.buffer.toString());
            b2.insert(this.cursorPos, c);
            if (this.fontMetrics.stringWidth(b2.toString()) <= this.m_nWidth - 4) {
                this.buffer.insert(this.cursorPos++, c);
                this.onTextModified();
                return true;
            }
            return false;
        }
        this.buffer.insert(this.cursorPos++, c);
        this.onTextModified();
        return true;
    }

    protected boolean isAllowScroll() {
        return this.m_bAllowScroll;
    }

    public boolean isAutoWrap() {
        return this.m_bAutoWrap;
    }

    protected boolean isCursorAtEnd() {
        return this.cursorPos == this.buffer.length();
    }

    protected boolean isCursorOnFirstLine() {
        String s = (String)this.lines.firstElement();
        int upper = s.length();
        if (upper > 0 && this.lines.size() > 1 && s.charAt(upper - 1) == ' ') {
            --upper;
        }
        return this.cursorPos <= upper;
    }

    protected boolean isCursorOnLastLine() {
        if (this.lines.size() == 1) {
            return true;
        }
        int base = 0;
        int i = 0;
        while (i < this.lines.size() - 1) {
            base += ((String)this.lines.elementAt(i)).length();
            ++i;
        }
        return this.cursorPos > base;
    }

    protected boolean isVisible() {
        return this.m_bVisible;
    }

    protected void moveSpecial(boolean b, int w, int key) {
        String s = b ? (String)this.lines.lastElement() : (String)this.lines.firstElement();
        int base = 0;
        if (b) {
            int i = 0;
            while (i < this.lines.size() - 1) {
                base += ((String)this.lines.elementAt(i)).length();
                ++i;
            }
        }
        if (this.isAllowScroll()) {
            int sW = this.fontMetrics.stringWidth(s);
            if (b && (key == 37 || key == 35)) {
                if (sW + this.m_inInsets.right + this.m_inInsets.left > w && this.getTarget() != null) {
                    int nOffset = Math.max(0, sW - w + this.m_inInsets.right + this.m_inInsets.left + 6);
                    this.getTarget().setXOffset(nOffset);
                }
            } else if (!(b || key != 39 && key != 36)) {
                if (this.x_offset > 0 && this.getTarget() != null) {
                    this.getTarget().setXOffset(0);
                }
            } else if (this.x_offset > sW && this.getTarget() != null) {
                int nOffset = Math.max(0, sW - w + this.m_inInsets.right + this.m_inInsets.left + 6);
                this.getTarget().setXOffset(nOffset);
            }
        }
        this.cursorPos = base + this.getPositionAt(s, w);
    }

    protected void onBackspaceKey() {
        String s = this.buffer.toString();
        String newS = s.substring(0, this.cursorPos - 1);
        if (this.cursorPos < s.length()) {
            newS = newS + s.substring(this.cursorPos);
        }
        this.buffer = new StringBuffer(newS);
        --this.cursorPos;
        this.onTextModified();
        if (this.isAllowScroll()) {
            int sW = this.fontMetrics.stringWidth(newS);
            if (this.getCursorPoint().x <= this.m_inInsets.left && this.getTarget() != null) {
                int nOffset = Math.max(0, sW - 3 * this.m_nWidth / 2 + this.m_inInsets.left + this.m_inInsets.right);
                this.setXOffset(nOffset);
                this.getTarget().setXOffset(nOffset);
            }
        }
    }

    protected void onDeleteKey() {
        String s = this.buffer.toString();
        if (this.cursorPos < s.length()) {
            String newS = s.substring(0, this.cursorPos);
            newS = newS + s.substring(this.cursorPos + 1);
            this.buffer = new StringBuffer(newS);
            this.onTextModified();
        }
    }

    protected void onDownKey() {
        int base = 0;
        int lineNum = 0;
        int i = 0;
        while (i < this.lines.size()) {
            String s = (String)this.lines.elementAt(i);
            int upper = s.length();
            if (upper > 0 && i < this.lines.size() - 1 && s.charAt(upper - 1) == ' ') {
                --upper;
            }
            if (this.cursorPos <= (upper += (base += s.length()))) {
                lineNum = i + 1;
                break;
            }
            ++i;
        }
        if (lineNum >= this.lines.size()) {
            return;
        }
        this.cursorPos = base + this.getPositionAt((String)this.lines.elementAt(lineNum), this.getCursorPoint().x);
    }

    protected void onEndKey() {
        if (this.isAllowScroll()) {
            this.moveSpecial(true, this.m_nWidth + this.m_inInsets.right + this.m_inInsets.left, 35);
        }
        int base = 0;
        int i = 0;
        while (i < this.lines.size()) {
            String s = (String)this.lines.elementAt(i);
            int upper = s.length();
            if (upper > 0 && i < this.lines.size() - 1 && s.charAt(upper - 1) == ' ') {
                --upper;
            }
            if (this.cursorPos >= base && this.cursorPos <= (upper += base)) {
                this.cursorPos = upper;
                break;
            }
            base += s.length();
            ++i;
        }
    }

    protected String onEnterKey() {
        if (this.cursorPos == this.buffer.length()) {
            return null;
        }
        String s = this.buffer.toString();
        this.buffer = new StringBuffer(s.substring(0, this.cursorPos));
        this.onTextModified();
        return s.substring(this.cursorPos);
    }

    protected void onHomeKey() {
        if (this.isAllowScroll()) {
            this.moveSpecial(false, this.m_nWidth, 36);
        }
        int base = 0;
        int i = 0;
        while (i < this.lines.size()) {
            String s = (String)this.lines.elementAt(i);
            int upper = s.length();
            if (upper > 0 && i < this.lines.size() - 1 && s.charAt(upper - 1) == ' ') {
                --upper;
            }
            if (this.cursorPos <= (upper += base)) {
                this.cursorPos = base;
                break;
            }
            base += s.length();
            ++i;
        }
    }

    protected void onScrollAction() {
        if (!this.m_bAllowScroll) {
            return;
        }
        if (this.m_nWidth > 0) {
            IScrollable label;
            int x = this.getCursorPoint().x + 2;
            if (x > this.m_nWidth) {
                this.x_offset += x - this.m_nWidth;
            } else if (x < 2) {
                this.x_offset -= 2 - x;
            }
            if (this.isCursorAtEnd() && this.m_nHAlign == 2 && this.x_offset > 0 && x < this.m_nWidth - 2) {
                this.x_offset -= this.m_nWidth - 2 - x;
                if (this.x_offset < 0) {
                    this.x_offset = 0;
                }
            }
            if ((label = this.getTarget()) != null) {
                label.setXOffset(this.x_offset);
            }
        }
    }

    protected void onTextModified() {
        if (this.isAutoWrap() && this.m_nWidth > 0) {
            this.lines = this.wrapText(this.buffer.toString());
        } else {
            this.lines.setElementAt(this.buffer.toString(), 0);
            this.onScrollAction();
        }
    }

    protected void onUpKey() {
        int base = 0;
        int prevBase = 0;
        int lineNum = 0;
        int i = 0;
        while (i < this.lines.size()) {
            String s = (String)this.lines.elementAt(i);
            int upper = s.length();
            if (upper > 0 && i < this.lines.size() - 1 && s.charAt(upper - 1) == ' ') {
                --upper;
            }
            if (this.cursorPos >= base && this.cursorPos <= (upper += base)) {
                lineNum = i - 1;
                break;
            }
            prevBase = base;
            base += s.length();
            ++i;
        }
        if (lineNum < 0) {
            return;
        }
        this.cursorPos = prevBase + this.getPositionAt((String)this.lines.elementAt(lineNum), this.getCursorPoint().x);
    }

    protected void render(Graphics g, int x, int y, boolean underline, boolean xo) {
        int base = 0;
        g.setFont(this.m_fFont);
        g.setColor(this.m_cForeground);
        boolean paintAll = false;
        if (this.m_nHAlign == 1) {
            x += 2;
        }
        int i = 0;
        while (i < this.lines.size()) {
            int yDraw;
            int upper;
            String str = (String)this.lines.elementAt(i);
            if (this.x_offset == 0 && this.m_nHAlign != 1) {
                if (this.m_nHAlign == 3) {
                    x = this.m_nWidth / 2 - this.fontMetrics.stringWidth(str) / 2;
                } else if (this.m_nHAlign == 2) {
                    x = this.m_nWidth - this.fontMetrics.stringWidth(str) - this.m_inInsets.right;
                }
            }
            if (x < this.m_inInsets.left) {
                x = this.m_inInsets.left;
            }
            if ((upper = str.length()) > 0 && i < this.lines.size() - 1 && str.charAt(upper - 1) == ' ') {
                --upper;
            }
            upper += base;
            int y2 = y + this.fontMetrics.getHeight();
            y2 -= this.fontMetrics.getHeight() / 4;
            x -= this.x_offset;
            if (!this.m_bMarkVisible || this.selected == 0) {
                g.drawString(str, x, y2);
                if (underline) {
                    yDraw = y + this.fontMetrics.getHeight();
                    g.drawLine(x, yDraw, x + this.fontMetrics.stringWidth(str), yDraw);
                }
                if (xo) {
                    yDraw = y + this.fontMetrics.getHeight() / 2;
                    g.drawLine(x, yDraw, x + this.fontMetrics.stringWidth(str), yDraw);
                }
            } else if (this.selected == 2) {
                g.setColor(this.m_cHighlight);
                g.fillRect(x, y, this.fontMetrics.stringWidth(str), this.fontMetrics.getHeight());
                g.setColor(this.m_cTextHighlight);
                g.drawString(str, x, y2);
                if (underline) {
                    yDraw = y + this.fontMetrics.getHeight();
                    g.drawLine(x, yDraw, x + this.fontMetrics.stringWidth(str), yDraw);
                }
                if (xo) {
                    yDraw = y + this.fontMetrics.getHeight() / 2;
                    g.drawLine(x, yDraw, x + this.fontMetrics.stringWidth(str), yDraw);
                }
            } else {
                int yDraw2;
                int x2;
                String s2;
                String s1;
                int start = this.selectionStart;
                int end = this.selectionEnd;
                if (this.selectionStart > this.selectionEnd) {
                    end = this.selectionStart;
                    start = this.selectionEnd;
                }
                boolean paintPart = false;
                boolean paintBefore = false;
                boolean paintAfter = false;
                if (start >= base && start <= upper && end >= base && end <= upper) {
                    paintPart = true;
                } else if (start >= base && start < base + str.length()) {
                    paintAfter = true;
                } else if (end >= base && end < base + str.length()) {
                    paintBefore = true;
                }
                if (paintAfter) {
                    int pos = start - base;
                    s1 = str.substring(0, pos);
                    s2 = str.substring(pos);
                    g.drawString(s1, x, y2);
                    x2 = x + this.fontMetrics.stringWidth(s1);
                    g.setColor(this.m_cHighlight);
                    g.fillRect(x2, y, this.fontMetrics.stringWidth(s2), this.fontMetrics.getHeight());
                    g.setColor(this.m_cTextHighlight);
                    g.drawString(s2, x2, y2);
                    if (underline) {
                        yDraw2 = y + this.fontMetrics.getHeight();
                        g.drawLine(x, yDraw2, x + this.fontMetrics.stringWidth(str), yDraw2);
                    }
                    if (xo) {
                        yDraw2 = y + this.fontMetrics.getHeight() / 2;
                        g.drawLine(x, yDraw2, x + this.fontMetrics.stringWidth(str), yDraw2);
                    }
                    paintAll = true;
                } else if (paintBefore) {
                    int pos = end - base;
                    s1 = str.substring(0, pos);
                    s2 = str.substring(pos);
                    x2 = x + this.fontMetrics.stringWidth(s1);
                    g.setColor(this.m_cHighlight);
                    g.fillRect(x, y, this.fontMetrics.stringWidth(s1), this.fontMetrics.getHeight());
                    g.setColor(this.m_cTextHighlight);
                    g.drawString(s1, x, y2);
                    g.setColor(this.m_cForeground);
                    g.drawString(s2, x2, y2);
                    if (underline) {
                        yDraw2 = y + this.fontMetrics.getHeight();
                        g.drawLine(x, yDraw2, x + this.fontMetrics.stringWidth(str), yDraw2);
                    }
                    if (xo) {
                        yDraw2 = y + this.fontMetrics.getHeight() / 2;
                        g.drawLine(x, yDraw2, x + this.fontMetrics.stringWidth(str), yDraw2);
                    }
                    paintAll = false;
                } else if (paintAll) {
                    g.setColor(this.m_cHighlight);
                    g.fillRect(x, y, this.fontMetrics.stringWidth(str), this.fontMetrics.getHeight());
                    g.setColor(this.m_cTextHighlight);
                    g.drawString(str, x, y2);
                    if (underline) {
                        int yDraw3 = y + this.fontMetrics.getHeight();
                        g.drawLine(x, yDraw3, x + this.fontMetrics.stringWidth(str), yDraw3);
                    }
                    if (xo) {
                        int yDraw4 = y + this.fontMetrics.getHeight() / 2;
                        g.drawLine(x, yDraw4, x + this.fontMetrics.stringWidth(str), yDraw4);
                    }
                } else if (paintPart) {
                    int yDraw5;
                    int pos1 = start - base;
                    int pos2 = end - base;
                    String s12 = str.substring(0, pos1);
                    x2 = x + this.fontMetrics.stringWidth(s12);
                    String s22 = str.substring(pos1, pos2);
                    int x3 = x2 + this.fontMetrics.stringWidth(s22);
                    String s3 = str.substring(pos2);
                    g.drawString(s12, x, y2);
                    g.setColor(this.m_cHighlight);
                    g.fillRect(x2, y, this.fontMetrics.stringWidth(s22), this.fontMetrics.getHeight());
                    g.setColor(this.m_cTextHighlight);
                    g.drawString(s22, x2, y2);
                    g.setColor(this.getForeground());
                    g.drawString(s3, x3, y2);
                    if (underline) {
                        yDraw5 = y + this.fontMetrics.getHeight();
                        g.drawLine(x, yDraw5, x + this.fontMetrics.stringWidth(str), yDraw5);
                    }
                    if (xo) {
                        yDraw5 = y + this.fontMetrics.getHeight() / 2;
                        g.drawLine(x, yDraw5, x + this.fontMetrics.stringWidth(str), yDraw5);
                    }
                } else {
                    g.drawString(str, x, y2);
                    if (underline) {
                        int yDraw6 = y + this.fontMetrics.getHeight();
                        g.drawLine(x, yDraw6, x + this.fontMetrics.stringWidth(str), yDraw6);
                    }
                    if (xo) {
                        int yDraw7 = y + this.fontMetrics.getHeight() / 2;
                        g.drawLine(x, yDraw7, x + this.fontMetrics.stringWidth(str), yDraw7);
                    }
                }
            }
            y += this.fontMetrics.getHeight();
            base += str.length();
            ++i;
        }
    }

    protected void setAllowScroll(boolean b) {
        this.m_bAllowScroll = b;
    }

    public void setAutoWrap(boolean bWrap) {
        if (this.m_bAutoWrap != bWrap) {
            this.m_bAutoWrap = bWrap;
            this.onTextModified();
        }
    }

    public void setBackground(Color c) {
        this.m_cBackground = c;
    }

    protected void setCursorPos(int p) {
        this.cursorPos = p;
        this.onScrollAction();
    }

    public void setFont(Font f) {
        this.m_fFont = f;
    }

    public void setFontMetrics(FontMetrics fm) {
        this.fontMetrics = fm;
    }

    public void setForeground(Color c) {
        this.m_cForeground = c;
    }

    protected void setHAlign(int align) {
        this.m_nHAlign = align;
    }

    protected void setHighlight(Color c) {
        this.m_cHighlight = c;
    }

    protected void setHighlightedText(Color c) {
        this.m_cTextHighlight = c;
    }

    public void setInsets(Insets i) {
        this.m_inInsets = i;
    }

    protected void setMarkVisible(boolean b) {
        this.m_bMarkVisible = b;
    }

    protected void setPrevXOffset(int x) {
        this.prevXOffset = x;
    }

    protected void setSelectionEnd(int pos) {
        this.selectionEnd = pos;
    }

    protected void setSelectionStart(int pos) {
        this.selectionStart = pos;
    }

    protected void setSelectionState(int s) {
        this.selected = s;
    }

    public void setTarget(IScrollable target) {
        this.target = target;
    }

    protected void setText(String s) {
        this.buffer = new StringBuffer(s);
        this.onTextModified();
    }

    public void setWidth(int w) {
        this.m_nWidth = w;
        this.onTextModified();
    }

    protected void setXOffset(int x) {
        this.x_offset = x;
    }

    public String toString() {
        String s = new String();
        s = "Paragraph: [text=" + this.buffer.toString() + "||selection state=";
        s = this.selected == 0 ? s + "NONE" : (this.selected == 1 ? s + "PARTIAL" : s + "COMPLETE");
        s = s + "||selectionStart=" + this.selectionStart + "||selectionEnd=" + this.selectionEnd;
        return s;
    }

    private Vector wrapText(String str) {
        Vector<String> v = new Vector<String>();
        int first = 0;
        if (str.length() > 0) {
            int i = 0;
            while (i < str.length()) {
                String s = str.substring(first, i + 1);
                if (this.fontMetrics.stringWidth(s) > this.m_nWidth - 4) {
                    int nWord = i;
                    while (nWord > first && str.charAt(nWord) != ' ') {
                        --nWord;
                    }
                    if (nWord == first) {
                        nWord = i;
                    }
                    if (first != nWord) {
                        if (nWord != i || str.charAt(nWord) == ' ') {
                            ++nWord;
                        }
                        v.addElement(str.substring(first, nWord));
                    }
                    first = nWord;
                }
                ++i;
            }
        }
        if (first < str.length() || str.length() == 0) {
            v.addElement(str.substring(first));
        }
        return v;
    }
}

