/*
 * Decompiled with CFR 0.152.
 */
package ob.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.StringTokenizer;
import java.util.Vector;
import ob.text.IScrollable;
import ob.text.Paragraph;

public class OBLabel
extends Panel
implements IScrollable {
    public static final int STANDARD = 1;
    public static final int LEFT = 1;
    public static final int CENTER = 3;
    public static final int RIGHT = 2;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int NONE = 0;
    public static final int INSET = 1;
    public static final int RAISED = 2;
    public static final int NORMAL = 3;
    protected Vector m_vParagraphs;
    protected Color borderColor = Color.black;
    protected Insets m_inTextInsets;
    Font defaultfont = new Font("Dialog", 0, 12);
    int m_nHAlign = 1;
    int m_nVAlign = 1;
    int m_nBorderStyle = 0;
    int y_offset = 0;
    int prevYOffset = 0;
    int m_nWidthOffset = 0;
    boolean m_bUnderline = false;
    boolean m_bStrikeOut = false;
    boolean m_bAutoWrap = true;
    transient Image offscreen;
    protected boolean m_bDoubleBuffering = true;
    protected boolean m_bLockUpdate = false;

    public OBLabel() {
        this("");
    }

    public OBLabel(String s) {
        this.m_vParagraphs = new Vector();
        super.setFont(this.defaultfont);
        super.setBackground(Color.white);
        super.setForeground(Color.black);
        this.m_inTextInsets = new Insets(3, 3, 3, 3);
        if (s.equals("")) {
            Paragraph p = new Paragraph(this, s);
            p.setFont(this.getFont());
            p.setFontMetrics(this.getFontMetrics(this.getFont()));
            p.setBackground(this.getBackground());
            p.setForeground(this.getForeground());
            p.setWidth(this.getSize().width);
            p.setInsets(this.m_inTextInsets);
            p.setAutoWrap(this.isAutoWrap());
            this.m_vParagraphs.addElement(p);
        } else {
            StringTokenizer st = new StringTokenizer(s, "\n", false);
            while (st.hasMoreTokens()) {
                String s2 = st.nextToken();
                Paragraph p = new Paragraph(this, s2);
                p.setFont(this.getFont());
                p.setFontMetrics(this.getFontMetrics(this.getFont()));
                p.setBackground(this.getBackground());
                p.setForeground(this.getForeground());
                p.setWidth(this.getSize().width);
                p.setInsets(this.m_inTextInsets);
                p.setAutoWrap(this.isAutoWrap());
                this.m_vParagraphs.addElement(p);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.setWidth(this.getSize().width - (this.m_inTextInsets.left + this.m_inTextInsets.right) - this.m_nWidthOffset);
            p.addNotify();
            ++i;
        }
    }

    public boolean getAutoWrap() {
        return this.m_bAutoWrap;
    }

    public boolean getBorder() {
        return this.m_nBorderStyle != 0;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderStyle() {
        return this.m_nBorderStyle;
    }

    public int getHAlign() {
        return this.m_nHAlign;
    }

    public Insets getInsets() {
        return this.m_inTextInsets;
    }

    public Dimension getMinimumSize() {
        return new Dimension(80, 20);
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(80, 0);
        int h = 0;
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            h += ((Paragraph)this.m_vParagraphs.elementAt(i)).getYSpan();
            ++i;
        }
        int nBoardWidth = 2;
        if (this.m_nBorderStyle == 0) {
            nBoardWidth = 0;
        } else if (this.m_nBorderStyle == 3) {
            nBoardWidth = 1;
        }
        d.height = this.m_inTextInsets.top + this.m_inTextInsets.bottom + h + 2 * nBoardWidth;
        return d;
    }

    public boolean getRaised() {
        return this.m_nBorderStyle == 2;
    }

    public String getText() {
        if (this.m_vParagraphs.size() == 0) {
            return null;
        }
        String str = new String();
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            str = str + ((Paragraph)this.m_vParagraphs.elementAt(i)).getText() + "\n";
            ++i;
        }
        str = str.substring(0, str.length() - 1);
        return str;
    }

    public int getTextHIndent() {
        return this.m_inTextInsets.left;
    }

    public int getTextVIndent() {
        return this.m_inTextInsets.top;
    }

    public int getVAlign() {
        return this.m_nVAlign;
    }

    protected int getWidthOffset() {
        return this.m_nWidthOffset;
    }

    protected boolean isAutoWrap() {
        return this.m_bAutoWrap;
    }

    public boolean isLockUpdate() {
        return this.m_bLockUpdate;
    }

    public boolean isStrikeOut() {
        return this.m_bStrikeOut;
    }

    public boolean isUnderLine() {
        return this.m_bUnderline;
    }

    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        if (this.m_bDoubleBuffering && this.validateImage()) {
            Dimension d = this.getSize();
            Rectangle r = g.getClipBounds();
            Graphics og = this.offscreen.getGraphics();
            if (r != null) {
                og.clipRect(r.x, r.y, r.width, r.height);
            }
            og.setFont(g.getFont());
            og.setColor(this.getBackground());
            og.fillRect(0, 0, d.width, d.height);
            og.setColor(g.getColor());
            this.draw(og);
            g.drawImage(this.offscreen, 0, 0, this);
            og.dispose();
        } else if (g != null && g.getClipBounds() != null) {
            this.draw(g);
        }
    }

    public void draw(Graphics g) {
        if (g == null || this.isLockUpdate()) {
            return;
        }
        Dimension d = this.getSize();
        this.printBorder(g);
        int nBoardWidth = 2;
        if (this.m_nBorderStyle == 0) {
            nBoardWidth = 0;
        } else if (this.m_nBorderStyle == 3) {
            nBoardWidth = 1;
        }
        g.clipRect(this.m_inTextInsets.left + nBoardWidth, this.m_inTextInsets.top + nBoardWidth, d.width - this.m_inTextInsets.left - this.m_inTextInsets.right - 2 * nBoardWidth + 1, d.height - this.m_inTextInsets.top - this.m_inTextInsets.bottom - 2 * nBoardWidth + 1);
        int y = this.m_inTextInsets.top;
        if (this.y_offset == 0 && this.m_nVAlign != 1) {
            int h1 = d.height;
            int h2 = 0;
            int i = 0;
            while (i < this.m_vParagraphs.size()) {
                h2 += ((Paragraph)this.m_vParagraphs.elementAt(i)).getYSpan();
                ++i;
            }
            if (this.m_nVAlign == 3) {
                y = h1 / 2 - h2 / 2;
            } else if (this.m_nVAlign == 2) {
                y = h1 - h2 - this.m_inTextInsets.bottom;
            }
        }
        y -= this.y_offset;
        int x = this.m_inTextInsets.left;
        g.setColor(this.getBackground());
        g.fillRect(2, 2, d.width - 4, d.height - 4);
        g.setColor(this.getForeground());
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.render(g, x, y, this.m_bUnderline, this.m_bStrikeOut);
            y += p.getYSpan();
            ++i;
        }
    }

    private void paintBorder(Graphics g, int x, int y, int w, int h, boolean raised) {
        g.setColor(SystemColor.controlLtHighlight);
        if (raised) {
            g.drawLine(x, y, x + w, y);
            g.drawLine(x, y, x, y + h);
        } else {
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
        }
        g.setColor(SystemColor.controlHighlight);
        if (!raised) {
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        }
        g.setColor(SystemColor.controlShadow);
        if (raised) {
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
        }
        g.setColor(SystemColor.controlDkShadow);
        if (raised) {
            g.drawLine(x, y + h, x + w, y + h);
            g.drawLine(x + w, y, x + w, y + h);
        } else {
            g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
        }
    }

    protected void printBorder(Graphics g) {
        Dimension d = super.getSize();
        if (this.m_nBorderStyle == 0) {
            g.setColor(this.getBackground());
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        } else if (this.m_nBorderStyle == 3) {
            g.setColor(this.borderColor);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        } else if (this.m_nBorderStyle == 2 || this.m_nBorderStyle == 1) {
            this.paintBorder(g, 0, 0, d.width, d.height, this.m_nBorderStyle == 2);
        }
    }

    public void setAutoWrap(boolean bAutoWrap) {
        this.m_bAutoWrap = bAutoWrap;
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            ((Paragraph)this.m_vParagraphs.elementAt(i)).setAutoWrap(bAutoWrap);
            ++i;
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            ((Paragraph)this.m_vParagraphs.elementAt(i)).setBackground(c);
            ++i;
        }
        this.repaint();
    }

    public void setBorder(boolean b) {
        if (!b) {
            this.m_nBorderStyle = 0;
            this.repaint();
        }
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        this.repaint();
    }

    public void setBorderStyle(int style) {
        if (style != 0 && style != 1 && style != 2 && style != 3) {
            return;
        }
        this.m_nBorderStyle = style;
        this.repaint();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            ((Paragraph)this.m_vParagraphs.elementAt(i)).setWidth(w - (this.m_inTextInsets.left + this.m_inTextInsets.right) - this.m_nWidthOffset);
            ++i;
        }
        this.repaint();
    }

    public void setFont(int p, Font f) {
        Paragraph pg = (Paragraph)this.m_vParagraphs.elementAt(p);
        if (pg != null) {
            pg.setFont(f);
            pg.setFontMetrics(this.getFontMetrics(f));
        }
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.setFont(f);
            p.setFontMetrics(this.getFontMetrics(f));
            ++i;
        }
        this.repaint();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            ((Paragraph)this.m_vParagraphs.elementAt(i)).setForeground(c);
            ++i;
        }
        this.repaint();
    }

    public void setHAlign(int align) {
        if (align != 1 && align != 3 && align != 2) {
            return;
        }
        this.m_nHAlign = align;
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.setHAlign(align);
            ++i;
        }
        this.repaint();
    }

    public void setInsets(Insets in) {
        this.m_inTextInsets = in;
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            ((Paragraph)this.m_vParagraphs.elementAt(i)).setInsets(in);
            ++i;
        }
        this.repaint();
    }

    public void setLockUpdate(boolean bLock) {
        this.m_bLockUpdate = bLock;
    }

    public void setRaised(boolean b) {
        if (b) {
            this.m_nBorderStyle = 2;
            this.repaint();
        }
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.setWidth(w - (this.m_inTextInsets.left + this.m_inTextInsets.right) - this.m_nWidthOffset);
            ++i;
        }
        this.repaint();
    }

    public void setStrikeOut(boolean b) {
        this.m_bStrikeOut = b;
        this.repaint();
    }

    public void setText(String t) {
        this.setText(t, true);
    }

    public void setText(String t, boolean repaint) {
        if (t == null) {
            t = "";
        }
        if (this.m_vParagraphs.size() > 0) {
            this.m_vParagraphs.removeAllElements();
        }
        if (t.equals("")) {
            Paragraph p = new Paragraph(this, t);
            p.setFont(this.getFont());
            p.setFontMetrics(this.getFontMetrics(this.getFont()));
            p.setBackground(this.getBackground());
            p.setForeground(this.getForeground());
            p.setWidth(this.getSize().width - this.m_nWidthOffset);
            p.setInsets(this.m_inTextInsets);
            p.setHAlign(this.getHAlign());
            p.setAutoWrap(this.isAutoWrap());
            this.m_vParagraphs.addElement(p);
        } else {
            StringTokenizer st = new StringTokenizer(t, "\n", false);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                Paragraph p = new Paragraph(this, s);
                p.setFont(this.getFont());
                p.setFontMetrics(this.getFontMetrics(this.getFont()));
                p.setBackground(this.getBackground());
                p.setForeground(this.getForeground());
                p.setWidth(this.getSize().width - this.m_nWidthOffset);
                p.setInsets(this.m_inTextInsets);
                p.setHAlign(this.getHAlign());
                p.setAutoWrap(this.isAutoWrap());
                this.m_vParagraphs.addElement(p);
            }
        }
        if (repaint) {
            this.repaint();
        }
    }

    public void setTextHIndent(int n) {
        this.m_inTextInsets.left = n;
        this.repaint();
    }

    public void setTextVIndent(int n) {
        this.m_inTextInsets.top = n;
    }

    public void setUnderLine(boolean b) {
        this.m_bUnderline = b;
    }

    public void setVAlign(int align) {
        if (align != 1 && align != 3 && align != 2) {
            return;
        }
        this.m_nVAlign = align;
        this.repaint();
    }

    protected void setWidthOffset(int w) {
        this.m_nWidthOffset = w;
        int wd = this.getSize().width - this.m_inTextInsets.left - this.m_inTextInsets.right;
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            ((Paragraph)this.m_vParagraphs.elementAt(i)).setWidth(wd - w);
            ++i;
        }
    }

    public void setXOffset(int n) {
    }

    protected boolean validateImage() {
        try {
            Dimension d = this.getSize();
            if (this.offscreen == null || this.offscreen.getWidth(this) != d.width || this.offscreen.getHeight(this) != d.height) {
                if (d.width > 0 && d.height > 0) {
                    this.offscreen = this.createImage(d.width, d.height);
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void update(Graphics g, int x, int y, int w, int h) {
        g.clipRect(x, y, w, h);
        this.paint(g);
    }

    public void update() {
        Dimension d = this.getSize();
        int nHeight = d.height;
        int nWidth = d.width;
        Graphics g = this.getGraphics();
        if (g != null) {
            this.update(g, 0, 0, nWidth, nHeight);
            g.dispose();
        }
    }

    public void repaint() {
        Dimension d = this.getSize();
        int nHeight = d.height;
        int nWidth = d.width;
        Graphics g = this.getGraphics();
        if (g != null) {
            if (!this.m_bDoubleBuffering) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, d.width, d.height);
            }
            this.update(g, 0, 0, nWidth, nHeight);
            g.dispose();
        }
    }

    public void update(Graphics g) {
        if (this.m_bDoubleBuffering) {
            this.paint(g);
        } else {
            super.update(g);
        }
    }
}

