/*
 * Decompiled with CFR 0.152.
 */
package ob.text;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import ob.text.Paragraph;
import ob.text.Text;

public class MultiText
extends Text {
    Hashtable m_htUpDownPositions = new Hashtable();
    boolean m_bAllowEnter = true;
    boolean m_bAllowVScroll = true;
    int m_nLastXPosition = -1;

    public MultiText() {
        this("");
    }

    public MultiText(String s) {
        super(s);
    }

    public boolean getAllowSpace() {
        return false;
    }

    public boolean getAllowVScroll() {
        return this.m_bAllowVScroll;
    }

    public int getCursorPos() {
        int pos = 0;
        int i = 0;
        while (i < this.cursorPoint.y) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            pos += p.getText().length() + 1;
            ++i;
        }
        return pos + ((Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).getCursorPos();
    }

    protected boolean insertChar(char c) {
        Paragraph p;
        if (c == '\uffff') {
            return false;
        }
        if (this.m_vParagraphs == null || this.cursorPoint.y < 0 || this.cursorPoint.y > this.m_vParagraphs.size() - 1) {
            return false;
        }
        this.m_htUpDownPositions.clear();
        this.m_nLastXPosition = -1;
        if (this.isSelected()) {
            this.cut(false);
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            if (this.m_bAllowVScroll) {
                this.onVerticalScroll();
            }
            this.start();
        }
        if ((p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).insertChar(c, !this.isAutoWrap() && !this.m_bAllowHScroll)) {
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            if (this.m_bAllowVScroll) {
                this.onVerticalScroll();
            }
            this.update();
            return true;
        }
        return false;
    }

    public boolean isAllowEnter() {
        return this.m_bAllowEnter && this.getVAlign() == 1;
    }

    public boolean isCursorOnEndPos() {
        if (this.m_vParagraphs.size() <= this.cursorPoint.y) {
            return true;
        }
        if (this.m_vParagraphs.size() - 1 == this.cursorPoint.y) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            if (super.getCursorPos() >= p.getText().length()) {
                return true;
            }
        }
        return false;
    }

    protected int nextCursorPos(int ParaNum, int pos) {
        if (this.m_htUpDownPositions.size() == 0) {
            return -1;
        }
        if (this.m_htUpDownPositions.containsKey("" + ParaNum)) {
            int prev = -1;
            Vector v = (Vector)this.m_htUpDownPositions.get("" + ParaNum);
            int i = 0;
            while (i < v.size()) {
                Integer n = (Integer)v.elementAt(i);
                int compare = n;
                if (compare > pos) {
                    prev = prev == -1 ? compare : Math.min(prev, compare);
                }
                ++i;
            }
            return prev;
        }
        return -1;
    }

    protected void onBackspaceKey() {
        this.m_htUpDownPositions.clear();
        if (this.isSelected()) {
            this.cut(false);
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            this.start();
        } else {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            if (!this.isAutoWrap() && p.getCursorPos() == 0) {
                if (p.getXOffset() > 0) {
                    this.setXOffset(0);
                    this.repaint();
                    return;
                }
                if (this.cursorPoint.y == 0) {
                    return;
                }
            } else if (this.cursorPoint.y == 0 && p.getCursorPos() == 0) {
                return;
            }
            this.stop();
            if (p.getCursorPos() == 0) {
                String addThis = p.getText();
                Paragraph pb4 = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y - 1);
                pb4.setCursorPos(pb4.getText().length());
                pb4.setText(pb4.getText() + addThis);
                this.m_vParagraphs.removeElement(p);
                --this.cursorPoint.y;
            } else {
                p.onBackspaceKey();
            }
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            this.start();
        }
        if (this.m_bAllowVScroll) {
            this.onVerticalScroll();
        }
        this.repaint();
    }

    protected void onDeleteKey() {
        this.m_htUpDownPositions.clear();
        if (this.isSelected()) {
            this.cut(false);
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            this.start();
        } else {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            if (p.isCursorAtEnd() && this.cursorPoint.y >= this.m_vParagraphs.size() - 1) {
                return;
            }
            if (p.isCursorAtEnd()) {
                String str = p.getText();
                Paragraph p2 = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y + 1);
                str = str + p2.getText();
                this.m_vParagraphs.removeElement(p2);
                p.setText(str);
            } else {
                p.onDeleteKey();
            }
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
        }
        if (this.m_bAllowVScroll) {
            this.onVerticalScroll();
        }
        this.repaint();
    }

    protected void onDownKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        if (p.isCursorOnLastLine() && this.cursorPoint.y == this.m_vParagraphs.size() - 1) {
            this.onEndKey(mod);
            return;
        }
        this.stop();
        if (p.isCursorOnLastLine()) {
            this.storePosition(this.cursorPoint.y, p.getCursorPos());
            int w = 0;
            if (this.m_nLastXPosition == -1) {
                this.m_nLastXPosition = w = p.getCursorPoint().x;
            } else {
                w = this.m_nLastXPosition;
            }
            ++this.cursorPoint.y;
            Paragraph pp = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            int testPos = this.nextCursorPos(this.cursorPoint.y, 0);
            if (testPos == -1) {
                pp.moveSpecial(false, w, 40);
            } else {
                pp.setCursorPos(testPos);
            }
            if (mod == 1) {
                if (p.getSelectionState() == 0) {
                    p.setSelectionState(1);
                    p.setSelectionStart(p.getCursorPos());
                    this.selectionStart.x = p.getCursorPos();
                    this.selectionStart.y = this.cursorPoint.y - 1;
                    if (this.m_bAllowVScroll) {
                        this.prevYOffset = this.y_offset;
                    }
                }
                p.setSelectionEnd(p.getText().length());
                if (pp.getSelectionState() == 0) {
                    pp.setSelectionState(1);
                    pp.setSelectionStart(0);
                }
                this.selectionEnd.x = pp.getCursorPos();
                this.selectionEnd.y = this.cursorPoint.y;
                pp.setSelectionEnd(pp.getCursorPos());
            } else {
                if (p.getSelectionState() != 0) {
                    this.unselectAll();
                }
                this.start();
            }
        } else {
            int oldPos = p.getCursorPos();
            this.storePosition(this.cursorPoint.y, oldPos);
            int testPos = this.nextCursorPos(this.cursorPoint.y, oldPos);
            if (testPos == -1) {
                p.onDownKey();
            } else {
                p.setCursorPos(testPos);
            }
            int newPos = p.getCursorPos();
            if (mod == 1) {
                if (p.getSelectionState() == 0) {
                    p.setSelectionState(1);
                    p.setSelectionStart(oldPos);
                    this.selectionStart.x = oldPos;
                    this.selectionStart.y = this.cursorPoint.y;
                    if (this.m_bAllowVScroll) {
                        this.prevYOffset = this.y_offset;
                    }
                }
                this.selectionEnd.x = newPos;
                this.selectionEnd.y = this.cursorPoint.y;
                p.setSelectionEnd(newPos);
            } else {
                if (p.getSelectionState() != 0) {
                    this.unselectAll();
                }
                this.start();
            }
        }
        if (this.m_bAllowVScroll) {
            this.onVerticalScroll();
        }
        this.repaint();
    }

    protected void onEndKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        this.m_htUpDownPositions.clear();
        this.m_nLastXPosition = -1;
        this.stop();
        int oldPos = p.getCursorPos();
        p.onEndKey();
        int newPos = p.getCursorPos();
        if (mod == 1) {
            if (p.getSelectionState() == 0) {
                p.setSelectionState(1);
                p.setSelectionStart(oldPos);
                this.selectionStart.x = oldPos;
                this.selectionStart.y = this.cursorPoint.y;
            }
            this.selectionEnd.x = newPos;
            this.selectionEnd.y = this.cursorPoint.y;
            p.setSelectionEnd(newPos);
        } else {
            if (p.getSelectionState() != 0) {
                this.unselectAll();
            }
            this.start();
        }
        this.repaint();
    }

    protected void onEnterKey() {
        if (!this.isAllowEnter()) {
            super.onEnterKey();
            return;
        }
        if (this.isSelected()) {
            this.cut(false);
            if (this.textListener != null) {
                this.textListener.textValueChanged(this.textEvent);
            }
            this.start();
        }
        Paragraph current = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        String str = current.onEnterKey();
        this.m_htUpDownPositions.clear();
        Paragraph p = str == null || str.length() < 1 ? new Paragraph(this, "") : new Paragraph(this, str);
        p.setFont(this.getFont());
        p.setFontMetrics(this.getFontMetrics(this.getFont()));
        p.setWidth(this.getSize().width - this.m_inTextInsets.left - this.m_inTextInsets.right);
        p.setForeground(this.getForeground());
        p.setBackground(this.getBackground());
        p.setInsets(this.m_inTextInsets);
        p.setHAlign(this.m_nHAlign);
        p.setAllowScroll(this.getAllowHScroll());
        p.setAutoWrap(this.isAutoWrap());
        this.m_vParagraphs.insertElementAt(p, this.cursorPoint.y + 1);
        ++this.cursorPoint.y;
        p.setCursorPos(0);
        if (this.m_bAllowVScroll) {
            this.onVerticalScroll();
        }
        this.setXOffset(0);
        if (this.textListener != null) {
            this.textListener.textValueChanged(this.textEvent);
        }
        this.repaint();
    }

    protected void onHomeKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        this.m_htUpDownPositions.clear();
        this.m_nLastXPosition = -1;
        this.stop();
        int oldPos = p.getCursorPos();
        p.onHomeKey();
        int newPos = p.getCursorPos();
        if (mod == 1) {
            if (p.getSelectionState() == 0) {
                p.setSelectionState(1);
                p.setSelectionStart(oldPos);
                this.selectionStart.x = oldPos;
                this.selectionStart.y = this.cursorPoint.y;
            }
            this.selectionEnd.x = newPos;
            this.selectionEnd.y = this.cursorPoint.y;
            p.setSelectionEnd(newPos);
        } else {
            if (p.getSelectionState() != 0) {
                this.unselectAll();
            }
            this.start();
        }
        this.repaint();
    }

    protected void onLeftKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        int pos = p.getCursorPos();
        if (pos == 0) {
            if (p.getXOffset() > 0) {
                this.setXOffset(0);
                this.repaint();
                return;
            }
            if (this.cursorPoint.y == 0) {
                return;
            }
        }
        this.m_htUpDownPositions.clear();
        this.m_nLastXPosition = -1;
        this.stop();
        Point start = this.selectionStart;
        Point end = this.selectionEnd;
        if (end.y < start.y || end.y == start.y && end.x < start.x) {
            Point temp = end;
            end = start;
            start = temp;
        }
        if (pos == 0) {
            --this.cursorPoint.y;
            Paragraph pp = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            pp.moveSpecial(true, this.getSize().width, 37);
            if (mod == 1) {
                if (p.getSelectionState() == 0) {
                    p.setSelectionState(1);
                    p.setSelectionStart(0);
                    this.selectionStart.y = this.cursorPoint.y + 1;
                    this.selectionStart.x = 0;
                }
                if (pp.getSelectionState() == 0) {
                    pp.setSelectionState(1);
                    pp.setSelectionStart(pp.getCursorPos());
                }
                int pos2 = pp.getText().length() > 0 ? pp.getCursorPos() - 1 : pp.getCursorPos();
                pp.setCursorPos(pos2);
                this.selectionEnd.x = pos2;
                this.selectionEnd.y = this.cursorPoint.y;
                pp.setSelectionEnd(pos2);
            } else {
                if (this.isSelected()) {
                    this.cursorPoint.y = start.y;
                    this.cursorPoint.x = start.x;
                    ((Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).setCursorPos(start.x);
                    this.unselectAll();
                }
                this.start();
            }
        } else {
            p.setCursorPos(--pos);
            if (mod == 1) {
                if (p.getSelectionState() == 0) {
                    p.setSelectionState(1);
                    p.setSelectionStart(pos + 1);
                    this.selectionStart.y = this.cursorPoint.y;
                    this.selectionStart.x = pos + 1;
                }
                this.selectionEnd.x = pos;
                this.selectionEnd.y = this.cursorPoint.y;
                p.setSelectionEnd(pos);
            } else {
                if (this.isSelected()) {
                    this.cursorPoint.y = start.y;
                    this.cursorPoint.x = start.x;
                    ((Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).setCursorPos(start.x);
                    this.unselectAll();
                }
                this.start();
            }
            if (!this.isAutoWrap() && p.getCursorPoint().x < this.m_inTextInsets.left + 2) {
                int offset = p.getXOffset() - this.getSize().width / 2;
                if (offset < 0) {
                    offset = 0;
                }
                this.setXOffset(offset);
            }
        }
        if (this.m_bAllowVScroll) {
            this.onVerticalScroll();
        }
        this.repaint();
    }

    protected void onRightKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        int pos = p.getCursorPos();
        if (this.cursorPoint.y == this.m_vParagraphs.size() - 1 && pos == p.getText().length()) {
            return;
        }
        this.m_htUpDownPositions.clear();
        this.m_nLastXPosition = -1;
        this.stop();
        Point start = this.selectionStart;
        Point end = this.selectionEnd;
        if (end.y < start.y || end.y == start.y && end.x < start.x) {
            Point temp = end;
            end = start;
            start = temp;
        }
        if (pos == p.getText().length()) {
            ++this.cursorPoint.y;
            Paragraph pp = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            pp.moveSpecial(false, 0, 39);
            if (mod == 1) {
                int pos2;
                if (p.getSelectionState() == 0) {
                    p.setSelectionState(1);
                    p.setSelectionStart(pos);
                    this.selectionStart.x = pos;
                    this.selectionStart.y = this.cursorPoint.y - 1;
                }
                if (pp.getSelectionState() == 0) {
                    pp.setSelectionState(1);
                    pp.setSelectionStart(0);
                }
                this.selectionEnd.x = pos2 = pp.getText().length() > 0 ? 1 : 0;
                this.selectionEnd.y = this.cursorPoint.y;
                pp.setCursorPos(pos2);
                pp.setSelectionEnd(pos2);
            } else {
                if (this.isSelected()) {
                    this.cursorPoint.y = end.y;
                    this.cursorPoint.x = end.x;
                    ((Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).setCursorPos(end.x);
                    this.unselectAll();
                }
                this.start();
            }
        } else {
            p.setCursorPos(++pos);
            if (mod == 1) {
                if (p.getSelectionState() == 0) {
                    p.setSelectionState(1);
                    p.setSelectionStart(pos - 1);
                    this.selectionStart.x = pos - 1;
                    this.selectionStart.y = this.cursorPoint.y;
                }
                this.selectionEnd.x = pos;
                this.selectionEnd.y = this.cursorPoint.y;
                p.setSelectionEnd(pos);
            } else {
                if (this.isSelected()) {
                    this.cursorPoint.y = end.y;
                    this.cursorPoint.x = end.x;
                    ((Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y)).setCursorPos(end.x);
                    this.unselectAll();
                }
                this.start();
            }
        }
        if (this.m_bAllowVScroll) {
            this.onVerticalScroll();
        }
        this.repaint();
    }

    protected void onUpKey(int mod) {
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        if (p.isCursorOnFirstLine() && this.cursorPoint.y == 0) {
            this.onHomeKey(mod);
            return;
        }
        this.stop();
        if (p.isCursorOnFirstLine()) {
            int w = 0;
            if (this.m_nLastXPosition == -1) {
                this.m_nLastXPosition = w = p.getCursorPoint().x;
            } else {
                w = this.m_nLastXPosition;
            }
            this.storePosition(this.cursorPoint.y, p.getCursorPos());
            --this.cursorPoint.y;
            Paragraph pp = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
            int testPos = this.prevCursorPos(this.cursorPoint.y, pp.getText().length());
            if (testPos == -1) {
                pp.moveSpecial(true, w, 38);
            } else {
                pp.setCursorPos(testPos);
            }
            if (mod == 1) {
                if (p.getSelectionState() == 0) {
                    p.setSelectionState(1);
                    p.setSelectionStart(p.getCursorPos());
                    this.selectionStart.x = p.getCursorPos();
                    this.selectionStart.y = this.cursorPoint.y + 1;
                }
                p.setSelectionEnd(0);
                if (pp.getSelectionState() == 0) {
                    pp.setSelectionState(1);
                    pp.setSelectionStart(pp.getText().length());
                }
                this.selectionEnd.x = pp.getCursorPos();
                this.selectionEnd.y = this.cursorPoint.y;
                pp.setSelectionEnd(pp.getCursorPos());
            } else {
                if (p.getSelectionState() != 0) {
                    this.unselectAll();
                }
                this.start();
            }
        } else {
            int oldPos = p.getCursorPos();
            this.storePosition(this.cursorPoint.y, oldPos);
            int testPos = this.prevCursorPos(this.cursorPoint.y, oldPos);
            if (testPos == -1) {
                p.onUpKey();
            } else {
                p.setCursorPos(testPos);
            }
            int newPos = p.getCursorPos();
            if (mod == 1) {
                if (p.getSelectionState() == 0) {
                    p.setSelectionState(1);
                    p.setSelectionStart(oldPos);
                    this.selectionStart.x = oldPos;
                    this.selectionStart.y = this.cursorPoint.y;
                }
                this.selectionEnd.x = newPos;
                this.selectionEnd.y = this.cursorPoint.y;
                p.setSelectionEnd(newPos);
            } else {
                if (p.getSelectionState() != 0) {
                    this.unselectAll();
                }
                this.start();
            }
        }
        if (this.m_bAllowVScroll) {
            this.onVerticalScroll();
            this.prevYOffset = this.y_offset;
        }
        this.repaint();
    }

    protected void onVerticalScroll() {
        int marker = 0;
        int y = 0;
        int i = 0;
        while (i <= this.cursorPoint.y) {
            if ((marker += ((Paragraph)this.m_vParagraphs.elementAt(i)).getYSpan()) > this.y_offset) {
                y = marker - this.y_offset;
            }
            ++i;
        }
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        y = y - p.getYSpan() + p.getCursorPoint().y;
        int nBoardWidth = 2;
        if (this.m_nBorderStyle == 0) {
            nBoardWidth = 0;
        } else if (this.m_nBorderStyle == 3) {
            nBoardWidth = 1;
        }
        if (y + p.getFontMetrics().getHeight() + this.m_inTextInsets.top + this.m_inTextInsets.bottom + 2 * nBoardWidth > this.getSize().height) {
            this.y_offset += p.getFontMetrics().getHeight();
        } else if (y < 0 && this.y_offset > 0) {
            this.y_offset -= p.getFontMetrics().getHeight();
        }
    }

    protected int prevCursorPos(int ParaNum, int pos) {
        if (this.m_htUpDownPositions.size() == 0) {
            return -1;
        }
        if (this.m_htUpDownPositions.containsKey("" + ParaNum)) {
            int prev = -1;
            Vector v = (Vector)this.m_htUpDownPositions.get("" + ParaNum);
            int i = 0;
            while (i < v.size()) {
                Integer n = (Integer)v.elementAt(i);
                int compare = n;
                if (compare < pos) {
                    prev = Math.max(prev, compare);
                }
                ++i;
            }
            return prev;
        }
        return -1;
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 501) {
            this.m_htUpDownPositions.clear();
            this.m_nLastXPosition = -1;
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        Point pt = e.getPoint();
        if (e.getID() == 506) {
            super.processMouseMotionEvent(e);
            this.onVerticalScroll();
        } else {
            super.processMouseMotionEvent(e);
        }
    }

    public void setAllowEnter(boolean b) {
        this.m_bAllowEnter = b;
    }

    public void setAllowHScroll(boolean b) {
        this.m_bAllowHScroll = b && this.getHAlign() == 1 && this.getVAlign() == 1 && !this.isAutoWrap();
        int i = 0;
        while (i < this.m_vParagraphs.size()) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.setAllowScroll(this.m_bAllowHScroll);
            ++i;
        }
    }

    public void setAllowVScroll(boolean b) {
        this.m_bAllowVScroll = b;
    }

    public void setText(String t, boolean repaint) {
        if (t == null) {
            t = "";
        }
        if (this.m_vParagraphs.size() > 0) {
            this.m_vParagraphs.removeAllElements();
        }
        if (t.equals("")) {
            Paragraph p = new Paragraph(this, t);
            p.setFont(this.getFont());
            p.setFontMetrics(this.getFontMetrics(this.getFont()));
            p.setBackground(this.getBackground());
            p.setForeground(this.getForeground());
            p.setWidth(this.getSize().width - this.m_nWidthOffset);
            p.setInsets(this.m_inTextInsets);
            p.setHAlign(this.getHAlign());
            p.setAllowScroll(this.getAllowHScroll());
            p.setAutoWrap(this.isAutoWrap());
            this.m_vParagraphs.addElement(p);
            this.cursorPoint = new Point(0, 0);
            this.selectionStart = new Point(0, 0);
            this.selectionEnd = new Point(0, 0);
        } else {
            StringTokenizer st = new StringTokenizer(t, "\n", false);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                Paragraph p = new Paragraph(this, s);
                p.setFont(this.getFont());
                p.setFontMetrics(this.getFontMetrics(this.getFont()));
                p.setBackground(this.getBackground());
                p.setForeground(this.getForeground());
                p.setWidth(this.getSize().width - this.m_nWidthOffset);
                p.setInsets(this.m_inTextInsets);
                p.setHAlign(this.getHAlign());
                p.setAllowScroll(this.getAllowHScroll());
                p.setAutoWrap(this.isAutoWrap());
                this.m_vParagraphs.addElement(p);
            }
        }
        this.y_offset = 0;
        this.cursorPoint = new Point(0, 0);
        this.selectionStart = new Point(0, 0);
        this.selectionEnd = new Point(0, 0);
        if (repaint) {
            this.repaint();
        }
    }

    public void setVAlign(int align) {
        if (align != 1) {
            this.setAllowHScroll(false);
        }
        super.setVAlign(align);
    }

    public void setXOffset(int n) {
        int nSize = this.m_vParagraphs.size();
        int i = 0;
        while (i < nSize) {
            Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(i);
            p.setXOffset(n);
            ++i;
        }
    }

    protected void storePosition(int ParaNum, int pos) {
        Vector v = this.m_htUpDownPositions.containsKey("" + ParaNum) ? (Vector)this.m_htUpDownPositions.get("" + ParaNum) : new Vector();
        v.addElement(new Integer(pos));
        this.m_htUpDownPositions.put("" + ParaNum, v);
    }
}

