/*
 * Decompiled with CFR 0.152.
 */
package ob.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import ob.text.MultiText;
import ob.text.Paragraph;

public class ExpandableText
extends MultiText {
    public int m_nLookAhead = 15;
    protected int m_nFixedWidth = 100;

    public ExpandableText() {
        this("");
    }

    public ExpandableText(String s) {
        super(s);
        this.setAutoWrap(true);
        this.setAllowEnter(false);
        this.setInsets(new Insets(0, 0, 0, 0));
    }

    public void update() {
        this.sizeToFit();
        super.update();
    }

    public void setFixedWidth(int nWidth) {
        this.m_nFixedWidth = nWidth;
    }

    public void sizeToFit() {
        String text = this.getText();
        Font font = this.getFont() != null ? this.getFont() : this.defaultfont;
        FontMetrics fm = this.getFontMetrics(font);
        int nWidth = fm.stringWidth(text);
        if (this.m_nFixedWidth > 0 && nWidth + this.m_nLookAhead > this.m_nFixedWidth) {
            nWidth = this.m_nFixedWidth;
            this.setAutoWrap(true);
        } else {
            this.setAutoWrap(false);
            nWidth += this.m_nLookAhead;
        }
        if (this.getBounds().width != nWidth) {
            this.setBounds(this.getBounds().x, this.getBounds().y, nWidth, this.getBounds().height);
        }
    }

    protected void onVerticalScroll() {
        int marker = 0;
        int y = 0;
        int i = 0;
        while (i <= this.cursorPoint.y) {
            if ((marker += ((Paragraph)this.m_vParagraphs.elementAt(i)).getYSpan()) > this.y_offset) {
                y = marker - this.y_offset;
            }
            ++i;
        }
        Paragraph p = (Paragraph)this.m_vParagraphs.elementAt(this.cursorPoint.y);
        y = y - p.getYSpan() + p.getCursorPoint().y;
        int nBoardWidth = 2;
        if (this.m_nBorderStyle == 0) {
            nBoardWidth = 0;
        } else if (this.m_nBorderStyle == 3) {
            nBoardWidth = 1;
        }
        if (y + this.m_inTextInsets.top + this.m_inTextInsets.bottom + 2 * nBoardWidth > this.getSize().height) {
            this.y_offset += p.getFontMetrics().getHeight();
        } else if (y < 0 && this.y_offset > 0) {
            this.y_offset -= p.getFontMetrics().getHeight();
        }
    }
}

