/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeMessageFilter;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimItems;
import com.aligo.pim.exchange.ExchangePimMessageItemFilter;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.exchange.ExchangePimSortTypeMapper;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import com.aligo.pim.interfaces.PimMessageItems;

public abstract class ExchangePimMessageItems
extends ExchangePimItems
implements PimMessageItems {
    private ExchangeMessages _oMessages;
    private ExchangeMessageFilter _oMessageFilter;
    private ExchangePimMessageItemFilter m_oPimMessageItemFilter;

    public ExchangePimMessageItems(ExchangeMessages _oMessages, ExchangePimSession pimSession) {
        super(pimSession);
        this._oMessages = _oMessages;
    }

    public void setExchangeMessages(ExchangeMessages _oMessages) {
        this._oMessages = _oMessages;
    }

    public ExchangeMessages getExchangeMessages() {
        return this._oMessages;
    }

    public ExchangePimMessageItemFilter getExchangePimMessageItemFilter() throws ExchangePimException {
        if (this.m_oPimMessageItemFilter == null) {
            this.m_oPimMessageItemFilter = new ExchangePimMessageItemFilter(this.getExchangeMessageFilter(), this.getPimSession());
        } else {
            this.m_oPimMessageItemFilter.setExchangeMessageFilter(this.getExchangeMessageFilter());
        }
        return this.m_oPimMessageItemFilter;
    }

    public ExchangeMessageFilter getExchangeMessageFilter() throws ExchangePimException {
        try {
            this._oMessageFilter = this.getExchangeMessages().getFilter();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return this._oMessageFilter;
    }

    public void sort(PimSortType pimSortType) throws ExchangePimException {
        try {
            this.getExchangeMessages().sort(ExchangePimSortTypeMapper.getType(pimSortType));
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public int getCount() throws ExchangePimException {
        try {
            if (this.getExchangeMessages() == null) {
                return 0;
            }
            return this.getExchangeMessages().getCount();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws ExchangePimException {
        return this.getExchangePimMessageItemFilter();
    }

    public void delete() throws ExchangePimException {
        try {
            this.getExchangeMessages().delete();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public abstract PimMessageItem getPreviousMessageItem() throws PimException;

    public abstract PimMessageItem getLastMessageItem() throws PimException;

    public abstract PimMessageItem getNextMessageItem() throws PimException;

    public abstract PimMessageItem getFirstMessageItem() throws PimException;

    public abstract PimMessageItem addMessageItem() throws PimException;

    public abstract PimMessageItem getMessageItem(String var1) throws PimException;

    public abstract PimMessageItem getMessageItem(int var1) throws PimException;
}

