/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeAppointmentItem;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeMeetingItem;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.ExchangeRecipients;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.PimMeetingItemResponseType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimAppointmentItem;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFieldItems;
import com.aligo.pim.exchange.ExchangePimMailAttachmentItems;
import com.aligo.pim.exchange.ExchangePimMailMessageItem;
import com.aligo.pim.exchange.ExchangePimMeetingAppointmentItem;
import com.aligo.pim.exchange.ExchangePimMeetingItemResponseTypeMapper;
import com.aligo.pim.exchange.ExchangePimRecipientItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMailAttachmentItems;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMeetingItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Date;

public class ExchangePimMeetingItem
extends ExchangePimMailMessageItem
implements PimMeetingItem {
    private ExchangeAppointmentItem _oApptItem;
    private ExchangePimAppointmentItem m_oApptItem;
    private ExchangePimMailAttachmentItems m_oPimMailAttachmentItems;
    private String m_szBody;
    private String m_szSubject;
    private ExchangeMeetingItem m_oResponseMeeting;

    public ExchangePimMeetingItem(Object _oMeetingItem, ExchangePimSession pimSession) {
        super(_oMeetingItem, pimSession);
    }

    public ExchangeMeetingItem getExchangeMeetingItem() {
        return (ExchangeMeetingItem)this.getMessageObject();
    }

    public PimMailAttachmentItems getAttachmentItems() throws ExchangePimException {
        try {
            if (this.m_oPimMailAttachmentItems == null) {
                this.m_oPimMailAttachmentItems = new ExchangePimMailAttachmentItems(this.getExchangeMeetingItem().getAttachments(), this.getPimSession());
            } else {
                this.m_oPimMailAttachmentItems.setExchangeMailAttachmentItems(this.getExchangeMeetingItem().getAttachments());
            }
            return this.m_oPimMailAttachmentItems;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getID() throws ExchangePimException {
        try {
            return this.getExchangeMeetingItem().getId();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getTimeReceived() throws ExchangePimException {
        try {
            return this.getExchangeMeetingItem().getTimeReceived();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public ExchangePimAppointmentItem getExchangePimAppointmentItem() throws ExchangePimException {
        if (this.m_oApptItem == null) {
            try {
                this.m_oApptItem = new ExchangePimMeetingAppointmentItem(this.getExchangeAppointmentItem(), this.getPimSession());
            }
            catch (Exception e) {
                throw new ExchangePimException(e);
            }
        } else {
            this.m_oApptItem.setExchangeAppointmentItem(this.getExchangeAppointmentItem());
        }
        return this.m_oApptItem;
    }

    public ExchangeAppointmentItem getExchangeAppointmentItem() throws ExchangePimException {
        try {
            this._oApptItem = this.getExchangeMeetingItem().getAssociatedAppointment();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return this._oApptItem;
    }

    private ExchangeAddressEntry getExchangeAddressEntry() throws ExchangePimException {
        try {
            this._oAddressEntry = this.getExchangeAppointmentItem().getOrganizer();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return this._oAddressEntry;
    }

    public PimAppointmentItem getAssociatedAppointmentItem() throws ExchangePimException {
        try {
            return this.getExchangePimAppointmentItem();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public boolean getUnread() throws ExchangePimException {
        try {
            return this.getExchangeMeetingItem().getUnread();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setUnread(boolean flag) throws ExchangePimException {
        try {
            this.getExchangeMeetingItem().setUnread(flag);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public boolean hasAttachment() throws PimException {
        try {
            return this.getExchangeMeetingItem().getAttachments().getCount() > 0;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public int getClassType() throws ExchangePimException {
        try {
            return this.getExchangePimAppointmentItem().getClassType();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getBody() throws ExchangePimException {
        try {
            return this.getExchangeMeetingItem().getText();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getSubject() throws ExchangePimException {
        try {
            return this.getExchangeMeetingItem().getSubject();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getText() throws ExchangePimException {
        try {
            return this.getExchangeMeetingItem().getText();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimImportanceType getImportance() throws ExchangePimException {
        try {
            int importance = this.getExchangeMailMessage().getImportance();
            switch (importance) {
                case 0: {
                    return PimImportanceType.LOW;
                }
                case 1: {
                    return PimImportanceType.NORMAL;
                }
                case 2: {
                    return PimImportanceType.HIGH;
                }
            }
            return PimImportanceType.NORMAL;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getSender() throws ExchangePimException {
        try {
            return this.getExchangePimAppointmentItem().getSender();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.getExchangeMeetingItem().delete();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws ExchangePimException {
        try {
            this.getExchangeMeetingItem().delete(flag);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFieldItems getFields() throws ExchangePimException {
        try {
            ExchangeFields _oFields = this.getExchangeMeetingItem().getFields();
            if (_oFields == null) {
                return null;
            }
            return new ExchangePimFieldItems(_oFields, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void update() throws ExchangePimException {
        try {
            this.getExchangeMeetingItem().update();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void update(boolean makeItPermanent, boolean refreshObject) throws ExchangePimException {
        try {
            this.getExchangeMeetingItem().update(makeItPermanent, refreshObject);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void send() throws ExchangePimException {
        try {
            if (this.m_oResponseMeeting != null) {
                if (this.m_szSubject != null) {
                    this.m_oResponseMeeting.setSubject(this.m_szSubject);
                }
                if (this.m_szBody != null) {
                    this.m_oResponseMeeting.setText(this.m_szBody);
                }
                this.m_oResponseMeeting.send();
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void respond(PimMeetingItemResponseType pimMeetingItemResponseType) throws ExchangePimException {
        try {
            if (!pimMeetingItemResponseType.equals(PimMeetingItemResponseType.NONE)) {
                ExchangeMeetingItem _oMeetingItem;
                this.m_oResponseMeeting = _oMeetingItem = this.getExchangeMeetingItem().respond(ExchangePimMeetingItemResponseTypeMapper.getType(pimMeetingItemResponseType));
                this.getExchangeMeetingItem().delete(true);
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItems getRecipientItems() throws ExchangePimException {
        try {
            ExchangeRecipients _oRecipients = this.getExchangeMeetingItem().getRecipients();
            if (_oRecipients == null) {
                return null;
            }
            return new ExchangePimRecipientItems(_oRecipients, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem reply() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = this.getExchangeMeetingItem().reply();
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimMeetingItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem replyAll() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = this.getExchangeMeetingItem().replyAll();
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimMeetingItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem forward() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = this.getExchangeMeetingItem().forward();
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimMeetingItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getName() throws ExchangePimException {
        return "MeetingItem: " + this.getSubject();
    }

    public void setSubject(String subject) throws ExchangePimException {
        this.m_szSubject = subject;
    }

    public void setBody(String szBody) throws ExchangePimException {
        this.m_szBody = szBody;
    }
}

