/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAppointmentItem;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exchange.ExchangePimAppointmentItem;
import com.aligo.pim.exchange.ExchangePimAppointmentItemFilter;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimMessageItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimAppointmentItemFilter;
import com.aligo.pim.interfaces.PimAppointmentItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import java.util.Calendar;

public class ExchangePimAppointmentItems
extends ExchangePimMessageItems
implements PimAppointmentItems {
    private ExchangePimAppointmentItemFilter m_oPimAppointmentItemFilter;

    public ExchangePimAppointmentItems(ExchangeMessages _oMessages, ExchangePimSession pimSession) {
        super(_oMessages, pimSession);
    }

    public void setExchangeAppointmentItems(ExchangeMessages _oMessages) {
        this.setExchangeMessages(_oMessages);
    }

    public PimAppointmentItemFilter getAppointmentItemFilter() throws ExchangePimException {
        if (this.m_oPimAppointmentItemFilter == null) {
            this.m_oPimAppointmentItemFilter = new ExchangePimAppointmentItemFilter(this.getExchangeMessageFilter(), this.getPimSession());
        } else {
            this.m_oPimAppointmentItemFilter.setExchangeAppointmentItemFilter(this.getExchangeMessageFilter());
        }
        return this.m_oPimAppointmentItemFilter;
    }

    public void sort(PimSortType pimSortType) throws ExchangePimException {
        throw new ExchangePimException(45L);
    }

    public int getCount() throws ExchangePimException {
        throw new ExchangePimException(49L);
    }

    public ExchangeMessages getExchangeAppointmentItems() {
        return this.getExchangeMessages();
    }

    public PimAppointmentItem getFirstAppointmentItem() throws ExchangePimException {
        try {
            ExchangeAppointmentItem _oMessage = this.getExchangeAppointmentItems().getFirstAppointment();
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimAppointmentItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAppointmentItem getNextAppointmentItem() throws ExchangePimException {
        try {
            ExchangeAppointmentItem _oMessage = this.getExchangeAppointmentItems().getNextAppointment();
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimAppointmentItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAppointmentItem getLastAppointmentItem() throws ExchangePimException {
        throw new ExchangePimException(50L);
    }

    public PimAppointmentItem getPreviousAppointmentItem() throws ExchangePimException {
        try {
            ExchangeAppointmentItem _oMessage = this.getExchangeAppointmentItems().getPreviousAppointment();
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimAppointmentItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAppointmentItem getAppointmentItem(int itemNumber) throws ExchangePimException {
        try {
            ExchangeAppointmentItem _oMessage = (ExchangeAppointmentItem)this.getExchangeAppointmentItems().getItem(itemNumber + 1);
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimAppointmentItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAppointmentItem getAppointmentItem(String id) throws ExchangePimException {
        try {
            ExchangeAppointmentItem exchangeAppointmentItem = this.getExchangeAppointmentItems().getFirstAppointment();
            while (exchangeAppointmentItem != null) {
                boolean status;
                if (exchangeAppointmentItem.getId().equals(id)) {
                    return new ExchangePimAppointmentItem(exchangeAppointmentItem, this.getPimSession());
                }
                if (id.length() == 160 && id.length() == exchangeAppointmentItem.getId().length() && (status = this.compareIDs(id, exchangeAppointmentItem.getId()))) {
                    return new ExchangePimAppointmentItem(exchangeAppointmentItem, this.getPimSession());
                }
                exchangeAppointmentItem = this.getExchangeAppointmentItems().getNextAppointment();
            }
            PimAppointmentItemFilter pimAppointmentItemFilter = this.getAppointmentItemFilter();
            Calendar startCal = Calendar.getInstance();
            startCal.set(1, 1920);
            startCal.set(2, 0);
            startCal.set(5, 1);
            Calendar endCal = Calendar.getInstance();
            endCal.set(1, 3000);
            endCal.set(2, 0);
            endCal.set(5, 1);
            pimAppointmentItemFilter.setStartTime(startCal.getTime());
            pimAppointmentItemFilter.setEndTime(endCal.getTime());
            exchangeAppointmentItem = this.getExchangeAppointmentItems().getFirstAppointment();
            while (exchangeAppointmentItem != null) {
                boolean status;
                if (exchangeAppointmentItem.getId().equals(id)) {
                    return new ExchangePimAppointmentItem(exchangeAppointmentItem, this.getPimSession());
                }
                if (id.length() == 160 && id.length() == exchangeAppointmentItem.getId().length() && (status = this.compareIDs(id, exchangeAppointmentItem.getId()))) {
                    return new ExchangePimAppointmentItem(exchangeAppointmentItem, this.getPimSession());
                }
                exchangeAppointmentItem = this.getExchangeAppointmentItems().getNextAppointment();
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
        return null;
    }

    public PimAppointmentItem addAppointmentItem() throws ExchangePimException {
        try {
            ExchangeAppointmentItem _oAppointmentItem = (ExchangeAppointmentItem)this.getExchangeAppointmentItems().add("IPM.Appointment");
            if (_oAppointmentItem == null) {
                return null;
            }
            return new ExchangePimAppointmentItem(_oAppointmentItem, true, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExchangePimException {
        return this.getAppointmentItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExchangePimException {
        return this.getAppointmentItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExchangePimException {
        return this.getFirstAppointmentItem();
    }

    public PimMessageItem getNextMessageItem() throws ExchangePimException {
        return this.getNextAppointmentItem();
    }

    public PimMessageItem getLastMessageItem() throws ExchangePimException {
        return this.getLastAppointmentItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExchangePimException {
        return this.getPreviousAppointmentItem();
    }

    public PimMessageItem addMessageItem() throws ExchangePimException {
        return this.addAppointmentItem();
    }

    public PimItem getItem(int itemNumber) throws ExchangePimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExchangePimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExchangePimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExchangePimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExchangePimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExchangePimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExchangePimException {
        return this.getPreviousMessageItem();
    }

    private boolean compareIDs(String id, String currentID) {
        if (id.length() != currentID.length()) {
            return false;
        }
        int count = 0;
        int i = 150;
        while (i < 160) {
            if (id.charAt(i) != currentID.charAt(i)) {
                ++count;
            }
            ++i;
        }
        if (count >= 1) {
            return false;
        }
        count = 0;
        int i2 = 10;
        while (i2 < 150) {
            if (id.charAt(i2) != currentID.charAt(i2)) {
                ++count;
            }
            ++i2;
        }
        return count <= 8;
    }
}

