/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.messaging.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeField;
import com.aligo.messaging.exchange.cdo.FieldProxy;
import com.aligo.messaging.exchange.cdo.Fields;
import com.aligo.messaging.exchange.cdo.Session;
import com.linar.jintegra.AutomationException;

public class ExchangeFields {
    private Fields _ocxFields;
    private Session _ocxSession;

    ExchangeFields(Fields handle) {
        this._ocxFields = handle;
    }

    ExchangeFields() {
    }

    private void setHandle(Fields handle) {
        this._ocxFields = handle;
    }

    Fields getFields() {
        return this._ocxFields;
    }

    public int getCount() throws AligoExchangeException {
        try {
            return (Integer)this._ocxFields.getCount();
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public boolean fieldExists(int mapiFieldId) throws AligoExchangeException {
        try {
            this._ocxFields.getItem(new Integer(mapiFieldId), null);
            return true;
        }
        catch (Exception e) {
            if (e instanceof AutomationException) {
                int code = new Long(((AutomationException)((Object)e)).getCode()).intValue();
                if (code == -2147221233) {
                    return false;
                }
                throw new AligoExchangeException(e);
            }
            throw new AligoExchangeException(e);
        }
    }

    public boolean fieldExists(String name) throws AligoExchangeException {
        try {
            this._ocxFields.getItem(name, null);
            return true;
        }
        catch (Exception e) {
            if (e instanceof AutomationException) {
                int code = new Long(((AutomationException)((Object)e)).getCode()).intValue();
                if (code == -2147221233) {
                    return false;
                }
                throw new AligoExchangeException(e);
            }
            throw new AligoExchangeException(e);
        }
    }

    public void setCount(int count) throws AligoExchangeException {
        try {
            this._ocxFields.setCount(new Integer(count));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeField getItem(String name) throws AligoExchangeException {
        try {
            return new ExchangeField(new FieldProxy(this._ocxFields.getItem(name, null)));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeField getItem(String name, String propId) throws AligoExchangeException {
        try {
            return new ExchangeField(new FieldProxy(this._ocxFields.getItem(name, propId)));
        }
        catch (Exception e) {
            if (e instanceof AutomationException) {
                int code = new Long(((AutomationException)((Object)e)).getCode()).intValue();
                if (code == -2147221233) {
                    return null;
                }
                throw new AligoExchangeException(e);
            }
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeField getItem(Integer name, String propId) throws AligoExchangeException {
        try {
            return new ExchangeField(new FieldProxy(this._ocxFields.getItem(name, propId)));
        }
        catch (Exception e) {
            if (e instanceof AutomationException) {
                int code = new Long(((AutomationException)((Object)e)).getCode()).intValue();
                if (code == -2147221233) {
                    return null;
                }
                throw new AligoExchangeException(e);
            }
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeField getItem(int index) throws AligoExchangeException {
        try {
            return new ExchangeField(new FieldProxy(this._ocxFields.getItem(new Integer(index), null)));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeField getItem(int index, int propsetId) throws AligoExchangeException {
        try {
            return new ExchangeField(new FieldProxy(this._ocxFields.getItem(new Integer(index), new Integer(propsetId))));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setNamespace(int propsetId) throws AligoExchangeException {
        try {
            Object ns = this._ocxFields.setNamespace(new Integer(propsetId));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeField add(String name, int classType) throws AligoExchangeException {
        try {
            FieldProxy resultHandle = new FieldProxy(this._ocxFields.add(name, new Integer(classType), null, null));
            return new ExchangeField(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeField add(int propertyTag, Object value) throws AligoExchangeException {
        try {
            FieldProxy resultHandle = new FieldProxy(this._ocxFields.add(new Integer(propertyTag), value, null, null));
            return new ExchangeField(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeField add(String name, int classType, Object value) throws AligoExchangeException {
        try {
            FieldProxy resultHandle = new FieldProxy(this._ocxFields.add(name, new Integer(classType), value, null));
            return new ExchangeField(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeField add(String name, int classType, Object value, String propId) throws AligoExchangeException {
        try {
            FieldProxy resultHandle = new FieldProxy(this._ocxFields.add(name, new Integer(classType), value, propId));
            return new ExchangeField(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void delete() throws AligoExchangeException {
        try {
            this._ocxFields.delete();
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }
}

