/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.messaging.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.cdo.Attachment;
import com.aligo.messaging.exchange.cdo.FieldsProxy;
import com.aligo.messaging.exchange.cdo.Message;
import com.aligo.messaging.exchange.cdo.MessageProxy;

public final class ExchangeAttachment {
    private Attachment _ocxAttachment;

    ExchangeAttachment(Attachment attachmentHandle) {
        this._ocxAttachment = attachmentHandle;
    }

    Attachment getAttachmentHandle() {
        return this._ocxAttachment;
    }

    public void delete() throws AligoExchangeException {
        try {
            this._ocxAttachment.delete();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean isSameAs(ExchangeAttachment attachment) throws AligoExchangeException {
        try {
            Attachment other = attachment.getAttachmentHandle();
            return (Boolean)this._ocxAttachment.isSameAs(other);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Object getSource() throws AligoExchangeException {
        try {
            if ((Integer)this._ocxAttachment.getType() == 4) {
                MessageProxy handle = new MessageProxy(this._ocxAttachment.zz_getSource());
                return new ExchangeMessage(handle);
            }
            return this._ocxAttachment.zz_getSource();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSource(ExchangeMessage embeddedMessage) throws AligoExchangeException {
        try {
            Message handle = embeddedMessage.getMessageHandle();
            this._ocxAttachment.setSource(handle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSource(String value) throws AligoExchangeException {
        try {
            this._ocxAttachment.setSource(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void writeToFile(String fileName) throws AligoExchangeException {
        switch (this.getType()) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new AligoExchangeException("Invalid attachment type!");
            }
        }
        try {
            this._ocxAttachment.writeToFile(fileName);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Object getFields() throws AligoExchangeException {
        try {
            FieldsProxy fieldsHandle = new FieldsProxy(this._ocxAttachment.getFields());
            return new ExchangeFields(fieldsHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getIndex() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAttachment.getIndex();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getName() throws AligoExchangeException {
        try {
            return (String)this._ocxAttachment.getName();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setName(String value) throws AligoExchangeException {
        try {
            this._ocxAttachment.setName(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getPosition() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAttachment.getPosition();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setPosition(int position) throws AligoExchangeException {
        try {
            this._ocxAttachment.setPosition(new Integer(position));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void readFromFile(String fileName) throws AligoExchangeException {
        try {
            this._ocxAttachment.readFromFile(fileName);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getType() throws AligoExchangeException {
        try {
            return (Integer)this._ocxAttachment.getType();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setType(int typeValue) throws AligoExchangeException {
        switch (typeValue) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new AligoExchangeException("Invalid attachment type value provided!");
            }
        }
        try {
            this._ocxAttachment.setType(new Integer(typeValue));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getApplication() throws AligoExchangeException {
        try {
            return "Collaboration Data Objects";
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }
}

