/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationInfo;
import HTTPClient.Log;
import HTTPClient.NVPair;
import HTTPClient.SocksException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

class SocksClient {
    private String socks_host;
    private int socks_port;
    private int socks_version;
    private static final byte CONNECT = 1;
    private static final byte BIND = 2;
    private static final byte UDP_ASS = 3;
    private static final byte NO_AUTH = 0;
    private static final byte GSSAPI = 1;
    private static final byte USERPWD = 2;
    private static final byte NO_ACC = -1;
    private static final byte IP_V4 = 1;
    private static final byte DMNAME = 3;
    private static final byte IP_V6 = 4;
    private boolean v4A = false;
    private byte[] user = null;

    SocksClient(String string, int n) {
        this.socks_host = string;
        this.socks_port = n;
        this.socks_version = -1;
    }

    SocksClient(String string, int n, int n2) throws SocksException {
        this.socks_host = string;
        this.socks_port = n;
        if (n2 != 4 && n2 != 5) {
            throw new SocksException("SOCKS Version not supported: " + n2);
        }
        this.socks_version = n2;
    }

    Socket getSocket(String string, int n) throws IOException {
        return this.getSocket(string, n, null, -1);
    }

    Socket getSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        Socket socket = null;
        try {
            Log.write(64, "Socks: contacting server on " + this.socks_host + ":" + this.socks_port);
            socket = SocksClient.connect(this.socks_host, this.socks_port, inetAddress, n2);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            switch (this.socks_version) {
                case 4: {
                    this.v4ProtExchg(inputStream, outputStream, string, n);
                    break;
                }
                case 5: {
                    this.v5ProtExchg(inputStream, outputStream, string, n);
                    break;
                }
                case -1: {
                    try {
                        this.v4ProtExchg(inputStream, outputStream, string, n);
                        this.socks_version = 4;
                    }
                    catch (SocksException socksException) {
                        Log.write(64, "Socks: V4 request failed: " + socksException.getMessage());
                        socket.close();
                        socket = SocksClient.connect(this.socks_host, this.socks_port, inetAddress, n2);
                        inputStream = socket.getInputStream();
                        outputStream = socket.getOutputStream();
                        this.v5ProtExchg(inputStream, outputStream, string, n);
                        this.socks_version = 5;
                    }
                    break;
                }
                default: {
                    throw new Error("SocksClient internal error: unknown version " + this.socks_version);
                }
            }
            Log.write(64, "Socks: connection established.");
            return socket;
        }
        catch (IOException iOException) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
    }

    private static final Socket connect(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        int n3 = 0;
        while (n3 < inetAddressArray.length) {
            try {
                if (inetAddress == null) {
                    return new Socket(inetAddressArray[n3], n);
                }
                return new Socket(inetAddressArray[n3], n, inetAddress, n2);
            }
            catch (SocketException socketException) {
                if (n3 >= inetAddressArray.length - 1) {
                    throw socketException;
                }
                ++n3;
            }
        }
        return null;
    }

    private void v4ProtExchg(InputStream inputStream, OutputStream outputStream, String string, int n) throws SocksException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        Log.write(64, "Socks: Beginning V4 Protocol Exchange for host " + string + ":" + n);
        byte[] byArray = new byte[]{0, 0, 0, 42};
        if (!this.v4A) {
            try {
                byArray = InetAddress.getByName(string).getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                this.v4A = true;
            }
            catch (SecurityException securityException) {
                this.v4A = true;
            }
            if (this.v4A) {
                Log.write(64, "Socks: Switching to version 4A");
            }
        }
        if (this.user == null) {
            String string2;
            try {
                string2 = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                string2 = "";
            }
            byte[] byArray2 = string2.getBytes();
            this.user = new byte[byArray2.length + 1];
            System.arraycopy(byArray2, 0, this.user, 0, byArray2.length);
            this.user[string2.length()] = 0;
        }
        Log.write(64, "Socks: Sending connect request for user " + new String(this.user, 0, this.user.length - 1));
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(this.user);
        if (this.v4A) {
            byteArrayOutputStream.write(string.getBytes("8859_1"));
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.writeTo(outputStream);
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new SocksException("Connection refused by server");
        }
        if (n2 == 4) {
            Log.write(64, "Socks: Warning: received version 4 instead of 0");
        } else if (n2 != 0) {
            throw new SocksException("Received invalid version: " + n2 + "; expected: 0");
        }
        int n3 = inputStream.read();
        Log.write(64, "Socks: Received response; version: " + n2 + "; status: " + n3);
        switch (n3) {
            case 90: {
                break;
            }
            case 91: {
                throw new SocksException("Connection request rejected");
            }
            case 92: {
                throw new SocksException("Connection request rejected: can't connect to identd");
            }
            case 93: {
                throw new SocksException("Connection request rejected: identd reports different user-id from " + new String(this.user, 0, this.user.length - 1));
            }
            default: {
                throw new SocksException("Connection request rejected: unknown error " + n3);
            }
        }
        byte[] byArray3 = new byte[6];
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray3.length && (n4 = inputStream.read(byArray3, 0, byArray3.length - n5)) != -1) {
            n5 += n4;
        }
    }

    private void v5ProtExchg(InputStream inputStream, OutputStream outputStream, String string, int n) throws SocksException, IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        Log.write(64, "Socks: Beginning V5 Protocol Exchange for host " + string + ":" + n);
        Log.write(64, "Socks: Sending authentication request; methods No-Authentication, Username/Password");
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(5);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.writeTo(outputStream);
        int n3 = inputStream.read();
        if (n3 == -1) {
            throw new SocksException("Connection refused by server");
        }
        if (n3 != 5) {
            throw new SocksException("Received invalid version: " + n3 + "; expected: 5");
        }
        int n4 = inputStream.read();
        Log.write(64, "Socks: Received response; version: " + n3 + "; method: " + n4);
        switch (n4) {
            case 0: {
                break;
            }
            case 1: {
                this.negotiate_gssapi(inputStream, outputStream);
                break;
            }
            case 2: {
                this.negotiate_userpwd(inputStream, outputStream);
                break;
            }
            case -1: {
                throw new SocksException("Server unwilling to accept any standard authentication methods");
            }
            default: {
                throw new SocksException("Cannot handle authentication method " + n4);
            }
        }
        Log.write(64, "Socks: Sending connect request");
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(5);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(string.length() & 0xFF);
        byteArrayOutputStream.write(string.getBytes("8859_1"));
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.writeTo(outputStream);
        n3 = inputStream.read();
        if (n3 != 5) {
            throw new SocksException("Received invalid version: " + n3 + "; expected: 5");
        }
        int n5 = inputStream.read();
        Log.write(64, "Socks: Received response; version: " + n3 + "; status: " + n5);
        switch (n5) {
            case 0: {
                break;
            }
            case 1: {
                throw new SocksException("General SOCKS server failure");
            }
            case 2: {
                throw new SocksException("Connection not allowed");
            }
            case 3: {
                throw new SocksException("Network unreachable");
            }
            case 4: {
                throw new SocksException("Host unreachable");
            }
            case 5: {
                throw new SocksException("Connection refused");
            }
            case 6: {
                throw new SocksException("TTL expired");
            }
            case 7: {
                throw new SocksException("Command not supported");
            }
            case 8: {
                throw new SocksException("Address type not supported");
            }
            default: {
                throw new SocksException("Unknown reply received from server: " + n5);
            }
        }
        inputStream.read();
        int n6 = inputStream.read();
        switch (n6) {
            case 4: {
                n2 = 16;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = inputStream.read();
                break;
            }
            default: {
                throw new SocksException("Invalid address type received from server: " + n6);
            }
        }
        byte[] byArray = new byte[n2 + 2];
        int n7 = 0;
        int n8 = 0;
        while (n8 < byArray.length && (n7 = inputStream.read(byArray, 0, byArray.length - n8)) != -1) {
            n8 += n7;
        }
    }

    private void negotiate_gssapi(InputStream inputStream, OutputStream outputStream) throws SocksException, IOException {
        throw new SocksException("GSSAPI authentication protocol not implemented");
    }

    private void negotiate_userpwd(InputStream inputStream, OutputStream outputStream) throws SocksException, IOException {
        AuthorizationInfo authorizationInfo;
        Log.write(64, "Socks: Entering authorization subnegotiation; method: Username/Password");
        try {
            authorizationInfo = AuthorizationInfo.getAuthorization(this.socks_host, this.socks_port, "SOCKS5", "USER/PASS", null, null, true);
        }
        catch (AuthSchemeNotImplException authSchemeNotImplException) {
            authorizationInfo = null;
        }
        if (authorizationInfo == null) {
            throw new SocksException("No Authorization info for SOCKS found (server requested username/password).");
        }
        NVPair[] nVPairArray = authorizationInfo.getParams();
        if (nVPairArray == null || nVPairArray.length == 0) {
            throw new SocksException("No Username/Password found in authorization info for SOCKS.");
        }
        String string = nVPairArray[0].getName();
        String string2 = nVPairArray[0].getValue();
        Log.write(64, "Socks: Sending authorization request for user " + string);
        byte[] byArray = string.getBytes();
        byte[] byArray2 = string2.getBytes();
        byte[] byArray3 = new byte[2 + byArray.length + 1 + byArray2.length];
        byArray3[0] = 1;
        byArray3[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, 2, byArray.length);
        byArray3[2 + byArray3[1]] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray3, 2 + byArray3[1] + 1, byArray2.length);
        outputStream.write(byArray3);
        int n = inputStream.read();
        if (n != 1) {
            throw new SocksException("Wrong version received in username/password subnegotiation response: " + n + "; expected: 1");
        }
        int n2 = inputStream.read();
        if (n2 != 0) {
            throw new SocksException("Username/Password authentication failed; status: " + n2);
        }
        Log.write(64, "Socks: Received response; version: " + n + "; status: " + n2);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.socks_host + ":" + this.socks_port + "]";
    }
}

