/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.AbstractURI;
import com.sun.portal.rewriter.util.uri.URI;
import com.sun.portal.rewriter.util.uri.URIIntf;
import com.sun.portal.rewriter.util.uri.URISyntaxException;
import java.net.MalformedURLException;

public final class StandardURI
extends AbstractURI
implements URIIntf {
    public static String PROPERTY_IS_NORMALIZE_URI_LIKE_BROWSER = "IS_NORMALIZE_URI_LIKE_BROWSER";
    private static boolean NORMALIZE_URI_LIKE_BROWSER = ConfigManager.getBoolean(PROPERTY_IS_NORMALIZE_URI_LIKE_BROWSER);
    private URI jdkURI;

    private StandardURI(String aURIString, URI aJDKURI) throws MalformedURLException {
        super(aURIString);
        try {
            int j;
            int i;
            this.jdkURI = aJDKURI != null ? aJDKURI : new URI(this.uriString);
            if (this.jdkURI.isOpaque()) {
                throw new URISyntaxException("Opaque URI:" + this.uriString, "");
            }
            String protocol = this.getProtocol();
            if (this.jdkURI.isAbsolute() && (i = this.uriString.indexOf(protocol)) != (j = this.uriString.indexOf(protocol + "://"))) {
                throw new URISyntaxException(this.uriString, "Absolute URI does not contain pattern '://' after the protocol");
            }
            this.setValid(true);
        }
        catch (URISyntaxException e) {
            this.setValid(false);
            throw new MalformedURLException("\nInput to StandardURI:" + aURIString + "\nCause StackTrace:" + StringHelper.exceptionStack2String(e) + "\nWraped Exception:");
        }
    }

    public StandardURI(String aURIString) throws MalformedURLException {
        this(aURIString, null);
    }

    public String getProtocol() {
        return StringHelper.normalize(this.jdkURI.getScheme());
    }

    public String getHost() {
        return StringHelper.normalize(this.jdkURI.getHost());
    }

    public int getPort() {
        return this.jdkURI.getPort();
    }

    public String getAuthority() {
        return StringHelper.normalize(this.jdkURI.getAuthority());
    }

    public String getUserInfo() {
        return StringHelper.normalize(this.jdkURI.getUserInfo());
    }

    public String getPath() {
        String lPath = URI.normalize(StringHelper.normalize(this.jdkURI.getPath()));
        if (NORMALIZE_URI_LIKE_BROWSER && this.isAbsolute()) {
            while (lPath.startsWith("/..")) {
                lPath = lPath.substring(3);
            }
        }
        return lPath;
    }

    public String getReference() {
        return StringHelper.normalize(this.jdkURI.getFragment());
    }

    public String getQuery() {
        return StringHelper.normalize(this.jdkURI.getQuery());
    }

    public boolean hasReference() {
        return this.jdkURI.getFragment() != null;
    }

    public boolean hasQuery() {
        return this.jdkURI.getQuery() != null;
    }

    public boolean isAbsolute() {
        return this.jdkURI.isAbsolute();
    }

    public String getImplID() {
        return "StandardURI";
    }

    public StandardURI resolve(String aResolveURI) throws MalformedURLException {
        if (aResolveURI == null) {
            return null;
        }
        try {
            URI lURI = this.jdkURI.resolve(new URI(aResolveURI));
            return new StandardURI(lURI.toString(), lURI);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("\nInvalid Resolve URI:" + aResolveURI + "\nCause StackTrace:" + StringHelper.exceptionStack2String(e));
        }
    }

    public static void main(String[] args) throws Exception {
        String[] location = new String[]{"http://user@password@srap.india.sun.com"};
        int i = 0;
        while (i < location.length) {
            StandardURI pageSpec = new StandardURI(location[i]);
            System.out.println("Original: " + location[i]);
            System.out.println("ExternalForm: " + pageSpec.toExternalForm());
            System.out.println("ToString " + pageSpec.jdkURI.toString());
            System.out.println("Host: " + pageSpec.getHost());
            System.out.println("Path: " + pageSpec.getPath());
            System.out.println("Normalized: " + new URI("HTTP://RAJA.COM/?abc=10").resolve(new URI(pageSpec.getPath())).toString());
            System.out.println("Port: " + pageSpec.getPort() + "\n\n");
            ++i;
        }
    }
}

